/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.headers.HeaderWriter;
import kd.bos.zip.model.Zip4jConfig;
import kd.bos.zip.model.ZipModel;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.progress.ProgressMonitor;
import kd.bos.zip.tasks.AbstractAddFileToZipTask;
import kd.bos.zip.tasks.AbstractZipTaskParameters;
import kd.bos.zip.tasks.AsyncZipTask;
import kd.bos.zip.util.FileUtils;

public class AddFolderToZipTask
extends AbstractAddFileToZipTask<AddFolderToZipTaskParameters> {
    public AddFolderToZipTask(ZipModel zipModel, char[] password, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, password, headerWriter, asyncTaskParameters);
    }

    @Override
    protected void executeTask(AddFolderToZipTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        List<File> filesToAdd = this.getFilesToAdd(taskParameters);
        this.setDefaultFolderPath(taskParameters);
        this.addFilesToZip(filesToAdd, progressMonitor, taskParameters.zipParameters, taskParameters.zip4jConfig);
    }

    @Override
    protected long calculateTotalWork(AddFolderToZipTaskParameters taskParameters) throws ZipException {
        List<File> filesToAdd = FileUtils.getFilesInDirectoryRecursive(taskParameters.folderToAdd, taskParameters.zipParameters.isReadHiddenFiles(), taskParameters.zipParameters.isReadHiddenFolders(), taskParameters.zipParameters.getExcludeFileFilter());
        if (taskParameters.zipParameters.isIncludeRootFolder()) {
            filesToAdd.add(taskParameters.folderToAdd);
        }
        return this.calculateWorkForFiles(filesToAdd, taskParameters.zipParameters);
    }

    private void setDefaultFolderPath(AddFolderToZipTaskParameters taskParameters) throws IOException {
        File parentFile;
        File folderToAdd = taskParameters.folderToAdd;
        String rootFolderPath = taskParameters.zipParameters.isIncludeRootFolder() ? ((parentFile = folderToAdd.getCanonicalFile().getParentFile()) == null ? folderToAdd.getCanonicalPath() : folderToAdd.getCanonicalFile().getParentFile().getCanonicalPath()) : folderToAdd.getCanonicalPath();
        taskParameters.zipParameters.setDefaultFolderPath(rootFolderPath);
    }

    private List<File> getFilesToAdd(AddFolderToZipTaskParameters taskParameters) throws ZipException {
        List<File> filesToAdd = FileUtils.getFilesInDirectoryRecursive(taskParameters.folderToAdd, taskParameters.zipParameters.isReadHiddenFiles(), taskParameters.zipParameters.isReadHiddenFolders(), taskParameters.zipParameters.getExcludeFileFilter());
        if (taskParameters.zipParameters.isIncludeRootFolder()) {
            filesToAdd.add(taskParameters.folderToAdd);
        }
        return filesToAdd;
    }

    public static class AddFolderToZipTaskParameters
    extends AbstractZipTaskParameters {
        private final File folderToAdd;
        private final ZipParameters zipParameters;

        public AddFolderToZipTaskParameters(File folderToAdd, ZipParameters zipParameters, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.folderToAdd = folderToAdd;
            this.zipParameters = zipParameters;
        }
    }
}

