/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher;

import com.kingdee.bos.app.launcher.Main;
import com.kingdee.bos.app.launcher.daemon.multicast.MulticastSend;
import com.kingdee.bos.app.launcher.util.AppRootFolderUtil;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.extreport.utils.IOUtil;
import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import sun.management.ManagementFactoryHelper;

public class JNLPToLocalLauncher {
    private static final Logger LOGGER = Logger.getLogger(JNLPToLocalLauncher.class);
    private static final String HOME = AppRootFolderUtil.filePathConcatenation(System.getProperty("java.io.tmpdir"), "cosmic-launcher-" + System.getProperty("jnlp.webVersion"));
    private static final String LIB_HOME = AppRootFolderUtil.filePathConcatenation(HOME, "lib");
    private static final String CONFIG_HOME = AppRootFolderUtil.filePathConcatenation(HOME, "config");
    private static String XMS = "512m";
    private static String XMX = "1024m";
    private static final int MIN_XMX = 512;
    private static final int MAX_XMX = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyJarByJarFile(JarFile jarFile, File des) throws IOException {
        JNLPToLocalLauncher.touchFile(des);
        Enumeration<JarEntry> jarEntrys = jarFile.entries();
        FileOutputStream fileOutputStream = new FileOutputStream(des);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        JarOutputStream jarOut = new JarOutputStream(bufferedOutputStream);
        try {
            byte[] bytes = new byte[1024];
            while (jarEntrys.hasMoreElements()) {
                JarEntry entryTemp = jarEntrys.nextElement();
                jarOut.putNextEntry(entryTemp);
                BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entryTemp));
                int len = in.read(bytes, 0, bytes.length);
                while (len != -1) {
                    jarOut.write(bytes, 0, len);
                    len = in.read(bytes, 0, bytes.length);
                }
                in.close();
                jarOut.closeEntry();
            }
            jarOut.finish();
        }
        finally {
            jarOut.close();
            jarFile.close();
        }
    }

    private static void touchFile(File des) throws IOException {
        File parent;
        if (des.exists() && !des.delete()) {
            LOGGER.error((Object)("failed to delete file : " + des.getCanonicalPath()));
        }
        if ((parent = des.getParentFile()).exists()) {
            if (!parent.isDirectory()) {
                if (!parent.delete()) {
                    LOGGER.error((Object)("failed to delete file : " + parent.getCanonicalPath()));
                }
                parent.mkdirs();
            }
        } else {
            parent.mkdirs();
        }
    }

    private static void mkdirsDirectory(String dir) throws IOException {
        File dirFile = new File(dir);
        if (dirFile.exists()) {
            File parentFile;
            if (!dirFile.isDirectory() && !dirFile.delete()) {
                LOGGER.error((Object)("failed to delete file : " + dirFile.getCanonicalPath()));
            }
            if (!(parentFile = dirFile.getParentFile()).exists()) {
                parentFile.mkdirs();
            }
        } else {
            dirFile.mkdirs();
        }
    }

    private static Map<String, File> getJarFilesInLib() {
        File[] allJarFilesInLib;
        HashMap<String, File> allJarFilesInLibMap = new HashMap<String, File>();
        File libForld = new File(LIB_HOME);
        if (!libForld.exists()) {
            return allJarFilesInLibMap;
        }
        for (File file : allJarFilesInLib = libForld.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        })) {
            allJarFilesInLibMap.put(file.getName(), file);
        }
        return allJarFilesInLibMap;
    }

    public static void launcher() throws Exception {
        MulticastSend multicastSend = new MulticastSend();
        multicastSend.setUniqueID(Main.LOCAL_SERVER_UUID);
        multicastSend.start();
        multicastSend.join();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!cl.getClass().getName().endsWith("JNLPClassLoader")) {
            String mainClassName = "com.kingdee.bos.app.launcher.Launcher";
            Class<?> mainClas = Class.forName(mainClassName);
            Method method = mainClas.getMethod("launcher", new Class[0]);
            method.invoke(null, (Object[])null);
            return;
        }
        JNLPToLocalLauncher.mkdirsDirectory(LIB_HOME);
        JNLPToLocalLauncher.mkdirsDirectory(CONFIG_HOME);
        AppRootFolderUtil.clearClientAll("qs");
        JNLPToLocalLauncher.mkdirsDirectory(HOME + File.separatorChar + "qs");
        Map<String, File> allJarFilesInLibMap = JNLPToLocalLauncher.getJarFilesInLib();
        Properties oldJNLPJarProperties = JNLPToLocalLauncher.getJNLPJarProperties();
        Properties jnlpJarProperties = new Properties();
        JNLPClassLoaderIf wsLoader = (JNLPClassLoaderIf)cl;
        LaunchDesc launchDesc = wsLoader.getLaunchDesc();
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        List<JARDesc> list = Arrays.asList(resourcesDesc.getLocalJarDescs());
        for (JARDesc jd : list) {
            if (jd == null) continue;
            String jarLocationString = jd.getLocationString();
            String fileName = JNLPToLocalLauncher.getFileName(jarLocationString);
            String version = JNLPToLocalLauncher.getFileVersion(jarLocationString);
            jnlpJarProperties.setProperty(fileName, version);
            String oldVersion = oldJNLPJarProperties.getProperty(fileName);
            allJarFilesInLibMap.remove(fileName);
            String filePath = JNLPToLocalLauncher.getFileFullPath(fileName);
            File newFile = new File(filePath);
            if (oldVersion != null && version.equals(oldVersion) && newFile.exists()) continue;
            JarFile jarFile = wsLoader.getJarFile(jd.getLocation());
            JNLPToLocalLauncher.copyJarByJarFile(jarFile, newFile);
        }
        if (!allJarFilesInLibMap.isEmpty()) {
            Set<Map.Entry<String, File>> entrySet = allJarFilesInLibMap.entrySet();
            for (Map.Entry<String, File> entry : entrySet) {
                File file = entry.getValue();
                if (file.delete()) continue;
                LOGGER.error((Object)("failed to delete file : " + file.getCanonicalPath()));
            }
        }
        JNLPToLocalLauncher.saveJNLPJarProperties(jnlpJarProperties);
        JNLPToLocalLauncher.startApp();
    }

    private static Properties getJNLPJarProperties() throws IOException {
        Properties properties = new Properties();
        File propertiesFile = new File(CONFIG_HOME + File.separatorChar + "JNLPJar.properties");
        if (propertiesFile.exists()) {
            properties.load(new FileInputStream(propertiesFile));
        }
        return properties;
    }

    private static void saveJNLPJarProperties(Properties properties) throws IOException {
        File propertiesFile = new File(CONFIG_HOME + File.separatorChar + "JNLPJar.properties");
        properties.store(new FileOutputStream(propertiesFile), "");
    }

    private static String getFileName(String locationString) {
        if (locationString.lastIndexOf(47) > 0) {
            locationString = locationString.substring(locationString.lastIndexOf(47) + 1);
        }
        if (locationString.lastIndexOf(63) > 0) {
            locationString = locationString.substring(0, locationString.lastIndexOf(63));
        }
        return locationString;
    }

    private static String getFileVersion(String locationString) {
        return locationString.substring(locationString.lastIndexOf("version=") + 8);
    }

    private static String getFileFullPath(String fileName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LIB_HOME);
        buffer.append(File.separatorChar);
        buffer.append(fileName);
        return buffer.toString();
    }

    private static void setJVMMemory() {
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean)ManagementFactoryHelper.getOperatingSystemMXBean();
        int freePhysicalMemory = (int)(systemMXBean.getFreePhysicalMemorySize() / 0x100000L);
        int xmx = Math.max(Math.min(freePhysicalMemory / 3, 2048), 512);
        XMX = xmx + "m";
    }

    private static void startApp() {
        try {
            JNLPToLocalLauncher.setJVMMemory();
            Object[] args = CtrlUtil.isWinOS() ? new String[]{"java", "-Xms" + XMS, "-Xmx" + XMX, "-Dfile.encoding=GBK", "-Djnlp.webVersion=" + System.getProperty("jnlp.webVersion"), "-Djnlp.token=" + System.getProperty("jnlp.token"), "-Djnlp.serverUrl=" + System.getProperty("jnlp.serverUrl"), "-classpath", "\"" + LIB_HOME + File.separatorChar + "*\"", Main.class.getName()} : new String[]{"java", "-Xms" + XMS, "-Xmx" + XMX, "-Dfile.encoding=GBK", "-Djnlp.webVersion=" + System.getProperty("jnlp.webVersion"), "-Djnlp.token=" + System.getProperty("jnlp.token"), "-Djnlp.serverUrl=" + System.getProperty("jnlp.serverUrl"), "-classpath", LIB_HOME + File.separatorChar + "*", Main.class.getName()};
            LOGGER.info((Object)("args :" + Arrays.toString(args)));
            final Process process = Runtime.getRuntime().exec((String[])args);
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            Thread redirectStdout = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = process.getInputStream();
                    try {
                        IOUtil.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                    }
                    catch (IOException var3) {
                        LOGGER.error((Object)var3);
                        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    }
                }
            });
            final StringBuilder errBuilder = new StringBuilder();
            Thread redirectStderr = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = process.getErrorStream();
                    try {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        IOUtil.copy((InputStream)inputStream, (OutputStream)output);
                        byte[] bytes = output.toByteArray();
                        errBuilder.append(new String(bytes, StandardCharsets.UTF_8));
                    }
                    catch (IOException var3) {
                        LOGGER.error((Object)var3);
                        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    }
                }
            });
            redirectStdout.start();
            redirectStderr.start();
            redirectStdout.join(20000L);
            redirectStderr.join(20000L);
            boolean succeed = JNLPToLocalLauncher.waitForProcess(process, 10L, TimeUnit.SECONDS);
            LOGGER.info((Object)byteArrayOutputStream.toString(Charset.defaultCharset().name()));
            if (errBuilder.length() > 0) {
                String errContent = errBuilder.toString();
                LOGGER.warn((Object)("start launcher error:" + errContent));
            }
            LOGGER.info((Object)("start launcher broker result :" + (succeed ? "succeed" : "failed")));
            Thread.sleep(10000L);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        System.exit(0);
    }

    private static boolean waitForProcess(Process proc, long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        while (true) {
            try {
                int exitCode = proc.exitValue();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("proc.exitValue:" + exitCode));
                }
                return false;
            }
            catch (IllegalThreadStateException var9) {
                if (rem <= 0L) continue;
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                if ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L) continue;
                return true;
            }
            break;
        }
    }
}

