/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher.daemon;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.launcher.useragent.manager.UserAgentManager;
import com.kingdee.bos.app.xlet.IXlet;
import com.kingdee.bos.extreport.utils.JsonUtil;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class VersionManagerDaemon {
    private static final Logger LOGGER = Logger.getLogger(VersionManagerDaemon.class);
    private static final String URL_PATTERN = "%s/auth/launcher/versionCheck.do";
    private static ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private static HashMap<IXlet, Boolean> xletNotifiedMap = new HashMap();
    private static Set<IXlet> openedXlet = new HashSet<IXlet>();

    public static void startVersionCheck() {
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    openedXlet.clear();
                    int userCount = UserAgentManager.getUserAgentCount();
                    for (int i = 0; i < userCount; ++i) {
                        Object[] xlets;
                        UserAgent agent = UserAgentManager.queryUserAgent(i);
                        if (agent == null || agent.getServiceGateway() == null) continue;
                        String versionMapStr = null;
                        versionMapStr = HttpClientUtils.get((String)String.format(VersionManagerDaemon.URL_PATTERN, agent.getServiceGateway()));
                        HashMap versionMap = (HashMap)JsonUtil.decodeFromString((String)versionMapStr, HashMap.class);
                        String webVersion = (String)versionMap.get("jnlp.webVersion");
                        String guiVersion = System.getProperty("jnlp.webVersion");
                        if (StringUtils.equals((CharSequence)guiVersion, (CharSequence)webVersion)) continue;
                        for (Object o : xlets = agent.getXletManager().getAllXlets()) {
                            final IXlet xlet = (IXlet)o;
                            openedXlet.add(xlet);
                            if (xletNotifiedMap.get(xlet) != null && !((Boolean)xletNotifiedMap.get(xlet)).equals(Boolean.FALSE)) continue;
                            LOGGER.info((Object)("\u5ba2\u6237\u7aef\u7248\u672c\uff1a" + guiVersion + ", \u670d\u52a1\u5668\u7248\u672c\uff1a" + webVersion));
                            xletNotifiedMap.put(xlet, Boolean.TRUE);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    MessageUtil.msgboxWarning((Component)xlet.getFrame(), (String)QingRptLauncherMessages.getMLS("currentClientVersionMismatch", "\u5f53\u524d\u5ba2\u6237\u7aef\u7248\u672c\u548c\u670d\u52a1\u5668\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9000\u51fa\u5ba2\u6237\u7aef\u91cd\u65b0\u8fdb\u5165"));
                                }
                            }).start();
                        }
                    }
                    HashSet mappedXlet = new HashSet(xletNotifiedMap.keySet());
                    mappedXlet.removeAll(openedXlet);
                    for (IXlet xlet : mappedXlet) {
                        xletNotifiedMap.remove(xlet);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"\u7248\u672c\u68c0\u6d4b\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
                }
            }
        }, 30L, 60L, TimeUnit.SECONDS);
    }
}

