/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher.handler;

import com.kingdee.bos.app.launcher.handler.BadMessageException;
import com.kingdee.bos.app.launcher.handler.ICommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.AppExitCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.DisposeXletCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.HeartbeatCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.LaunchXletCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.UserLogoutCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.WebDataSetCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.WebHyperCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.WebPreviewCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.WebRefreshCommandHandler;
import com.kingdee.bos.app.launcher.handler.impl.WebStopPollingCommandHandler;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.extreport.launcher.model.ExchangeMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommandHandlerManager {
    private static Map<String, ICommandHandler> HANDLERS = new HashMap<String, ICommandHandler>();
    private static final Logger LOGGER = Logger.getLogger(CommandHandlerManager.class);

    public static ExchangeMessage handle(ExchangeMessage message, UserAgent agent) {
        ExchangeMessage messagechain = null;
        try {
            while (message != null) {
                ExchangeMessage current = HANDLERS.get(message.command).handle(message, agent);
                current.setUuid(message.getUuid());
                if (messagechain != null) {
                    messagechain.forward_message = current;
                } else {
                    messagechain = current;
                }
                message = message.forward_message;
            }
        }
        catch (BadMessageException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ExchangeMessage current = new ExchangeMessage();
            current.command = message.command;
            ArrayList<String> list = new ArrayList<String>();
            list.add("OP_FAILED");
            current.information = list;
            if (messagechain != null) {
                messagechain.forward_message = current;
            }
            messagechain = current;
        }
        return messagechain;
    }

    static {
        HANDLERS.put("HEARTBEAT", new HeartbeatCommandHandler());
        HANDLERS.put("LAUNCH_XLET", new LaunchXletCommandHandler());
        HANDLERS.put("DISPOSE_XLET", new DisposeXletCommandHandler());
        HANDLERS.put("APP_EXIT", new AppExitCommandHandler());
        HANDLERS.put("USER_LOGOUT", new UserLogoutCommandHandler());
        HANDLERS.put("WEB_REFRESH", new WebRefreshCommandHandler());
        HANDLERS.put("WEB_CUSTOM_HYPER", new WebHyperCommandHandler());
        HANDLERS.put("WEB_BILL_HYPER", new WebHyperCommandHandler());
        HANDLERS.put("WEB_STOP_POLLING", new WebStopPollingCommandHandler());
        HANDLERS.put("WEB_PREVIEW_RPT", new WebPreviewCommandHandler());
        HANDLERS.put("WEB_DATASET_DESIGNER", new WebDataSetCommandHandler());
        HANDLERS.put("WEB_DATASET_PREVIEW", new WebDataSetCommandHandler());
    }
}

