/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.proxy;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianServiceException;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.xlet.util.exception.AppFrameworkException;
import com.kingdee.bos.app.xlet.util.exception.QingReportLicenseRuntimeException;
import com.kingdee.bos.extreport.common.model.COSMILoginVO;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.extreport.utils.IOUtil;
import com.kingdee.bos.extreport.utils.JsonUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HessianClient {
    private static final Logger LOGGER = Logger.getLogger(HessianClient.class);
    private static final String URL_PATTERN = "%s/qing_rpt/hessian.do?access_token=%s&isSync=%s&id=%s&clientID=%s&callID=%s";
    private static final String URL_POLLING_PATTERN = "%s/qing_rpt/hessianPolling.do?access_token=%s&id=%s&clientID=%s&callID=%s";
    private String remoteServiceName;
    private boolean isSync = false;
    private static final String QING_REPORT_NOLICENSE = "3010005";
    private static final String QING_REPORT_NOTREGISTEREDUSER = "3010006";

    public HessianClient(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }

    public HessianClient(String remoteServiceName, boolean isSync) {
        this.remoteServiceName = remoteServiceName;
        this.isSync = isSync;
    }

    public static CloseableHttpClient createIgnoreSSLHttpClient() throws GeneralSecurityException {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        MyTrustStrategy trustStrategy = new MyTrustStrategy();
        sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)trustStrategy);
        SSLContext sslContext = sslContextBuilder.build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
    }

    public <T> T call(Boolean log, UserAgent agent, String method, Class<T> returnType, Object ... args) {
        return this.callInner(log, agent, method, returnType, args);
    }

    public <T> T call(UserAgent agent, String method, Class<T> returnType, Object ... args) {
        return this.callInner(true, agent, method, returnType, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T callInner(boolean log, UserAgent agent, String method, Class<T> returnType, Object ... args) {
        start = 0L;
        if (log) {
            start = System.currentTimeMillis();
        }
        clientID = UUID.randomUUID().toString();
        callID = UUID.randomUUID().toString();
        data = new ByteArrayOutputStream();
        hessianOutput = new Hessian2Output((OutputStream)data);
        client = null;
        isFirst = true;
        sleepTime = 1L;
        try {
            while (true) {
                post = null;
                try {
                    client = HessianClient.createIgnoreSSLHttpClient();
                    if (isFirst) {
                        isFirst = false;
                        hessianOutput.call(method, args);
                        hessianOutput.completeCall();
                        hessianOutput.close();
                        url = String.format("%s/qing_rpt/hessian.do?access_token=%s&isSync=%s&id=%s&clientID=%s&callID=%s", new Object[]{agent.getServiceGateway(), agent.getUserToken(), this.isSync, this.remoteServiceName, clientID, callID});
                        post = new HttpPost(url);
                        post.setEntity((HttpEntity)new ByteArrayEntity(data.toByteArray()));
                        post.addHeader("Content-Type", "multipart/form-data");
                    } else {
                        url = String.format("%s/qing_rpt/hessianPolling.do?access_token=%s&id=%s&clientID=%s&callID=%s", new Object[]{agent.getServiceGateway(), agent.getUserToken(), this.remoteServiceName, clientID, callID});
                        post = new HttpPost(url);
                    }
                    response = client.execute((HttpUriRequest)post);
                    statusCode = response.getStatusLine().getStatusCode();
                    switch (statusCode) {
                        case 200: 
                        case 201: {
                            in = response.getEntity().getContent();
                            oneByte = in.read();
                            if (oneByte == -1) ** GOTO lbl-1000
                            if (oneByte == 72) ** GOTO lbl38
                            this.parseNotHessian(oneByte, in);
                            ** GOTO lbl-1000
lbl38:
                            // 1 sources

                            var21_21 = this.parseHessian(in, returnType);
                            ** GOTO lbl51
                        }
                        default: {
                            throw new IllegalStateException("illegal http status code: " + statusCode);
                        }
                    }
                }
                catch (Throwable e) {
                    try {
                        HessianClient.LOGGER.debug((Object)"---------------------------------UserAgent---------------------------------");
                        HessianClient.LOGGER.debug((Object)agent);
                        this.throwUnknownError(e);
                    }
                    catch (Throwable var29_28) {
                        CloseUtil.close((Closeable[])new Closeable[]{client});
                        throw var29_28;
                    }
lbl51:
                    // 1 sources

                    CloseUtil.close((Closeable[])new Closeable[]{client});
                    return (T)var21_21;
lbl-1000:
                    // 2 sources

                    {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        ** break;
                    }
lbl55:
                    // 1 sources

                    CloseUtil.close((Closeable[])new Closeable[]{client});
                    CloseUtil.close((Closeable[])new Closeable[]{client});
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    HessianClient.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (sleepTime > 1000L) {
                    sleepTime = 1000L;
                    continue;
                }
                sleepTime *= 8L;
            }
        }
        finally {
            end = 0L;
            if (log) {
                end = System.currentTimeMillis();
            }
            argsString = new StringBuilder();
            if (args != null) {
                for (Object arg : args) {
                    argsString.append(arg).append(" ");
                }
            }
            if (log) {
                HessianClient.LOGGER.info((Object)("HessianClient call " + method + " " + argsString + " cost" + (end - start)));
            }
        }
    }

    private void parseNotHessian(int oneByte, InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(oneByte);
        IOUtil.copy((InputStream)in, (OutputStream)out);
        String content = new String(out.toByteArray(), StandardCharsets.UTF_8);
        COSMILoginVO cosmiLoginVO = (COSMILoginVO)JsonUtil.decodeFromString((String)content, COSMILoginVO.class);
        if (cosmiLoginVO != null && cosmiLoginVO.getErrorCode() > 0) {
            throw new IllegalArgumentException("ErrorCode:" + cosmiLoginVO.getErrorCode() + " message :" + cosmiLoginVO.getErrorDesc());
        }
        LOGGER.error((Object)("\u975e\u6709\u6548Hessian\u62a5\u6587\uff0c\u62a5\u6587\u5185\u5bb9\uff1a" + content));
        throw new IllegalArgumentException(QingRptLauncherMessages.getMLS("invalidHessianMessage", "\u975e\u6709\u6548Hessian\u62a5\u6587\uff01"));
    }

    private Object parseHessian(InputStream stream, Class<?> returnType) throws Throwable {
        try {
            stream.read();
            stream.read();
            Hessian2Input hessianInput = new Hessian2Input(stream);
            Object retrieved = hessianInput.readReply(returnType);
            hessianInput.close();
            return retrieved;
        }
        catch (HessianServiceException e) {
            Object err = e.getDetail();
            if (err != null) {
                LOGGER.debug((Object)"", (Throwable)e);
            }
            this.throwUnknownError(e);
            return null;
        }
    }

    private void throwUnknownError(Throwable ex) {
        if (ex instanceof QingReportLicenseRuntimeException) {
            throw new QingReportLicenseRuntimeException(ex.getMessage(), ex);
        }
        if (ex instanceof HessianServiceException) {
            HessianServiceException hessianException = (HessianServiceException)ex;
            if (QING_REPORT_NOLICENSE.equals(hessianException.getCode())) {
                throw new QingReportLicenseRuntimeException(QingRptLauncherMessages.getMLS("noLicenseForLightReportModule", "\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u3010\u8f7b\u62a5\u8868\u3011\u6a21\u5757\u7684\u4f7f\u7528\u8bb8\u53ef\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\u3002"), ex);
            }
            if (QING_REPORT_NOTREGISTEREDUSER.equals(hessianException.getCode())) {
                throw new QingReportLicenseRuntimeException(QingRptLauncherMessages.getMLS("noLicenseForAccount", "\u60a8\u6240\u4f7f\u7528\u7684\u8d26\u6237\u6ca1\u6709\u88ab\u5206\u914d\u3010\u8f7b\u62a5\u8868\u3011\u6a21\u5757\u7684\u4f7f\u7528\u8bb8\u53ef\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\u3002"), ex);
            }
        }
        throw new AppFrameworkException("client encounterred an unknown server failure!", ex);
    }

    private static class MyTrustStrategy
    implements TrustStrategy {
        private MyTrustStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

