/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet;

import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.launcher.useragent.util.UserAgentUtil;
import com.kingdee.bos.app.launcher.util.COSMICLoginUtil;
import com.kingdee.bos.app.proxy.context.IXletContext;
import com.kingdee.bos.app.proxy.context.impl.DSDesignerContext;
import com.kingdee.bos.app.proxy.context.impl.RptDesignerContext;
import com.kingdee.bos.app.proxy.context.impl.RptSnapEditorContext;
import com.kingdee.bos.app.xlet.IXlet;
import com.kingdee.bos.app.xlet.impl.dsdesigner.DSDesignerXlet;
import com.kingdee.bos.app.xlet.impl.rptdesigner.RptDesignerXlet;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.RptSnapEditorXlet;
import com.kingdee.bos.extreport.launcher.model.ExchangeMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class XletManager {
    private static Logger LOGGER = Logger.getLogger(XletManager.class);
    public static final String XLET_RPT_DESIGNER = "RPT_DESIGNER";
    public static final String XLET_RPT_DS_DESIGNER = "RPT_DS_DESIGNER";
    public static final String XLET_RPT_SNAP_DESIGNER = "RPT_SNAP_DESIGNER";
    private TreeMap<IXletContext, IXlet> xletRepo = new TreeMap();
    private UserAgent agent;

    public XletManager(UserAgent agent) {
        this.agent = agent;
    }

    public Object[] getAllXlets() {
        return this.xletRepo.values().toArray();
    }

    public synchronized void launch(ExchangeMessage message) {
        final IXlet xlet = this.createXlet(message);
        if (xlet == null) {
            return;
        }
        if (xlet.isAlive()) {
            xlet.active();
        } else {
            if (!this.putXletToRepo(xlet)) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Launched: " + xlet));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            xlet.launch();
                        }
                        catch (Throwable t) {
                            LOGGER.error((Object)"can not initialize xlet ", t);
                            XletManager.this.xletRepo.remove(xlet.getContext());
                            if (!LOGGER.isDebugEnabled()) break block2;
                            LOGGER.debug((Object)("Error occurs during " + xlet + "'s launching process: " + t.getMessage()));
                        }
                    }
                }
            });
        }
    }

    public void quit(IXlet xlet, boolean doActually) {
        if (xlet != null) {
            this.xletRepo.remove(xlet.getContext());
            if (doActually) {
                xlet.quit();
            }
            String clientId = xlet.getContext().getClientId();
            HashSet<String> clientIdSet = new HashSet<String>(this.xletRepo.size());
            for (Map.Entry<IXletContext, IXlet> entry : this.xletRepo.entrySet()) {
                clientIdSet.add(entry.getKey().getClientId());
            }
            if (!clientIdSet.contains(clientId)) {
                UserAgentUtil.sendStopPollingCommand2WebBrowser(xlet.getContext());
            }
        }
    }

    public void quitAll() {
        Iterator it = ((TreeMap)this.xletRepo.clone()).keySet().iterator();
        while (it.hasNext()) {
            this.xletRepo.get(it.next()).quit();
        }
        this.checkAppHaltPrecondition();
    }

    private void checkAppHaltPrecondition() {
        if (this.xletRepo.size() == 0) {
            System.exit(0);
        }
    }

    protected IXlet createXlet(ExchangeMessage message) {
        this.syncDefaultLocale();
        ArrayList arguments = message.information;
        String xletName = (String)arguments.get(0);
        if (XLET_RPT_DESIGNER.equals(xletName)) {
            RptDesignerContext context = new RptDesignerContext(this.agent);
            context.setClientId(message.clientId);
            context.setIsPreview(true);
            context.setExtReportId((String)arguments.get(1));
            context.setExtReportGroupID((String)arguments.get(2));
            context.setPreset(Boolean.parseBoolean((String)arguments.get(4)));
            context.setPresetGroupPerm(Boolean.parseBoolean((String)arguments.get(5)));
            IXlet xlet = this.xletRepo.get(context);
            if (xlet != null && xlet.getType() == XLET_RPT_DESIGNER) {
                this.copyContext(xlet, context);
                return xlet;
            }
            return new RptDesignerXlet(context);
        }
        if (XLET_RPT_SNAP_DESIGNER.equals(xletName)) {
            RptSnapEditorContext context = new RptSnapEditorContext(this.agent);
            context.setClientId(message.clientId);
            context.setIsPreview(false);
            context.setExtReportId((String)arguments.get(1));
            context.setExtReportSnapID((String)arguments.get(2));
            context.setExtReportSnapName((String)arguments.get(3));
            IXlet xlet = this.xletRepo.get(context);
            if (xlet != null && XLET_RPT_SNAP_DESIGNER.equals(xlet.getType())) {
                this.copyContext(xlet, context);
                return xlet;
            }
            return new RptSnapEditorXlet(context);
        }
        if (XLET_RPT_DS_DESIGNER.equals(xletName)) {
            DSDesignerContext dscontext = new DSDesignerContext(this.agent);
            dscontext.setClientId(message.clientId);
            dscontext.setDataSourceId((String)arguments.get(1));
            dscontext.setDataSourceName((String)arguments.get(2));
            dscontext.setMetaFolderId((String)arguments.get(3));
            dscontext.setDataSourceType((String)arguments.get(4));
            dscontext.setPreset(Boolean.parseBoolean((String)arguments.get(5)));
            dscontext.setPresetGroupPerm(Boolean.parseBoolean((String)arguments.get(6)));
            IXlet xlet = this.xletRepo.get(dscontext);
            if (xlet != null && xlet.getType() == XLET_RPT_DS_DESIGNER) {
                this.copyContext(xlet, dscontext);
                return xlet;
            }
            xlet = new DSDesignerXlet(dscontext);
            return xlet;
        }
        throw new IllegalArgumentException("unrecognized xlet symbol: " + xletName);
    }

    private void syncDefaultLocale() {
        if (this.xletRepo.size() != 0) {
            return;
        }
        String token = this.agent.getUserToken();
        String serverUrl = this.agent.getServiceGateway();
        COSMICLoginUtil.syncDefaultLocale(serverUrl, token);
    }

    private boolean putXletToRepo(IXlet xlet) {
        if (this.xletRepo.get(xlet.getContext()) == null) {
            this.xletRepo.put((IXletContext)xlet.getContext(), xlet);
            return true;
        }
        return false;
    }

    private void copyContext(IXlet xlet, IXletContext context) {
        if (context instanceof RptDesignerContext) {
            RptDesignerContext rptDesignerContext = (RptDesignerContext)context;
            ((RptDesignerContext)xlet.getContext()).setClientId(rptDesignerContext.getClientId());
            ((RptDesignerContext)xlet.getContext()).setIsPreview(rptDesignerContext.isPreview());
            ((RptDesignerContext)xlet.getContext()).setExtReportGroupID(rptDesignerContext.getExtReportGroupID());
            ((RptDesignerContext)xlet.getContext()).setPreset(rptDesignerContext.getPreset());
            ((RptDesignerContext)xlet.getContext()).setPresetGroupPerm(rptDesignerContext.getPresetGroupPerm());
        } else if (context instanceof DSDesignerContext) {
            DSDesignerContext dsDesignerContext = (DSDesignerContext)context;
            ((DSDesignerContext)xlet.getContext()).setClientId(dsDesignerContext.getClientId());
            ((DSDesignerContext)xlet.getContext()).setDataSourceName(dsDesignerContext.getDataSourceName());
            ((DSDesignerContext)xlet.getContext()).setMetaFolderId(dsDesignerContext.getMetaFolderId());
            ((DSDesignerContext)xlet.getContext()).setDataSourceType(dsDesignerContext.getDataSourceType());
            ((DSDesignerContext)xlet.getContext()).setPreset(dsDesignerContext.getPreset());
            ((DSDesignerContext)xlet.getContext()).setPresetGroupPerm(dsDesignerContext.getPresetGroupPerm());
        } else if (context instanceof RptSnapEditorContext) {
            RptSnapEditorContext rptSnapEditorContext = (RptSnapEditorContext)context;
            ((RptSnapEditorContext)xlet.getContext()).setClientId(rptSnapEditorContext.getClientId());
            ((RptSnapEditorContext)xlet.getContext()).setIsPreview(rptSnapEditorContext.isPreview());
            ((RptSnapEditorContext)xlet.getContext()).setExtReportSnapName(rptSnapEditorContext.getExtReportSnapName());
        }
    }
}

