/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.dsdesigner;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.proxy.context.impl.DSDesignerContext;
import com.kingdee.bos.app.proxy.impl.SQLDesignerProxy;
import com.kingdee.bos.app.xlet.IXlet;
import com.kingdee.bos.app.xlet.util.GlobalLockUtil;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.ReportFrame;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.report.ext.model.SQLCustomType;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class DSDesignerXlet
implements IXlet<DSDesignerContext> {
    private static final Logger logger = Logger.getLogger(DSDesignerXlet.class);
    private DSDesignerContext context;
    private ReportFrame reportDialog;
    private DesignUI designUI;
    private String defaultNewName;

    public DSDesignerXlet(DSDesignerContext context) {
        this.context = context;
        this.defaultNewName = QingRptLauncherMessages.getMLS("create", "\u65b0\u5efa") + SQLCustomType.getType((String)context.getDataSourceType()).getName();
        if (!this.defaultNewName.endsWith(QingRptLauncherMessages.getMLS("dataset", "\u6570\u636e\u96c6")) && !this.defaultNewName.endsWith("\u6570\u636e\u96c6")) {
            this.defaultNewName = this.defaultNewName + QingRptLauncherMessages.getMLS("dataset", "\u6570\u636e\u96c6");
        }
    }

    @Override
    public void launch() {
        this.refreshUI();
    }

    @Override
    public void quit() {
        if (this.designUI != null) {
            this.designUI.destroyWindow();
        }
        if (this.reportDialog != null) {
            this.reportDialog.dispose();
        }
    }

    @Override
    public void active() {
        this.setMetaMapData();
        this.reportDialog.setTitle(this.getName());
        this.reportDialog.setState(0);
        this.reportDialog.toFront();
    }

    private void refreshUI() {
        Context c = new Context();
        c.putSessionSQLDesignerProxy(new SQLDesignerProxy(this.context));
        String dataSourceName = this.context.getDataSourceName();
        String dataSourceID = this.context.getDataSourceId();
        try {
            this.designUI = new DesignUI(c);
            this.setMetaMapData();
            this.designUI.refresh();
            if (dataSourceName == null) {
                dataSourceName = this.defaultNewName;
            }
            this.reportDialog = new ReportFrame(this.designUI, QingRptLauncherMessages.getMLS("lightReportDataSetDesigner", "\u8f7b\u62a5\u8868 \u6570\u636e\u96c6\u8bbe\u8ba1\u5668"), true);
            this.reportDialog.setTitle(QingRptLauncherMessages.getMLS("lightReportDataSetDesignerDash", "\u8f7b\u62a5\u8868 \u6570\u636e\u96c6\u8bbe\u8ba1\u5668 - ") + dataSourceName);
            this.reportDialog.setIconImage(((ImageIcon)UIManager.getIcon("Frame.Icon")).getImage());
            this.reportDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    DSDesignerXlet.this.context.getUserAgent().getXletManager().quit(DSDesignerXlet.this, false);
                }
            });
            GlobalLockUtil.lock(dataSourceID, this.context.getUserAgent());
            this.reportDialog.setVisible(true);
        }
        catch (Exception e) {
            logger.error((Object)"\u542f\u52a8\u6570\u636e\u96c6\u8bbe\u8ba1\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    private void setMetaMapData() {
        String dataSourceName = this.context.getDataSourceName();
        String dataSourceID = this.context.getDataSourceId();
        String groupId = this.context.getMetaFolderId();
        String isolateTag = this.context.getUserID();
        SQLCustomType sqlCustomType = SQLCustomType.getType((String)this.context.getDataSourceType());
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("leafParentTreePath", groupId);
        mapData.put("fname", dataSourceName);
        mapData.put("fid", dataSourceID);
        mapData.put("customType", sqlCustomType);
        mapData.put("isolateTag", isolateTag);
        this.designUI.setMapData(mapData);
    }

    @Override
    public DSDesignerContext getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        if (this.context.getDataSourceName() == null) {
            return QingRptLauncherMessages.getMLS("lightReportDataSetDesignerNew", "\u8f7b\u62a5\u8868 \u6570\u636e\u96c6\u8bbe\u8ba1\u5668 - \u65b0\u5efa\u6570\u636e\u96c6");
        }
        return QingRptLauncherMessages.getMLS("lightReportDataSetDesignerDash", "\u8f7b\u62a5\u8868 \u6570\u636e\u96c6\u8bbe\u8ba1\u5668 - ") + this.context.getDataSourceName();
    }

    @Override
    public boolean isAlive() {
        if (this.reportDialog == null) {
            return false;
        }
        return this.reportDialog.isVisible();
    }

    @Override
    public String getType() {
        return "RPT_DS_DESIGNER";
    }

    @Override
    public boolean isDisplayable() {
        return true;
    }

    @Override
    public KDFrame getFrame() {
        return this.reportDialog;
    }
}

