/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptdesigner;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.proxy.FacadeFactory;
import com.kingdee.bos.app.proxy.context.impl.RptDesignerContext;
import com.kingdee.bos.app.proxy.facade.RptDesignerFacade;
import com.kingdee.bos.app.proxy.impl.rpt.ExtReportTreeProxy;
import com.kingdee.bos.app.xlet.IXlet;
import com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.ExtCallbackImpl;
import com.kingdee.bos.app.xlet.impl.rptdesigner.rptattribute.KBIReportViewConstraintsWizard;
import com.kingdee.bos.app.xlet.util.GlobalLockUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DataSetDefineModel;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.showcase.ReportViewConstraintsWizard;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.workbench.splash.NotifyObject;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RptDesignerXlet
implements IXlet<RptDesignerContext> {
    private static final Logger logger = Logger.getLogger(RptDesignerXlet.class);
    private KDExt _ext;
    private RptDesignerContext _context;
    private RptDesignerFacade _facade;
    public static String Wizard_ReportViewConstraints = "Wizard_ReportViewConstraints";

    public RptDesignerXlet(RptDesignerContext context) {
        this._context = context;
    }

    @Override
    public void launch() {
        this._facade = FacadeFactory.createRptDesignerFacade(this._context);
        final ExtCallbackImpl callback = new ExtCallbackImpl(this._facade);
        this._ext = new KDExt((IExtCallback)callback);
        this._ext.setPathDefiner(new KDExt.IPathDefiner(){

            public String defineName(String datasetDefine) {
                DataSetDefineModel dataSetDefineModel = DataSetDefineModel.parseDefine((String)datasetDefine);
                String dbSourceName = dataSetDefineModel.getName();
                String groupName = dataSetDefineModel.getGroupName();
                String groupType = dataSetDefineModel.getGroupType();
                if (StringUtil.isEmptyString((String)groupName)) {
                    String groupId = dataSetDefineModel.getGroupID();
                    groupName = new ExtReportTreeProxy(RptDesignerXlet.this._context.getUserAgent()).findFullPath(groupId);
                    groupName = groupName.replaceAll("/", "\\\\");
                    groupName = groupName + "\\" + QingRptLauncherMessages.getMLS("sqlDataset", "SQL\u6570\u636e\u96c6");
                } else {
                    groupName = groupName.replaceAll("\\\\", "/");
                }
                String[] split = groupType.split("\\\\");
                if (split.length > 1) {
                    return QingRptLauncherMessages.getMLS("dataSetNamePath", "\u6570\u636e\u96c6\u540d\u79f0\uff1a#1\uff0c\u8def\u5f84\uff1a").replace("#1", dbSourceName) + split[1] + "/" + groupName;
                }
                return QingRptLauncherMessages.getMLS("dataSetNamePath", "\u6570\u636e\u96c6\u540d\u79f0\uff1a#1\uff0c\u8def\u5f84\uff1a").replace("#1", dbSourceName) + split[0] + "/" + groupName;
            }
        });
        callback.setKDExt(this._ext);
        this.setTitle();
        this._ext.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                RptDesignerXlet.this._context.getUserAgent().getXletManager().quit(RptDesignerXlet.this, false);
                GlobalLockUtil.releaseLock(RptDesignerXlet.this._context.getExtReportId(), RptDesignerXlet.this._context.getUserAgent());
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RptDesignerXlet.this._ext.refresh();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    MiscUtil.handleFileCheckingException((Exception)ex, (Component)RptDesignerXlet.this._ext);
                    callback.closeNotify();
                    NotifyObject.getCurrentInstance().notice(100, QingRptLauncherMessages.getMLS("lightReportOpenFailed", "\u8f7b\u62a5\u8868\u6253\u5f00\u5931\u8d25"));
                    return;
                }
                GlobalLockUtil.lock(RptDesignerXlet.this._context.getExtReportId(), RptDesignerXlet.this._context.getUserAgent());
                RptDesignerXlet.this._ext.setVisible(true);
                RptDesignerXlet.this._ext.toFront();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ISpreadWizzard w = RptDesignerXlet.this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportViewConstraints);
                        ShowcaseConfig config = new ShowcaseConfig();
                        config.setShowFormula(true);
                        config.setEditable(true);
                        config.setHideEditable(true);
                        if (!(w instanceof KBIReportViewConstraintsWizard) && w instanceof ReportViewConstraintsWizard) {
                            ReportViewConstraintsWizard wizzard = (ReportViewConstraintsWizard)w;
                            wizzard.setDefaultShowcaseConfig(config);
                        }
                    }
                });
            }
        }, "Splash Update Thread").start();
    }

    private void setTitle() {
        if (this._context.getExtReportId() != null) {
            this._ext.setTitle(QingRptLauncherMessages.getMLS("lightReportDesigner", "\u8f7b\u62a5\u8868 \u62a5\u8868\u8bbe\u8ba1\u5668") + " - " + this._facade.getName(true));
        } else {
            this._ext.setTitle(QingRptLauncherMessages.getMLS("lightReportDesigner", "\u8f7b\u62a5\u8868 \u62a5\u8868\u8bbe\u8ba1\u5668") + " - " + QingRptLauncherMessages.getMLS("newReport", "\u65b0\u5efa\u62a5\u8868"));
        }
    }

    @Override
    public void active() {
        this.setTitle();
        this._ext.setState(0);
        this._ext.toFront();
    }

    @Override
    public void quit() {
        if (this._ext != null) {
            this._ext.dispose();
        }
    }

    @Override
    public RptDesignerContext getContext() {
        return this._context;
    }

    @Override
    public String getName() {
        if (this._ext == null) {
            return QingRptLauncherMessages.getMLS("reportDesigner", "\u62a5\u8868\u8bbe\u8ba1\u5668");
        }
        return this._ext.getTitle();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.getName());
        buf.append(']');
        buf.append(" context:");
        buf.append(this._context);
        buf.append(" useragent:");
        buf.append(this._context.getUserAgent());
        return buf.toString();
    }

    @Override
    public boolean isAlive() {
        if (this._ext == null) {
            return false;
        }
        return this._ext.isVisible();
    }

    @Override
    public String getType() {
        return "RPT_DESIGNER";
    }

    @Override
    public boolean isDisplayable() {
        return true;
    }

    @Override
    public KDFrame getFrame() {
        return this._ext;
    }
}

