/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.ui.AbstractSelectedTargetUI;
import com.kingdee.bos.app.xlet.util.InteractiveUIUtil;
import com.kingdee.bos.app.xlet.util.TableManager;
import com.kingdee.bos.datawizard.edd.ctrlreport.adapter.TreeManager;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.bill.BillModelType;
import com.kingdee.cosmic.ctrl.ext.immit.bill.BillProp;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDComponentDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSplitPane;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.cosmic.ctrl.swing.util.JVM;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;

public class SelectedBillUI
extends AbstractSelectedTargetUI<BillProp> {
    private KDComponentDialog findDialog;
    private KDTextField findNextTxt;
    private KDComboBox findNextCom;
    private List<BillProp> nodeList;
    private BillProp selectedBill;
    private Map<String, List<BillProp>> entitiesCache = new HashMap<String, List<BillProp>>(64);
    private String textToFound = "";
    private String typeToFound = QingRptLauncherMessages.getMLS("allTypes", "\u5168\u90e8\u7c7b\u578b");
    private int foundIndex = -1;
    private int currentIndex = 0;
    private KDComponentDialog notFoundDialog;
    private KDComponentDialog finishSearchDialog;
    private boolean finishSearch = false;
    DefaultKingdeeTreeNode nodeRootCache;

    public SelectedBillUI() {
        this.dirTree.setRootVisible(false);
    }

    @Override
    protected void kDButtonRefreshActionPerformed(ActionEvent e) {
        this.entitiesCache.clear();
        this.loadTree();
    }

    @Override
    protected void initBounds() {
        super.initBounds();
        KDSplitPane splitPaneTable = new KDSplitPane(0);
        KDTreeView.ControlPanel controlPane = new KDTreeView.ControlPanel(QingRptLauncherMessages.getMLS("blank", ""));
        KDWorkButton findBtn = new KDWorkButton((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)this.getMLS("picFind", "tree_demand.png"))));
        findBtn.setActionCommand("findNode");
        findBtn.setToolTipText(this.getMLS("menuToolTipFind", QingRptLauncherMessages.getMLS("find", "\u67e5\u627e")));
        findBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectedBillUI.this.kDButtonFindActionPerformed(e);
            }
        });
        controlPane.add((Component)findBtn);
        FlowLayout layout = new FlowLayout(2, 0, 1);
        controlPane.setLayout((LayoutManager)layout);
        controlPane.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
        InputMap inputmap = this.getInputMap(1);
        inputmap.put(KeyStroke.getKeyStroke(70, 128), "findNext");
        ActionMap actionmap = this.getActionMap();
        actionmap.put("findNext", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectedBillUI.this.kDButtonFindActionPerformed(e);
            }
        });
        this.splitPane.add((Component)splitPaneTable, (Object)"right");
        splitPaneTable.add((Component)this.tableReport, (Object)"right");
        splitPaneTable.add((Component)controlPane, (Object)"left");
        splitPaneTable.setDividerSize(0);
        splitPaneTable.setDividerLocation(23);
    }

    @Override
    protected void init() {
        super.init();
        this.tableReport.addColumns(3);
        this.tableReport.getColumn(0).setWidth(250);
        this.tableReport.getColumn(0).setSortable(true);
        this.tableReport.getColumn(1).setWidth(150);
        this.tableReport.getColumn(2).setWidth(100);
        this.tableReport.addHeadRow();
        this.tableReport.getHeadRow(0).getCell(0).setValue((Object)this.getTargetName());
        this.tableReport.getHeadRow(0).getCell(1).setValue((Object)this.getTargetCode());
        this.tableReport.getHeadRow(0).getCell(2).setValue((Object)this.getTargetType());
        this.setPreferredSize(new Dimension(800, 600));
        this.initBounds();
    }

    public String getMLS(String key, String defaultValue) {
        return QingRptLauncherMessages.getMLS(key, defaultValue);
    }

    protected void kDButtonFindActionPerformed(ActionEvent e) {
        if (this.tableReport.getRowCount() <= 0) {
            return;
        }
        if (this.tableReport.getRowCount() > 0) {
            Window w = SwingUtilities.windowForComponent((Component)((Object)this));
            this.findDialog = w instanceof Dialog ? new KDComponentDialog((Dialog)w) : (w instanceof Frame ? new KDComponentDialog((Frame)w) : new KDComponentDialog());
            this.setFindDialogModal();
            this.findDialog.setLFStyle(2);
            this.findDialog.setTitle(this.getMLS("findNodeDialogTitle", QingRptLauncherMessages.getMLS("findPage", "\u67e5\u627e\u9875\u9762")));
            KDButton findNextBtn = new KDButton(this.getMLS("find", QingRptLauncherMessages.getMLS("find", "\u67e5\u627e")));
            findNextBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectedBillUI.this.findNode();
                }
            });
            findNextBtn.setLimitedSize(false);
            findNextBtn.setFocusable(false);
            KDButton closeBtn = new KDButton(this.getMLS("closeDialog", QingRptLauncherMessages.getMLS("closeBtn", "\u5173\u95ed")));
            closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectedBillUI.this.findDialog.dispose();
                }
            });
            this.findDialog.addButton(closeBtn);
            this.findDialog.addButton(findNextBtn);
            KDPanel panel = new KDPanel();
            panel.setPreferredSize(new Dimension(270, 120));
            KDLabelContainer findNextLabel = new KDLabelContainer();
            this.findNextTxt = new KDTextField();
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.findNextTxt, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
            findNextLabel.setBoundLabelText(this.getMLS("findNameAndEncoderLabel", QingRptLauncherMessages.getMLS("nameCode", "\u540d\u79f0/\u7f16\u7801     ")));
            findNextLabel.setBoundEditor((JComponent)this.findNextTxt);
            findNextLabel.setPreferredSize(new Dimension(260, 21));
            KDLabelContainer findNextTypeLable = new KDLabelContainer();
            this.findNextCom = new KDComboBox();
            Object[] typeItems = new String[]{this.getMLS("allKinds", QingRptLauncherMessages.getMLS("allTypes", "\u5168\u90e8\u7c7b\u578b")), this.getMLS("billForm", QingRptLauncherMessages.getMLS("document", "\u5355\u636e")), this.getMLS("baseForm", QingRptLauncherMessages.getMLS("basicData", "\u57fa\u7840\u8d44\u6599"))};
            this.findNextCom.addItems(typeItems);
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.findNextCom, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
            findNextTypeLable.setBoundLabelText(this.getMLS("findTypeLabel", QingRptLauncherMessages.getMLS("type", "\u7c7b\u578b") + "     "));
            findNextTypeLable.setBoundEditor((JComponent)this.findNextCom);
            findNextTypeLable.setPreferredSize(new Dimension(260, 21));
            panel.add((Component)findNextLabel);
            panel.add((Component)findNextTypeLable);
            this.findDialog.setDialogComponent((Component)panel);
            this.findDialog.setSize(290, 150);
            this.findDialog.setResizable(false);
            this.nodeList = new ArrayList<BillProp>(16);
            for (int i = 0; i < this.tableReport.getRowCount(); ++i) {
                BillProp billProp = (BillProp)this.tableReport.getRow(i).getUserObject();
                this.nodeList.add(billProp);
            }
            this.findDialog.getRootPane().setDefaultButton((JButton)findNextBtn);
            this.findDialog.setLocation(this.tableReport.getLocationOnScreen());
            this.findDialog.show();
        }
    }

    private void setFindDialogModal() {
        if (JVM.current().isOverOneDotFive() && this.findDialog != null) {
            this.findDialog.setModal(true);
        }
    }

    private void findNode() {
        String nodeText = "";
        String nodeCode = "";
        String nodeType = QingRptLauncherMessages.getMLS("allTypes", "\u5168\u90e8\u7c7b\u578b");
        int size = this.nodeList.size();
        String input = this.findNextTxt.getText().toLowerCase(Locale.ENGLISH).trim();
        String type = ((String)this.findNextCom.getSelectedItem()).toLowerCase(Locale.ENGLISH).trim();
        if (input.length() > 0 || type.length() > 0) {
            if (!this.textToFound.equalsIgnoreCase(input) && !this.typeToFound.equalsIgnoreCase(type)) {
                this.finishSearch = false;
                this.textToFound = input;
                this.typeToFound = type;
                this.foundIndex = -1;
                this.currentIndex = 0;
            } else if (!this.textToFound.equalsIgnoreCase(input)) {
                this.finishSearch = false;
                this.textToFound = input;
                this.foundIndex = -1;
                this.currentIndex = 0;
            } else if (!this.typeToFound.equalsIgnoreCase(type)) {
                this.finishSearch = false;
                this.typeToFound = type;
                this.foundIndex = -1;
                this.currentIndex = 0;
            }
            this.currentIndex = this.foundIndex + 1;
            if (this.currentIndex < size) {
                int i;
                for (i = this.currentIndex; i < size; ++i) {
                    BillProp currentNode = this.nodeList.get(i);
                    nodeText = currentNode.getName();
                    nodeType = currentNode.getType();
                    nodeCode = currentNode.getId();
                    nodeText = StringUtil.isEmptyString((String)nodeText) ? "" : nodeText.toLowerCase(Locale.ENGLISH);
                    String string = nodeType = StringUtil.isEmptyString((String)nodeType) ? "" : nodeType.toLowerCase(Locale.ENGLISH);
                    if (this.textToFound.length() > 0 && this.typeToFound.length() > 0) {
                        if ((nodeText.contains(this.textToFound) || nodeCode.contains(this.textToFound)) && nodeType.contains(this.typeToFound)) {
                            i = this.getSelectedIndex(i);
                            break;
                        }
                        if (!nodeText.contains(this.textToFound) && !nodeCode.contains(this.textToFound) || !this.typeToFound.contains(QingRptLauncherMessages.getMLS("allTypes", "\u5168\u90e8\u7c7b\u578b"))) continue;
                        i = this.getSelectedIndex(i);
                        break;
                    }
                    if (nodeType.contains(this.typeToFound)) {
                        i = this.getSelectedIndex(i);
                        break;
                    }
                    if (!this.typeToFound.contains(QingRptLauncherMessages.getMLS("allTypes", "\u5168\u90e8\u7c7b\u578b"))) continue;
                    i = this.getSelectedIndex(i);
                    break;
                }
                if (i == size) {
                    this.finishSearch = true;
                }
            }
            if (this.foundIndex == -1) {
                this.setTipInformation(this.notFoundDialog, "searchFinish", QingRptLauncherMessages.getMLS("searchCompletedNoResults", "\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879"));
            } else if (this.finishSearch) {
                this.setTipInformation(this.finishSearchDialog, "searchFinish2", QingRptLauncherMessages.getMLS("searchCompleted", "\u5df2\u7ecf\u5b8c\u6210\u641c\u7d22"));
            }
        } else {
            this.setTipInformation(this.notFoundDialog, "searchInfoError", QingRptLauncherMessages.getMLS("enterNameOrSelectType", "\u8bf7\u8f93\u5165\u540d\u79f0/\u7f16\u7801\u6216\u9009\u62e9\u7c7b\u578b"));
        }
    }

    protected int getSelectedIndex(int index) {
        ((KDButton)this.findDialog.getButtons().get(1)).setText(this.getMLS("findNext", QingRptLauncherMessages.getMLS("findNext", "\u67e5\u627e\u4e0b\u4e00\u4e2a")));
        this.tableReport.getSelectManager().select(index, 0);
        this.tableReport.scrollToVisible(index, 0);
        this.foundIndex = index;
        if (index == this.nodeList.size() - 1) {
            ++index;
        }
        return index;
    }

    protected void setTipInformation(KDComponentDialog Dialog2, String key, String value) {
        this.textToFound = "";
        this.typeToFound = "";
        if (Dialog2 == null) {
            Dialog2 = new KDComponentDialog((Dialog)this.findDialog);
            Dialog2.setLFStyle(2);
            Dialog2.setTitle(this.getMLS("notFindNodeDialogTitle", QingRptLauncherMessages.getMLS("informationReminder", "\u4fe1\u606f\u63d0\u9192")));
            KDButton ok = new KDButton(this.getMLS("OKBtn", QingRptLauncherMessages.getMLS("confirm2", "\u786e\u5b9a")));
            final KDComponentDialog finalDialog = Dialog2;
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    finalDialog.dispose();
                }
            });
            KDLabel notFoundLbl = new KDLabel(this.getMLS(key, value));
            notFoundLbl.setHorizontalAlignment(0);
            notFoundLbl.setPreferredSize(new Dimension(290, 21));
            Dialog2.addButton(ok);
            Dialog2.setDialogComponent((Component)notFoundLbl);
        } else {
            KDLabel notFoundLbl = new KDLabel(this.getMLS(key, value));
            notFoundLbl.setHorizontalAlignment(0);
            notFoundLbl.setPreferredSize(new Dimension(290, 21));
            Dialog2.setDialogComponent((Component)notFoundLbl);
        }
        Dialog2.setLocation(this.findDialog.getLocation());
        Dialog2.setSize(290, 118);
        Dialog2.setModal(true);
        Dialog2.show();
    }

    @Override
    protected void kDButtonCancelActionPerformed(ActionEvent e) {
        this.canceled = true;
        InteractiveUIUtil.closeInteractiveUI(this);
    }

    @Override
    protected void kDButtonOkActionPerformed(ActionEvent e) {
        ArrayList<Integer> lstIndex = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstIndex.isEmpty()) {
            WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("selectRecord", "\u8bf7\u9009\u62e9\u8bb0\u5f55\uff01"), (String)CtrlEXTMessages.getMLS((String)"messagePrompt", (String)"\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
            return;
        }
        if (lstIndex.size() != 1) {
            WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("onlySelectOne", "\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01"), (String)CtrlEXTMessages.getMLS((String)"messagePrompt", (String)"\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
            return;
        }
        this.canceled = false;
        IRow row = this.tableReport.getRow(lstIndex.get(0).intValue());
        this.value = (BillProp)row.getUserObject();
        ((BillProp)this.value).setPathAlias(this.backTrackPath(this.selectedNode));
        InteractiveUIUtil.closeInteractiveUI(this);
    }

    private String backTrackPath(DefaultKingdeeTreeNode childNode) {
        StringBuilder path = new StringBuilder(childNode.getText() + "/" + ((BillProp)this.value).getName());
        for (DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)childNode.getParent(); parent != null && !"Root".equals(parent.getUserObject()); parent = (DefaultKingdeeTreeNode)parent.getParent()) {
            path.insert(0, parent.getText() + "/");
        }
        return path.toString();
    }

    @Override
    protected void kDDirTreeValueChanged(TreeSelectionEvent e) {
        Object object = this.dirTree.getLastSelectedPathComponent();
        if (object == this.selectedNode) {
            return;
        }
        if (object instanceof DefaultKingdeeTreeNode) {
            this.selectedNode = (DefaultKingdeeTreeNode)object;
            if (((DefaultKingdeeTreeNode)object).isLeaf()) {
                if (this.selectedNode != null) {
                    this.selectedNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                }
                this.selectedNode.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
                JsonObject userObject = (JsonObject)this.selectedNode.getUserObject();
                List<BillProp> billProperties = this.entitiesCache.get(userObject.get("id").getAsString());
                if (billProperties.get(0).getType() == null) {
                    this.fillBillModelType(billProperties);
                }
                this.fillData(billProperties);
            } else {
                this.tableReport.removeRows();
            }
        } else {
            this.tableReport.removeRows();
        }
    }

    public void fillData(List<BillProp> billProperties) {
        this.tableReport.removeRows();
        if (billProperties == null || billProperties.isEmpty()) {
            return;
        }
        for (BillProp billProp : billProperties) {
            if (BillModelType.BalanceModel.getDescription().equals(billProp.getType())) continue;
            IRow irow = this.tableReport.addRow();
            irow.getCell(0).setValue((Object)billProp.getName());
            irow.getCell(1).setValue((Object)billProp.getId());
            irow.getCell(2).setValue((Object)billProp.getType());
            irow.setUserObject((Object)billProp);
        }
    }

    public void fillBillModelType(List<BillProp> billProperties) {
        ArrayList<String> fidList = new ArrayList<String>(billProperties.size());
        for (BillProp billProp : billProperties) {
            fidList.add(billProp.getFid());
        }
        HashMap<String, String> map = this.facade.getBillModelTypeMap(fidList);
        for (BillProp billProp : billProperties) {
            String fid = billProp.getFid();
            String modelType = map.get(fid);
            String type = BillModelType.BillFormModel.name().equals(modelType) ? BillModelType.BillFormModel.getDescription() : (BillModelType.BaseFormModel.name().equals(modelType) ? BillModelType.BaseFormModel.getDescription() : BillModelType.BalanceModel.getDescription());
            billProp.setType(type);
        }
    }

    @Override
    protected String getTargetName() {
        return QingRptLauncherMessages.getMLS("documentName", "\u5355\u636e\u540d\u79f0");
    }

    protected String getTargetType() {
        return QingRptLauncherMessages.getMLS("type", "\u7c7b\u578b");
    }

    protected String getTargetCode() {
        return QingRptLauncherMessages.getMLS("code", "\u7f16\u7801");
    }

    @Override
    protected void loadTree() {
        super.loadTree();
        if (this.selectedBill != null) {
            String fid = this.selectedBill.getFid();
            String appId = this.selectedBill.getAppId();
            TreeManager.treeSelectedBill(this.dirTree, this.nodeRootCache, appId);
            String selectedFid = StringUtil.isEmptyString((String)fid) ? null : fid;
            for (int i = 0; i < this.tableReport.getRowCount(); ++i) {
                BillProp billProp = (BillProp)this.tableReport.getRow(i).getUserObject();
                if (!billProp.getFid().equals(selectedFid)) continue;
                this.tableReport.getSelectManager().select(i, 0);
                this.tableReport.scrollToVisible(i, 0);
            }
        }
    }

    @Override
    protected DefaultKingdeeTreeNode buildTree() {
        String entities = this.facade.getUsableEntities();
        DefaultKingdeeTreeNode nodeRoot = new DefaultKingdeeTreeNode((Object)"Root");
        this.entitiesCache.clear();
        nodeRoot.setText(QingRptLauncherMessages.getMLS("billPath", "\u5355\u636e\u8def\u5f84"));
        JsonElement jsonElement = JsonParser.parseString((String)entities);
        this.appendToTree(nodeRoot, jsonElement);
        this.nodeRootCache = nodeRoot;
        return nodeRoot;
    }

    private void appendToTree(DefaultKingdeeTreeNode root, JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
                if (jsonObject.has("children")) {
                    this.appendChild(root, jsonObject);
                    continue;
                }
                this.cacheLeaves(root, jsonObject);
            }
        }
    }

    private void appendChild(DefaultKingdeeTreeNode parent, JsonObject childData) {
        DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)childData.get("id").getAsString());
        child.setText(childData.get("name").getAsString());
        child.setUserObject((Object)childData);
        child.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
        if (this.selectedNode == null) {
            this.selectedNode = child;
            child.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
        } else {
            child.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
        }
        parent.add((MutableTreeNode)child);
        JsonElement children = childData.get("children");
        this.appendToTree(child, children);
    }

    private void cacheLeaves(DefaultKingdeeTreeNode parent, JsonObject leaf) {
        BillProp billProp = new BillProp(leaf.get("fid").getAsString(), leaf.get("id").getAsString(), leaf.get("name").getAsString());
        JsonObject parentObject = (JsonObject)parent.getUserObject();
        String appId = parentObject.get("id").getAsString();
        billProp.setAppId(appId);
        List<BillProp> list = this.entitiesCache.get(appId);
        if (list == null) {
            list = new ArrayList<BillProp>(4);
        }
        list.add(billProp);
        this.entitiesCache.put(appId, list);
    }

    public void setSelectedBill(BillProp billProp) {
        this.selectedBill = billProp;
    }
}

