/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.ui.save;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.proxy.facade.RptDesignerFacade;
import com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.ui.AbstractSelectedTargetUI;
import com.kingdee.bos.app.xlet.util.InteractiveUIUtil;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.cosmic.ctrl.common.CtrlUIEnv;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public class SavePrompt
extends AbstractSelectedTargetUI<ExtReportVO>
implements ActionListener {
    private static final long serialVersionUID = -6058989173086154753L;
    private KDTextField reportNameField;
    private KDComboBox rptTypeComboBox;
    private static final String RESTRICT_STR = "^[^\\\\\\/\\:\\*\\?\\\"\\<\\>\\|]";

    @Override
    protected void init() {
        this.setPreferredSize(new Dimension(300, 95));
        this.reportNameField = new KDTextField();
        this.reportNameField.setRequired(true);
        this.rptTypeComboBox = new KDComboBox((Object[])new String[]{QingRptLauncherMessages.getMLS("normalModel", "\u666e\u901a\u6a21\u677f")});
        this.okButton = new KDButton(QingRptLauncherMessages.getMLS("confirmBtn", "\u786e\u5b9a"));
        this.cancelButton = new KDButton(QingRptLauncherMessages.getMLS("cancelBtn", "\u53d6\u6d88"));
        this.setLayout(null);
        KDLabelContainer con = CtrlSwingUtilities.createLabelContainer((JComponent)this.reportNameField, (String)QingRptLauncherMessages.getMLS("reportName", "\u62a5\u8868\u540d\u79f0"), (int)80);
        con.setBounds(10, 10, 280, 20);
        this.add((Component)con);
        con = CtrlSwingUtilities.createLabelContainer((JComponent)this.rptTypeComboBox, (String)QingRptLauncherMessages.getMLS("reportType", "\u62a5\u8868\u7c7b\u578b"), (int)80);
        con.setBounds(10, 40, 280, 20);
        this.add((Component)con);
        this.add((Component)this.okButton);
        this.add((Component)this.cancelButton);
        this.okButton.setBounds(120, 70, 80, 20);
        this.cancelButton.setBounds(210, 70, 80, 20);
    }

    @Override
    protected void initListeners() {
        this.reportNameField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String str = String.valueOf(e.getKeyChar());
                if (!str.matches(SavePrompt.RESTRICT_STR)) {
                    String newRptName = StringUtils.replace((String)SavePrompt.this.reportNameField.getText(), (String)str, (String)"");
                    SavePrompt.this.reportNameField.setText(newRptName);
                    SavePrompt.this.reportNameField.setCaretPosition(newRptName.length());
                }
            }
        });
        this.okButton.addActionListener((ActionListener)this);
        this.cancelButton.addActionListener((ActionListener)this);
    }

    @Override
    protected String getTargetName() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (StringUtil.isEmptyString((String)this.reportNameField.getText())) {
                WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("reportNameCannotBeEmpty", "\u62a5\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (String)QingRptLauncherMessages.getMLS("messagePrompt", "\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
                return;
            }
            if (!Pattern.matches("^([\u4e00-\u9fa5a-zA-Z_])[\u4e00-\u9fa5a-zA-Z0-9_]*$", this.reportNameField.getText())) {
                WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("reportNameRuleViolation", "\u62a5\u8868\u540d\u79f0\u53ea\u80fd\u7531\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff01"), (String)QingRptLauncherMessages.getMLS("messagePrompt", "\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
                return;
            }
            if (Pattern.compile("\\b(null|true|false)\\b", 2).matcher(this.reportNameField.getText()).find()) {
                WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("unavailableName", "\u65e0\u6cd5\u4f7f\u7528\"#1\"\u4f5c\u4e3a\u540d\u79f0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002").replace("#1", this.reportNameField.getText()), (String)QingRptLauncherMessages.getMLS("messagePrompt", "\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
                return;
            }
            if (this.reportNameField.getText().length() > 50) {
                WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("reportNameTooLong", "\u62a5\u8868\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26\uff01"), (String)QingRptLauncherMessages.getMLS("messagePrompt", "\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
                return;
            }
            if (this.facade.checkExtReportNameExist(((ExtReportVO)this.value).getExtReportID(), ((ExtReportVO)this.value).getExtReportGroupID(), this.reportNameField.getText())) {
                this.reportNameField.setText(QingRptLauncherMessages.getMLS("blank", ""));
                WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("reportNameDuplicated", "\u62a5\u8868\u540d\u79f0\u4e0d\u80fd\u91cd\u540d"), (String)QingRptLauncherMessages.getMLS("messagePrompt", "\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
                return;
            }
            this.canceled = false;
        } else if (e.getSource() == this.cancelButton) {
            this.canceled = true;
        }
        InteractiveUIUtil.closeInteractiveUI(this);
    }

    @Override
    public void initialize(ExtReportVO value, RptDesignerFacade facade) {
        this.canceled = true;
        this.value = value;
        this.facade = facade;
        this.reportNameField.setText(((ExtReportVO)this.value).getExtReportName());
        this.rptTypeComboBox.setSelectedIndex(Integer.parseInt(((ExtReportVO)this.value).getTemplateType()));
    }

    @Override
    public void show(String title) {
        InteractiveUIUtil.popInteractiveUI(this, title);
    }

    @Override
    protected DefaultKingdeeTreeNode buildTree() {
        return null;
    }

    @Override
    public ExtReportVO getResult() {
        ((ExtReportVO)this.value).setExtReportName(this.reportNameField.getText());
        ((ExtReportVO)this.value).setTemplateType(this.rptTypeComboBox.getSelectedIndex() + "");
        return (ExtReportVO)this.value;
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        InteractiveUIUtil.popInteractiveUI(new SavePrompt(), QingRptLauncherMessages.getMLS("saveReport", "\u4fdd\u5b58\u62a5\u8868"));
    }
}

