/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptsnapeditor;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.launcher.useragent.util.UserAgentUtil;
import com.kingdee.bos.app.proxy.FacadeFactory;
import com.kingdee.bos.app.proxy.context.impl.RptSnapEditorContext;
import com.kingdee.bos.app.xlet.IXlet;
import com.kingdee.bos.app.xlet.impl.rptexecutor.ExtRuntimeDataProviderImpl;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ExtSnapDataService;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ExtSnapExecutor;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.ExtSnapRunFrame;
import com.kingdee.bos.app.xlet.util.GlobalLockUtil;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.apache.log4j.Logger;

public class RptSnapEditorXlet
implements IXlet<RptSnapEditorContext> {
    private static final Logger logger = Logger.getLogger(RptSnapEditorXlet.class);
    private ExtSnapRunFrame frame;
    private RptSnapEditorContext context;
    private ExtSnapDataService dataService;

    public RptSnapEditorXlet(RptSnapEditorContext context) {
        this.context = context;
        this.dataService = new ExtSnapDataService(context);
    }

    @Override
    public void launch() {
        byte[] data = this.dataService.findSnapContentById();
        String title = QingRptLauncherMessages.getMLS("lightReportSnapshotEditor", "\u8f7b\u62a5\u8868 \u5feb\u7167\u7f16\u8f91\u5668 - ") + this.context.getExtReportSnapName();
        this.frame = new ExtSnapRunFrame(title, data);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                RptSnapEditorXlet.this.context.getUserAgent().getXletManager().quit(RptSnapEditorXlet.this, false);
                GlobalLockUtil.releaseLock(RptSnapEditorXlet.this.context.getExtReportSnapID(), RptSnapEditorXlet.this.context.getUserAgent());
            }
        });
        GlobalLockUtil.lock(this.context.getExtReportSnapID(), this.context.getUserAgent());
        this.frame.setFrontTask(new ExecutorDataTask());
        this.frame.setWindowCloseTask(new WebRefreshTask());
        this.frame.runEXT();
    }

    @Override
    public void quit() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    @Override
    public void active() {
        this.frame.setTitle(QingRptLauncherMessages.getMLS("lightReportSnapshotEditor", "\u8f7b\u62a5\u8868 \u5feb\u7167\u7f16\u8f91\u5668 - ") + this.context.getExtReportSnapName());
        this.frame.setState(0);
        this.frame.toFront();
    }

    @Override
    public boolean isAlive() {
        if (this.frame == null) {
            return false;
        }
        return this.frame.isVisible();
    }

    @Override
    public String getType() {
        return "RPT_SNAP_DESIGNER";
    }

    @Override
    public RptSnapEditorContext getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        if (this.frame == null) {
            return QingRptLauncherMessages.getMLS("snapshotEditor", "\u5feb\u7167\u7f16\u8f91\u5668");
        }
        return this.frame.getTitle();
    }

    @Override
    public boolean isDisplayable() {
        return true;
    }

    @Override
    public KDFrame getFrame() {
        return this.frame;
    }

    public class WebRefreshTask
    implements ExtSnapRunFrame.Task {
        @Override
        public void deal(ExtSnapExecutor executor) {
            UserAgentUtil.sendRefreshCommand2WebBrowser(RptSnapEditorXlet.this.context);
        }
    }

    public class ExecutorDataTask
    implements ExtSnapRunFrame.Task {
        @Override
        public void deal(ExtSnapExecutor executor) {
            executor.setDataProvider(new ExtRuntimeDataProviderImpl(FacadeFactory.createRptExecutorFacade(RptSnapEditorXlet.this.context)));
            executor.setDataService(RptSnapEditorXlet.this.dataService);
        }
    }
}

