/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ExtSnapExecutor;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.SaveAsAction;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.SnapStatusBarManager;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.UpdateSnapshotAction;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapRuntimeInfo;
import com.kingdee.cosmic.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ExtSnapRunFrame
extends KDFrame {
    private byte[] _data;
    private Action[] _extraActions;
    private Task _frontTask;
    private Task _windowCloseTask;
    private SnapStatusBarManager statusBarManager;

    public ExtSnapRunFrame(String title, byte[] data) {
        super(title);
        this._data = data;
        this.statusBarManager = new SnapStatusBarManager(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (ExtSnapRunFrame.this._windowCloseTask != null) {
                    ExtSnapRunFrame.this._windowCloseTask.deal(null);
                }
            }
        });
    }

    public void runEXT() {
        SnapshotRunner worker = new SnapshotRunner();
        worker.start();
    }

    public void setExtraActions(Action[] actions) {
        this._extraActions = actions;
    }

    public void setFrontTask(Task task) {
        this._frontTask = task;
    }

    public void setWindowCloseTask(Task task) {
        this._windowCloseTask = task;
    }

    public void showStatusMsg(final String msg, final int msgtype) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExtSnapRunFrame.this.statusBarManager.show(null, "", msg, msgtype);
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException var2) {
                    var2.printStackTrace();
                }
                ExtSnapRunFrame.this.statusBarManager.show(null, "", "", 1);
            }
        }).start();
    }

    public static interface Task {
        public void deal(ExtSnapExecutor var1);
    }

    private class SnapshotRunner
    extends LongTaskWorker {
        private ExtSnapExecutor _executor;
        private ExtSnapRunFrame _ui;

        private SnapshotRunner() {
            this._ui = ExtSnapRunFrame.this;
        }

        public Object construct() {
            try {
                this.load();
                if (ExtSnapRunFrame.this._frontTask != null) {
                    ExtSnapRunFrame.this._frontTask.deal(this._executor);
                }
                if (!this._executor.execute()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageUtil.showDetailAndOK(null, QingRptLauncherMessages.getMLS("reportExecutionError", "\u6267\u884c\u62a5\u8868\u51fa\u9519"), e);
                    }
                });
                return null;
            }
        }

        private void load() throws Exception {
            this._executor = new ExtSnapExecutor(this._ui._data);
            this._executor.setUi(this._ui);
        }

        public void finished() {
            Object obj = this.get();
            if (obj == Boolean.TRUE) {
                this.displayReport();
            }
        }

        private void displayReport() {
            Container c = this._ui.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)this._executor.getSpreadContext(), "Center");
            KDToolBar tb = new KDToolBar();
            tb.setFloatable(true);
            ExtReportSnapRuntimeInfo runtimeInfo = this._executor.getDataService().loadSnapInfo();
            if (runtimeInfo.isHasSaveSnapshotPermission()) {
                this._ui.setExtraActions(new Action[]{new UpdateSnapshotAction(this._executor), new SaveAsAction(this._executor)});
            }
            if (ExtSnapRunFrame.this._extraActions != null) {
                for (int j = 0; j < ExtSnapRunFrame.this._extraActions.length; ++j) {
                    tb.add(ExtSnapRunFrame.this._extraActions[j]);
                }
                tb.addSeparator();
            }
            Action[] actions = new Action[]{};
            if (runtimeInfo.isHasExportPermission() && runtimeInfo.isHasPrintPermission()) {
                actions = this._executor.getContextualActions(4);
            } else if (runtimeInfo.isHasExportPermission()) {
                actions = this._executor.getContextualActions(3);
            } else if (runtimeInfo.isHasPrintPermission()) {
                actions = this._executor.getContextualActions(2);
            }
            for (int i = 0; i < actions.length; ++i) {
                tb.add(actions[i]);
            }
            this._ui.addToolBar((JToolBar)tb);
            this._ui.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                }
            });
            this._ui.setSize(400, 300);
            this._ui.setExtendedState(6);
            this._ui.setDefaultCloseOperation(2);
            this._ui.setVisible(true);
            this._ui.show();
        }
    }
}

