/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ExtSnapDataService;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.InfoMessagePanel;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.SnapFolderF7;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.SnapFolderF7Data;
import com.kingdee.bos.boslayer.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.boslayer.eas.util.client.EASResource;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapGroupType;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapSaveInfo;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.facade.tip.SpreadBorderLayout;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ExtSnapSaverDialog
extends KDDialog {
    private KDTextField _tfName;
    private KDBizPromptBox _bpLocation;
    private KDPanel _board;
    private KDWorkButton _btnSave;
    private KDWorkButton _btnClose;
    private KDComboBox _cmbSaveLocationType;
    private ExtReportSnapSaveInfo _value;
    private KDCheckBox _saveHyplink;
    private InfoMessagePanel _tipPanel;
    private String _reportID;
    private String _snapID;
    private ExtSnapDataService _dataService;

    public ExtSnapSaverDialog(Frame owner, String reportID, String snapID, ExtSnapDataService dataService) {
        super(owner);
        this._reportID = reportID;
        this._snapID = snapID;
        this._dataService = dataService;
        this.initUI();
        this.installToolBar();
        this.installListener();
    }

    private void installToolBar() {
        KDToolBar toolBar = new KDToolBar(0);
        toolBar.add((Component)this._btnSave);
        toolBar.add((Component)this._btnClose);
        this.addToolBar((JToolBar)toolBar);
    }

    private void installListener() {
        this._cmbSaveLocationType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String selectedValue = (String)ExtSnapSaverDialog.this._cmbSaveLocationType.getSelectedItem();
                SnapFolderF7 f7 = new SnapFolderF7(selectedValue, ExtSnapSaverDialog.this._dataService);
                ExtSnapSaverDialog.this._bpLocation.setSelector(f7);
                ExtSnapSaverDialog.this._bpLocation.setData(null);
            }
        });
        this._cmbSaveLocationType.setSelectedItem((Object)ExtReportSnapGroupType.PERSONAL.getDesc());
    }

    private void initUI() {
        this.setTitle(QingRptLauncherMessages.getMLS("saveSnapshot", "\u4fdd\u5b58\u5feb\u7167"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Dimension leftSize = new Dimension(99, 21);
        KDLabelContainer snapNameLc = new KDLabelContainer();
        snapNameLc.setBoundLabelText(QingRptLauncherMessages.getMLS("snapshotName", "\u5feb\u7167\u540d\u79f0"));
        snapNameLc.setBoundLabelUnderline(true);
        snapNameLc.setPreferredSize(leftSize);
        KDLabelContainer savePathLc = new KDLabelContainer();
        savePathLc.setBoundLabelText(QingRptLauncherMessages.getMLS("directory", "\u76ee\u5f55"));
        savePathLc.setBoundLabelUnderline(true);
        savePathLc.setPreferredSize(leftSize);
        KDLabelContainer savePathTypeLc = new KDLabelContainer();
        savePathTypeLc.setBoundLabelText(QingRptLauncherMessages.getMLS("directoryType", "\u76ee\u5f55\u7c7b\u578b"));
        savePathTypeLc.setBoundLabelUnderline(true);
        savePathTypeLc.setPreferredSize(leftSize);
        this._saveHyplink = new KDCheckBox(QingRptLauncherMessages.getMLS("saveLinkageSettings", "\u4fdd\u5b58\u8054\u67e5/\u8054\u52a8\u8bbe\u7f6e"), false);
        this._saveHyplink.setPreferredSize(leftSize);
        Dimension rightSize = new Dimension(234, 21);
        this._tfName = new KDTextField();
        this._tfName.setPreferredSize(rightSize);
        this._bpLocation = new KDBizPromptBox();
        this._bpLocation.setEditable(false);
        this._bpLocation.setPreferredSize(rightSize);
        List<ExtReportSnapGroupType> folderTypes = this._dataService.loadSnapFolderTypes(this._snapID);
        if (folderTypes != null && folderTypes.size() > 0) {
            ExtReportSnapGroupType snapGroupType = folderTypes.get(0);
            SnapFolderF7 f7 = new SnapFolderF7(snapGroupType.getDesc(), this._dataService);
            this._bpLocation.setSelector(f7);
            this._cmbSaveLocationType = new KDComboBox(new Object[]{snapGroupType.getDesc()});
            this.disableLocationChoices();
            this._cmbSaveLocationType.setPreferredSize(rightSize);
        }
        TableLayout2 panelLayout = new TableLayout2(4, 2);
        panelLayout.setFixedHeight(new int[]{0, 1, 2, 3}, 21);
        panelLayout.setFixedWidth(0, 99);
        panelLayout.setRatableWidth(1, 234);
        panelLayout.setColSpacing(0, 0);
        panelLayout.setRowsSpacing(TableLayout2.ALL, 3);
        this._board = new KDPanel((LayoutManager)panelLayout);
        this._board.setCustomInsets(new Insets(10, 10, 10, 10));
        this._board.setPreferredSize(new Dimension(346, 126));
        this._board.add((Component)snapNameLc, (Object)TableLayout2.param((int)0, (int)0));
        this._board.add((Component)this._tfName, (Object)TableLayout2.param((int)0, (int)1));
        this._board.add((Component)savePathTypeLc, (Object)TableLayout2.param((int)1, (int)0));
        this._board.add((Component)this._cmbSaveLocationType, (Object)TableLayout2.param((int)1, (int)1));
        this._board.add((Component)savePathLc, (Object)TableLayout2.param((int)2, (int)0));
        this._board.add((Component)((Object)this._bpLocation), (Object)TableLayout2.param((int)2, (int)1));
        this._board.add((Component)this._saveHyplink, (Object)TableLayout2.param((int)3, (int)0, (int)3, (int)1));
        this.getContentPane().setLayout((LayoutManager)new SpreadBorderLayout());
        this.getContentPane().add((Component)this._board, "Center");
        ActionDispatch action = new ActionDispatch();
        this._btnSave = new KDWorkButton();
        this._btnSave.setText(QingRptLauncherMessages.getMLS("saveBtn", "\u4fdd\u5b58"));
        this._btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this._btnSave.addActionListener((ActionListener)action);
        this._btnClose = new KDWorkButton();
        this._btnClose.setText(QingRptLauncherMessages.getMLS("closeBtn", "\u5173\u95ed"));
        this._btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this._btnClose.addActionListener((ActionListener)action);
    }

    public void actionQuit() {
        this._value = null;
        this.dispose();
    }

    public void actionSave() {
        String info = this.verifyUnEmpty();
        if (info != null) {
            this.handleInfoTips(info);
            return;
        }
        this._value = new ExtReportSnapSaveInfo();
        SnapFolderF7Data data = (SnapFolderF7Data)this._bpLocation.getData();
        this._value.setSnapGroupId(data.getLongNumber());
        this._value.setSnapGroupType(data.getName());
        this._value.setReportId(this._reportID);
        this._value.setSaveHyperlink(this._saveHyplink.isSelected());
        String newName = this._tfName.getText().trim();
        try {
            if (newName.length() > 50) {
                this.handleInfoTips(QingRptLauncherMessages.getMLS("snapshotNameCannotExceed50Chars", "\u5feb\u7167\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26"));
                return;
            }
            if (!Pattern.matches("^([\u4e00-\u9fa5a-zA-Z_])[\u4e00-\u9fa5a-zA-Z0-9_]*$", newName)) {
                this.handleInfoTips(QingRptLauncherMessages.getMLS("snapshotNameOnlyContainCharsAndNumber", "\u5feb\u7167\u540d\u79f0\u53ea\u80fd\u7531\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934"));
                return;
            }
            if (Pattern.compile("\\b(null|true|false)\\b", 2).matcher(newName).find()) {
                this.handleInfoTips(QingRptLauncherMessages.getMLS("unavailableName", "\u65e0\u6cd5\u4f7f\u7528\"#1\"\u4f5c\u4e3a\u540d\u79f0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002").replace("#1", newName));
                return;
            }
            if (this._dataService.checkSnapNameExist(this._value.getSnapGroupId(), this._value.getReportId(), newName)) {
                this._value.setSnapName(newName);
                boolean ok = MessageUtil.msgboxOkCancel((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)QingRptLauncherMessages.getMLS("snapshotNameExists", "\u5feb\u7167\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u786e\u5b9a\u8986\u76d6\u5417\uff1f"));
                if (ok) {
                    this._value.setOverwrite(true);
                    this.dispose();
                } else {
                    this._value = null;
                }
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        this._value.setSnapName(newName);
        this.dispose();
    }

    private void handleInfoTips(String info) {
        if (this._tipPanel == null) {
            this._tipPanel = new InfoMessagePanel(info, this.getContentPane(), this._board);
        }
        this._tipPanel.setTipString(info);
        this.getContentPane().add((Component)((Object)this._tipPanel), "center_north");
        this._tipPanel.showTip();
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
    }

    public ExtReportSnapSaveInfo getValue() {
        return this._value;
    }

    private String verifyUnEmpty() {
        String info = null;
        if (StringUtil.isEmptyString((String)this._tfName.getText()) || StringUtil.isEmptyString((String)this._tfName.getText().trim())) {
            this._tfName.setText(null);
            this.requestFocus((JComponent)this._tfName);
            info = QingRptLauncherMessages.getMLS("enterSnapshotName", "\u8bf7\u8f93\u5165\u5feb\u7167\u540d\u79f0\u3002");
        } else if (this._bpLocation.getData() == null || this._bpLocation.getData() == "") {
            info = QingRptLauncherMessages.getMLS("pleaseSelectSaveDirectory", "\u8bf7\u9009\u62e9\u4fdd\u5b58\u76ee\u5f55\u3002");
        }
        return info;
    }

    protected void requestFocus(final JComponent comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                comp.requestFocus();
            }
        });
    }

    public void setValue(ExtReportSnapSaveInfo value) {
        this._value = value;
    }

    public void disableLocationChoices() {
        this._cmbSaveLocationType.setEnabled(false);
    }

    public class ActionDispatch
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == ExtSnapSaverDialog.this._btnSave) {
                ExtSnapSaverDialog.this.actionSave();
            } else if (obj == ExtSnapSaverDialog.this._btnClose) {
                ExtSnapSaverDialog.this.actionQuit();
            }
        }
    }
}

