/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ExtSnapExecutor;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.ExtSnapSaverDialog;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapSaveInfo;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class SaveAsAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(SaveAsAction.class);
    private ExtSnapExecutor executor;

    public SaveAsAction(ExtSnapExecutor executor) {
        this.executor = executor;
        this.putValue("SmallIcon", ResourceManager.getImageIcon((String)"tbtn_Saveas.gif"));
        String text = ExtGuiExecutor.getLocalText((String)"saveAs");
        text = "NotFound".equals(text) ? QingRptLauncherMessages.getMLS("saveAs", "\u53e6\u5b58\u4e3a") : text;
        this.putValue("ShortDescription", text);
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            String reportId = this.executor.getDataService().getContext().getExtReportId();
            String snapId = this.executor.getDataService().getContext().getExtReportSnapID();
            ExtSnapSaverDialog saveUI = new ExtSnapSaverDialog((Frame)((Object)this.executor.getUi()), reportId, snapId, this.executor.getDataService());
            saveUI.setTitle(QingRptLauncherMessages.getMLS("saveAsSnapshot", "\u53e6\u5b58\u5feb\u7167"));
            saveUI.pack();
            saveUI.setLocationRelativeTo(null);
            saveUI.setVisible(true);
            ExtReportSnapSaveInfo value = saveUI.getValue();
            if (value == null) {
                return;
            }
            value.setOldSnapId(snapId);
            SpreadContext ctx = this.executor.getSpreadContext();
            ctx.getStateManager().stopEditing();
            SnapReportControlModel controlModel = new SnapReportControlModel();
            controlModel.setSaveHyplink(value.isSaveHyperlink());
            this.executor.getDataService().addSnapshot(value, ExecutorUtil.generateSnapShot((Book)ctx.getBook(), (SnapReportControlModel)controlModel));
            this.executor.getUi().showStatusMsg(CtrlEXTMessages.getMLS((String)"saveSuccessMsg", (String)"\u4fdd\u5b58\u6210\u529f\uff01"), 1);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u4fdd\u5b58\u5931\u8d25\uff01", (Throwable)e);
            String message = QingRptLauncherMessages.getMLS("saveFailed", "\u4fdd\u5b58\u5931\u8d25\uff01");
            if (e.getCause() != null) {
                message = e.getCause().getCause() != null ? message + "\u3010" + e.getCause().getCause().getMessage() + "\u3011" : message + "\u3010" + e.getCause().getMessage() + "\u3011";
            }
            this.executor.getUi().showStatusMsg(message, 0);
        }
    }
}

