/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui;

import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ExtSnapDataService;
import com.kingdee.bos.app.xlet.impl.rptsnapeditor.ui.LoadingPanel;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapFolderVO;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapGroupType;
import com.kingdee.cosmic.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.Window;
import java.net.SocketException;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class SnapFolderTreeLoader
extends LongTaskWorker {
    public static final int DIALOG_MODE = 0;
    public static final int FRAME_MODE = 1;
    private Window _targetWindow;
    private int _mode;
    private KDTree _tree;
    private ExtSnapDataService _dataService;
    private String _selectedFolderTypeValue;

    public SnapFolderTreeLoader(KDTree tree, Window targetWindow, int mode, String selectedFolderTypeValue, ExtSnapDataService dataService) {
        this._tree = tree;
        this._targetWindow = targetWindow;
        this._mode = mode;
        switch (this._mode) {
            case 0: {
                ((KDDialog)this._targetWindow).setGlassPane((Component)new LoadingPanel());
                break;
            }
            case 1: {
                ((KDFrame)this._targetWindow).setGlassPane((Component)new LoadingPanel());
            }
        }
        this._selectedFolderTypeValue = selectedFolderTypeValue;
        this._dataService = dataService;
    }

    public Object construct() {
        try {
            this.doTask();
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (SnapFolderTreeLoader.this._mode) {
                        case 0: {
                            SnapFolderTreeLoader.this._targetWindow.dispose();
                            break;
                        }
                        case 1: {
                            SnapFolderTreeLoader.this._targetWindow.dispose();
                        }
                    }
                    SnapFolderTreeLoader.this.dealSessionException(e);
                }
            });
        }
        return null;
    }

    protected void dealSessionException(Exception ex) {
        Throwable ori = ex.getCause();
        if (ori instanceof IllegalStateException) {
            throw (IllegalStateException)ori;
        }
        if (ori instanceof SocketException) {
            throw new IllegalStateException(ori.toString());
        }
    }

    public void doTask() {
        try {
            ExtReportSnapFolderVO rootFolder = new ExtReportSnapFolderVO();
            rootFolder.setParentId(null);
            rootFolder.setName(this._selectedFolderTypeValue);
            rootFolder.setType(ExtReportSnapGroupType.getValueByDesc((String)this._selectedFolderTypeValue));
            List<ExtReportSnapFolderVO> folder = this._dataService.loadSnapFolder(ExtReportSnapGroupType.getValueByDesc((String)this._selectedFolderTypeValue));
            rootFolder.setChildren(folder);
            final DefaultKingdeeTreeNode root = this.createMyTreeNode(rootFolder);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
                    SnapFolderTreeLoader.this._tree.setModel((TreeModel)model);
                    SnapFolderTreeLoader.this._tree.setRootVisible(false);
                    SnapFolderTreeLoader.this._tree.expandAllNodes(true, (TreeNode)root);
                    SnapFolderTreeLoader.this._tree.repaint();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    DefaultKingdeeTreeNode createMyTreeNode(ExtReportSnapFolderVO foler) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)foler);
        newNode.setText(foler.getName());
        newNode.setUserObject((Object)foler);
        List children = foler.getChildren();
        if (null != children && children.size() > 0) {
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                newNode.add((MutableTreeNode)this.createMyTreeNode((ExtReportSnapFolderVO)itr.next()));
            }
        }
        if (newNode.getChildCount() == 0) {
            newNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
        }
        return newNode;
    }

    public void finished() {
        super.finished();
    }
}

