/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.nativelib;

import com.kingdee.bos.app.launcher.util.AppRootFolderUtil;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.extreport.utils.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

public class NativeLibrary {
    private static final Logger LOGGER = Logger.getLogger(NativeLibrary.class);
    private static String[] nativeLibs = new String[]{"WinClipProxy.dll", "WinClipProxy64.dll", "PrintHook5.dll", "PrintHook6.dll", "PrintProxy2.dll"};

    private NativeLibrary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws IOException {
        String nativeLibPath = AppRootFolderUtil.filePathConcatenation(System.getProperty("java.io.tmpdir"), "cosmic-launcher-" + System.getProperty("jnlp.webVersion"), "nativelib") + File.separatorChar;
        File nativeLibFolder = new File(nativeLibPath);
        if (!nativeLibFolder.exists()) {
            nativeLibFolder.mkdirs();
        }
        NativeLibrary.addLibraryDirectory(nativeLibPath);
        for (String nativeLibName : nativeLibs) {
            String absolutePath = nativeLibPath + nativeLibName;
            File nativeLibFile = new File(absolutePath);
            InputStream inputStream = null;
            try {
                inputStream = NativeLibrary.class.getResourceAsStream(nativeLibName);
                IOUtil.copyFile((InputStream)inputStream, (File)nativeLibFile);
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                continue;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        }
    }

    public static void addLibraryDirectory(String s) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!s.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
        }
        catch (Exception e) {
            throw new IOException("Failed to get permissions to set library path");
        }
    }
}

