/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.common.ui;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.common.model.DatasetOutputField;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class OutputFieldsUI {
    private static final int COL_NAME = 0;
    private static final int COL_ALIAS = 1;
    private static final int COL_DATATYPE = 2;
    private KDPanel _panAll;
    private KDTable _table;
    private KDLabel _labPrompt;
    private boolean _isDirty;

    public OutputFieldsUI() {
        this.init();
    }

    private void init() {
        this._table = new KDTable();
        this._table.addColumns(3);
        IColumn col = this._table.getColumn(0);
        col.setWidth(200);
        col.getStyleAttributes().setLocked(true);
        col.getStyleAttributes().setFontColor(Color.GRAY);
        col = this._table.getColumn(1);
        col.setWidth(240);
        col = this._table.getColumn(2);
        col.setWidth(120);
        col.getStyleAttributes().setLocked(true);
        col.getStyleAttributes().setFontColor(Color.GRAY);
        IRow head = this._table.addHeadRow();
        head.getCell(0).setValue((Object)QingRptLauncherMessages.getMLS("fieldPanel", "\u5b57\u6bb5"));
        head.getCell(1).setValue((Object)QingRptLauncherMessages.getMLS("alias", "\u522b\u540d"));
        head.getCell(2).setValue((Object)QingRptLauncherMessages.getMLS("dataType", "\u6570\u636e\u7c7b\u578b"));
        this._table.getSelectManager().setSelectMode(1);
        this._table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent evt) {
                OutputFieldsUI.this._isDirty = true;
                OutputFieldsUI.this.check();
            }
        });
        this._labPrompt = new KDLabel();
        this._labPrompt.setForeground(Color.red);
        this._labPrompt.setPreferredSize(new Dimension(600, 40));
        this._panAll = new KDPanel((LayoutManager)new BorderLayout());
        this._panAll.add((Component)this._table, (Object)"Center");
        this._panAll.add((Component)this._labPrompt, (Object)"South");
    }

    public JComponent getUI() {
        return this._panAll;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setModel(List<DatasetOutputField> outputFields, Map<String, String> metaFieldAliasMap) {
        this._isDirty = false;
        this._table.removeRows();
        if (outputFields != null) {
            for (DatasetOutputField of : outputFields) {
                IRow row = this._table.addRow();
                row.setUserObject((Object)of);
                String field = null;
                if (metaFieldAliasMap != null) {
                    field = metaFieldAliasMap.get(of.getName());
                }
                if (field == null) {
                    field = of.getName();
                }
                row.getCell(0).setValue((Object)field);
                row.getCell(1).setValue((Object)of.getAlias());
                row.getCell(2).setValue((Object)of.getDataType());
            }
        }
    }

    public void acceptEdited() {
        this._table.getEditManager().stopEditing();
        int c = this._table.getRowCount();
        for (int i = 0; i < c; ++i) {
            IRow row = this._table.getRow(i);
            DatasetOutputField of = (DatasetOutputField)row.getUserObject();
            of.setAlias((String)row.getCell(1).getValue());
        }
    }

    private void check() {
        String prompt = this.verify();
        if (StringUtil.isEmptyString((String)prompt)) {
            this._labPrompt.setText(null);
            this._labPrompt.setVisible(false);
        } else {
            this._labPrompt.setText(prompt);
            this._labPrompt.setVisible(true);
        }
    }

    public String verify() {
        this._table.getEditManager().stopEditing();
        HashMap<String, Integer> existAlias = new HashMap<String, Integer>();
        int c = this._table.getRowCount();
        for (int i = 0; i < c; ++i) {
            IRow row = this._table.getRow(i);
            String alias = (String)row.getCell(1).getValue();
            if (StringUtil.isEmptyString((String)alias)) {
                return QingRptLauncherMessages.getMLS("aliasCannotBeEmpty", "\u7b2c#1\u884c\uff0c\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002").replace("#1", String.valueOf(i + 1));
            }
            if (existAlias.containsKey(alias = alias.toLowerCase())) {
                int idx = (Integer)existAlias.get(alias);
                String str = QingRptLauncherMessages.getMLS("duplicateAliases", "\u7b2c#1\u884c\u4e0e\u7b2c#2\u884c\u522b\u540d\u91cd\u590d\u3002".replace("#1", String.valueOf(idx)).replace("#2", String.valueOf(i + 1)));
                return str;
            }
            existAlias.put(alias, new Integer(i + 1));
        }
        return null;
    }
}

