/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.common.ui;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.res.Resource;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class TableView {
    public static final int BUTTON_UP = 1;
    public static final int BUTTON_DOWN = 2;
    public static final int BUTTON_ADD_ROW = 4;
    public static final int BUTTON_REMOVE_ROW = 8;
    private KDPanel _panContainAll;
    private KDTable _table;
    private KDPanel _panTop;
    private KDLabel _labTitle;
    private List _listActions;
    private Action _actionUp;
    private Action _actionDown;
    private Action _actionAddRow;
    private Action _actionRemoveRow;

    public TableView() {
        this.init();
    }

    protected KDPanel getTopPan() {
        return this._panTop;
    }

    private void init() {
        this._listActions = new ArrayList();
        this._table = new KDTable();
        this._panTop = new KDPanel();
        this._labTitle = new KDLabel();
        this._actionUp = new ActionUp();
        this._actionDown = new ActionDown();
        this._actionAddRow = new ActionAddRow();
        this._actionRemoveRow = new ActionRemoveRow();
        this.setDefaultButton(true);
    }

    public KDPanel getPanel() {
        if (this._panContainAll == null) {
            TableLayout tl = TableLayout.split((int)2, (int)1);
            tl.rowStyle(0).setHeight(20);
            tl.rowStyle(0).setMarginBottom(3);
            tl.rowStyle(1).setPriY(1);
            this._panContainAll = new KDPanel((LayoutManager)tl);
            this._panContainAll.add((Component)this._panTop, (Object)tl.cell(0));
            this._panContainAll.add((Component)this._table, (Object)tl.cell(1));
            this.validateTitlePane();
        }
        return this._panContainAll;
    }

    public Action getDefaultAction(int key) {
        switch (key) {
            case 1: {
                return this._actionUp;
            }
            case 2: {
                return this._actionDown;
            }
            case 4: {
                return this._actionAddRow;
            }
            case 8: {
                return this._actionRemoveRow;
            }
        }
        return null;
    }

    public void setDefaultButton(boolean isShow) {
        this.setDefaultButton(isShow ? 15 : 0);
    }

    public void setDefaultButton(int tag) {
        this.addDefaultButton(tag, 1, this._actionUp);
        this.addDefaultButton(tag, 2, this._actionDown);
        this.addDefaultButton(tag, 4, this._actionAddRow);
        this.addDefaultButton(tag, 8, this._actionRemoveRow);
    }

    private void addDefaultButton(int tag, int key, Action action) {
        if ((tag & key) == key) {
            if (!this._listActions.contains(action)) {
                this._listActions.add(action);
            }
        } else {
            this._listActions.remove(action);
        }
    }

    public void addCustomAction(Action action) {
        this._listActions.add(action);
    }

    public void validateTitlePane() {
        int count = this._listActions.size();
        TableLayout tl = TableLayout.splitCol((int)(count + 1));
        tl.colStyle(0).setPriX(1);
        this._panTop.removeAll();
        this._panTop.setLayout((LayoutManager)tl);
        this._panTop.add((Component)this._labTitle, (Object)tl.cell(0));
        for (int i = 0; i < count; ++i) {
            tl.colStyle(i + 1).setWidth(26);
            tl.colStyle(i + 1).setMarginLeft(3);
            Action action = (Action)this._listActions.get(i);
            this._panTop.add((Component)new KDWorkButton(action), (Object)tl.cell(i + 1));
        }
    }

    public KDTable getTable() {
        return this._table;
    }

    public void setTitle(String title) {
        this._labTitle.setText(title);
    }

    protected void actionPerformedMoveUp() {
        KDTSelectBlock sel = this._table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == 0) {
            return;
        }
        if (this.preMoveUp()) {
            IRow selRow = this._table.removeRow(idx);
            this._table.addRow(idx - 1, selRow);
            this._table.getSelectManager().select(idx - 1, 0);
            this.postMoveUp();
        }
    }

    protected boolean preMoveUp() {
        return true;
    }

    protected void postMoveUp() {
    }

    private void actionPerformedMoveDown() {
        KDTSelectBlock sel = this._table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == this._table.getRowCount() - 1) {
            return;
        }
        if (this.preMoveDown()) {
            IRow selRow = this._table.removeRow(idx);
            this._table.addRow(idx + 1, selRow);
            this._table.getSelectManager().select(idx + 1, 0);
            this.postMoveDown();
        }
    }

    protected boolean preMoveDown() {
        return true;
    }

    protected void postMoveDown() {
    }

    private void actionPerformedAddRow() {
        if (this.preAddRow()) {
            if (this._table.getSelectManager().get() == null) {
                this._table.addRow();
            } else {
                this._table.addRow(this._table.getSelectManager().get().getBeginRow());
            }
            this.postAddRow();
        }
    }

    protected boolean preAddRow() {
        return true;
    }

    protected void postAddRow() {
    }

    private void actionPerformedRemoveRow() {
        KDTSelectBlock sel = this._table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (this.preRemoveRow()) {
            int selBegin = sel.getBeginRow();
            int selEnd = sel.getEndRow();
            for (int i = selBegin; i <= selEnd; ++i) {
                this._table.removeRow(selBegin);
            }
            this._table.getSelectManager().setActiveRowIndex(selBegin);
            this.postRemoveRow();
        }
    }

    protected boolean preRemoveRow() {
        return true;
    }

    protected void postRemoveRow() {
    }

    public void acceptTableEditing() {
        this.getTable().getEditManager().stopEditing();
    }

    class ActionRemoveRow
    extends AbstractAction {
        public ActionRemoveRow() {
            this.putValue("SmallIcon", Resource.ICON_DELETE);
            this.putValue("ShortDescription", QingRptLauncherMessages.getMLS("deleteRowTooltip", "\u5220\u9664\u884c"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TableView.this.actionPerformedRemoveRow();
        }
    }

    class ActionAddRow
    extends AbstractAction {
        public ActionAddRow() {
            this.putValue("SmallIcon", Resource.ICON_INSERT);
            this.putValue("ShortDescription", QingRptLauncherMessages.getMLS("insertRowBtn", "\u63d2\u5165\u884c"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TableView.this.actionPerformedAddRow();
        }
    }

    class ActionDown
    extends AbstractAction {
        public ActionDown() {
            this.putValue("SmallIcon", Resource.ICON_MOVE_DOWN);
            this.putValue("ShortDescription", QingRptLauncherMessages.getMLS("moveDownBtn", "\u4e0b\u79fb"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TableView.this.actionPerformedMoveDown();
        }
    }

    class ActionUp
    extends AbstractAction {
        public ActionUp() {
            this.putValue("SmallIcon", Resource.ICON_MOVE_TOP);
            this.putValue("ShortDescription", QingRptLauncherMessages.getMLS("moveUpBtn", "\u4e0a\u79fb"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TableView.this.actionPerformedMoveUp();
        }
    }
}

