/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.adapter;

import com.google.gson.JsonObject;
import com.kingdee.bos.boslayer.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.boslayer.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.datawizard.edd.ctrlreport.adapter.IFilter;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public class TreeManager {
    IFilter reportUI;
    String systemID;
    public static String filter_name = "name";
    public static String filter_alias = "alias";
    public static String filter_f7 = "F7";
    public static String filter_systemID = "systemID";

    public TreeManager(IFilter reportUI) {
        this.reportUI = reportUI;
    }

    public void expandExtTreeSelected(KDTree kDTree1, String systemID) {
        this.systemID = systemID;
        String preSystemID = this.reportUI.getSystemID();
        if (null != preSystemID && preSystemID.equals(systemID)) {
            return;
        }
        if (systemID.length() <= 0) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)kDTree1.getModel().getRoot();
        this.expandSelected(kDTree1, root, systemID);
        this.reportUI.setSystemID(systemID);
    }

    private boolean expandSelected(KDTree kDTree1, DefaultKingdeeTreeNode nodeRoot, String selectedPath) {
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            Object userObject = repNode.getUserObject();
            if (!(userObject instanceof IBriefViewTreeNode)) continue;
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)userObject;
            if (bvNode.getFullName().equals(selectedPath)) {
                boolean isExtend = false;
                Enumeration enumeLeaf = repNode.children();
                while (enumeLeaf.hasMoreElements()) {
                    DefaultKingdeeTreeNode repNodeLeaf = (DefaultKingdeeTreeNode)enumeLeaf.nextElement();
                    Object userObjectLeaf = repNodeLeaf.getUserObject();
                    if (!(userObjectLeaf instanceof String) || !userObjectLeaf.toString().equals(this.reportUI.getTableFlag())) continue;
                    Object[] pathtoRoot = repNodeLeaf.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    this.reportUI.setStopChange(true);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                    isExtend = true;
                    break;
                }
                if (!isExtend) {
                    Object[] pathtoRoot = repNode.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    this.reportUI.setStopChange(true);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                }
                flag = false;
                break;
            }
            flag = this.expandSelected(kDTree1, repNode, selectedPath);
            if (flag) continue;
            break;
        }
        return flag;
    }

    public static boolean treeSelected(KDTree kDTree1, DefaultKingdeeTreeNode nodeRoot, String tableFlag, String selectedTreeNode) {
        if (StringUtils.isEmpty((CharSequence)selectedTreeNode)) {
            return false;
        }
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            repNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
            Object userObject = repNode.getUserObject();
            if (!(userObject instanceof IBriefViewTreeNode)) continue;
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)userObject;
            if (bvNode.getFullName().equals(selectedTreeNode)) {
                boolean isExtend = false;
                Enumeration enumeLeaf = repNode.children();
                while (enumeLeaf.hasMoreElements()) {
                    DefaultKingdeeTreeNode repNodeLeaf = (DefaultKingdeeTreeNode)enumeLeaf.nextElement();
                    Object userObjectLeaf = repNodeLeaf.getUserObject();
                    repNodeLeaf.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                    if (!(userObjectLeaf instanceof String) || !userObjectLeaf.toString().equals(tableFlag)) continue;
                    repNodeLeaf.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
                    Object[] pathtoRoot = repNodeLeaf.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                    isExtend = true;
                    break;
                }
                if (!isExtend) {
                    Object[] pathtoRoot = repNode.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                }
                flag = false;
                break;
            }
            flag = TreeManager.treeSelected(kDTree1, repNode, tableFlag, selectedTreeNode);
            if (flag) continue;
            break;
        }
        return flag;
    }

    public static boolean treeSelectedBill(KDTree kDTree, DefaultKingdeeTreeNode nodeRoot, String selectedNodeId) {
        if (StringUtils.isEmpty((CharSequence)selectedNodeId)) {
            return false;
        }
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            repNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
            JsonObject userObject = (JsonObject)repNode.getUserObject();
            if (!(userObject instanceof JsonObject)) continue;
            if (userObject.get("id").getAsString().equals(selectedNodeId)) {
                Object[] pathtoRoot = repNode.getPath();
                TreePath path = new TreePath(pathtoRoot);
                kDTree.expandPath(path);
                kDTree.setSelectionPath(path);
                kDTree.scrollPathToVisible(path);
                flag = false;
                break;
            }
            flag = TreeManager.treeSelectedBill(kDTree, repNode, selectedNodeId);
            if (flag) continue;
            break;
        }
        return flag;
    }

    public static boolean treeSelectedPreset(KDTree kDTree1, DefaultKingdeeTreeNode nodeRoot, String tableFlag, String selectedTreeNode) {
        if (StringUtils.isEmpty((CharSequence)selectedTreeNode)) {
            return false;
        }
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        block0: while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            repNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
            Enumeration enumechild = repNode.children();
            while (enumechild.hasMoreElements()) {
                DefaultKingdeeTreeNode repNodechild = (DefaultKingdeeTreeNode)enumechild.nextElement();
                repNodechild.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                Object userObject = repNodechild.getUserObject();
                if (!(userObject instanceof IBriefViewTreeNode)) continue;
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)userObject;
                if (bvNode.getFullName().equals(selectedTreeNode)) {
                    boolean isExtend = false;
                    Enumeration enumeLeaf = repNodechild.children();
                    while (enumeLeaf.hasMoreElements()) {
                        DefaultKingdeeTreeNode repNodeLeaf = (DefaultKingdeeTreeNode)enumeLeaf.nextElement();
                        Object userObjectLeaf = repNodeLeaf.getUserObject();
                        repNodeLeaf.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                        if (!(userObjectLeaf instanceof String) || !userObjectLeaf.toString().equals(tableFlag)) continue;
                        repNodeLeaf.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
                        Object[] pathtoRoot = repNodeLeaf.getPath();
                        TreePath path = new TreePath(pathtoRoot);
                        kDTree1.expandPath(path);
                        kDTree1.setSelectionPath(path);
                        kDTree1.scrollPathToVisible(path);
                        isExtend = true;
                        break;
                    }
                    if (!isExtend) {
                        Object[] pathtoRoot = repNodechild.getPath();
                        TreePath path = new TreePath(pathtoRoot);
                        kDTree1.expandPath(path);
                        kDTree1.setSelectionPath(path);
                        kDTree1.scrollPathToVisible(path);
                    }
                    flag = false;
                    continue block0;
                }
                flag = TreeManager.treeSelectedPreset(kDTree1, repNodechild, tableFlag, selectedTreeNode);
                if (flag) continue;
                continue block0;
            }
        }
        return flag;
    }

    public static final void filterTree(ArrayList lstData, IBriefViewTreeNode root, HashMap mapFilter) throws Exception {
        MetaDataBriefInfo info;
        String filterSystemID = CtrlReportUtil.getObjectString(mapFilter.get(filter_systemID));
        if (StringUtils.isEmpty((CharSequence)filterSystemID) && (info = (MetaDataBriefInfo)root.getMetaDataObjectBriefInfo()) != null && null != info.getFullName()) {
            TreeManager.filterNode(lstData, root, mapFilter, info.getFullName());
        }
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            MetaDataBriefInfo info2 = (MetaDataBriefInfo)bvNode.getMetaDataObjectBriefInfo();
            if (!StringUtils.isEmpty((CharSequence)filterSystemID)) {
                if (info2 != null && info2.getFullName().equals(filterSystemID)) {
                    TreeManager.filterNode(lstData, bvNode, mapFilter, info2.getFullName());
                    break;
                }
                TreeManager.filterTree(lstData, bvNode, mapFilter);
                continue;
            }
            TreeManager.filterTree(lstData, bvNode, mapFilter);
        }
    }

    private static final void filterNode(ArrayList lstData, IBriefViewTreeNode ibf, HashMap mapFilter, String parentSystemID) throws Exception {
        String name = CtrlReportUtil.getObjectString(mapFilter.get(filter_name)).toLowerCase();
        String alias = CtrlReportUtil.getObjectString(mapFilter.get(filter_alias)).toLowerCase();
        boolean F7 = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get(filter_systemID)));
        Locale locale = new Locale("l2", "");
        MetaDataBriefInfo info = null;
        Enumeration enu = ibf.children();
        while (enu.hasMoreElements()) {
            boolean isHidden;
            IBriefViewTreeNode ibf1 = (IBriefViewTreeNode)enu.nextElement();
            if (ibf1.isPackage()) continue;
            info = (MetaDataBriefInfo)ibf1.getMetaDataObjectBriefInfo();
            boolean isNameHidden = false;
            boolean isAliasHidden = false;
            boolean isF7Hidden = false;
            String nodeName = CtrlReportUtil.getObjectString((Object)ibf1.getName()).toLowerCase();
            String nodeAlias = CtrlReportUtil.getObjectString((Object)ibf1.getAlias()).toLowerCase();
            nodeAlias = nodeAlias + " [" + nodeName + "]";
            if (name.length() > 0 && nodeName.indexOf(name) == -1) {
                isNameHidden = true;
            }
            if (alias.length() > 0 && nodeAlias.indexOf(alias) == -1) {
                isAliasHidden = true;
            }
            if (F7 && (nodeName.indexOf("f7") != -1 || nodeAlias.indexOf("f7") != -1)) {
                isF7Hidden = true;
            }
            if (isHidden = isNameHidden || isAliasHidden || isF7Hidden) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String fid = info.getFullName();
            String currentName = CtrlReportUtil.getObjectString((Object)info.getName());
            String currentAlias = CtrlReportUtil.getObjectString((Object)info.getAlias(locale));
            currentAlias = currentAlias + " [" + currentName + "]";
            map.put("fid", fid);
            map.put("fname", currentAlias);
            map.put("fsystemid", parentSystemID);
            lstData.add(map);
        }
    }
}

