/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.client.app;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.boslayer.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.boslayer.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.boslayer.eas.framework.client.CoreUI;
import com.kingdee.bos.boslayer.eas.util.client.MsgBox;
import com.kingdee.bos.corelayer.proxy.IBizCloudProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.SelelctUIUtil;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDSplitPane;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AppSelectUI
extends CoreUI {
    private Context context;
    private KDSplitPane splitPane;
    private KDTreeView treeView;
    private KDSeparator separator;
    private KDTree tree;
    private KDTable table;
    private KDButton btnOK;
    private KDButton btnCancel;
    private boolean isOk = false;
    private transient Map<String, Object> selectedInfo;
    private static final String SELECTED_CLOUD_ID = "selectedCloudId";
    private static final String SELECTED_APP_ID = "selectedAppId";
    private transient IBizCloudProxy bizCloudProxy;

    private IBizCloudProxy getBizCloudProxy() {
        if (this.bizCloudProxy == null) {
            this.bizCloudProxy = ProxyFactory.createBizCloudProxy((Object)((Object)this.context));
        }
        return this.bizCloudProxy;
    }

    public AppSelectUI(Context context) {
        this.context = context;
    }

    public void init() throws IOException, ClassNotFoundException {
        this.jbInit();
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 800, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 800, 600));
        this.splitPane.setBounds(new Rectangle(5, 7, 787, 545));
        this.add((Component)this.splitPane, new KDLayout.Constraints(5, 7, 787, 545, 15));
        this.separator.setBounds(new Rectangle(0, 560, 800, 10));
        this.add((Component)this.separator, new KDLayout.Constraints(0, 560, 800, 10, 14));
        this.btnOK.setBounds(new Rectangle(637, 568, 73, 21));
        this.add((Component)this.btnOK, new KDLayout.Constraints(637, 568, 73, 21, 10));
        this.btnCancel.setBounds(new Rectangle(719, 568, 73, 21));
        this.add((Component)this.btnCancel, new KDLayout.Constraints(719, 568, 73, 21, 10));
        this.splitPane.setDividerLocation(240);
        this.splitPane.setDividerSize(8);
        this.treeView.setTree(this.tree);
        this.splitPane.add((Component)this.treeView, (Object)"left");
        this.splitPane.add((Component)this.table, (Object)"right");
    }

    private void jbInit() throws IOException, ClassNotFoundException {
        this.resHelper = new ResourceBundleHelper(AppSelectUI.class.getName());
        this.setUITitle(QingRptLauncherMessages.getMLS("title", ""));
        this.splitPane = new KDSplitPane();
        this.treeView = new KDTreeView();
        this.separator = new KDSeparator();
        this.tree = new KDTree();
        this.table = new KDTable();
        this.btnOK = new KDButton();
        this.btnCancel = new KDButton();
        this.splitPane.setName("splitPane");
        this.treeView.setName("treeView");
        this.separator.setName("separator");
        this.tree.setName("tree");
        this.table.setName("table");
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        this.btnOK.setText(QingRptLauncherMessages.getMLS("confirmBtn", "\u786e\u5b9a"));
        this.btnCancel.setText(QingRptLauncherMessages.getMLS("cancelBtn", "\u53d6\u6d88"));
        this.initTable();
        this.initEventListener();
        this.initTree();
    }

    private void initEventListener() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    AppSelectUI.this.treeSelectionChanged();
                }
                catch (Exception exc) {
                    AppSelectUI.this.handUIException(exc);
                }
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    AppSelectUI.this.tableCellClicked(e);
                }
                catch (Exception exc) {
                    AppSelectUI.this.handUIException(exc);
                }
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppSelectUI.this.btnOKListener();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppSelectUI.this.btnCancelListener();
            }
        });
    }

    private void treeSelectionChanged() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.isLeaf()) {
            MetaDataBriefInfo userObject = (MetaDataBriefInfo)treeNode.getUserObject();
            String selectedCloudId = userObject.getFullName();
            if (StringUtils.isEmpty((String)selectedCloudId)) {
                throw new IllegalStateException(QingRptLauncherMessages.getMLS("selectionError", "\u9009\u62e9\u51fa\u9519\uff0ccloudId\u4e3a\u7a7a"));
            }
            List appList = this.getBizCloudProxy().getAppsByCloudId(selectedCloudId);
            this.updateTable(appList);
            this.setSelectedInfo(selectedCloudId, null);
        }
    }

    private void tableCellClicked(KDTMouseEvent e) {
        KDTSelectManager selectManager = this.table.getSelectManager();
        int activeRowIndex = selectManager.getActiveRowIndex();
        if (activeRowIndex < 0) {
            return;
        }
        if (e.getClickCount() == 2 && e.getType() == 1) {
            IRow row = this.table.getRow(activeRowIndex);
            DesignerVO appVO = (DesignerVO)row.getUserObject();
            this.setSelectedInfo(appVO, false);
            this.isOk = true;
            CtrlReportUtil.closeWin((Component)((Object)this));
        }
        int rowIndex = e.getRowIndex();
        selectManager.select(rowIndex, 0);
    }

    private void btnOKListener() {
        KDTSelectManager selectManager = this.table.getSelectManager();
        int activeRowIndex = selectManager.getActiveRowIndex();
        if (activeRowIndex < 0) {
            MsgBox.showInfo(QingRptLauncherMessages.getMLS("selectRecord", "\u8bf7\u9009\u62e9\u8bb0\u5f55\uff01"));
        } else {
            IRow row = this.table.getRow(activeRowIndex);
            DesignerVO appVO = (DesignerVO)row.getUserObject();
            this.setSelectedInfo(appVO, false);
            this.isOk = true;
            CtrlReportUtil.closeWin((Component)((Object)this));
        }
    }

    private void btnCancelListener() {
        this.isOk = false;
        CtrlReportUtil.closeWin((Component)((Object)this));
    }

    private void initTree() {
        IBriefViewTreeNode briefRootNode = this.getBizCloudProxy().getSubSystemTree();
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        rootNode.setText(QingRptLauncherMessages.getMLS("directory", "\u76ee\u5f55"));
        rootNode.setUserObject((Object)briefRootNode);
        SelelctUIUtil.convertToKingdeeTreeNode(briefRootNode, rootNode);
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)rootNode);
        this.tree.setModel((TreeModel)treeModel);
        treeModel.setAsksAllowsChildren(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setAutoscrolls(true);
        Enumeration children = rootNode.children();
        if (this.selectedInfo != null && !this.selectedInfo.isEmpty()) {
            String selectedCloudId = (String)this.selectedInfo.get(SELECTED_CLOUD_ID);
            if (StringUtils.isEmpty((String)selectedCloudId)) {
                this.selectFirstCloud(children);
                return;
            }
            while (children.hasMoreElements() && !StringUtils.isEmpty((String)selectedCloudId)) {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)children.nextElement();
                Object userObject = treeNode.getUserObject();
                if (!(userObject instanceof MetaDataBriefInfo) || !StringUtil.equals((String)((MetaDataBriefInfo)userObject).getFullName(), (String)selectedCloudId)) continue;
                Object[] path = treeNode.getPath();
                TreePath treePath = new TreePath(path);
                this.tree.expandPath(treePath);
                this.tree.setSelectionPath(treePath);
                this.tree.scrollPathToVisible(treePath);
                break;
            }
        } else {
            this.selectFirstCloud(children);
        }
    }

    private void selectFirstCloud(Enumeration<DefaultKingdeeTreeNode> children) {
        DefaultKingdeeTreeNode treeNode;
        Object userObject;
        if (children.hasMoreElements() && (userObject = (treeNode = children.nextElement()).getUserObject()) instanceof MetaDataBriefInfo) {
            Object[] path = treeNode.getPath();
            TreePath treePath = new TreePath(path);
            this.tree.expandPath(treePath);
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
    }

    private void initTable() {
        this.table.setFormatXml(this.resHelper.getString("appSelectUIXML"));
        this.table.checkParsed();
        InputMap inputMap = this.table.getInputMap();
        inputMap.remove(KeyStroke.getKeyStroke(38, 64));
        inputMap.remove(KeyStroke.getKeyStroke(40, 64));
        KDTSelectManager selectManager = this.table.getSelectManager();
        selectManager.setSelectMode(2);
        this.table.setEditable(false);
    }

    private void updateTable(List<DesignerVO> appList) {
        this.table.removeRows();
        DesignerVO selectedAppInfo = null;
        String selectedAppNumber = null;
        if (!this.selectedAppEmpty()) {
            selectedAppInfo = (DesignerVO)this.selectedInfo.get(SELECTED_APP_ID);
            selectedAppNumber = (String)selectedAppInfo.getFieldContent("number");
        }
        for (int i = 0; appList != null && i < appList.size(); ++i) {
            DesignerVO appVO = appList.get(i);
            String appNumber = (String)appVO.getFieldContent("number");
            String appName = (String)appVO.getFieldContent("name");
            String appDescription = (String)appVO.getFieldContent("description");
            IRow row = this.table.addRow(i);
            if (StringUtil.equals((String)(appNumber = CtrlReportUtil.getObjectString((Object)appNumber)), (String)selectedAppNumber)) {
                KDTSelectManager selectManager = this.table.getSelectManager();
                selectManager.select(i, 0);
            }
            row.getCell(0).setValue((Object)appNumber);
            row.getCell(1).setValue((Object)CtrlReportUtil.getObjectString((Object)appName));
            row.getCell(2).setValue((Object)CtrlReportUtil.getObjectString((Object)appDescription));
            row.setUserObject((Object)appVO);
        }
    }

    private void setSelectedInfo(String selectedCloudId, DesignerVO selectedApp) {
        this.setSelectedInfoBefore();
        this.selectedInfo.put(SELECTED_CLOUD_ID, selectedCloudId);
        this.selectedInfo.put(SELECTED_APP_ID, selectedApp);
    }

    public void setSelectedInfo(DesignerVO selectedApp, boolean setCloudId) {
        this.setSelectedInfoBefore();
        this.selectedInfo.put(SELECTED_APP_ID, selectedApp);
        if (!setCloudId) {
            return;
        }
        String selectedAppNumber = (String)selectedApp.getFieldContent("number");
        DesignerVO bizCloudVO = this.getBizCloudProxy().getCloudByAppNumber(selectedAppNumber);
        if (bizCloudVO == null) {
            return;
        }
        String selectedCloudId = (String)bizCloudVO.getFieldContent("id");
        this.selectedInfo.put(SELECTED_CLOUD_ID, selectedCloudId);
    }

    private void setSelectedInfoBefore() {
        if (this.selectedInfo == null || this.selectedInfo.isEmpty()) {
            this.selectedInfo = new HashMap<String, Object>(2);
        }
    }

    public String getSelectedAppNumber() {
        DesignerVO appVO = (DesignerVO)this.selectedInfo.get(SELECTED_APP_ID);
        String appNumber = (String)appVO.getFieldContent("number");
        return appNumber.trim();
    }

    public String getSelectedAppName() {
        DesignerVO appVO = (DesignerVO)this.selectedInfo.get(SELECTED_APP_ID);
        String appName = (String)appVO.getFieldContent("name");
        return appName.trim();
    }

    public boolean isOk() {
        return this.isOk;
    }

    private boolean selectedAppEmpty() {
        return this.selectedInfo == null || this.selectedInfo.isEmpty() || this.selectedInfo.get(SELECTED_APP_ID) == null;
    }
}

