/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.util.fi;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.fi.FIParam;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.fi.FIParamDataType;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.fi.FIParamIO;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextField;

public class FIParamEditUI
extends KDDialog {
    private static final long serialVersionUID = 1L;
    private KDTable table = new KDTable(4, 1, 0);
    private KDButton confirm = new KDButton(QingRptLauncherMessages.getMLS("confirmBtn", "\u786e\u5b9a"));
    private boolean isCanceled = true;

    private FIParamEditUI(KDFrame frame, Book template) {
        super((Frame)frame);
        this.setTitle(QingRptLauncherMessages.getMLS("businessFunctionVariable", "\u4e1a\u52a1\u51fd\u6570\u53d8\u91cf"));
        this.setModal(true);
        this.setSize(500, 480);
        this.setResizable(false);
        KDPanel content = new KDPanel((LayoutManager)new BorderLayout());
        IRow head = this.table.getHeadRow(0);
        head.getCell(0).setValue((Object)QingRptLauncherMessages.getMLS("range", "\u8303\u56f4"));
        head.getCell(1).setValue((Object)QingRptLauncherMessages.getMLS("description", "\u63cf\u8ff0"));
        head.getCell(2).setValue((Object)QingRptLauncherMessages.getMLS("variableName", "\u53d8\u91cf\u540d\u79f0"));
        head.getCell(3).setValue((Object)QingRptLauncherMessages.getMLS("value", "\u503c"));
        IColumn col = this.table.getColumn(0);
        col.setWidth(40);
        col.getStyleAttributes().setLocked(true);
        col = this.table.getColumn(1);
        col.getStyleAttributes().setLocked(true);
        col = this.table.getColumn(2);
        col.getStyleAttributes().setLocked(true);
        this.table.setAutoResize(true);
        content.add((Component)this.table);
        KDPanel controller = new KDPanel((LayoutManager)new FlowLayout(2, 6, 12));
        controller.add((Component)this.confirm);
        content.add((Component)controller, (Object)"South");
        this.setContentPane((Container)content);
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FIParamEditUI.this.isCanceled = false;
                FIParamEditUI.this.dispose();
            }
        });
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo((Component)frame);
        KDTSelectManager selectManager = this.table.getSelectManager();
        selectManager.setSelectMode(1);
    }

    public static void showEditDialog(KDFrame frame, Book template) {
        FIParamEditUI editUI = new FIParamEditUI(frame, template);
        ArrayList<FIParam> params = FIParamIO.load((Book)template);
        for (FIParam p : params) {
            IRow row = editUI.table.addRow();
            row.getCell(0).setValue((Object)QingRptLauncherMessages.getMLS("workbook", "\u5de5\u4f5c\u7c3f"));
            row.getCell(1).setValue((Object)p.getDesc());
            row.getCell(2).setValue((Object)p.getName());
            ICell cll = row.getCell(3);
            cll.setValue(FIParamEditUI.parseValue(p));
            cll.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDFormattedTextField(0)));
            row.setUserObject((Object)p);
        }
        editUI.show();
        if (!editUI.isCanceled) {
            params = new ArrayList<FIParam>(editUI.table.getRowCount());
            for (int i = 0; i < editUI.table.getRowCount(); ++i) {
                IRow row = editUI.table.getRow(i);
                FIParam p = (FIParam)row.getUserObject();
                p.setValue(FIParamEditUI.serializeValue(row.getCell(3).getValue(), p.getDataType()));
                params.add(p);
            }
            FIParamIO.serialize(params, (Book)template);
        }
    }

    private static Object parseValue(FIParam p) {
        String value = p.getValue();
        FIParamDataType dataType = p.getDataType();
        if (dataType == FIParamDataType.Boolean) {
            return "Y".equals(value);
        }
        if (dataType == FIParamDataType.Date) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(value);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new Date();
            }
        }
        if (dataType == FIParamDataType.Integer) {
            try {
                return Long.parseLong(value);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new Long(0L);
            }
        }
        if (dataType == FIParamDataType.Number) {
            try {
                return new BigDecimal(value);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new BigDecimal(0);
            }
        }
        return value;
    }

    private static String serializeValue(Object value, FIParamDataType dataType) {
        if (dataType == FIParamDataType.Boolean) {
            return Boolean.valueOf(String.valueOf(value)) != false ? "Y" : "N";
        }
        if (dataType == FIParamDataType.Date) {
            return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format((Date)value);
        }
        if (dataType == FIParamDataType.Number) {
            return new BigDecimal(value.toString()).toPlainString();
        }
        if (dataType == FIParamDataType.Integer) {
            return Long.parseLong(value.toString()) + "";
        }
        return String.valueOf(value);
    }
}

