/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.ui.face.CoreUIObject;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateSettingModel;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateTransUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractDateSettingUI;
import com.kingdee.bos.extreport.utils.JsonUtil;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.dlg.FormulaMiniWizardDialog;
import com.kingdee.cosmic.ctrl.ext.util.CalExprUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JSpinner;
import kd.bos.ksql.util.StringUtil;
import org.apache.log4j.Logger;

public class DateSettingUI
extends AbstractDateSettingUI {
    private static final Logger logger = CoreUIObject.getLogger(DateSettingUI.class);
    private DateSettingModel primitiveModel = null;

    private DateSettingUI() throws Exception {
    }

    public DateSettingUI(DateSettingModel model, Context ctx) throws Exception {
        this();
        this.primitiveModel = model;
        this.ctx = ctx;
        this.resolveModel2UI(model);
    }

    private void resolveModel2UI(DateSettingModel model) {
        this.cbDateGran.setSelectedIndex(model.getDateGran().ordinal());
        switch (model.getDateType()) {
            case PERM: {
                this.permDateRadio.setSelected(true);
                Date date = null;
                if (StringUtils.isNotEmpty((CharSequence)model.getValue())) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        date = sdf.parse(model.getValue());
                    }
                    catch (ParseException e) {
                        logger.error((Object)("DateSettingUI parse date error:" + model.getValue()), (Throwable)e);
                    }
                }
                if (DateSettingModel.DateGranEnum.Y_M_D == model.getDateGran()) {
                    this.kDDatePicker.setValue(date);
                    break;
                }
                this.similarDatePicker.setValue(model.getValue());
                break;
            }
            case EXPR: {
                this.exprDefRadio.setSelected(true);
                this.exprTextField.setText(model.getValue());
                break;
            }
            case RELATIVE: {
                this.relativeDateRadio.setSelected(true);
                String[] splitValue = DateTransUtil.splitValue((String)model.getValue());
                if (splitValue.length < 3) break;
                this.cbOffsetPath.setSelectedIndex(DateSettingModel.DateOffsetPathEnum.valueOf((String)splitValue[0]).ordinal());
                this.spOffsetValue.setValue((Object)Integer.parseInt(splitValue[1]));
                switch (DateSettingModel.DateGranEnum.values()[this.cbDateGran.getSelectedIndex()]) {
                    case Y_M: {
                        this.cbOffsetUnit.setSelectedIndex(DateSettingModel.DateUnitEnum.valueOf((String)splitValue[2]).ordinal() - 2);
                        break;
                    }
                    case Y_S: {
                        this.cbOffsetUnit.setSelectedIndex(DateSettingModel.DateUnitEnum.valueOf((String)splitValue[2]).ordinal() - 3);
                        break;
                    }
                    case Y: {
                        this.cbOffsetUnit.setSelectedIndex(DateSettingModel.DateUnitEnum.valueOf((String)splitValue[2]).ordinal() - 4);
                        break;
                    }
                    default: {
                        this.cbOffsetUnit.setSelectedIndex(DateSettingModel.DateUnitEnum.valueOf((String)splitValue[2]).ordinal());
                    }
                }
                if (splitValue.length == 4) {
                    this.labelOf.setVisible(true);
                    this.cbOffsetDay.setVisible(true);
                    this.cbOffsetDay.setSelectedIndex(DateSettingModel.DateOffsetDayEnum.valueOf((String)splitValue[3]).ordinal());
                    break;
                }
                this.labelOf.setVisible(false);
                this.cbOffsetDay.setVisible(false);
                break;
            }
            default: {
                logger.error((Object)("unknown DateSettingModel dateType:" + model.getDateType()));
            }
        }
    }

    public String getDateSelected() {
        DateSettingModel ret = new DateSettingModel();
        DateSettingModel.DateGranEnum dateGranEnum = DateSettingModel.DateGranEnum.values()[this.cbDateGran.getSelectedIndex()];
        ret.setDateGran(dateGranEnum);
        ret.setDateType(DateSettingModel.DateTypeEnum.values()[this.radioGroup.getValue()]);
        String value = "";
        switch (ret.getDateType()) {
            case PERM: {
                if (DateSettingModel.DateGranEnum.Y_M_D == dateGranEnum) {
                    value = CtrlReportUtil.getObjectString((Object)this.kDDatePicker.getText());
                    String pattern = this.kDDatePicker.getDatePattern();
                    if (StringUtils.isEmpty((CharSequence)value)) break;
                    value = CtrlReportUtil.formatDate((String)pattern, (String)"yyyy-MM-dd", (String)value);
                    break;
                }
                value = CtrlReportUtil.getObjectString((Object)this.similarDatePicker.getValue());
                break;
            }
            case EXPR: {
                value = this.exprTextField.getText().trim();
                break;
            }
            case RELATIVE: {
                StringBuilder sb = new StringBuilder();
                sb.append(DateSettingModel.DateOffsetPathEnum.values()[this.cbOffsetPath.getSelectedIndex()]).append("!@#ORANGE#@!");
                sb.append(this.spOffsetValue.getValue()).append("!@#ORANGE#@!");
                switch (ret.getDateGran()) {
                    case Y_M: {
                        sb.append(DateSettingModel.DateUnitEnum.values()[2 + this.cbOffsetUnit.getSelectedIndex()]);
                        break;
                    }
                    case Y_S: {
                        sb.append(DateSettingModel.DateUnitEnum.values()[3 + this.cbOffsetUnit.getSelectedIndex()]);
                        break;
                    }
                    case Y: {
                        sb.append(DateSettingModel.DateUnitEnum.values()[4 + this.cbOffsetUnit.getSelectedIndex()]);
                        break;
                    }
                    default: {
                        sb.append(DateSettingModel.DateUnitEnum.values()[this.cbOffsetUnit.getSelectedIndex()]);
                    }
                }
                if (this.labelOf.isVisible()) {
                    sb.append("!@#ORANGE#@!").append(DateSettingModel.DateOffsetDayEnum.values()[this.cbOffsetDay.getSelectedIndex()]);
                }
                value = sb.toString();
                break;
            }
        }
        ret.setValue(value);
        return JsonUtil.encodeToString((Object)ret);
    }

    @Override
    protected void fomularActionPerformed(ActionEvent e) {
        FormulaMiniWizardDialog dialog = FormulaMiniWizardDialog.getMiniDialog();
        String editingData = this.exprTextField.getText();
        if (editingData.startsWith("=")) {
            editingData = editingData.replaceFirst("=", "");
        }
        dialog.getMiniWizard().setEditingData(editingData);
        dialog.showDialog();
        if (dialog.isOk()) {
            this.exprTextField.setText("=" + dialog.getMiniWizard().getEditor().getRealText());
        }
    }

    @Override
    protected void okActionPerformed(ActionEvent e) {
        if (!this.checkSpinner() || !this.checkFormula(this.exprTextField.getText().trim())) {
            return;
        }
        this.isCancel = false;
        this.closeWin();
    }

    @Override
    protected void resetActionPerformed(ActionEvent e) {
        this.resolveModel2UI(this.primitiveModel);
    }

    private boolean checkFormula(String formula) {
        if (this.exprDefRadio.isSelected()) {
            if (StringUtil.isEmpty((String)formula) || formula.equals("=")) {
                this.exprDefRadio.requestFocusInWindow();
                return false;
            }
            short isValid = CalExprUtil.isDateFormula((String)formula);
            String warn = null;
            switch (isValid) {
                case 1: {
                    return true;
                }
                case -1: {
                    warn = QingRptLauncherMessages.getMLS("expressionSyntaxCheckFailed", "\u8868\u8fbe\u5f0f\u8bed\u6cd5\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u5b9a\u4e49\uff01");
                    break;
                }
                case 2: {
                    warn = QingRptLauncherMessages.getMLS("expressionResultNotDate", "\u8868\u8fbe\u5f0f\u8ba1\u7b97\u7ed3\u679c\u4e0d\u662f\u4e00\u4e2a\u65e5\u671f\u7c7b\u578b\uff01");
                    break;
                }
            }
            WindowUtil.msgboxWarning((Object)warn, (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (Component)((Object)this));
            this.exprDefRadio.requestFocusInWindow();
            this.exprDefRadio.setSelected(true);
            return false;
        }
        return true;
    }

    private boolean checkSpinner() {
        boolean isOk = true;
        if (this.relativeDateRadio.isSelected()) {
            if (this.spOffsetValue.getErrorInfo().isShowing()) {
                return false;
            }
            try {
                ((JSpinner.DefaultEditor)this.spOffsetValue.getEditor()).getTextField().commitEdit();
            }
            catch (ParseException e1) {
                this.spOffsetValue.requestFocusInWindow();
                this.spOffsetValue.getErrorInfo().setArrowHeight(10);
                this.spOffsetValue.getErrorInfo().setShowing(true);
                isOk = false;
            }
            this.spOffsetValue.repaint();
        }
        return isOk;
    }
}

