/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.ui.face.CoreUIObject;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractDefaultDateTimeValueUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.dlg.FormulaMiniWizardDialog;
import com.kingdee.cosmic.ctrl.ext.util.CalExprUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import kd.bos.ksql.util.StringUtil;
import org.apache.log4j.Logger;

public class DefaultDateTimeValueUI
extends AbstractDefaultDateTimeValueUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DefaultDateTimeValueUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = false;
    private int dataType = 4;

    public DefaultDateTimeValueUI() throws Exception {
        this.initLayout();
        this.kDButtonGroup1.add((AbstractButton)this.rbSystem);
        this.kDButtonGroup1.add((AbstractButton)this.rbFix);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateAdd);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateSub);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthBegin);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthEnd);
        this.kDButtonGroup1.add((AbstractButton)this.rbFormula);
        this.kDButtonGroup2.add((AbstractButton)this.rbFixTime);
        this.kDButtonGroup2.add((AbstractButton)this.rbSystemTime);
        this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
        this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
    }

    public DefaultDateTimeValueUI(String value, int dataType) throws Exception {
        this(value, dataType, null);
    }

    public DefaultDateTimeValueUI(String value, int dataType, Context ctx) throws Exception {
        this();
        SimpleDateFormat sdf;
        String formatString;
        String unit;
        this.dataType = dataType;
        this.initDateFormat(ctx);
        String dateValue = value;
        String timeValue = "";
        if (value.indexOf("|") != -1) {
            String[] arr = value.split("\\|");
            dateValue = arr[0];
            timeValue = arr[1];
        }
        if (dateValue.startsWith("getSystemDate()")) {
            this.rbSystem.setSelected(true);
        } else if (dateValue.startsWith("dayBegin")) {
            this.rbMonthBegin.setSelected(true);
        } else if (dateValue.startsWith("dayEnd")) {
            this.rbMonthEnd.setSelected(true);
        } else if (dateValue.startsWith("dateAdd + ")) {
            this.rbDateAdd.setSelected(true);
            dateValue = ExtStringUtil.replace((String)dateValue, (String)"dateAdd + ", (String)"");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            unit = dateValue.substring(lenth - 1);
            this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (dateValue.startsWith("dateSub - ")) {
            this.rbDateSub.setSelected(true);
            dateValue = ExtStringUtil.replace((String)dateValue, (String)"dateSub - ", (String)"");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            unit = dateValue.substring(lenth - 1);
            this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (value.startsWith("=")) {
            this.rbFormula.setSelected(true);
            this.rbFormulaField.setText(value);
        } else {
            this.rbFix.setSelected(true);
            formatString = "yyyy-MM-dd";
            if (dataType == 4) {
                formatString = "yyyy-MM-dd HH:mm:ss";
            }
            Date date = null;
            if (!StringUtils.isEmpty((CharSequence)dateValue)) {
                try {
                    sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(dateValue);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                date = RunReportParam.getServerDate((Object)((Object)ctx));
            }
            this.kDDatePicker1.setValue((Object)date);
        }
        if (timeValue.startsWith("getSystemTime()")) {
            this.rbSystemTime.setSelected(true);
        } else {
            this.rbFixTime.setSelected(true);
            formatString = "HH:mm:ss";
            Date date = null;
            if (!StringUtils.isEmpty((CharSequence)timeValue)) {
                try {
                    sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(timeValue);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                date = RunReportParam.getServerDate((Object)((Object)ctx));
            }
            this.kDTimePicker1.setValue((Object)date);
        }
    }

    public DefaultDateTimeValueUI(String value, int dataType, boolean isProcedure, Context ctx) throws Exception {
        this(value, dataType, ctx);
        if (isProcedure) {
            this.rbSystem.setEnabled(false);
            this.rbDateAdd.setEnabled(false);
            this.rbDateSub.setEnabled(false);
            this.rbMonthBegin.setEnabled(false);
            this.rbMonthEnd.setEnabled(false);
            this.spAdd.setEnabled(false);
            this.spSub.setEnabled(false);
            this.btnClear.setEnabled(false);
            this.rbFormula.setEnabled(false);
            this.rbFormulaField.setEnabled(false);
        }
    }

    @Override
    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void initDateFormat(Context ctx) {
        if (this.dataType == 4) {
            String datePatternOld = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setTimeEnabled(true);
            String datePatternNew = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setDatePattern(ExtStringUtil.replace((String)datePatternNew, (String)datePatternOld, (String)(datePatternOld + " ")));
            Date date = RunReportParam.getServerDate((Object)((Object)ctx));
            this.kDDatePicker1.setValue((Object)date);
        }
    }

    @Override
    protected void initListener() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultDateTimeValueUI.this.isCancel = true;
            }
        });
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    private boolean checkFormula(String formula) {
        if (this.rbFormula.isSelected()) {
            if (StringUtil.isEmpty((String)formula) || formula.equals("=")) {
                this.rbFormulaField.requestFocusInWindow();
                return false;
            }
            short isValid = CalExprUtil.isDateFormula((String)formula);
            String warn = null;
            switch (isValid) {
                case 1: {
                    return true;
                }
                case -1: {
                    warn = QingRptLauncherMessages.getMLS("expressionSyntaxCheckFailed", "\u8868\u8fbe\u5f0f\u8bed\u6cd5\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u5b9a\u4e49\uff01");
                    break;
                }
                case 2: {
                    warn = QingRptLauncherMessages.getMLS("expressionResultNotDate", "\u8868\u8fbe\u5f0f\u8ba1\u7b97\u7ed3\u679c\u4e0d\u662f\u4e00\u4e2a\u65e5\u671f\u7c7b\u578b\uff01");
                }
            }
            WindowUtil.msgboxWarning((Object)warn, (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (Component)((Object)this));
            this.rbFormulaField.requestFocusInWindow();
            this.rbFormulaField.selectAll();
            return false;
        }
        return true;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkFormula(this.rbFormulaField.getText().trim())) {
            return;
        }
        this.isCancel = false;
        this.closeWin();
    }

    @Override
    protected void btnFunc_actionPerformed(ActionEvent e) throws Exception {
        FormulaMiniWizardDialog dialog = FormulaMiniWizardDialog.getMiniDialog();
        String editingData = this.rbFormulaField.getText();
        if (editingData.startsWith("=")) {
            editingData = editingData.replaceFirst("=", "");
        }
        dialog.getMiniWizard().setEditingData(editingData);
        dialog.showDialog();
        if (dialog.isOk()) {
            this.rbFormulaField.setText("=" + dialog.getMiniWizard().getEditor().getRealText());
        }
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
        this.kDDatePicker1.setValue(null);
        this.rbFix.setSelected(true);
        this.rbFormulaField.setText(null);
    }

    @Override
    protected void rbFix_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
    }

    @Override
    protected void rbSystem_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(false);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getDateSelected() {
        String ret = null;
        if (this.rbSystem.isSelected()) {
            ret = "getSystemDate()";
        } else if (this.rbMonthBegin.isSelected()) {
            ret = "dayBegin";
            ret = this.joinDateTime(ret);
        } else if (this.rbMonthEnd.isSelected()) {
            ret = "dayEnd";
            ret = this.joinDateTime(ret);
        } else if (this.rbDateAdd.isSelected()) {
            ret = "dateAdd + " + this.spAdd.getIntegerVlaue() + "D";
            ret = this.joinDateTime(ret);
        } else if (this.rbDateSub.isSelected()) {
            ret = "dateSub - " + this.spSub.getIntegerVlaue() + "D";
            ret = this.joinDateTime(ret);
        } else if (this.rbFormula.isSelected()) {
            String formula = this.rbFormulaField.getText().trim();
            ret = formula.startsWith("=") ? formula : "=" + formula;
        } else {
            ret = CtrlReportUtil.getObjectString((Object)this.kDDatePicker1.getText());
            if (!StringUtils.isEmpty((CharSequence)ret)) {
                String formatString = "yyyy-MM-dd";
                if (this.dataType == 4) {
                    formatString = "yyyy-MM-dd HH:mm:ss";
                }
                String pattern = this.kDDatePicker1.getDatePattern();
                ret = CtrlReportUtil.formatDate((String)pattern, (String)formatString, (String)ret);
            }
        }
        return ret;
    }

    private String joinDateTime(String value) {
        return value + "|" + this.getTimeSelected();
    }

    private String getTimeSelected() {
        String ret = null;
        if (this.rbSystemTime.isSelected()) {
            ret = "getSystemTime()";
        } else {
            ret = CtrlReportUtil.getObjectString((Object)this.kDTimePicker1.getText());
            if (!StringUtils.isEmpty((CharSequence)ret)) {
                String formatString = "HH:mm:ss";
                String pattern = this.kDTimePicker1.getTimePattern();
                ret = CtrlReportUtil.formatDate((String)pattern, (String)formatString, (String)ret);
            }
        }
        return ret;
    }
}

