/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.xlet.util.exception.AppFrameworkException;
import com.kingdee.bos.boslayer.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.boslayer.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.boslayer.bos.ui.face.CoreUIObject;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.BlobBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.ReportDialog;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoExisitException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractPreviewKSQLPanelUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.CurrentSQLUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.ReportCommonFilterUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputState;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetContentNotExistsException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.report.ext.model.SQLCustomType;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTIOManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.exception.FieldDuplicateException;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.jdbc.rowset.impl.RowSetMetaDataImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;

public class PreviewKSQLPanelUI
extends AbstractPreviewKSQLPanelUI {
    private static final long serialVersionUID = -4330303623770370806L;
    private static final Logger logger = CoreUIObject.getLogger(PreviewKSQLPanelUI.class);
    private boolean isinitLayout = false;
    private String solutionID;
    private String parameterXmlString;
    private int shareType;
    private boolean isShowPreviewUI = true;
    private HashMap logMap = new HashMap();
    private CtrlDesignQueryModel model = null;
    private DesignUI _designUI;
    private KDPopupMenu exportToExcel;
    private KDMenuItem exportTOExcelMenuItem;

    public PreviewKSQLPanelUI(DesignUI designUI) throws Exception {
        this._designUI = designUI;
        this.model = designUI.getModel();
        this.spnTop.setModel((SpinnerModel)new SpinnerNumberModel(50, 1, 1000, 1));
        this.tblContent.setEditable(false);
        this.tblContent.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 3 && e.getSource() instanceof KDTable) {
                    PreviewKSQLPanelUI.this.exportToExcel.show((Component)PreviewKSQLPanelUI.this.tblContent, e.getX() + 30, e.getY() + 40);
                }
            }
        });
        this.exportToExcel = new KDPopupMenu();
        this.exportTOExcelMenuItem = new KDMenuItem(QingRptLauncherMessages.getMLS("exportExcel", "\u5bfc\u51faEXCEL"));
        this.exportToExcel.add((JMenuItem)this.exportTOExcelMenuItem);
        this.exportTOExcelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == PreviewKSQLPanelUI.this.exportTOExcelMenuItem) {
                    String name = PreviewKSQLPanelUI.this._designUI.getMapData().get("fname").toString();
                    KDFileChooser fc = new KDFileChooser();
                    fc.setSelectedFile(new File(name + ".xls"));
                    String[] saveType = new String[]{"xls"};
                    fc.setDialogTitle(QingRptLauncherMessages.getMLS("saveFile", "\u4fdd\u5b58\u6587\u4ef6"));
                    fc.setFileFilter((FileFilter)new FileNameExtensionFilter("Excel2003" + QingRptLauncherMessages.getMLS("fileFormatXLS", "\u6587\u4ef6\u683c\u5f0f(.xls)"), saveType));
                    int returnVal = fc.showDialog((Component)((Object)PreviewKSQLPanelUI.this), QingRptLauncherMessages.getMLS("confirm2", "\u786e\u5b9a"));
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        File file2 = file.getAbsolutePath().endsWith(".xls") ? file : new File(file.getAbsolutePath() + ".xls");
                        KDTIOManager manager = PreviewKSQLPanelUI.this.tblContent.getIOManager();
                        manager.exportExcelToFile(false, file2);
                    }
                }
            }
        });
        this.initLayout();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            if (this._designUI.getCustomType() == SQLCustomType.OQL) {
                this.btnSQL.setVisible(false);
            }
            this.isinitLayout = true;
        }
    }

    @Override
    protected void btnSQL_actionPerformed(ActionEvent e) throws Exception {
        CurrentSQLUI ui = new CurrentSQLUI(this._designUI);
        ui.setLogMap(this.logMap);
        ReportDialog.showDialog(ui, QingRptLauncherMessages.getMLS("currentExecutingSQL", "\u5f53\u524d\u6267\u884cSQL"), true);
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        CtrlReportUtil.closeWin((Component)((Object)this));
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.preview(true, false);
    }

    @Override
    protected void btnSettingArgs_actionPerformed(ActionEvent e) throws Exception {
        this.preview(false, false);
    }

    private boolean isContineSearch(boolean isVisible) throws Exception {
        boolean isContinue = true;
        String isolateTag = this._designUI.getContext().getSeessionSQLDesignerProxy().getContext().getUserID();
        DefaultArgInput argUI = new DefaultArgInput(this._designUI.getContext(), isolateTag);
        List params = this.model.getCommonQuery().getParameters();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (!isVisible && params != null) {
            for (int i = 0; i < params.size(); ++i) {
                DesignParameter dp = (DesignParameter)params.get(i);
                InputType inputType = dp.getInputType();
                if (InputType.Separator.equals((Object)inputType) || InputType.EMPTY.equals((Object)inputType) || !InputState.HIDDEN.equals(dp.getInputState())) continue;
                dp.setInputState(InputState.READONLY);
                indexes.add(i);
            }
        }
        argUI.createParametersUI(params);
        ReportCommonFilterUI commonFilterUI = new ReportCommonFilterUI(this._designUI.getContext(), (JPanel)((Object)argUI), this._designUI.getEditID(), this.solutionID, this.parameterXmlString, this.shareType);
        if (isVisible) {
            ReportDialog.showDialog(commonFilterUI, QingRptLauncherMessages.getMLS("filterCondition", "\u8fc7\u6ee4\u6761\u4ef6"), true, false, SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            new KDDialog().add((Component)((Object)commonFilterUI));
            commonFilterUI.onLoad();
            commonFilterUI.btnConfirm_actionPerformed(null);
            if (params != null) {
                for (Integer i : indexes) {
                    DesignParameter dp = (DesignParameter)params.get(i);
                    dp.setInputState(InputState.HIDDEN);
                }
            }
        }
        if (commonFilterUI.isOk()) {
            this.solutionID = commonFilterUI.getSolutionID();
            this.parameterXmlString = commonFilterUI.getParameterXmlString();
            this.shareType = commonFilterUI.getShareType();
        } else {
            isContinue = false;
        }
        return isContinue;
    }

    private int getTopNumber() {
        return this.spnTop.getIntegerVlaue();
    }

    private void clearRows() {
        this.tblContent.removeColumns();
    }

    public static final int addResultSet(KDTable tblContent, ResultSet rs, CtrlDesignQueryModel model) throws Exception {
        PreviewKSQLPanelUI.setTaleHeader(tblContent, rs, model);
        return PreviewKSQLPanelUI.bindResultSet(tblContent, rs);
    }

    public boolean showFilterDialog(boolean showFilterUI) throws Exception {
        boolean isContinue = true;
        List lstParam = this.model.getCommonQuery().getParameters();
        if (PreviewKSQLPanelUI.isAllParamsHidden(lstParam)) {
            isContinue = this.isContineSearch(false);
        } else if (null != lstParam && !lstParam.isEmpty()) {
            isContinue = this.isContineSearch(showFilterUI);
        }
        return isContinue;
    }

    private static boolean isAllParamsHidden(List lstParam) {
        if (null == lstParam || lstParam.isEmpty()) {
            return true;
        }
        for (DesignParameter dp : lstParam) {
            InputState inputState = dp.getInputState();
            if (inputState == InputState.HIDDEN) continue;
            return false;
        }
        return true;
    }

    static Map<String, DesignParameter> getExecuteParam(Object ctx, CtrlDesignQueryModel model, String parameterXmlString) throws IOException, XmlParsingException {
        Map mapDesignParameter = RunReportParam.changWhereValueToMapParams((String)parameterXmlString);
        if (!mapDesignParameter.isEmpty()) {
            List currentList = model.getCommonQuery().getParameters();
            RunReportParam.getExecuteParam((List)currentList, (Map)mapDesignParameter);
        }
        RunReportParam.putDefalutListParamsMap((Object)ctx, (Map)mapDesignParameter);
        return mapDesignParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preview(boolean isRefresh, boolean isFromDesign, boolean showFilterUI) throws Exception {
        try {
            if (!isRefresh && !this.showFilterDialog(showFilterUI)) {
                if (isFromDesign) {
                    this.isShowPreviewUI = false;
                }
                return false;
            }
            Map<String, DesignParameter> mapDesignParameter = PreviewKSQLPanelUI.getExecuteParam((Object)this._designUI.getContext(), this.model, this.parameterXmlString);
            this.clearRows();
            int rowCount = this.getTopNumber();
            if (rowCount == -1) {
                rowCount = Integer.MAX_VALUE;
            }
            ResultSet rs = null;
            try {
                Map mapResult = CtrlDesignDataExecutor.execute((Object)((Object)this._designUI.getContext()), (CtrlDesignQueryModel)this.model, mapDesignParameter, (Map)this.logMap, (int)0, (int)rowCount, (boolean)false, null);
                rs = (ResultSet)mapResult.get("6xx8xxRowset");
            }
            catch (CtrlReportException e) {
                Throwable appCause;
                logger.error((Object)e);
                this.isShowPreviewUI = false;
                Throwable cause = e.getCause();
                if (cause instanceof BOSException && (appCause = cause.getCause()) instanceof AppFrameworkException) {
                    cause = appCause;
                }
                if (cause instanceof AppFrameworkException) {
                    Throwable realCause = cause.getCause();
                    if (realCause instanceof FieldDuplicateException) {
                        MessageUtil.showDetailAndOK(null, QingRptLauncherMessages.getMLS("duplicateFieldNames", "\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u540d\u79f0\uff1a") + realCause.getMessage(), (Exception)realCause);
                        return false;
                    }
                    if (realCause != null && !(realCause instanceof AppFrameworkException)) {
                        MessageUtil.showDetailAndOK(null, realCause.getMessage(), (Exception)realCause);
                        return false;
                    }
                }
                MessageUtil.showDetailAndOK(null, e.getMessage(), (Exception)((Object)e));
                return false;
            }
            String repeatName = null;
            try {
                PreviewKSQLPanelUI.addResultSet(this.tblContent, rs, this.model);
                HashMap mapRepeatName = new HashMap();
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    String name = rsmd.getColumnName(i + 1).toUpperCase();
                    if (mapRepeatName.containsKey(name)) {
                        repeatName = name;
                        break;
                    }
                    mapRepeatName.put(name, null);
                }
            }
            finally {
                CloseUtil.close((ResultSet)rs);
            }
            this.isTextErrVisible(false);
            if (repeatName != null) {
                String msg = QingRptLauncherMessages.getMLS("reportNotSupportDuplicateColumn", "\u62a5\u8868\u4e0d\u652f\u6301\u91cd\u590d\u7684\u5217\u540d\uff08#1\uff09\uff0c\u8bf7\u91cd\u65b0\u8bbe\u8ba1SQL\u8bed\u53e5").replace("#1", repeatName);
                this.lbMsg.setText(msg);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)writer, true));
            if (e.getCause() instanceof ExtMacroException || e.getCause() instanceof ExtDataSetNoPermissionException || e.getCause() instanceof ExtDataSetNoExisitException || e.getCause() instanceof DataCenterNoPermissionException || e.getCause() instanceof DataSetContentNotExistsException || e.getCause() instanceof SuperQueryNoPermissionException) {
                MessageUtil.showDetailAndOK((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._designUI)), e.getCause().getMessage(), e.getCause().getMessage() + "\n\n" + writer.toString());
            } else if (e instanceof SuperQueryNoPermissionException) {
                MessageUtil.showDetailAndOK((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._designUI)), e.getMessage(), e.getMessage() + "\n\n" + writer);
            } else if (this._designUI.getCustomType() == SQLCustomType.SQL) {
                MessageUtil.showDetailAndOK((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._designUI)), QingRptLauncherMessages.getMLS("previewErrorOQL", "\u9884\u89c8\u9519\u8bef\uff0c\u975e\u6cd5\u7684SQL\u8bed\u53e5\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f"), "SQL Content:" + (String)this.logMap.get("sql") + "\n\n" + writer.toString());
            } else if (this._designUI.getCustomType() == SQLCustomType.OQL) {
                MessageUtil.showDetailAndOK((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._designUI)), QingRptLauncherMessages.getMLS("previewError", "\u9884\u89c8\u9519\u8bef\uff0c\u975e\u6cd5\u7684OQL\u8bed\u53e5\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f"), "OQL Content:" + (String)this.logMap.get("oql") + "\n\n" + writer.toString());
            }
            this.isShowPreviewUI = false;
            return false;
        }
        return true;
    }

    public boolean preview(boolean isRefresh, boolean isFromDesign) throws Exception {
        return this.preview(isRefresh, isFromDesign, true);
    }

    public static OutputColumns parseRSMD(ResultSetMetaData rsmd) throws SQLException {
        OutputColumns columns = new OutputColumns();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            String name = rsmd.getColumnName(i + 1);
            int columnType = rsmd.getColumnType(i + 1);
            DataType dt = DataType.fromJdbcType((int)columnType);
            if (columnType == -9) {
                dt = DataType.STRING;
            }
            Column oc = new Column();
            oc.setName(name);
            PreviewKSQLPanelUI.setDefMulLangMap((DefObj)oc, "alias", name);
            oc.setDataType(dt);
            columns.add((Object)oc);
        }
        return columns;
    }

    public static final void setDefMulLangMap(DefObj def, String keyName, String currentName) {
        LanguageCollection lc = new LanguageCollection();
        int size = lc.size();
        for (int i = 0; i < size; ++i) {
            LanguageInfo li = lc.get(i);
            String localString = li.getLocaleString();
            def.setProperty(keyName + "." + localString, (Object)currentName);
        }
        def.setProperty(keyName, (Object)"#1");
    }

    public static final void setTaleHeader(KDTable table, ResultSet rs, CtrlDesignQueryModel model) throws Exception {
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        ArrayList<StyleAttributes> colums = new ArrayList<StyleAttributes>();
        ArrayList<Integer> columsWidth = new ArrayList<Integer>();
        for (int i = 0; i < cols; ++i) {
            if (table.getColumn(i) != null) {
                colums.add(table.getColumn(i).getStyleAttributes());
                columsWidth.add(table.getColumn(i).getWidth());
                continue;
            }
            colums.add(null);
            columsWidth.add(null);
        }
        table.removeColumns();
        table.addColumns(cols);
        Map<String, Column> oldNameAlisaMap = OutputFieldsUI.getNameAlisaMapFromModel(model);
        String[] colFields = new String[cols];
        IRow headRow = table.addHeadRow();
        int headRowHeight = table.getHead().getHeight();
        headRow.setHeight(headRowHeight);
        for (int i = 0; i < cols; ++i) {
            String rowHeader = metaData.getColumnName(i + 1);
            if (metaData instanceof RowSetMetaDataImpl) {
                Object hasPermission;
                Map extendedProperties = ((RowSetMetaDataImpl)metaData).getExtendedProperties(i + 1);
                Object v0 = hasPermission = extendedProperties == null ? null : ((Hashtable)extendedProperties).get("hasPermission");
                if (hasPermission != null && !((Boolean)hasPermission).booleanValue()) {
                    rowHeader = rowHeader + QingRptLauncherMessages.getMLS("unauthorized", "\uff08\u672a\u6388\u6743\uff09");
                }
            }
            if (oldNameAlisaMap.containsKey(rowHeader.toUpperCase())) {
                Column oc = oldNameAlisaMap.get(rowHeader.toUpperCase());
                rowHeader = oc.getAlias();
            }
            headRow.getCell(i).setValue((Object)rowHeader);
            colFields[i] = rowHeader;
            table.getColumn(i).setKey(rowHeader);
            if (colums.get(i) != null) {
                table.getColumn(i).setStyleAttributes((StyleAttributes)colums.get(i));
            }
            if (columsWidth.get(i) == null) continue;
            table.getColumn(i).setWidth((Integer)columsWidth.get(i) == 0 ? 1 : (Integer)columsWidth.get(i));
        }
        table.putBindContents("member", colFields);
        table.checkParsed();
    }

    public static final int bindResultSet(KDTable table, ResultSet rs) throws SQLException {
        int bindRow = 0;
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int row = 0;
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        ArrayList<Boolean> fieldsPermission = new ArrayList<Boolean>(cols);
        boolean checkFieldPerm = false;
        if (rsmd instanceof RowSetMetaDataImpl) {
            for (int i = 0; i < cols; ++i) {
                Object hasPermission;
                Map extendedProperties = ((RowSetMetaDataImpl)rsmd).getExtendedProperties(i + 1);
                Object v0 = hasPermission = extendedProperties == null ? null : ((Hashtable)extendedProperties).get("hasPermission");
                if (hasPermission == null) break;
                fieldsPermission.add(hasPermission);
                if (checkFieldPerm) continue;
                checkFieldPerm = true;
            }
        }
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            IRow irow = table.addRow();
            for (int col = 0; col < cols; ++col) {
                Object value = rs.getObject(col + 1);
                int type = rsmd.getColumnType(col + 1);
                value = checkFieldPerm && (Boolean)fieldsPermission.get(col) == false ? "***" : (value == null ? "" : (type == 12 || type == 16 || type == 4 || type == 8 || type == 6 || type == 2 || type == -6 || type == 3 || type == 5 || type == 1 || type == -1 || type == -5 || type == -16 || type == -9 || type == -15 ? String.valueOf(value) : (type == 91 ? dateFormat.format(value) : (type == 92 ? timeFormat.format(value) : (type == 93 ? timestampFormat.format(value) : (type == 2004 ? (Object)BlobBO.readBlob((ResultSet)rs, (int)(col + 1)) : value.toString()))))));
                value = RunReportParam.getOracleDateValue((Object)value);
                table.getCell(row, col).setValue(value);
                map.put(rsmd.getColumnName(col + 1).toLowerCase(), value);
            }
            irow.setUserObject(map);
            ++row;
            ++bindRow;
        }
        return bindRow;
    }

    private void isTextErrVisible(boolean isShowErr) {
        this.kDScrollPane1.setVisible(isShowErr);
        this.tblContent.setVisible(!isShowErr);
    }

    public boolean isShowPreviewUI() {
        return this.isShowPreviewUI;
    }

    protected KDTable getTableForCommon() {
        return this.tblContent;
    }

    public String getSolutionID() {
        return this.solutionID;
    }

    public void setSolutionID(String solutionID) {
        this.solutionID = solutionID;
    }
}

