/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.boslayer.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.boslayer.bos.ui.face.CoreUIObject;
import com.kingdee.bos.boslayer.eas.framework.report.util.RptParams;
import com.kingdee.bos.boslayer.eas.util.client.MsgBox;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.ReportDialog;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractProcedureUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DefaultDateValueUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DefaultTimeValueUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignParamUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.ProcedureImportUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InOutputParamVO;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputState;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureIOType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureParamData;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTableHelper;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ProcedureUI
extends AbstractProcedureUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ProcedureUI.class);
    private static final int COL_NAME = 0;
    private static final int COL_ALIAS = 1;
    private static final int COL_IO_TYPE = 2;
    private static final int COL_DATA_TYPE = 3;
    private static final int COL_DEFAULTVALUE = 4;
    int dbType = -1;
    private KDComboBox cmbIOType;
    private KDComboBox cmbDataType;
    private KDComboBox cmbBindFilterParam;
    private KDTDefaultCellEditor ceBindParam;
    ProcedureDataType dataTypeOld;
    ProcedureIOType ioTypeOld;
    TablePropertyChangeHandler tablePropertyChangeHandler;
    private DesignUI _designUI;

    public ProcedureUI(DesignUI designUI) throws Exception {
        this._designUI = designUI;
        this.init();
    }

    private void init() throws Exception {
        this.initLayout();
        this.table.checkParsed();
        this.setOpaque(false);
        this.setHelpMessage();
        this.initTable();
        this.kDSpinner1.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        this.setDBTypeName();
        this.installListener();
        this.txtProcedureName.requestFocus();
    }

    private void initTable() {
        this.table.getSelectManager().setSelectMode(15);
        KDTableHelper.updateEnterWithTab((KDTable)this.table, (boolean)false);
        this.cmbBindFilterParam = new KDComboBox();
        this.cmbBindFilterParam.setEditable(true);
        this.cmbBindFilterParam.putClientProperty((Object)"jump", (Object)"false");
        this.ceBindParam = new KDTDefaultCellEditor((JComboBox)this.cmbBindFilterParam);
        this.table.getColumn(1).setEditor((ICellEditor)this.ceBindParam);
        this.cmbIOType = new KDComboBox();
        this.cmbIOType.addItems((Object[])ProcedureIOType.ProcedureIOTypes);
        this.cmbIOType.putClientProperty((Object)"jump", (Object)"false");
        KDTDefaultCellEditor ceIOType = new KDTDefaultCellEditor((JComboBox)this.cmbIOType);
        this.table.getColumn(2).setEditor((ICellEditor)ceIOType);
        this.cmbDataType = new KDComboBox();
        this.cmbDataType.addItems((Object[])ProcedureDataType.ProcedureDataTypes);
        this.cmbDataType.putClientProperty((Object)"jump", (Object)"false");
        KDTDefaultCellEditor ceDataType = new KDTDefaultCellEditor((JComboBox)this.cmbDataType);
        this.table.getColumn(3).setEditor((ICellEditor)ceDataType);
        this.kDPanel1.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), "Sqlserver\u3001DB2\u3001PostgreSQL" + QingRptLauncherMessages.getMLS("set", "\u8bbe\u7f6e")));
        this.kDPanel2.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), "Oracle\u3001PostgreSQL" + QingRptLauncherMessages.getMLS("set", "\u8bbe\u7f6e")));
    }

    private void installListener() {
        this.btnAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProcedureUI.this.doBtnAuto();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    String dbTypeMsg = QingRptLauncherMessages.getMLS("databaseType", "\u6570\u636e\u5e93\u7c7b\u578b\uff1a") + ProcedureUI.this.txtDBType.getText();
                    String proceNaemMsg = QingRptLauncherMessages.getMLS("storedProcedureName", "\u5b58\u50a8\u8fc7\u7a0b\u540d\u79f0\uff1a") + ProcedureUI.this.txtProcedureName.getText();
                    String msgTip = QingRptLauncherMessages.getMLS("cannotDetectParameterInfo", "\u65e0\u6cd5\u68c0\u6d4b\u5230\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u624b\u5de5\u914d\u7f6e\uff01");
                    String msg = dbTypeMsg + "\r\n" + proceNaemMsg + "\r\n" + msgTip;
                    MessageUtil.showDetailAndOK(null, msg + e1.getMessage(), e1);
                }
            }
        });
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProcedureUI.this.doBtnImport();
                }
                catch (Exception e1) {
                    logger.error((Object)"doBtnImport", (Throwable)e1);
                }
            }
        });
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcedureUI.this.doBtnMoveUp();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcedureUI.this.doBtnMoveDown();
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcedureUI.this.doBtnInsert();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcedureUI.this.doBtnDelete();
            }
        });
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcedureUI.this.doBtnCreate();
            }
        });
        this.cmbIOType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ProcedureIOType ioType = (ProcedureIOType)e.getItem();
                    ICell cell = ProcedureUI.this.table.getRow(ProcedureUI.this.table.getSelectManager().getActiveRowIndex()).getCell(4);
                    if (ioType.equals(ProcedureIOType.OUT)) {
                        cell.setValue((Object)QingRptLauncherMessages.getMLS("noNeedToSetOutputParameter", "\u8f93\u51fa\u53c2\u6570\u65e0\u9700\u8bbe\u7f6e"));
                        cell.getStyleAttributes().setLocked(true);
                        cell.getStyleAttributes().setFontColor(Color.lightGray);
                        ICell cellAlias = ProcedureUI.this.table.getRow(ProcedureUI.this.table.getSelectManager().getActiveRowIndex()).getCell(1);
                        ProcedureUI.this.table.getColumn(1).setEditor(null);
                        cellAlias.getStyleAttributes().setLocked(true);
                        cellAlias.setValue((Object)QingRptLauncherMessages.getMLS("noNeedToBindOutputParameter", "\u8f93\u51fa\u53c2\u6570\u65e0\u9700\u7ed1\u5b9a"));
                        cellAlias.getStyleAttributes().setFontColor(Color.lightGray);
                    } else {
                        ICell cellAlias = ProcedureUI.this.table.getRow(ProcedureUI.this.table.getSelectManager().getActiveRowIndex()).getCell(1);
                        cellAlias.setValue(null);
                        cellAlias.getStyleAttributes().setFontColor(Color.black);
                        cell.getStyleAttributes().setFontColor(Color.black);
                        ProcedureDataType dataType = (ProcedureDataType)ProcedureUI.this.table.getRow(ProcedureUI.this.table.getSelectManager().getActiveRowIndex()).getCell(3).getValue();
                        if (dataType.equals(ProcedureDataType.CURSOR)) {
                            dataType = ProcedureDataType.STRING;
                            ProcedureUI.this.table.getRow(ProcedureUI.this.table.getSelectManager().getActiveRowIndex()).getCell(3).setValue((Object)dataType);
                        }
                        ProcedureUI.this.setCellDefaultValue(ProcedureUI.this.table.getRow(ProcedureUI.this.table.getSelectManager().getActiveRowIndex()), ProcedureUI.this.dataTypeOld);
                    }
                }
            }
        });
        this.cmbDataType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (ProcedureUI.this.ioTypeOld.equals(ProcedureIOType.OUT)) {
                        return;
                    }
                    ProcedureDataType dataType = (ProcedureDataType)e.getItem();
                    if (ProcedureUI.this.ioTypeOld.equals(ProcedureIOType.INPUT) && dataType.equals(ProcedureDataType.CURSOR)) {
                        MessageUtil.showInfo("parameterDataTypeMustNotBeCursor", true, QingRptLauncherMessages.getMLS("parameterDataTypeMustNotBeCursor", "\u8f93\u5165\u53c2\u6570\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u662f\u6e38\u6807"));
                        ProcedureUI.this.cmbDataType.setSelectedItem((Object)ProcedureUI.this.dataTypeOld);
                        return;
                    }
                    ProcedureUI.this.setCellDefaultValue(ProcedureUI.this.table.getRow(ProcedureUI.this.table.getSelectManager().getActiveRowIndex()), dataType);
                }
            }
        });
        this.table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int row = e.getRowIndex();
                int col = e.getColumnIndex();
                if (row == -1) {
                    return;
                }
                ProcedureUI.this.dataTypeOld = (ProcedureDataType)ProcedureUI.this.table.getRow(row).getCell(3).getValue();
                ProcedureUI.this.ioTypeOld = (ProcedureIOType)ProcedureUI.this.table.getRow(row).getCell(2).getValue();
                if (ProcedureUI.this.ioTypeOld.equals(ProcedureIOType.OUT)) {
                    return;
                }
                if (col == 1) {
                    ICell cell = ProcedureUI.this.table.getRow(row).getCell(1);
                    cell.getStyleAttributes().setLocked(false);
                    ProcedureUI.this.ceBindParam = new KDTDefaultCellEditor((JComboBox)ProcedureUI.this.cmbBindFilterParam);
                    ProcedureUI.this.table.getColumn(1).setEditor((ICellEditor)ProcedureUI.this.ceBindParam);
                }
                if (col == 4) {
                    ProcedureDataType dataType = (ProcedureDataType)ProcedureUI.this.table.getRow(row).getCell(3).getValue();
                    if (dataType.equals(ProcedureDataType.STRING) || dataType.equals(ProcedureDataType.INTEGER) || dataType.equals(ProcedureDataType.DOUBLE)) {
                        ProcedureUI.this.table.getColumn(4).setEditor(null);
                        ProcedureUI.this.table.getRow(row).getCell(4).getStyleAttributes().setLocked(false);
                    } else if (dataType.equals(ProcedureDataType.DATE) || dataType.equals(ProcedureDataType.DATETIME) || dataType.equals(ProcedureDataType.TIME)) {
                        ProcedureUI.this.showDefalutDateUI(row);
                    }
                }
            }
        });
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if (colIndex == 1) {
                    ICell cell = ProcedureUI.this.table.getRow(rowIndex).getCell(2);
                    ProcedureIOType ioType = (ProcedureIOType)cell.getValue();
                    if (ioType.equals(ProcedureIOType.OUT)) {
                        return;
                    }
                    String selectName = "";
                    Object bindObj = e.getValue();
                    if (bindObj instanceof DesignParameter) {
                        selectName = ((DesignParameter)bindObj).getName();
                    }
                    ProcedureUI.this.setBindFilterParamList(selectName);
                }
            }

            public void editStopping(KDTEditEvent e) {
                boolean flag;
                if (e.getColIndex() == 0 && e.getValue() != null && (flag = DesignParamUI.isNameRepeat(ProcedureUI.this.table, 0, e.getRowIndex(), e.getValue().toString(), null))) {
                    e.setCancel(true);
                    return;
                }
                for (int i = 0; i < ProcedureUI.this.table.getRowCount(); ++i) {
                    IRow row = ProcedureUI.this.table.getRow(i);
                    ProcedureUI.this.setParameterFromRow(row);
                }
            }

            public void editStopped(KDTEditEvent e) {
                ProcedureUI.this.setCursorList(null);
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1 && e.getType() == 1) {
                    int row = e.getRowIndex();
                    int col = e.getColIndex();
                    ProcedureIOType ioType = (ProcedureIOType)ProcedureUI.this.table.getRow(row).getCell(2).getValue();
                    if (ioType.equals(ProcedureIOType.OUT)) {
                        return;
                    }
                    if (col == 4) {
                        ProcedureDataType dataType = (ProcedureDataType)ProcedureUI.this.table.getRow(row).getCell(3).getValue();
                        if (dataType.equals(ProcedureDataType.STRING) || dataType.equals(ProcedureDataType.INTEGER) || dataType.equals(ProcedureDataType.DOUBLE)) {
                            ProcedureUI.this.table.getColumn(4).setEditor(null);
                            ProcedureUI.this.table.getRow(row).getCell(4).getStyleAttributes().setLocked(false);
                        } else if (dataType.equals(ProcedureDataType.DATE) || dataType.equals(ProcedureDataType.DATETIME) || dataType.equals(ProcedureDataType.TIME)) {
                            ProcedureUI.this.showDefalutDateUI(row);
                        }
                    }
                }
            }
        });
    }

    private void setCellDefaultValue(IRow row, ProcedureDataType dataType) {
        ProcedureParamData ppd = (ProcedureParamData)row.getUserObject();
        if (dataType == null) {
            dataType = ppd.getDataType();
        }
        ICell cell = row.getCell(4);
        String defaultValue = CtrlReportUtil.getObjectString((Object)ppd.getDefaultValue());
        if (dataType.equals(ProcedureDataType.DATE)) {
            if (StringUtils.isEmpty((CharSequence)defaultValue)) {
                defaultValue = "9999-12-31";
            }
            cell.setValue((Object)defaultValue);
        } else if (dataType.equals(ProcedureDataType.TIME)) {
            if (StringUtils.isEmpty((CharSequence)defaultValue)) {
                defaultValue = "00:00:00";
            }
            cell.setValue((Object)"00:00:00");
        } else if (dataType.equals(ProcedureDataType.DATETIME)) {
            if (StringUtils.isEmpty((CharSequence)defaultValue)) {
                defaultValue = "9999-12-31 00:00:00";
            }
            cell.setValue((Object)"9999-12-31 00:00:00");
        } else if (dataType.equals(ProcedureDataType.STRING)) {
            cell.setValue((Object)defaultValue);
        } else if (dataType.equals(ProcedureDataType.INTEGER) || dataType.equals(ProcedureDataType.DOUBLE)) {
            if (StringUtils.isEmpty((CharSequence)defaultValue)) {
                defaultValue = "0";
            }
            cell.setValue((Object)defaultValue);
        }
        ppd.setDefaultValue(defaultValue);
    }

    private void setBindFilterParamList(String selectedName) {
        this.cmbBindFilterParam.removeAllItems();
        DesignParameter[] dps = ProcedureImportUI.getFilterAllParamArr(this._designUI.getModel());
        for (int i = 0; i < dps.length; ++i) {
            DesignParameter p = dps[i];
            String currentParamName = p.getName();
            this.cmbBindFilterParam.addItem((Object)p);
            if (!selectedName.equalsIgnoreCase(currentParamName)) continue;
            this.cmbBindFilterParam.setSelectedItem((Object)p);
        }
    }

    private void setCursorList(String selectedName) {
        Object obj = null;
        if (selectedName == null) {
            obj = this.cmbCursor.getSelectedItem();
        }
        this.cmbCursor.removeAllItems();
        int cursorCount = 0;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String name;
            ProcedureDataType dataType = (ProcedureDataType)this.table.getRow(i).getCell(3).getValue();
            if (!dataType.equals(ProcedureDataType.CURSOR)) continue;
            DefObj def = new DefObj();
            Object value = this.table.getRow(i).getCell(0).getValue();
            String alias = name = value == null ? "" : value.toString();
            def.setName(name);
            def.setAlias(alias);
            this.cmbCursor.addItem((Object)def);
            if (selectedName != null && selectedName.equals(name)) {
                this.cmbCursor.setSelectedItem((Object)def);
            } else if (null != obj && ((DefObj)obj).getName().equals(name)) {
                this.cmbCursor.setSelectedItem((Object)def);
            }
            ++cursorCount;
        }
        if (this.dbType == 5 && cursorCount > 0) {
            this.kDSpinner1.setEnabled(false);
            this.cmbCursor.setEnabled(true);
        } else if (this.dbType == 5 && cursorCount == 0) {
            this.kDSpinner1.setEnabled(true);
            this.cmbCursor.setEnabled(false);
        }
    }

    private void showDefalutDateUI(int row) {
        this.table.getRow(row).getCell(4).getStyleAttributes().setLocked(true);
        this.table.getColumn(4).setEditor(null);
        String value = CtrlReportUtil.getObjectString((Object)this.table.getRow(row).getCell(4).getValue());
        try {
            int intDataType = ((ProcedureDataType)this.table.getRow(row).getCell(3).getValue()).intValue();
            if (intDataType == 5) {
                DefaultTimeValueUI dtui = new DefaultTimeValueUI(value, true, this._designUI.getContext());
                ReportDialog.showDialog(dtui, QingRptLauncherMessages.getMLS("setTimeDefault", "\u8bbe\u7f6e\u65f6\u95f4\u9ed8\u8ba4\u503c"), true, false);
                if (!dtui.isCancel()) {
                    value = dtui.getDateSelected();
                    this.table.getRow(row).getCell(4).setValue((Object)value);
                }
            } else {
                DefaultDateValueUI dvui = new DefaultDateValueUI(value, intDataType, true, this._designUI.getContext());
                ReportDialog.showDialog(dvui, QingRptLauncherMessages.getMLS("setDateDefault", "\u8bbe\u7f6e\u65e5\u671f\u9ed8\u8ba4\u503c"), true, false);
                if (!dvui.isCancel()) {
                    value = dvui.getDateSelected();
                    this.table.getRow(row).getCell(4).setValue((Object)value);
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)"\u8bbe\u7f6e\u65e5\u671f\u9ed8\u8ba4\u503c", (Throwable)e1);
        }
    }

    public void commitTableData() {
        this.table.getEditManager().stopEditing();
    }

    private void doBtnMoveUp() {
        KDTSelectBlock sel = this.table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == 0) {
            return;
        }
        IRow selRow = this.table.removeRow(idx);
        if (null == selRow) {
            return;
        }
        this.table.addRow(idx - 1, selRow);
        this.table.getSelectManager().select(idx - 1, 0);
    }

    private void doBtnMoveDown() {
        KDTSelectBlock sel = this.table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == this.table.getRowCount() - 1) {
            return;
        }
        IRow selRow = this.table.removeRow(idx);
        this.table.addRow(idx + 1, selRow);
        this.table.getSelectManager().select(idx + 1, 0);
    }

    private void doBtnInsert() {
        this.removeTablePropertyChangeHandler();
        try {
            IRow newRow = this.table.addRow();
            int idx = this.table.getRowCount() - 1;
            newRow.setUserObject((Object)new ProcedureParamData());
            newRow.getCell(2).setValue((Object)ProcedureIOType.INPUT);
            newRow.getCell(3).setValue((Object)ProcedureDataType.STRING);
            this.table.getEditManager().editCellAt(idx, 0);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            this.addTablePropertyChangeHandler();
        }
    }

    private void doBtnDelete() {
        int selEnd;
        KDTSelectBlock sel = this.table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)QingRptLauncherMessages.getMLS("confirmDeleteSelection", "\u786e\u5b9e\u8981\u5220\u9664\u6240\u9009\u5185\u5bb9\u5417\uff1f"), (String)QingRptLauncherMessages.getMLS("confirmDelete", "\u786e\u8ba4\u5220\u9664"))) {
            return;
        }
        int selBegin = sel.getBeginRow();
        for (int i = selEnd = sel.getEndRow(); i >= selBegin; --i) {
            this.table.removeRow(i);
        }
        this.table.getSelectManager().setActiveRowIndex(selBegin);
        if (this.dbType == 2 || this.dbType == 5) {
            String selectName = null;
            Object obj = this.cmbCursor.getSelectedItem();
            if (null != obj) {
                DefObj def = (DefObj)obj;
                selectName = def.getName();
            }
            this.setCursorList(selectName);
        }
    }

    private void doBtnCreate() {
        if (StringUtils.isEmpty((CharSequence)this.txtProcedureName.getText())) {
            MessageUtil.showInfo("enterStoredProcedureName", true, QingRptLauncherMessages.getMLS("enterStoredProcedureName", "\u8bf7\u8f93\u5165\u5b58\u50a8\u8fc7\u7a0b\u540d\u79f0"));
            this.txtProcedureName.requestFocus();
            return;
        }
        if (this.dbType == 2 && null == this.cmbCursor.getSelectedItem()) {
            MessageUtil.showInfo("noOutputParameterIsCursor", true, QingRptLauncherMessages.getMLS("noOutputCursorResultSet", "\u6ca1\u6709\u8f93\u51fa\u53c2\u6570\u662f\u6e38\u6807\u7684\u7ed3\u679c\u96c6"));
            this.cmbCursor.requestFocus();
            return;
        }
        this._designUI.getModel().getCommonQuery().setProcedureModel(this.getProcedureModel());
    }

    private void doBtnImport() throws Exception {
        ProcedureImportUI dtui = new ProcedureImportUI(this._designUI);
        ReportDialog.showDialog(dtui, QingRptLauncherMessages.getMLS("importFilterParamToStoredProcedure", "\u5f15\u5165\u8fc7\u6ee4\u53c2\u6570\u5230\u5b58\u50a8\u8fc7\u7a0b"), true, false);
        if (!dtui.isCancel()) {
            this.removeTablePropertyChangeHandler();
            ArrayList lst = dtui.getLstSelected();
            DesignParameter[] dps = ProcedureImportUI.getFilterAllParamArr(this._designUI.getModel());
            for (Object obj : lst) {
                DesignParameter p;
                ProcedureParamData param = new ProcedureParamData();
                if (!(obj instanceof DesignParameter) || this.isExistParam((p = (DesignParameter)obj).getName())) continue;
                boolean isAllowMultipleSelected = false;
                IInputCtrl inputCtrl = p.getInputCtrl();
                if (inputCtrl != null) {
                    isAllowMultipleSelected = inputCtrl.isAllowMultipleSelected();
                }
                IRow newRow = this.table.addRow();
                param.setName(p.getName());
                param.setBindFilterParamName(p.getName());
                param.setIoType(ProcedureIOType.INPUT);
                DesignDataType ddt = p.getDesignDataType();
                if (ddt.equals((Object)DesignDataType.TXT)) {
                    param.setDataType(ProcedureDataType.STRING);
                } else if (ddt.equals((Object)DesignDataType.NUMERICAL) || ddt.equals((Object)DesignDataType.BOOLEAN)) {
                    this.setInParamDataType(param, isAllowMultipleSelected, ProcedureDataType.INTEGER);
                    param.setDefaultValue("0");
                } else if (ddt.equals((Object)DesignDataType.DATE)) {
                    this.setInParamDataType(param, isAllowMultipleSelected, ProcedureDataType.DATE);
                    param.setDefaultValue("9999-12-31");
                } else if (ddt.equals((Object)DesignDataType.DATETIME)) {
                    this.setInParamDataType(param, isAllowMultipleSelected, ProcedureDataType.DATETIME);
                    param.setDefaultValue("9999-12-31 00:00:00");
                } else if (ddt.equals((Object)DesignDataType.TIME)) {
                    this.setInParamDataType(param, isAllowMultipleSelected, ProcedureDataType.TIME);
                    param.setDefaultValue("00:00:00");
                } else {
                    param.setDataType(ProcedureDataType.STRING);
                }
                this.setParam2Row(param, newRow, dps);
            }
            this.addTablePropertyChangeHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBtnAuto() throws Exception {
        HashMap<String, String> mapR;
        String type_name;
        String column_type;
        String column_name;
        ArrayList lstReturn;
        String sql;
        int confirm;
        String procedureName = CtrlReportUtil.getObjectString((Object)this.txtProcedureName.getText());
        if (StringUtils.isEmpty((CharSequence)procedureName)) {
            MessageUtil.showInfo("enterStoredProcedureName", true, QingRptLauncherMessages.getMLS("enterStoredProcedureName", "\u8bf7\u8f93\u5165\u5b58\u50a8\u8fc7\u7a0b\u540d\u79f0"));
            this.txtProcedureName.requestFocus();
            return;
        }
        if (this.table.getRowCount() > 0 && (confirm = MsgBox.showConfirm2(QingRptLauncherMessages.getMLS("autoGenerationWillOverwriteExistingParameters", "\u81ea\u52a8\u751f\u6210\u5c06\u4f1a\u7528\u6700\u65b0\u53c2\u6570\u4fe1\u606f\u8986\u76d6\u6389\u539f\u6709\u53c2\u6570\uff0c\u662f\u5426\u7ee7\u7eed\uff1f"))) == 2) {
            return;
        }
        boolean isCreateFilterParam = true;
        int confirm2 = MsgBox.showConfirm2(QingRptLauncherMessages.getMLS("generateFilterInterfaceParameters", "\u662f\u5426\u540c\u65f6\u751f\u6210\u8fc7\u6ee4\u754c\u9762\u53c2\u6570\uff1f"));
        if (confirm2 == 2) {
            isCreateFilterParam = false;
        }
        String outDB = CtrlReportUtil.getObjectString((Object)((CtrlDesignKsqlQuery)this._designUI.getModel().getQuery()).getOutDB());
        boolean isExitsProce = KSQLReportBO.isExitsProce((Object)((Object)this._designUI.getContext()), (String)outDB, (String)procedureName, (int)this.dbType);
        if (!isExitsProce) {
            String dbTypeMsg = QingRptLauncherMessages.getMLS("databaseType", "\u6570\u636e\u5e93\u7c7b\u578b\uff1a") + this.txtDBType.getText();
            String proceNaemMsg = QingRptLauncherMessages.getMLS("storedProcedureName", "\u5b58\u50a8\u8fc7\u7a0b\u540d\u79f0\uff1a") + this.txtProcedureName.getText();
            String msgTip = QingRptLauncherMessages.getMLS("storedProcedureDoesNotExistOrNoAccessPermission", "\u5b58\u50a8\u8fc7\u7a0b\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u624b\u5de5\u5f15\u5165\u53c2\u6570\uff01");
            String string = dbTypeMsg + "\r\n" + proceNaemMsg + "\r\n" + msgTip;
            MessageUtil.showInfo(string, false, "");
            return;
        }
        RptParams pr = new RptParams();
        ArrayList lst = new ArrayList();
        if (this.dbType == 3) {
            ArrayList<InOutputParamVO> procedureVOList = new ArrayList<InOutputParamVO>();
            ArrayList<DesignParameter> arrayList = new ArrayList<DesignParameter>();
            InOutputParamVO vo1 = new InOutputParamVO();
            vo1.setName("dp1");
            vo1.setIoType(0);
            vo1.setDataType(0);
            vo1.setValue((Object)procedureName);
            DesignParameter dp1 = new DesignParameter();
            dp1.setName("dp1");
            dp1.setDefaultValue(procedureName);
            dp1.setCurentValue(procedureName);
            dp1.setInputType(InputType.INPUT);
            InOutputParamVO vo2 = new InOutputParamVO();
            vo2.setName("dp2");
            vo2.setIoType(0);
            vo2.setDataType(0);
            vo2.setValue(null);
            DesignParameter dp2 = new DesignParameter();
            dp2.setName("dp2");
            dp2.setDefaultValue(null);
            dp2.setCurentValue(null);
            dp2.setInputType(InputType.INPUT);
            InOutputParamVO vo3 = new InOutputParamVO();
            vo3.setName("dp3");
            vo3.setIoType(0);
            vo3.setDataType(0);
            vo3.setValue(null);
            DesignParameter dp3 = new DesignParameter();
            dp3.setName("dp3");
            dp3.setDefaultValue(null);
            dp3.setCurentValue(null);
            dp3.setInputType(InputType.INPUT);
            InOutputParamVO vo4 = new InOutputParamVO();
            vo4.setName("dp4");
            vo4.setIoType(0);
            vo4.setDataType(0);
            vo4.setValue(null);
            DesignParameter dp4 = new DesignParameter();
            dp4.setName("dp4");
            dp4.setDefaultValue(null);
            dp4.setCurentValue(null);
            dp4.setInputType(InputType.INPUT);
            InOutputParamVO vo5 = new InOutputParamVO();
            vo5.setName("dp5");
            vo5.setIoType(0);
            vo5.setDataType(1);
            vo5.setValue((Object)new Integer("2"));
            DesignParameter dp5 = new DesignParameter();
            dp5.setName("dp5");
            dp5.setDefaultValue("2");
            dp5.setCurentValue("2");
            dp5.setInputType(InputType.INPUT);
            procedureVOList.add(vo1);
            procedureVOList.add(vo2);
            procedureVOList.add(vo3);
            procedureVOList.add(vo4);
            procedureVOList.add(vo5);
            arrayList.add(dp1);
            arrayList.add(dp2);
            arrayList.add(dp3);
            arrayList.add(dp4);
            arrayList.add(dp5);
            pr.setString("MethodName", "callProcedure");
            pr.setString("procedureName", "sp_sproc_columns");
            pr.setInt("dbType", 3);
            pr.setString("resultNumberName", "1");
            pr.setObject("paramList", procedureVOList);
            pr.setInt("start", 0);
            pr.setInt("rows", -1);
            CtrlDesignQueryModel model = new CtrlDesignQueryModel();
            String defaultModel = "<CommonQuery SQLCustomType=\"2\"><Procedure name=\"sp_sproc_columns\" dbType=\"3\" resultNumber=\"1\" resultCursor=\"\" ><Parameter bindFilterParamName=\"dp1\" name=\"" + procedureName + "\" ioType=\"0\" dataType=\"0\"/><Parameter bindFilterParamName=\"dp2\" ioType=\"0\" dataType=\"0\"/><Parameter bindFilterParamName=\"dp3\" ioType=\"0\" dataType=\"0\"/><Parameter bindFilterParamName=\"dp4\" ioType=\"0\" dataType=\"0\"/><Parameter bindFilterParamName=\"dp5\" ioType=\"0\" dataType=\"1\"/></Procedure><Query version=\"1.0\" type=\"sql.wizard\" goodOutput=\"true\" OutDB=\"" + (outDB == null ? "KBI.METADATA.DATASOURCE" : outDB) + "\"><Columns /><Tables /><Joins /><Orders /><Filter /><Content /></Query><EXT /></CommonQuery>";
            try {
                IXmlElement xml = XmlUtil.loadXmlString((String)defaultModel);
                model = new CtrlDesignQueryModel();
                CtrlDesignUtil.toObject((Object)((Object)this._designUI.ctx), (CtrlDesignQueryModel)model, (IXmlElement)xml, null);
                model.getCommonQuery().setParameters(arrayList);
                pr.setObject("CtrlDesignQueryModel", (Object)model);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (!StringUtils.isEmpty((CharSequence)outDB)) {
                pr.setObject("outDB", (Object)outDB);
            }
            RptParams psR2 = FacadeFactory.commonExecute((Object)((Object)this._designUI.getContext()), (RptParams)pr);
            HashMap mapResult = (HashMap)psR2.getObject("object");
            ResultSet rs = (ResultSet)mapResult.get("6xx8xxRowset");
            List lstReturn2 = null;
            try {
                lstReturn2 = ExtDBUtil.setDataToList((ResultSet)rs);
            }
            finally {
                CloseUtil.close((ResultSet)rs);
            }
            for (HashMap map : lstReturn2) {
                String column_name2 = CtrlReportUtil.getObjectString(map.get("column_name"));
                if (column_name2.equalsIgnoreCase("@RETURN_VALUE")) continue;
                column_name2 = ExtStringUtil.replaceFirst((String)column_name2, (String)"@", (String)"");
                String column_type2 = CtrlReportUtil.getObjectString(map.get("column_type"));
                String data_type = CtrlReportUtil.getObjectString(map.get("data_type"));
                String type_name2 = CtrlReportUtil.getObjectString(map.get("type_name"));
                HashMap<String, String> mapR2 = new HashMap<String, String>();
                mapR2.put("column_name", column_name2);
                mapR2.put("column_type", column_type2);
                mapR2.put("data_type", data_type);
                mapR2.put("type_name", type_name2);
                lst.add(mapR2);
            }
        } else if (this.dbType == 2) {
            sql = null;
            if (procedureName.indexOf(".") != -1) {
                String[] stringArray = procedureName.split("\\.");
                String package_name = stringArray[0];
                String object_name = stringArray[1];
                sql = "/*dialect*/select T.ARGUMENT_NAME, T.DATA_TYPE, T.in_out, T.DEFAULT_VALUE from all_arguments t where t.package_name = '" + package_name.toUpperCase() + "' and t.object_name = '" + object_name.toUpperCase() + "' ORDER BY T.POSITION";
            } else {
                sql = "/*dialect*/select T.ARGUMENT_NAME, T.DATA_TYPE, T.in_out, T.DEFAULT_VALUE from all_arguments t where t.package_name is null and t.object_name = '" + procedureName.toUpperCase() + "' ORDER BY T.POSITION";
            }
            pr.setString("MethodName", "getInfoListBySQL");
            pr.setString("sql", sql);
            if (!StringUtils.isEmpty((CharSequence)outDB)) {
                pr.setObject("outDB", (Object)outDB);
            }
            RptParams rptParams = FacadeFactory.commonExecute((Object)((Object)this._designUI.getContext()), (RptParams)pr);
            lstReturn = (ArrayList)rptParams.getObject("object");
            for (HashMap map : lstReturn) {
                column_name = CtrlReportUtil.getObjectString(map.get("argument_name"));
                column_type = CtrlReportUtil.getObjectString(map.get("in_out"));
                type_name = CtrlReportUtil.getObjectString(map.get("data_type"));
                mapR = new HashMap<String, String>();
                mapR.put("column_name", column_name.toLowerCase());
                mapR.put("column_type", column_type);
                mapR.put("type_name", type_name);
                lst.add(mapR);
            }
        } else if (this.dbType == 1) {
            sql = "/*dialect*/select parmname,typename,parm_mode from SYSIBM.SYSPROCPARMS where procname = '" + procedureName.toUpperCase() + "'  order by ordinal";
            pr.setString("MethodName", "getInfoListBySQL");
            pr.setString("sql", sql);
            if (!StringUtils.isEmpty((CharSequence)outDB)) {
                pr.setObject("outDB", (Object)outDB);
            }
            RptParams rptParams = FacadeFactory.commonExecute((Object)((Object)this._designUI.getContext()), (RptParams)pr);
            lstReturn = (ArrayList)rptParams.getObject("object");
            for (HashMap map : lstReturn) {
                column_name = CtrlReportUtil.getObjectString(map.get("parmname"));
                column_type = CtrlReportUtil.getObjectString(map.get("parm_mode"));
                type_name = CtrlReportUtil.getObjectString(map.get("typename"));
                column_name = ExtStringUtil.replaceFirst((String)column_name, (String)"@", (String)"");
                mapR = new HashMap();
                mapR.put("column_name", column_name.toLowerCase());
                mapR.put("column_type", column_type);
                mapR.put("type_name", type_name);
                lst.add(mapR);
            }
        } else if (this.dbType == 5) {
            sql = "/*dialect*/SELECT parameters.parameter_name, parameters.parameter_mode, parameters.data_type FROM information_schema.routines JOIN information_schema.parameters ON routines.specific_name=parameters.specific_name WHERE routines.routine_name='" + procedureName.toLowerCase() + "'ORDER BY routines.routine_name, parameters.ordinal_position;";
            pr.setString("MethodName", "getInfoListBySQL");
            pr.setString("sql", sql);
            if (!StringUtils.isEmpty((CharSequence)outDB)) {
                pr.setObject("outDB", (Object)outDB);
            }
            RptParams rptParams = FacadeFactory.commonExecute((Object)((Object)this._designUI.getContext()), (RptParams)pr);
            lstReturn = (ArrayList)rptParams.getObject("object");
            HashMap returnTypeMap = new HashMap();
            for (HashMap map : lstReturn) {
                String column_name3 = CtrlReportUtil.getObjectString(map.get("parameter_name"));
                String column_type3 = CtrlReportUtil.getObjectString(map.get("parameter_mode"));
                String type_name3 = CtrlReportUtil.getObjectString(map.get("data_type"));
                column_name3 = ExtStringUtil.replaceFirst((String)column_name3, (String)"@", (String)"");
                HashMap<String, String> mapR3 = new HashMap<String, String>();
                mapR3.put("column_name", column_name3.toLowerCase());
                mapR3.put("column_type", column_type3);
                mapR3.put("type_name", type_name3);
                lst.add(mapR3);
            }
            if (returnTypeMap.size() > 0) {
                lst.add(returnTypeMap);
            }
        }
        if (lst.isEmpty()) {
            MessageUtil.showInfo("storedProcedureHasNoInputOutputParametersOrNoAccessPermission", true, QingRptLauncherMessages.getMLS("storedProcedureNoParamsOrAccessDenied", "\u5b58\u50a8\u8fc7\u7a0b\u6ca1\u6709\u8f93\u5165\u8f93\u51fa\u53c2\u6570\u6216\u65e0\u8bbf\u95ee\u6743\u9650"));
            return;
        }
        this.removeTablePropertyChangeHandler();
        try {
            this.table.removeRows();
            if (isCreateFilterParam) {
                this._designUI.getModel().getCommonQuery().setParameters(new ArrayList());
            }
            for (HashMap hashMap : lst) {
                boolean isCreate;
                String column_name4 = CtrlReportUtil.getObjectString(hashMap.get("column_name"));
                String column_type4 = CtrlReportUtil.getObjectString(hashMap.get("column_type"));
                String type_name4 = CtrlReportUtil.getObjectString(hashMap.get("type_name"));
                ProcedureParamData param = new ProcedureParamData();
                param.setName(column_name4);
                param.setBindFilterParamName("");
                param.setIoType(ProcedureIOType.dBIOtoPDIOType((int)this.dbType, (String)column_type4));
                if (this.dbType == 5) {
                    param.setDataType(ProcedureDataType.PGTypeToPDType((String)type_name4));
                } else {
                    param.setDataType(ProcedureDataType.dBTypeToPDType((String)type_name4));
                }
                if (isCreateFilterParam && (isCreate = this.createFilterParam(param))) {
                    param.setBindFilterParamName(column_name4);
                }
                DesignParameter[] dps = ProcedureImportUI.getFilterAllParamArr(this._designUI.getModel());
                IRow newRow = this.table.addRow();
                this.setParam2Row(param, newRow, dps);
                if (this.dbType != 5 || !param.getDataType().equals(ProcedureDataType.CURSOR)) continue;
                this.kDSpinner1.setEnabled(false);
                this.cmbCursor.setEnabled(true);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        finally {
            this.addTablePropertyChangeHandler();
        }
        this.setCursorList(null);
    }

    private boolean createFilterParam(ProcedureParamData proceParam) {
        ArrayList<DesignParameter> filterParamList = this._designUI.getModel().getCommonQuery().getParameters();
        if (null == filterParamList) {
            filterParamList = new ArrayList<DesignParameter>();
            this._designUI.getModel().getCommonQuery().setParameters(filterParamList);
        }
        boolean isExist = false;
        DesignParameter filterParam = this.getDesignParameterObj(proceParam);
        if (null != filterParam && !filterParamList.isEmpty()) {
            for (int i = 0; i < filterParamList.size(); ++i) {
                DesignParameter p = (DesignParameter)filterParamList.get(i);
                if (null == p.getName() || !p.getName().equalsIgnoreCase(proceParam.getName())) continue;
                isExist = true;
                return true;
            }
        }
        if (null != filterParam && !isExist) {
            filterParamList.add(filterParam);
            return true;
        }
        return false;
    }

    private DesignParameter getDesignParameterObj(ProcedureParamData proceParam) {
        if (proceParam.getIoType().equals(ProcedureIOType.OUT)) {
            return null;
        }
        DesignParameter p = new DesignParameter();
        String name = CtrlReportUtil.getObjectString((Object)proceParam.getName());
        p.setName(name);
        Map properties = p.getProperties();
        LanguageCollection lc = new LanguageCollection();
        int z = lc.size();
        for (int i = 0; i < z; ++i) {
            LanguageInfo li = lc.get(i);
            String localString = CtrlReportUtil.bosToEasLang((String)li.getLocale().toString());
            properties.put("alias." + localString, name);
        }
        properties.put("alias", "#1");
        p.setDesignDataType(ProcedureDataType.toDesignDataType((ProcedureDataType)proceParam.getDataType()));
        if (p.getDesignDataType().equals((Object)DesignDataType.DATE) || p.getDesignDataType().equals((Object)DesignDataType.DATETIME) || p.getDesignDataType().equals((Object)DesignDataType.TIME)) {
            p.setInputType(InputType.DATE);
        } else {
            p.setInputType(InputType.INPUT);
        }
        p.setDefaultValue(null);
        p.setDefaultAlias(null);
        p.setAllowNull(true);
        p.setInputState(InputState.ALL);
        p.setDesc(null);
        return p;
    }

    private boolean isExistParam(String name) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String cellName = CtrlReportUtil.getObjectString((Object)this.table.getRow(i).getCell(0).getValue());
            if (!cellName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void setInParamDataType(ProcedureParamData param, boolean isAllowMultipleSelected, ProcedureDataType dataType) {
        if (isAllowMultipleSelected) {
            param.setDataType(ProcedureDataType.STRING);
        } else {
            param.setDataType(dataType);
        }
    }

    private void setParam2Row(ProcedureParamData ppd, IRow row, DesignParameter[] dps) {
        ICell cell = row.getCell(1);
        ICell cellDefault = row.getCell(4);
        if (ppd.getIoType().equals(ProcedureIOType.OUT)) {
            this.table.getColumn(1).setEditor(null);
            cell.getStyleAttributes().setLocked(true);
            cell.setValue((Object)QingRptLauncherMessages.getMLS("noNeedToBindOutputParameter", "\u8f93\u51fa\u53c2\u6570\u65e0\u9700\u7ed1\u5b9a"));
            cell.getStyleAttributes().setFontColor(Color.lightGray);
            this.table.getColumn(4).setEditor(null);
            cellDefault.getStyleAttributes().setLocked(true);
            cellDefault.setValue((Object)QingRptLauncherMessages.getMLS("noNeedToSetOutputParameter", "\u8f93\u51fa\u53c2\u6570\u65e0\u9700\u8bbe\u7f6e"));
            cellDefault.getStyleAttributes().setFontColor(Color.lightGray);
        } else {
            Object bindFilterParamObj = this.getBindFilterParam(ppd.getBindFilterParamName(), dps);
            cell.setValue(bindFilterParamObj);
            cellDefault.setValue((Object)ppd.getDefaultValue());
        }
        row.getCell(0).setValue((Object)ppd.getName());
        row.getCell(2).setValue((Object)ppd.getIoType());
        row.getCell(3).setValue((Object)ppd.getDataType());
        row.setUserObject((Object)ppd);
        if (ppd.getIoType().equals(ProcedureIOType.INPUT)) {
            this.setCellDefaultValue(row, this.dataTypeOld);
        }
    }

    private ProcedureParamData setParameterFromRow(IRow row) {
        ProcedureParamData p = (ProcedureParamData)row.getUserObject();
        if (row.getCell(0).getValue() != null) {
            p.setName(row.getCell(0).getValue().toString());
        } else {
            p.setName(null);
        }
        if (row.getCell(1).getValue() != null) {
            Object obj = row.getCell(1).getValue();
            if (obj instanceof DesignParameter) {
                p.setBindFilterParamName(((DesignParameter)obj).getName());
            } else if (obj instanceof String) {
                p.setBindFilterParamName((String)obj);
            }
        } else {
            p.setBindFilterParamName(null);
        }
        if (row.getCell(2).getValue() != null) {
            p.setIoType((ProcedureIOType)row.getCell(2).getValue());
        }
        if (row.getCell(3).getValue() != null) {
            p.setDataType((ProcedureDataType)row.getCell(3).getValue());
        }
        if (row.getCell(4).getValue() != null) {
            p.setDefaultValue(row.getCell(4).getValue().toString());
        } else {
            p.setDefaultValue(null);
        }
        return p;
    }

    public ProcedureModel getProcedureModel() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            paramList.add(this.table.getRow(i).getUserObject());
        }
        ProcedureModel pm = new ProcedureModel();
        pm.setName(this.txtProcedureName.getText().trim());
        pm.setDbType(this.dbType);
        pm.setResultNumber(this.kDSpinner1.getIntegerVlaue().intValue());
        Object obj = this.cmbCursor.getSelectedItem();
        if (null != obj) {
            pm.setResultCursor(((DefObj)obj).getName());
        }
        pm.setParamList(paramList);
        return pm;
    }

    private Object getBindFilterParam(String bindParamName, DesignParameter[] dps) {
        if (null != dps) {
            for (int i = 0; i < dps.length; ++i) {
                DesignParameter p = dps[i];
                String currentParamName = p.getName();
                if (!bindParamName.equalsIgnoreCase(currentParamName)) continue;
                return p;
            }
        }
        return bindParamName;
    }

    public void setParameters(ProcedureModel pm) {
        if (pm == null) {
            return;
        }
        this.removeTablePropertyChangeHandler();
        this.txtProcedureName.setText(pm.getName());
        this.setDBTypeName();
        this.kDSpinner1.setValue((Object)new Integer(pm.getResultNumber()));
        ArrayList paramList = pm.getParamList();
        if (paramList != null && !paramList.isEmpty()) {
            int size = paramList.size();
            this.table.removeRows();
            this.table.addRows(size);
            DesignParameter[] dps = ProcedureImportUI.getFilterAllParamArr(this._designUI.getModel());
            for (int i = 0; i < size; ++i) {
                IRow row = this.table.getRow(i);
                ProcedureParamData pmd = (ProcedureParamData)paramList.get(i);
                this.setParam2Row(pmd, row, dps);
                if (this.dbType != 5 || !pmd.getIoType().equals(ProcedureIOType.OUT)) continue;
                this.kDSpinner1.setEnabled(false);
                this.cmbCursor.setEnabled(true);
            }
        }
        this.setCursorList(pm.getResultCursor());
        this.addTablePropertyChangeHandler();
    }

    private void setHelpMessage() {
        this.areaHelp.setText("");
        this.areaHelp.append(QingRptLauncherMessages.getMLS("inputOutputParamOrderNote", "1\u3001\u754c\u9762\u4e2d\u8bbe\u7f6e\u7684\u5b58\u50a8\u8fc7\u7a0b\u7684\u8f93\u5165\u8f93\u51fa\u53c2\u6570\uff0c\u987a\u5e8f\u5fc5\u987b\u548c\u5b58\u50a8\u8fc7\u7a0b\u5b9a\u4e49\u7684\u53c2\u6570\u987a\u5e8f\u4e00\u81f4\uff1b") + "\r\n" + QingRptLauncherMessages.getMLS("inputParamMultiSelectNote", "2\u3001\u5982\u679c\u8f93\u5165\u53c2\u6570\u5141\u8bb8\u591a\u9009\uff0c\u5219\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u5b57\u7b26\u4e32\uff0c\u7cfb\u7edf\u75280xx1xx\u8fdb\u884c\u7ec4\u5408\uff0c\u4f8b\u5982\u4f20\u5165\u53c2\u6570number\u5728\u8fc7\u6ee4\u754c\u9762\u4e2d\u9009\u62e9\u4e86aaa\u3001bbb\uff0c\u5219\u4f20\u5165\u53c2\u6570\u4e3aaaa0xx1xxbbb\uff0c\u7528\u6237\u9700\u8981\u5728\u5b58\u50a8\u8fc7\u7a0b\u4e2d\u5206\u89e3\uff1b") + "\r\n" + QingRptLauncherMessages.getMLS("parameterMustHaveDefaultValueNote", "3\u3001\u53c2\u6570\u4e3a\u7a7a\u65f6\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u7684\u56fa\u5b9a\u503c\uff0c\u5426\u5219\u8f6c\u578b\u51fa\u73b0\u9519\u8bef\uff0c\u5982\u7a7a\u8f6c\u4e3a\u6574\u578b\uff1b") + "\r\n" + QingRptLauncherMessages.getMLS("outputParamNotResultSetNote", "4\u3001\u5982\u679c\u8f93\u51fa\u53c2\u6570\u4e0d\u662f\u7ed3\u679c\u96c6\uff0c\u5982\u6709\u8f93\u51fa\u53c2\u6570sumCount\uff0c \u5728\u62a5\u8868\u6a21\u677f\u4e2d\u53ef\u901a\u8fc7=@sumCount\u53d6\u503c\uff1b") + "\r\n" + QingRptLauncherMessages.getMLS("canOnlySelectOneResultSetNote", "5\u3001\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u7ed3\u679c\u96c6\u4f5c\u4e3a\u8f93\u51fa\u5b57\u6bb5\uff1b"));
    }

    private void setDBTypeName() {
        try {
            String[] arr = CtrlDesignDataExecutor.getDBType((Object)((Object)this._designUI.getContext()), (IQuery)this._designUI.getModel().getQuery());
            this.dbType = Integer.parseInt(arr[0]);
            this.txtDBType.setText(arr[1]);
            if (this.dbType == 1 || this.dbType == 3 || this.dbType == 5) {
                this.kDSpinner1.setEnabled(true);
                this.cmbCursor.setEnabled(false);
            } else if (this.dbType == 2) {
                this.kDSpinner1.setEnabled(false);
                this.cmbCursor.setEnabled(true);
            } else {
                this.kDSpinner1.setEnabled(false);
                this.cmbCursor.setEnabled(false);
            }
        }
        catch (CtrlReportException e) {
            logger.debug((Object)e);
        }
    }

    private void removeTablePropertyChangeHandler() {
        if (this.tablePropertyChangeHandler == null) {
            this.tablePropertyChangeHandler = new TablePropertyChangeHandler();
        }
        this.table.removeKDTPropertyChangeListener((KDTPropertyChangeListener)this.tablePropertyChangeHandler);
    }

    private void addTablePropertyChangeHandler() {
        if (this.tablePropertyChangeHandler == null) {
            this.tablePropertyChangeHandler = new TablePropertyChangeHandler();
        }
        this.table.addKDTPropertyChangeListener((KDTPropertyChangeListener)this.tablePropertyChangeHandler);
    }

    private class TablePropertyChangeHandler
    implements KDTPropertyChangeListener {
        private TablePropertyChangeHandler() {
        }

        public void propertyChange(KDTPropertyChangeEvent e) {
            if (e.getColIndex() == 0) {
                if (e.getNewValue() != null) {
                    boolean flag = DesignParamUI.isNameRepeat(ProcedureUI.this.table, 0, e.getRowIndex(), e.getNewValue().toString(), CtrlReportUtil.getObjectString((Object)e.getOldValue()));
                    if (flag) {
                        return;
                    }
                } else {
                    MessageUtil.showInfo("parameterNameCannotBeEmpty", true, QingRptLauncherMessages.getMLS("parameterNameCannotBeEmpty", "\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                    return;
                }
            }
            for (int i = 0; i < ProcedureUI.this.table.getRowCount(); ++i) {
                IRow row = ProcedureUI.this.table.getRow(i);
                ProcedureUI.this.setParameterFromRow(row);
            }
        }
    }
}

