/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.edd.ctrlreport.app.CtrlDBUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.cosmic.ctrl.common.layout.table2.CellOccupied;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.ui.editor.styled.ScriptQLStyledEditor;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class SqlUI
extends BaseTabUIImp {
    private static final Logger logger = Logger.getLogger(SqlUI.class);
    private CtrlDesignQueryModel model = null;
    private DesignUI _designUI;
    private ContentPane contentPane;

    public SqlUI(DesignUI designUI) {
        this._designUI = designUI;
        this.model = this._designUI.getModel();
        this.contentPane = new ContentPane();
    }

    public void refreshFromModel(boolean isRefreshFromModel) {
        this.setRefreshFromModel(isRefreshFromModel);
    }

    @Override
    public KDPanel getPanel() {
        return this.contentPane;
    }

    @Override
    public void syncUi2Model() {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        ksqlQuery.setRegular(false);
        ksqlQuery.setContent(this.contentPane.getContent());
    }

    @Override
    public void syncModel2Ui() {
        if (this._designUI.isNoFoundQuery()) {
            this.contentPane.showValue(this.model.getQuery());
            return;
        }
        try {
            this.updateSQL();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MessageUtil.showDetailAndOK(null, QingRptLauncherMessages.getMLS("failParseMetadata", "\u89e3\u6790\u5143\u6570\u636e\u9519\u8bef") + "\r\n" + e.getMessage(), (Exception)((Object)e));
            return;
        }
        this.contentPane.showValue(this.model.getQuery());
    }

    private void updateSQL() throws BOSException {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        if (ksqlQuery.isRegular()) {
            String sql = CtrlDesignQueryModel.makeSQL((CtrlDesignQueryModel)this.model);
            this.model.getQuery().setContent(sql);
        }
    }

    static class ContentPane
    extends KDPanel {
        private static final long serialVersionUID = -9018141010951919050L;
        private ScriptQLStyledEditor editor;
        private KDRadioButton radioSQL;
        private KDRadioButton radioKSQL;
        private boolean isSuperQuery = false;

        public ContentPane() {
            this.init();
            this.installListener();
        }

        private void init() {
            this.setOpaque(false);
            this.radioKSQL = new KDRadioButton("KSQL");
            this.radioKSQL.setSelected(true);
            this.radioSQL = new KDRadioButton("SQL");
            this.editor = new ScriptQLStyledEditor();
            KDScrollPane scpEditor = new KDScrollPane();
            scpEditor.setBorder(this.editor.getBorder());
            this.editor.setBorder(null);
            scpEditor.getViewport().add((Component)this.editor);
            TableLayout2 ly = new TableLayout2(2, 3);
            ly.setFixedHeight(0, 20);
            ly.setRowSpacing(0, 3);
            ly.setRatableHeight(1, 1);
            ly.setRatableWidth(0, 40);
            ly.setRatableWidth(1, 320);
            ly.setFixedWidth(2, 100);
            ly.setColsSpacing(TableLayout2.ALL, 4);
            this.setLayout((LayoutManager)ly);
            this.add((Component)this.radioKSQL, new CellOccupied(0, 0));
            this.add((Component)this.radioSQL, new CellOccupied(0, 1));
            this.add((Component)scpEditor, new CellOccupied(1, 0, 1, 2));
        }

        private void installListener() {
            this.radioKSQL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    radioKSQL.setSelected(true);
                    radioSQL.setSelected(false);
                    this.removeDialect();
                }
            });
            this.radioSQL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    radioSQL.setSelected(true);
                    radioKSQL.setSelected(false);
                    this.addDialect();
                }
            });
        }

        private void setContent(String str) {
            this.editor.setText(str);
            this.editor.setCaretPosition(0);
        }

        private String getContent() {
            return this.editor.getText();
        }

        public void showValue(IQuery query) {
            String queryContent = query.getContent();
            this.setContent(queryContent);
            this.remove((Component)this.radioKSQL);
            this.remove((Component)this.radioSQL);
            ((TableLayout2)this.getLayout()).setFixedHeight(0, 20);
            if (CtrlDBUtil.isSuperQuerySource((String)((CtrlDesignKsqlQuery)query).getOutDB())) {
                ((TableLayout2)this.getLayout()).setFixedHeight(0, 0);
                this.isSuperQuery = true;
                return;
            }
            this.add((Component)this.radioKSQL, new CellOccupied(0, 0));
            this.add((Component)this.radioSQL, new CellOccupied(0, 1));
            if (queryContent != null && queryContent.toLowerCase().indexOf("/*dialect*/") > -1) {
                this.radioKSQL.setSelected(false);
                this.radioSQL.setSelected(true);
            } else {
                this.radioKSQL.setSelected(true);
                this.radioSQL.setSelected(false);
            }
        }

        public boolean isKSQL() {
            return this.radioKSQL.isSelected();
        }

        private void addDialect() {
            boolean hasDialect;
            String sql = this.getContent();
            int selectIndex = sql.toUpperCase().indexOf("SELECT");
            boolean bl = hasDialect = sql.toLowerCase().indexOf("/*dialect*/") != -1;
            if (selectIndex >= 0 && !hasDialect) {
                String before = sql.substring(0, selectIndex);
                String after = sql.substring(selectIndex);
                sql = before + "/*dialect*/\r\n" + after;
                if (this.isSuperQuery) {
                    sql = before + after;
                }
                this.setContent(sql);
            }
        }

        private void removeDialect() {
            String sql = this.getContent();
            int dialectIndex = sql.toLowerCase().indexOf("/*dialect*/");
            if (dialectIndex > -1) {
                String suffix;
                String prefix = sql.substring(0, dialectIndex);
                if (prefix != null && prefix.startsWith("\r\n")) {
                    prefix = prefix.replaceFirst("\r\n", "");
                }
                if ((suffix = sql.substring(dialectIndex + 11)) != null && suffix.startsWith("\r\n")) {
                    suffix = suffix.substring(2);
                }
                sql = prefix + suffix;
            }
            this.setContent(sql);
        }
    }
}

