/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.pd;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.datawizard.edd.ctrlreport.IPopupSelector;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroVO;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValueType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.pd.CheckBoxGroupConstantValueSetterUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.pd.F7ConstantValueSetterUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.pd.IConstantValueSetterUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.pd.InputConstantValueSetterUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.pd.ListConstantValueSetterUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.InnerParam;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.InnerParamUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.cosmic.ctrl.common.macro.MacroFormatUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultValueSelectorUI
extends KDPanel
implements IPopupSelector {
    public static final String FIRST_DATA_MACRO = "#@$firstData$@#";
    private static final long serialVersionUID = 1L;
    private IConstantValueSetterUI setter;
    private DesignParameter dp;
    private String isolateTag;
    private boolean isCanceled = true;
    private boolean isAllowMulti = false;
    private IInputCtrl ctrl;
    private List<DesignParameter> parameters;
    private KDButtonGroup group;
    private KDTreeView treeView;
    private KDRadioButton constRadio;
    private KDRadioButton sysRadio;
    private KDRadioButton firstRadio;
    private KDButton confirm;
    private KDButton cancel;
    private KDPanel contentPanel;
    private KDPanel southPanel;
    private KDPanel controlPanel;
    private JComponent constUI;
    private DefaultKingdeeTreeNode sysVarGroup;
    private DefaultKingdeeTreeNode macroGroup;
    private Context context;

    public DefaultValueSelectorUI(Context context, DesignParameter dp, String isolateTag, List<DesignParameter> parameters) {
        this.context = context;
        this.dp = dp;
        this.isolateTag = isolateTag;
        this.parameters = parameters;
        this.ctrl = dp.getInputCtrl();
        this.isAllowMulti = this.ctrl != null ? this.ctrl.isAllowMultipleSelected() : false;
        this.initSetter();
    }

    private void initSetter() {
        InputType inputType = this.dp.getInputType();
        this.setter = inputType.equals((Object)InputType.LIST) ? new ListConstantValueSetterUI(this.context, this.parameters) : (inputType.equals((Object)InputType.F7LIST) ? new F7ConstantValueSetterUI(this.context, this.parameters) : (inputType.equals((Object)InputType.CHECKBOX) ? new CheckBoxGroupConstantValueSetterUI(this.context, this.parameters) : new InputConstantValueSetterUI()));
    }

    @Override
    public Component getComponentSelector() {
        return this;
    }

    @Override
    public Object getData() {
        DefObj result = null;
        if (this.group.isSelected(this.constRadio.getModel())) {
            result = this.setter.getData();
        } else if (this.group.isSelected(this.sysRadio.getModel())) {
            if (this.isAllowMulti) {
                ArrayList<DefObj> selections = new ArrayList<DefObj>();
                if (this.sysVarGroup.isChecked()) {
                    this.addSelection(this.sysVarGroup.children(), selections);
                }
                if (this.macroGroup.isChecked()) {
                    this.addSelection(this.macroGroup.children(), selections);
                }
                result = selections.toArray();
            } else {
                KDTree tree = this.treeView.getTree();
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    result = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
                }
                if (!(result instanceof DefObj)) {
                    result = null;
                }
            }
        } else if (this.group.isSelected(this.firstRadio.getModel())) {
            DefObj obj = new DefObj();
            obj.setName(FIRST_DATA_MACRO);
            obj.setAlias(QingRptLauncherMessages.getMLS("firstData", "\u7b2c\u4e00\u6761\u6570\u636e"));
            result = obj;
        } else {
            throw new RuntimeException("unknown default value type");
        }
        this.refreshDefaultValue(result);
        return result;
    }

    private void refreshDefaultValue(Object result) {
        if (result instanceof DefObj) {
            this.dp.setDefaultValue(((DefObj)result).getName());
            this.dp.setDefaultAlias(((DefObj)result).getAlias());
        } else if (result instanceof Object[]) {
            String value = "";
            String valueAlias = "";
            int len = ((Object[])result).length;
            for (int i = 0; i < len; ++i) {
                Object defObj = ((Object[])result)[i];
                if (!(defObj instanceof DefObj)) continue;
                value = value + ((DefObj)defObj).getName();
                valueAlias = valueAlias + ((DefObj)defObj).getAlias();
                if (i >= len - 1) continue;
                value = value + "0xx1xx";
                valueAlias = valueAlias + "0xx1xx";
            }
            this.dp.setDefaultValue(value);
            this.dp.setDefaultAlias(valueAlias);
        }
    }

    private void addSelection(Enumeration<?> e, ArrayList<DefObj> selections) {
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.nextElement();
            if (!node.isChecked()) continue;
            this.addSelection(node.children(), selections);
            Object uo = node.getUserObject();
            if (!(uo instanceof DefObj)) continue;
            selections.add((DefObj)node.getUserObject());
        }
    }

    @Override
    public int getHeightSelector() {
        return this.getPreferredSize().height;
    }

    @Override
    public int getWidthSelector() {
        return this.getPreferredSize().width;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void onLoadSelector() throws Exception {
        KDTree tree = this.treeView.getTree();
        tree.setShowCheckBox(this.isAllowMulti);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
        this.sysVarGroup = new DefaultKingdeeTreeNode((Object)QingRptLauncherMessages.getMLS("sysVariable", "\u7cfb\u7edf\u53d8\u91cf"));
        this.macroGroup = new DefaultKingdeeTreeNode((Object)QingRptLauncherMessages.getMLS("macroVariable", "\u5b8f\u53d8\u91cf"));
        for (InnerParam param : InnerParamUtil.getInnerParams((Object)((Object)this.context))) {
            DefObj def = new DefObj();
            def.setName("@" + param.getId());
            def.setAlias(param.getAlias().replaceAll("'", ""));
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)def);
            this.sysVarGroup.add((MutableTreeNode)node);
        }
        DefaultKingdeeTreeNode sqlSingleMacroGroup = new DefaultKingdeeTreeNode((Object)QingRptLauncherMessages.getMLS("singleValueMacro", "\u5355\u503c\u5b8f"));
        DefaultKingdeeTreeNode sqlMutipleMacroGroup = new DefaultKingdeeTreeNode((Object)QingRptLauncherMessages.getMLS("multiValueMacro", "\u591a\u503c\u5b8f"));
        for (ExtMacroVO macro : MacroUtil.getAllMacros((Object)((Object)this.context))) {
            DefObj def = new DefObj();
            def.setName("$" + macro.getUid());
            def.setAlias(macro.getName());
            def.setDesc(macro.getDesc());
            def.setProperty(macro.getUid(), (Object)macro);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)def);
            if (ExtMacroValueType.SINGLE == macro.getValueType()) {
                sqlSingleMacroGroup.add((MutableTreeNode)node);
                continue;
            }
            sqlMutipleMacroGroup.add((MutableTreeNode)node);
        }
        this.macroGroup.add((MutableTreeNode)sqlSingleMacroGroup);
        this.macroGroup.add((MutableTreeNode)sqlMutipleMacroGroup);
        root.add((MutableTreeNode)this.sysVarGroup);
        root.add((MutableTreeNode)this.macroGroup);
        tree.setModel((TreeModel)treeModel);
        tree.expandOnLevel(100);
    }

    @Override
    public void initLayoutSelector() {
        this.setLayout(new BorderLayout());
        this.contentPanel = new KDPanel((LayoutManager)new KDLayout());
        this.contentPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 740, 580));
        this.group = new KDButtonGroup();
        this.setPreferredSize(new Dimension(560, 510));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof KDRadioButton) {
                    if (DefaultValueSelectorUI.this.firstRadio != null && DefaultValueSelectorUI.this.firstRadio.isSelected()) {
                        DefaultValueSelectorUI.this.setter.setEnabled(false);
                        DefaultValueSelectorUI.this.treeView.getTree().clearSelection();
                    } else if (DefaultValueSelectorUI.this.constRadio.isSelected()) {
                        DefaultValueSelectorUI.this.setter.setEnabled(true);
                        DefaultValueSelectorUI.this.treeView.getTree().clearSelection();
                    } else if (DefaultValueSelectorUI.this.sysRadio.isSelected()) {
                        DefaultValueSelectorUI.this.setter.setEnabled(false);
                    }
                } else if (source instanceof KDButton) {
                    if (source == DefaultValueSelectorUI.this.confirm) {
                        DefaultValueSelectorUI.this.isCanceled = false;
                        DefaultValueSelectorUI.this.close();
                    } else if (source == DefaultValueSelectorUI.this.cancel) {
                        DefaultValueSelectorUI.this.isCanceled = true;
                        DefaultValueSelectorUI.this.close();
                    }
                }
            }
        };
        int top = 10;
        if (this.ctrl != null && InputType.LIST.equals((Object)this.ctrl.getInputType())) {
            this.firstRadio = new KDRadioButton(QingRptLauncherMessages.getMLS("firstData", "\u7b2c\u4e00\u6761\u6570\u636e"));
            this.firstRadio.addActionListener(listener);
            this.group.add((AbstractButton)this.firstRadio);
            this.firstRadio.putClientProperty((Object)"KDLayoutConstraints", (Object)new KDLayout.Constraints(4, new Rectangle(10, top, 100, 19)));
            top += 29;
            this.contentPanel.add((Component)this.firstRadio);
        }
        this.constRadio = new KDRadioButton(QingRptLauncherMessages.getMLS("constant", "\u5e38\u91cf"));
        this.constRadio.addActionListener(listener);
        this.group.add((AbstractButton)this.constRadio);
        this.constRadio.putClientProperty((Object)"KDLayoutConstraints", (Object)new KDLayout.Constraints(4, new Rectangle(10, top, 100, 19)));
        this.contentPanel.add((Component)this.constRadio);
        this.constUI = this.setter.getUI();
        this.constUI.putClientProperty("KDLayoutConstraints", new KDLayout.Constraints(12, new Rectangle(29, top += 29, 700, this.constUI.getPreferredSize().height)));
        this.contentPanel.add((Component)this.constUI);
        this.sysRadio = new KDRadioButton(QingRptLauncherMessages.getMLS("variable", "\u53d8\u91cf"));
        this.sysRadio.addActionListener(listener);
        this.group.add((AbstractButton)this.sysRadio);
        this.sysRadio.putClientProperty((Object)"KDLayoutConstraints", (Object)new KDLayout.Constraints(4, new Rectangle(10, top += this.constUI.getPreferredSize().height + 10, 100, 19)));
        this.contentPanel.add((Component)this.sysRadio);
        top += 29;
        this.group.setSelected(this.constRadio.getModel(), true);
        KDTree tree = new KDTree();
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() == null) {
                    return;
                }
                DefaultValueSelectorUI.this.sysRadio.setSelected(true);
                DefaultValueSelectorUI.this.setter.setEnabled(false);
            }
        });
        this.treeView = new KDTreeView(tree);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setSyncChecked(true);
        this.treeView.setShowControlPanel(false);
        int treeViewHeight = 475;
        if (this.setter instanceof ListConstantValueSetterUI) {
            treeViewHeight = 445;
        }
        this.treeView.putClientProperty((Object)"KDLayoutConstraints", (Object)new KDLayout.Constraints(15, new Rectangle(29, top, 700, treeViewHeight)));
        this.contentPanel.add((Component)this.treeView);
        this.add((Component)this.contentPanel);
        this.southPanel = new KDPanel((LayoutManager)new BorderLayout());
        this.southPanel.add((Component)new KDSeparator());
        this.controlPanel = new KDPanel((LayoutManager)new FlowLayout(2, 6, 12));
        this.confirm = new KDButton(QingRptLauncherMessages.getMLS("confirm", "\u786e\u8ba4"));
        this.confirm.addActionListener(listener);
        this.cancel = new KDButton(QingRptLauncherMessages.getMLS("cancelBtn", "\u53d6\u6d88"));
        this.cancel.addActionListener(listener);
        this.controlPanel.add((Component)this.confirm);
        this.controlPanel.add((Component)this.cancel);
        this.southPanel.add((Component)this.controlPanel, (Object)"South");
        this.add((Component)this.southPanel, "South");
        if (this.ctrl != null && 5 == this.ctrl.getDataBind()) {
            this.sysRadio.setEnabled(false);
            this.treeView.setEnabled(false);
        } else {
            this.sysRadio.setEnabled(true);
            this.treeView.setEnabled(true);
        }
    }

    @Override
    public void showSelector() {
        this.isCanceled = true;
        String defaultValue = this.dp.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (defaultValue.startsWith("@") || MacroFormatUtil.checkMacroUidFormat((String)defaultValue)) {
            this.dp.setDefaultValue(null);
            this.setter.willShow(this.dp, this.isolateTag);
            this.dp.setDefaultValue(defaultValue);
            this.group.setSelected(this.sysRadio.getModel(), true);
            this.sysRadio.doClick();
            if (this.isAllowMulti) {
                String[] items = defaultValue.split("0xx1xx");
                HashSet<String> sysItems = new HashSet<String>();
                HashSet<String> macroItems = new HashSet<String>();
                for (String item : items) {
                    if (item.startsWith("@")) {
                        sysItems.add(item);
                        continue;
                    }
                    if (!MacroFormatUtil.checkMacroUidFormat((String)item)) continue;
                    macroItems.add(item);
                }
                this.selectChildren(this.sysVarGroup.children(), sysItems);
                this.selectChildren(this.macroGroup.children(), macroItems);
            } else {
                KDTree tree = this.treeView.getTree();
                if (defaultValue.startsWith("@")) {
                    this.selectNode(this.sysVarGroup.children(), defaultValue, tree);
                } else if (MacroFormatUtil.checkMacroUidFormat((String)defaultValue)) {
                    this.selectNode(this.macroGroup.children(), defaultValue, tree);
                }
                tree.scrollPathToVisible(tree.getSelectionPath());
            }
        } else if (defaultValue.equals(FIRST_DATA_MACRO)) {
            this.dp.setDefaultValue(null);
            this.setter.willShow(this.dp, this.isolateTag);
            this.dp.setDefaultValue(defaultValue);
            this.group.setSelected(this.firstRadio.getModel(), true);
            this.setter.setEnabled(false);
            this.treeView.getTree().clearSelection();
        } else {
            this.setter.willShow(this.dp, this.isolateTag);
            this.group.setSelected(this.constRadio.getModel(), true);
            this.setter.setEnabled(true);
            this.treeView.getTree().clearSelection();
        }
    }

    private void selectNode(Enumeration<?> e, String value, KDTree tree) {
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.nextElement();
            this.selectNode(node.children(), value, tree);
            Object uo = node.getUserObject();
            if (!(uo instanceof DefObj) || !((DefObj)node.getUserObject()).getName().equals(value)) continue;
            tree.setSelectionNode(node);
        }
    }

    private void selectChildren(Enumeration<?> e, HashSet<String> values) {
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.nextElement();
            this.selectChildren(node.children(), values);
            Object uo = node.getUserObject();
            if (!(uo instanceof DefObj) || !values.contains(((DefObj)node.getUserObject()).getName())) continue;
            node.setChecked(true);
            node.syncChecked();
        }
    }

    private void close() {
        Window parent = SwingUtilities.getWindowAncestor(this.getComponentSelector());
        parent.setVisible(false);
        parent.dispose();
    }

    @Override
    public KDToolBar getToolBarSelector() {
        return null;
    }

    public void setParamMap(HashMap paramMap) {
    }

    public void config4TabbedPane() {
        this.remove((Component)this.southPanel);
    }

    public DesignParameter getDesignParameter() {
        return this.dp;
    }

    public void getDesignParameter(DesignParameter p) {
        this.dp = p;
    }
}

