/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.tabkid;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.common.tabframework.AbstractTabkidWrapper;
import com.kingdee.bos.datawizard.common.tabframework.ITabkidChangeListener;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.OutDBUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.model.EDDContextBetweenTabkids;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;

public class OutDBUITabkidWrapper
extends AbstractTabkidWrapper {
    private String title = QingRptLauncherMessages.getMLS("dataSource1", "\u6570\u636e\u6e90");
    private OutDBUI outDBUI;
    private String originOutDB;

    public OutDBUITabkidWrapper(EDDContextBetweenTabkids ctx) {
        super(ctx);
    }

    @Override
    protected String getTitle() {
        return this.title;
    }

    @Override
    protected void initUI(KDPanel ui) throws Exception {
        ui.setCustomInsets(new Insets(8, 8, 8, 8));
        ui.setLayout((LayoutManager)new BorderLayout());
        DesignUI designUI = ((EDDContextBetweenTabkids)this.getContext()).getDesignUI();
        this.outDBUI = new OutDBUI(designUI.getContext(), designUI.getModel());
        ui.add((Component)((Object)this.outDBUI));
    }

    @Override
    protected void initTabkidChangeListener() {
        this.addListener("OutputFieldsUIChanged", new ITabkidChangeListener(){

            @Override
            public void tabkidChange(String eventKey) {
                if (OutDBUITabkidWrapper.this.isOutDBChanged()) {
                    OutDBUITabkidWrapper.this.fireEvent("OutDBUIChanged");
                }
            }
        });
        DesignUI designUI = ((EDDContextBetweenTabkids)this.getContext()).getDesignUI();
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)designUI.getModel().getQuery();
        this.originOutDB = ksqlQuery.getOutDB();
    }

    @Override
    protected void intoThisTabkid() {
        DesignUI designUI = ((EDDContextBetweenTabkids)this.getContext()).getDesignUI();
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)designUI.getModel().getQuery();
        this.originOutDB = ksqlQuery.getOutDB();
    }

    @Override
    protected void outThisTabkid() {
        if (this.isOutDBChanged()) {
            this.fireEvent("OutDBUIChanged");
        }
    }

    @Override
    protected String checkPermission() {
        return this.outDBUI.checkPermission();
    }

    @Override
    protected String verify() {
        return this.outDBUI.isOutDBNameError();
    }

    private boolean isOutDBChanged() {
        DesignUI designUI = ((EDDContextBetweenTabkids)this.getContext()).getDesignUI();
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)designUI.getModel().getQuery();
        String currentOutDB = ksqlQuery.getOutDB();
        return !StringUtil.equals((String)this.originOutDB, (String)currentOutDB);
    }
}

