/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public abstract class MultiOrgsClientCacheImplUtil {
    private static final Logger logger = Logger.getLogger(MultiOrgsClientCacheImplUtil.class);
    private static final String FILE_SEPARATOR = File.separator;

    public static String getBaseCacheDir() {
        String appserver = UIConfig.getUrl().toLowerCase();
        if (appserver.startsWith("tcp:")) {
            appserver = appserver.replaceAll("tcp:", "http:");
        }
        String srvUrl = "localhost";
        try {
            srvUrl = new URL(appserver).getHost();
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
            srvUrl = "localhost";
        }
        String dcNumber = SysContext.getSysContext().getDCNumber().trim();
        String baseCacheDir = new StringBuffer().append(System.getProperty("easclient.root")).append(FILE_SEPARATOR).append("cache").append(FILE_SEPARATOR).append(srvUrl).append(FILE_SEPARATOR).append(dcNumber).toString();
        return baseCacheDir;
    }

    public static String getUserBaseCacheDir() {
        String baseCacheDir = MultiOrgsClientCacheImplUtil.getBaseCacheDir();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String userBaseCacheDir = new StringBuffer().append(baseCacheDir).append(FILE_SEPARATOR).append(MultiOrgsClientCacheImplUtil.getPathStrFromObjID(userID)).toString();
        return userBaseCacheDir;
    }

    public static String getOrgBaseCacheDir() {
        String userBaseCacheDir = MultiOrgsClientCacheImplUtil.getUserBaseCacheDir();
        String orgBaseCacheDir = new StringBuffer().append(userBaseCacheDir).append(FILE_SEPARATOR).append("orgcache").toString();
        return orgBaseCacheDir;
    }

    public static String getOrgCacheDir(String ouId) {
        String orgBaseCachedDir = MultiOrgsClientCacheImplUtil.getOrgBaseCacheDir();
        String dirByOuId = MultiOrgsClientCacheImplUtil.getPathStrFromObjID(ouId);
        String orgCacheDir = new StringBuffer().append(orgBaseCachedDir).append(FILE_SEPARATOR).append(dirByOuId).toString();
        return orgCacheDir;
    }

    public static String getOrgCacheFile(String orgCacheDir, OrgType orgType) {
        String orgCacheFile = new StringBuffer().append(orgCacheDir).append(FILE_SEPARATOR).append(orgType.getValue()).append(".dat").toString();
        return orgCacheFile;
    }

    public static String getPathStrFromObjID(String objID) {
        return objID.replace('/', '-').replace('=', '_').replace('+', '$');
    }

    public static boolean isFileObjExistedByPathStr(String path) {
        return new File(path).exists();
    }

    public static void makeDirByPathStr(String path) {
        new File(path).mkdirs();
    }

    public static void dropDirByPathStr(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] subFileNames = file.list();
            int n = subFileNames.length;
            for (int i = 0; i < n; ++i) {
                MultiOrgsClientCacheImplUtil.dropDirByPathStr(path + FILE_SEPARATOR + subFileNames[i]);
            }
        }
        file.delete();
    }
}

