/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOrgBizChecker;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IOtherDealSealUp;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgAlterPageEnum;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgLogTypeEnum;
import com.kingdee.eas.basedata.org.OrgMoveParam;
import com.kingdee.eas.basedata.org.OrgSealUpInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.OrgXMLElement;
import com.kingdee.eas.basedata.org.ToSealUpEnum;
import com.kingdee.eas.basedata.org.app.AbstractNewOUInnerFacadeControllerBean;
import com.kingdee.eas.basedata.org.app.ext.ExtHelper;
import com.kingdee.eas.basedata.org.app.ext.IOrgExt;
import com.kingdee.eas.basedata.org.app.ext.IOrgSealUp4Server;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.app.log.OrgLogServerUtils;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgConfigHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.JDOMException;

public class NewOUInnerFacadeControllerBean
extends AbstractNewOUInnerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)NewOUInnerFacadeControllerBean.class.getName());
    private List orgBosTypeList = new ArrayList();

    @Override
    protected void _SubmitOUPart(Context ctx, IObjectValue orgUnitInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _SubmitUnitDelegate(Context ctx, IObjectCollection deteInfos) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteUnion(Context ctx, IObjectValue structInfo) throws BOSException, EASBizException {
        OrgStructureInfo sInfo = (OrgStructureInfo)structInfo;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        iStruct.delete((IObjectPK)new ObjectUuidPK(sInfo.getId()));
        iFull.delete((IObjectPK)new ObjectUuidPK(sInfo.getUnit().getId()));
    }

    @Override
    protected void _addNewUnionInput(Context ctx, IObjectCollection structCol) throws BOSException, EASBizException {
        OrgStructureCollection orgStructCol = (OrgStructureCollection)structCol;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        for (int i = 0; i < orgStructCol.size(); ++i) {
            this._checkHasInput(ctx, orgStructCol.get(i));
            iStruct.addnew(orgStructCol.get(i));
        }
        if (orgStructCol != null && orgStructCol.size() > 0) {
            String parentStructureID = "";
            if (orgStructCol.get(0) != null && orgStructCol.get(0).getParent() != null && orgStructCol.get(0).getParent().getId() != null) {
                parentStructureID = orgStructCol.get(0).getParent().getId().toString();
            }
            String updateParetnStructureIsLeaf = new StringBuffer().append(" update t_org_Structure set FISLEAF = 0 where fid = '").append(orgStructCol.get(0).getParent().getId()).append("' ").toString();
            DbUtil.execute((Context)ctx, (String)updateParetnStructureIsLeaf);
        }
    }

    void _checkHasInput(Context ctx, OrgStructureInfo structInfo) throws EASBizException, BOSException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)structInfo.getTree().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)structInfo.getUnit().getId().toString()));
        filter.setMaskString("#0 and #1");
        if (iStruct.exists(filter)) {
            throw new OUException(OUException.EXIST_RECORD_IN_ORGSTRUCTUE);
        }
    }

    @Override
    protected void _deleteUnionImport(Context ctx, IObjectPK structInfo) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo info = iStruct.getOrgStructureInfo(structInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)info.getTree().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.partUnionGroup.stockControlCompany.id", (Object)info.getUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        if (iStruct.exists(filter)) {
            throw new OUException(OUException.NOT_DELETE_STOCKCONTROL);
        }
        FilterInfo deleteFilter = new FilterInfo();
        deleteFilter.getFilterItems().add(new FilterItemInfo("id", (Object)structInfo.toString(), CompareType.EQUALS));
        iStruct.delete(deleteFilter);
    }

    @Override
    protected void _deleteUnionImport(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo info = null;
        HashSet<String> unitIds = new HashSet<String>();
        HashSet<String> structureIds = new HashSet<String>();
        for (int i = 0; i < arrayPK.length; ++i) {
            info = iStruct.getOrgStructureInfo(arrayPK[i]);
            unitIds.add(info.getUnit().getId().toString());
            structureIds.add(info.getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        if (info != null && info.getTree() != null) {
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)info.getTree().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("unit.partUnionGroup.stockControlCompany.id", unitIds, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1");
            if (iStruct.exists(filter)) {
                throw new OUException(OUException.NOT_DELETE_STOCKCONTROL);
            }
            FilterInfo deleteFilter = new FilterInfo();
            deleteFilter.getFilterItems().add(new FilterItemInfo("id", structureIds, CompareType.INCLUDE));
            iStruct.delete(deleteFilter);
        }
    }

    @Override
    protected Map _getCompanyFromUnionGroup(Context ctx, String treeID, Map unionGroup) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        HashMap groupMap = (HashMap)unionGroup;
        Set groupKeys = groupMap.keySet();
        Iterator it = groupKeys.iterator();
        StringBuffer groupIDs = new StringBuffer();
        if (!it.hasNext()) {
            return ret;
        }
        while (it.hasNext()) {
            String groupID = (String)it.next();
            if (StringUtils.isEmpty((String)groupID)) continue;
            if (groupIDs.length() != 0) {
                groupIDs.append(",");
            }
            groupIDs.append("'").append(groupID).append("'");
        }
        String oql = "Select unit.id Where tree.id = '" + treeID + "' and parent.unit.id in (" + groupIDs.toString() + ") and unit.isUnion = 0 and unit.partFI.isSealUp = 0";
        OrgStructureCollection companyCol = iStruct.getOrgStructureCollection(oql);
        int n = companyCol.size();
        for (int i = 0; i < n; ++i) {
            ret.put(companyCol.get(i).getUnit().getId().toString(), Boolean.FALSE);
        }
        return ret;
    }

    @Override
    protected void _updateCUBDControl(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        CUBDControlCollection ctrlCol = (CUBDControlCollection)col;
        ICUBDControl iCUBD = CUBDControlFactory.getLocalInstance(ctx);
        int n = ctrlCol.size();
        for (int i = 0; i < n; ++i) {
            CUBDControlInfo ctrlInfo = ctrlCol.get(i);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isSuperiorViewable"));
            sic.add(new SelectorItemInfo("isSubordinateAddnewable"));
            sic.add(new SelectorItemInfo("isSubordinateEditable"));
            sic.add(new SelectorItemInfo("isSubordinateDeletable"));
            sic.add(new SelectorItemInfo("isSubordinateUpgradable"));
            sic.add(new SelectorItemInfo("dispatchPattern"));
            sic.add(new SelectorItemInfo("isSubordinateAssign"));
            iCUBD.updatePartial((CoreBaseInfo)ctrlInfo, sic);
        }
    }

    @Override
    protected IObjectCollection _getTypedOrgsInSubCU(Context ctx, String cuID, int orgViewType, String treeID) throws BOSException, EASBizException {
        if (orgViewType != 8) {
            treeID = NewOrgViewHelper.convert2TreeId(OrgViewType.getEnum(orgViewType));
        }
        if (treeID == null || treeID.equals("")) {
            return new FullOrgUnitCollection();
        }
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo rootStruct = iStruct.getOrgStructureInfo("select longNumber where tree.id = '00000000-0000-0000-0000-0000000000014F2827FD' and unit.id = '" + cuID + "'");
        String rootLongNumber = rootStruct.getLongNumber();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.CU.longNumber", (Object)rootLongNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.CU.longNumber", (Object)(rootLongNumber + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 and (#1 or #2)");
        view.setFilter(filter);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(view);
        FullOrgUnitCollection ret = new FullOrgUnitCollection();
        int n = structCol.size();
        for (int i = 0; i < n; ++i) {
            ret.add(structCol.get(i).getUnit());
        }
        return ret;
    }

    @Override
    protected HashMap _getFIPropertiesOfCU(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        IOrgExt iOrgExt = ExtHelper.getOrgExtImpl();
        return iOrgExt.getFIPropertiesOfCU(ctx, cuPK);
    }

    @Override
    protected IObjectCollection _getDelegations(Context ctx, String ouid) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("toUnit.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("typeRelation.toType"));
        viewInfo.getSelector().add(new SelectorItemInfo("typeRelation.fromType"));
        viewInfo.getSelector().add(new SelectorItemInfo("typeRelation.existReverseDelegate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", (Object)ouid, CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        OrgUnitRelationCollection col = iUnitRel.getOrgUnitRelationCollection(viewInfo);
        return col;
    }

    @Override
    protected BizParentAndDelegateInfo _loadSuperiorAndDelegateUnits(Context ctx, IObjectPK unitPK) throws BOSException, EASBizException {
        BizParentAndDelegateInfo pdInfo = new BizParentAndDelegateInfo();
        if (!unitPK.toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            this.loadSuperiorUnits(ctx, unitPK, pdInfo);
        }
        this.loadDelegate(ctx, unitPK, pdInfo);
        return pdInfo;
    }

    private void loadSuperiorUnits(Context ctx, IObjectPK unitPK, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo(unitPK);
        OrgTypeAppCenter.getInstance().loadSuperiorUnits(ctx, unitInfo, pdInfo, true);
    }

    private void loadSuperiorUnits(Context ctx, IObjectPK unitPK, BizParentAndDelegateInfo pdInfo, SelectorItemCollection selector) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo(unitPK);
        OrgTypeAppCenter.getInstance().loadSuperiorUnits(ctx, unitInfo, pdInfo, true);
    }

    private void loadDelegate(Context ctx, IObjectPK unitPK, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRelation = OrgUnitRelationFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("toUnit.*"));
        sic.add(new SelectorItemInfo("typeRelation.toType"));
        sic.add(new SelectorItemInfo("typeRelation.fromType"));
        sic.add(new SelectorItemInfo("typeRelation.existReverseDelegate"));
        this.loadDelegate(ctx, unitPK, pdInfo, sic);
    }

    private void loadDelegate(Context ctx, IObjectPK unitPK, BizParentAndDelegateInfo pdInfo, SelectorItemCollection selector) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRelation = OrgUnitRelationFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (selector != null && !selector.isEmpty()) {
            viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", (Object)unitPK.toString(), CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        OrgUnitRelationCollection col = iUnitRelation.getOrgUnitRelationCollection(viewInfo);
        pdInfo.setDelegateCollection(col);
    }

    @Override
    protected void _startOrg(Context ctx) throws BOSException, EASBizException {
        this.updateIsStartFlagAndDate(ctx, true);
        OrgLogServerUtils.log(ctx, OrgLogTypeEnum.START);
    }

    @Override
    protected void _undoStartOrg(Context ctx) throws BOSException, EASBizException {
        this.updateIsStartFlagAndDate(ctx, false);
        OrgLogServerUtils.log(ctx, OrgLogTypeEnum.UNSTART);
    }

    private void updateIsStartFlagAndDate(Context ctx, boolean isStart) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            Date utilDate = Calendar.getInstance().getTime();
            java.sql.Date sqlDate = new java.sql.Date(utilDate.getTime());
            String effectDate = "{ts'" + sqlDate.toString() + "'}";
            Set allOrgTypeSet = OrgTypeInfoMgr.getInstance().getAllOrgType();
            Iterator it = allOrgTypeSet.iterator();
            String updStartSql = "UPDATE update_table_name SET FIsStart = " + (isStart ? 1 : 0) + " WHERE FID = '" + "00000000-0000-0000-0000-000000000000CCE7AED4" + "'";
            String updEffectSql = "UPDATE update_table_name SET FEffectDate = " + effectDate + ", FLastUpdateTime = " + effectDate;
            ArrayList<BOSObjectType> orgViewBotTypeList = new ArrayList<BOSObjectType>();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof OrgType)) continue;
                OrgType orgType = (OrgType)((Object)obj);
                OrgTypeSelfInfo orgTypeInfo = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo();
                String updateStartSql = updStartSql.replace("update_table_name", orgTypeInfo.getViewTableName());
                stmt.addBatch(updateStartSql);
                if (isStart) {
                    String updateEffectSql = updEffectSql.replace("update_table_name", orgTypeInfo.getViewTableName());
                    stmt.addBatch(updateEffectSql);
                }
                BOSObjectType bsoObjectType = orgTypeInfo.getOrgViewBosType();
                orgViewBotTypeList.add(bsoObjectType);
            }
            stmt.executeBatch();
            for (int i = 0; i < orgViewBotTypeList.size(); ++i) {
                BOSObjectType bosObjectType = (BOSObjectType)orgViewBotTypeList.get(i);
                if (isStart) {
                    ORMValueCacheService.getInstance().discardType(ctx, bosObjectType);
                    continue;
                }
                ORMValueCacheService.getInstance().remove(ctx, bosObjectType, "00000000-0000-0000-0000-000000000000CCE7AED4");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
                conn = null;
            }
        }
    }

    @Override
    protected void _ouSealUp(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        if (unitInfo.isIsCU()) {
            throw new OUException(OUException.CANT_SEALUP_SELF);
        }
        ORMValueCacheService.getInstance().remove(ctx, unitInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(unitInfo.getId()));
        this.checkBizPropertiesSealedUp(ctx, unitInfo);
        String longNumberOfSubUnits = unitInfo.getLongNumber() + "!%";
        String oqlToFindUnSealedUpSubUnits = "where isOUSealUp = 0 and isUnion = 0 and longNumber like '" + longNumberOfSubUnits + "'";
        if (iFull.exists(oqlToFindUnSealedUpSubUnits)) {
            throw new OUException(OUException.CAN_NOT_SEALUP_FOR_HAS_SUBS);
        }
        this.updateSealUpTagAndDate(ctx, unitID, true, new java.sql.Date(System.currentTimeMillis()));
        this.otherDealOuSealUp(ctx, unitID);
        OrgLogServerUtils.log(ctx, OrgAlterPageEnum.PAGE_BASIC, OrgLogTypeEnum.SEALUP, (IObjectValue)unitInfo);
    }

    @Override
    protected void _ouUnSealUp(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        String parentid = unitInfo.getParent().getId().toString();
        String oqlToFindSealedUpParent = "where isOUSealUp = 1 and isUnion = 0 and id = '" + parentid + "'";
        if (iFull.exists(oqlToFindSealedUpParent)) {
            throw new OUException(OUException.CAN_NOT_UNSEALUP_PARENTHAS_SEALUP);
        }
        this.updateSealUpTagAndDate(ctx, unitID, false, new java.sql.Date(System.currentTimeMillis()));
        this.otherDealOuUnSealUp(ctx, unitID);
        OrgLogServerUtils.log(ctx, OrgAlterPageEnum.PAGE_BASIC, OrgLogTypeEnum.UNSEALUP, (IObjectValue)unitInfo);
    }

    @Override
    protected void _bizSealUp(Context ctx, String unitID, int orgTypeValue) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        this.checkOrgType(unitInfo, orgTypeValue);
        this.checkIsAlreadySealUp(ctx, unitID, orgTypeValue);
        OrgDelegateFacadeFactory.getLocalInstance(ctx).deleteDelegateOnType(unitID, orgTypeValue);
        this.checkIsBizSubordinatesSealedUp(ctx, unitInfo, orgTypeValue);
        if (orgTypeValue == 1) {
            this.checkIsAssistantOrgsSealedUp(ctx, unitInfo);
        }
        OrgType type = OrgType.getEnum(orgTypeValue);
        IOrgBizChecker aChecker = null;
        try {
            List checkers = OrgConfigHelper.getXMLBizClasses("beforeOrgSealUp", null);
            int n = checkers.size();
            for (int i = 0; i < n; ++i) {
                String className = ((OrgXMLElement)checkers.get(i)).getValue();
                if (StringUtils.isEmpty((String)className)) continue;
                aChecker = (IOrgBizChecker)Class.forName(className).newInstance();
                aChecker.checkBizClear(ctx, unitInfo, type);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.updateBizSealUpTag(ctx, unitID, orgTypeValue, 1);
        this.otherDealBizSealUp(ctx, unitID, orgTypeValue);
        OrgLogServerUtils.log(ctx, OrgLogServerUtils.convert(type), OrgLogTypeEnum.SEALUP, (IObjectValue)unitInfo);
    }

    @Override
    protected void _bizUnSealUp(Context ctx, String unitID, int orgType) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        String treeId = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgTypeIntValue(orgType).getOrgTreeID();
        OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select id,parent.unit.*  Where unit.id = '" + unitID + "' and tree.id = '" + treeId + "'");
        if (structInfo != null && structInfo.getParent() != null) {
            FullOrgUnitInfo parentOrgUnitInfo = structInfo.getParent().getUnit();
            HashSet<OrgType> notIncludeOrgTypes = new HashSet<OrgType>();
            Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
            Iterator it = orgTypeCol.iterator();
            while (it.hasNext()) {
                OrgType type = ((OrgTypeInfo)it.next()).getOrgType();
                if (type.getValue() == orgType) continue;
                notIncludeOrgTypes.add(type);
            }
            this.checkBizPropertiesSealedUp(ctx, parentOrgUnitInfo, notIncludeOrgTypes, false);
        }
        try {
            this.beforeUnSealUp(ctx, unitID, orgType, "OrgUnSealUp", "");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.updateBizSealUpTag(ctx, unitID, orgType, 0);
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        OrgType type = OrgType.getEnum(orgType);
        this.otherDealBizUnSealUp(ctx, unitID, orgType);
        OrgLogServerUtils.log(ctx, OrgLogServerUtils.convert(type), OrgLogTypeEnum.UNSEALUP, (IObjectValue)unitInfo);
    }

    private void beforeUnSealUp(Context ctx, String unitID, int orgType, String configitemName, String attributeKey) throws Exception {
        List dealClassNamesList = null;
        OrgXMLElement xmlElement = null;
        String key = null;
        String value = null;
        boolean isThrowException = true;
        String description = "";
        StringBuffer errorMessage = null;
        try {
            dealClassNamesList = OrgConfigHelper.getXMLBizClasses(configitemName, attributeKey);
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < dealClassNamesList.size(); ++i) {
            xmlElement = (OrgXMLElement)dealClassNamesList.get(i);
            key = xmlElement.getKey();
            value = xmlElement.getValue();
            isThrowException = xmlElement.isThrowException();
            description = xmlElement.getDescription();
            errorMessage = new StringBuffer();
            errorMessage.append("--org beforeUnSealUp error--\n").append("key=").append(key).append("\n").append("value=").append(value).append("\n").append("description=").append(description).append("\n");
            if (StringUtils.isEmpty((String)value)) continue;
            try {
                Class<?> dealClass = Class.forName(value);
                IOrgSealUp4Server iOrgSealUp4Server = (IOrgSealUp4Server)dealClass.newInstance();
                iOrgSealUp4Server.beforeUnSealUp(ctx, unitID, orgType);
                continue;
            }
            catch (BOSException e) {
                if (!isThrowException) continue;
                throw new BOSException((Throwable)e);
            }
            catch (EASBizException e) {
                if (!isThrowException) continue;
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    protected void _cuSealUp(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        this.checkCUIsAlreadySealedUp(ctx, unitID);
        this.checkIsSubordinateOUSealedUp(ctx, unitInfo);
        this.checkIsSubordinateCUSealedUp(ctx, unitInfo);
        HashSet<OrgType> cuSet = new HashSet<OrgType>();
        cuSet.add(OrgType.ControlUnit);
        this.checkBizPropertiesSealedUp(ctx, unitInfo, cuSet);
        this.updateSealUpTagAndDate(ctx, unitID, true, new java.sql.Date(System.currentTimeMillis()));
        OrgLogServerUtils.log(ctx, OrgAlterPageEnum.PAGE_BASIC, OrgLogTypeEnum.SEALUP, (IObjectValue)unitInfo);
    }

    @Override
    protected void _cuUnSealUp(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        this.checkIsParentCUSealedUp(ctx, unitInfo);
        this.updateSealUpTagAndDate(ctx, unitID, false, new java.sql.Date(System.currentTimeMillis()));
        OrgLogServerUtils.log(ctx, OrgAlterPageEnum.PAGE_BASIC, OrgLogTypeEnum.UNSEALUP, (IObjectValue)unitInfo);
    }

    private void checkOrgType(FullOrgUnitInfo unitInfo, int orgTypeValue) throws EASBizException {
        Collection orgCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgCol) {
            if (OrgType.NONE == orgTypeInfo.getOrgType() || OrgType.getEnum(orgTypeValue) != orgTypeInfo.getOrgType()) continue;
            if (OrgTypeHelper.isOrgType(unitInfo.getOrgTypeStr(), orgTypeInfo.getOrgType())) break;
            Object[] params = new String[]{orgTypeInfo.getOrgType().getAlias()};
            throw new OUException(OUException.CANT_SEALUP_ORGTYPE_NOTMATCH, params);
        }
    }

    private void checkIsAlreadySealUp(Context ctx, String unitID, int orgTypeValue) throws BOSException, EASBizException {
        BizOrgQueryParam bizOrgParam = new BizOrgQueryParam();
        bizOrgParam.setOrgOUSealType("TRUE");
        bizOrgParam.setOrgId(unitID);
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(orgTypeValue);
        OrgUnitCollection orgCol = OrgAppHelper.getOrgUnitCollection(ctx, orgAppHelper, bizOrgParam);
        if (!orgCol.isEmpty()) {
            throw new OUException(OUException.CANT_SEALUP_ALREADYSEALUP);
        }
    }

    private void checkIsDelegatedByOtherOrg(Context ctx, FullOrgUnitInfo unitInfo, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        boolean result = iDelegate.isDelegatedByOthers(unitInfo.getId().toString(), orgTypeValue);
        if (result) {
            Object[] params = new String[]{OrgType.getEnum(orgTypeValue).getAlias()};
            throw new OUException(OUException.CANT_SEALUP_DELEGATEDBYOTHERS, params);
        }
    }

    private void checkIsBizSubordinatesSealedUp(Context ctx, FullOrgUnitInfo unitInfo, int orgTypeValue) throws BOSException, EASBizException {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(OrgType.getEnum(orgTypeValue));
        if (orgTypeInfo == null) {
            return;
        }
        String treeId = orgTypeInfo.getOrgTreeID();
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select longNumber Where unit.id = '" + unitInfo.getId().toString() + "' and tree.id = '" + treeId + "'");
        BizOrgQueryParam bizOrgParam = new BizOrgQueryParam();
        bizOrgParam.setOrgOUSealType("FALSE");
        bizOrgParam.setSubLongNumber(structInfo.getLongNumber());
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(orgTypeValue);
        OrgUnitCollection orgCol = OrgAppHelper.getOrgUnitCollection(ctx, orgAppHelper, bizOrgParam, true);
        if (!orgCol.isEmpty()) {
            throw new OUException(OUException.ORG_NOT_SEALUP);
        }
    }

    private void checkIsAssistantOrgsSealedUp(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)unitInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        boolean result = iFull.exists(filter);
        if (result) {
            throw new OUException(OUException.EXIST_UNSEALUP_ASSISTANT_ORGS);
        }
    }

    private void updateBizSealUpTag(Context ctx, String unitID, int orgTypeValue, int value) throws BOSException {
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        String partTableName = "";
        String tableName = "";
        OrgTypeSelfInfo orgTypeAppInfo = OrgTypeAppCenter.getInstance().getHelper(orgTypeValue).getOrgTypeSelfInfo();
        sql1.append("UPDATE ").append(orgTypeAppInfo.getTableName()).append(" SET FIsSealUp = ").append(value);
        sql2.append("UPDATE ").append(orgTypeAppInfo.getViewTableName()).append(" SET FIsSealUp = ").append(value);
        java.sql.Date currentDate = new java.sql.Date(System.currentTimeMillis());
        String timeStampFormat = this.dateTransforDateFormat(currentDate);
        if (value == 1) {
            sql1.append(",FPropertySealUpDate = {ts'").append(currentDate).append("'}");
            sql2.append(",FPropertySealUpDate = {ts'").append(currentDate).append("'}");
        } else {
            sql1.append(",FPropertySealUpDate = NULL");
            sql2.append(",FPropertySealUpDate = NULL");
        }
        sql2.append(",FLASTUPDATETIME = {ts'").append(timeStampFormat).append("'}");
        sql1.append(" WHERE FUnitID = '").append(unitID).append("'");
        sql2.append(" WHERE FID = '").append(unitID).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select fid from t_org_oupartfi where funitid = '" + unitID + "'"));
        String fid = null;
        try {
            if (rowSet.next()) {
                fid = rowSet.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        DbUtil.execute((Context)ctx, (String)sql1.toString());
        DbUtil.execute((Context)ctx, (String)sql2.toString());
        ORMValueCacheService.getInstance().remove(ctx, orgTypeAppInfo.getOrgViewBosType(), unitID);
        ORMValueCacheService.getInstance().remove(ctx, orgTypeAppInfo.getOrgTableBosType(), fid);
    }

    private void checkCUIsAlreadySealedUp(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)unitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        if (iFull.exists(filter)) {
            throw new OUException(OUException.CANT_SEALUP_ALREADYSEALEDUP_CU);
        }
    }

    private boolean checkIsAlreadySealedUp(Context ctx, String unitID) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)unitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        return iFull.exists(filter);
    }

    private void checkIsSubordinateOUSealedUp(Context ctx, FullOrgUnitInfo unit) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)unit.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isUnion", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCU", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        if (iFull.exists(filter)) {
            throw new OUException(OUException.CANT_SEALUP_CU_SUBORDINATE_OU);
        }
    }

    private void checkIsSubordinateCUSealedUp(Context ctx, FullOrgUnitInfo unit) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(unit.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("isCU", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
        if (iFull.exists(filter)) {
            throw new OUException(OUException.CANT_SEALUP_CU_SUBORDINATE_CU);
        }
    }

    private void checkIsParentCUSealedUp(Context ctx, FullOrgUnitInfo unit) throws BOSException, EASBizException {
        if (unit.getParent() == null) {
            return;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)unit.getParent().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCU", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(1), CompareType.EQUALS));
        if (iFull.exists(filter)) {
            throw new OUException(OUException.CANT_UNSEALUP_CU_PARENT_CU);
        }
    }

    private void checkBizPropertiesSealedUp(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        this.checkBizPropertiesSealedUp(ctx, unitInfo, null);
    }

    private void checkBizPropertiesSealedUp(Context ctx, FullOrgUnitInfo unitInfo, Set notIncludeThisOrgTypeSet) throws BOSException, EASBizException {
        this.checkBizPropertiesSealedUp(ctx, unitInfo, notIncludeThisOrgTypeSet, true);
    }

    private void checkBizPropertiesSealedUp(Context ctx, FullOrgUnitInfo unitInfo, Set notIncludeThisOrgTypeSet, boolean isCheckSealUp) throws BOSException, EASBizException {
        String unitID = unitInfo.getId().toString();
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        Iterator it = orgTypeCol.iterator();
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(unitInfo);
        IDynamicObject iDO = DynamicObjectFactory.getLocalInstance((Context)ctx);
        String oql = "Select isSealUp Where unit.id = '" + unitID + "'";
        while (it.hasNext()) {
            OrgTypeInfo orgTypeInfo = (OrgTypeInfo)it.next();
            if (OrgType.NONE == orgTypeInfo.getOrgType() || notIncludeThisOrgTypeSet != null && notIncludeThisOrgTypeSet.contains((Object)orgTypeInfo.getOrgType()) || !orgTypeHelper.isOrgType(orgTypeInfo.getOrgType())) continue;
            OrgTypeSelfInfo orgInfo = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType()).getOrgTypeSelfInfo();
            OUPartCoreBaseInfo ouPartBaseInfo = (OUPartCoreBaseInfo)iDO.getValue(orgInfo.getOrgTableBosType(), oql);
            if (isCheckSealUp) {
                if (ouPartBaseInfo.getBoolean("isSealUp")) continue;
                Object[] params = new String[]{orgTypeInfo.getOrgType().getAlias()};
                throw new OUException(OUException.CANT_OUSEALUP_NOTSEALUP, params);
            }
            if (!ouPartBaseInfo.getBoolean("isSealUp")) continue;
            Object[] params = new String[]{orgTypeInfo.getOrgType().getAlias()};
            throw new OUException(OUException.CANNOT_UNSEALUP_PARENTSUB_HASSEALUP, params);
        }
    }

    private List getSqlList(String sourceSql) {
        ArrayList<String> sqlList = new ArrayList<String>();
        Collection orgTyepInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTyepInfoCol) {
            if (!orgTypeInfo.isBasicOrgType()) continue;
            OrgTypeSelfInfo orgTypeSelfInfo = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType()).getOrgTypeSelfInfo();
            String newTableSql = StringUtils.replace((String)sourceSql, (String)"tableName", (String)orgTypeSelfInfo.getViewTableName());
            this.orgBosTypeList.add(orgTypeSelfInfo.getOrgViewBosType());
            sqlList.add(newTableSql);
        }
        return sqlList;
    }

    private void updateSealUpTagAndDate(Context ctx, String unitID, boolean isSealUp, java.sql.Date date) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        String timeStampFormat = this.dateTransforDateFormat(date);
        if (isSealUp) {
            String dateStr = date.toString();
            sql.append("update tableName set FIsOUSealUp = 1,FInvalidDate = {ts'").append(dateStr).append("'},FLASTUPDATETIME = {ts'").append(timeStampFormat).append("'} where FID = '").append(unitID).append("'");
        } else {
            sql.append("update tableName set FIsOUSealUp = 0,FInvalidDate = NULL,FLASTUPDATETIME = {ts'").append(timeStampFormat).append("'} where FID = '").append(unitID).append("'");
        }
        List sqlList = this.getSqlList(sql.toString());
        for (int i = 0; i < sqlList.size(); ++i) {
            DbUtil.execute((Context)ctx, (String)sqlList.get(i).toString());
            ORMValueCacheService.getInstance().remove(ctx, (BOSObjectType)this.orgBosTypeList.get(i), unitID);
        }
    }

    private void otherDealOuSealUp(Context ctx, String id) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"096ED22F", IOtherDealSealUp.class);
            if (checks != null && checks.length > 0) {
                IOtherDealSealUp otherDealSealUpCheck = null;
                for (int i = 0; i < checks.length; ++i) {
                    otherDealSealUpCheck = (IOtherDealSealUp)Class.forName(checks[i]).newInstance();
                    otherDealSealUpCheck.ouSealUp(ctx, id);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void otherDealOuUnSealUp(Context ctx, String id) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"096ED22F", IOtherDealSealUp.class);
            if (checks != null && checks.length > 0) {
                IOtherDealSealUp otherDealSealUpCheck = null;
                for (int i = 0; i < checks.length; ++i) {
                    otherDealSealUpCheck = (IOtherDealSealUp)Class.forName(checks[i]).newInstance();
                    otherDealSealUpCheck.ouUnSealUp(ctx, id);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void otherDealBizSealUp(Context ctx, String id, int orgType) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"096ED22F", IOtherDealSealUp.class);
            if (checks != null && checks.length > 0) {
                IOtherDealSealUp otherDealSealUpCheck = null;
                for (int i = 0; i < checks.length; ++i) {
                    otherDealSealUpCheck = (IOtherDealSealUp)Class.forName(checks[i]).newInstance();
                    otherDealSealUpCheck.bizSealUp(ctx, id, orgType);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void otherDealBizUnSealUp(Context ctx, String id, int orgType) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"096ED22F", IOtherDealSealUp.class);
            if (checks != null && checks.length > 0) {
                IOtherDealSealUp otherDealSealUpCheck = null;
                for (int i = 0; i < checks.length; ++i) {
                    otherDealSealUpCheck = (IOtherDealSealUp)Class.forName(checks[i]).newInstance();
                    otherDealSealUpCheck.bizUnSealUp(ctx, id, orgType);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _ouShift(Context ctx, IObjectPK ouPK, IObjectPK parentPK) throws BOSException, EASBizException {
        boolean cuChange;
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("orgtypestr"));
        sic.add(new SelectorItemInfo("name"));
        FullOrgUnitInfo unitInfo = iFull.getFullOrgUnitInfo(ouPK, sic);
        FullOrgUnitInfo parentInfo = iFull.getFullOrgUnitInfo(parentPK, sic);
        if (parentInfo.getLongNumber().startsWith(unitInfo.getLongNumber() + "!")) {
            throw new OUException(OUException.OUSHIFT_SUPERIORLOOP);
        }
        unitInfo.setParent(parentInfo);
        unitInfo.put("ParentOnly", Boolean.TRUE);
        boolean bl = cuChange = !unitInfo.getCU().getId().toString().equals(parentInfo.getCU().getId().toString());
        if (cuChange) {
            this.updateCUwhenMove(ctx, parentInfo.getCU().getId().toString(), unitInfo.getLongNumber(), unitInfo.getCU().getId().toString());
            unitInfo.setCU(parentInfo.getCU());
            this.updateAssistantOrg(ctx, unitInfo);
        }
        iFull.update(ouPK, (CoreBaseInfo)unitInfo);
    }

    private void updateAssistantOrg(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        boolean isCompany = StringUtils.cnulls((String)unitInfo.getOrgTypeStr()).toUpperCase().indexOf("COMPANY") >= 0;
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (isCompany) {
            filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)unitInfo.getId(), CompareType.EQUALS));
            filter.setMaskString("#0");
            viewInfo.setFilter(filter);
            FullOrgUnitCollection col = iFull.getFullOrgUnitCollection(viewInfo);
            for (int i = 0; i < col.size(); ++i) {
                FullOrgUnitInfo assistantOrgInfo = col.get(i);
                assistantOrgInfo.setParent(unitInfo.getParent());
                assistantOrgInfo.setCU(unitInfo.getParent().getCU());
                assistantOrgInfo.put("ParentOnly", Boolean.TRUE);
                iFull.update((IObjectPK)new ObjectUuidPK(assistantOrgInfo.getId()), (CoreBaseInfo)assistantOrgInfo);
            }
        }
    }

    private void updateCUwhenMove(Context ctx, String newCUId, String oldLongNumber, String oldCUID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)newCUId) || StringUtils.isEmpty((String)oldLongNumber)) {
            throw new OUException(OUException.OUSHIFT_SUPERIORLOOP);
        }
        String sql = new StringBuffer().append("UPDATE T_ORG_BaseUnit set FControlUnitID = '").append(newCUId).append("' WHERE FLongNumber like '").append(oldLongNumber).append("%' and FControlUnitID = '").append(oldCUID).append("'").toString();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _bizSealUp(Context ctx, String unitID, int orgTypeValue, List sealUpList) throws BOSException, EASBizException {
        IOrgSealUp4Server iOrgSealUp4Server = null;
        if (sealUpList != null && sealUpList.size() > 0) {
            for (int i = 0; i < sealUpList.size(); ++i) {
                OrgSealUpInfo sealUpInfo = (OrgSealUpInfo)sealUpList.get(i);
                if (!ToSealUpEnum.OK.equals((Object)sealUpInfo.getToSealSatus()) || sealUpInfo.getData() == null || StringUtils.isEmpty((String)sealUpInfo.getImpl())) continue;
                try {
                    iOrgSealUp4Server = (IOrgSealUp4Server)Class.forName(sealUpInfo.getImpl()).newInstance();
                    iOrgSealUp4Server.beforeSealUp(ctx, orgTypeValue, sealUpInfo);
                    continue;
                }
                catch (BOSException e) {
                    if (!sealUpInfo.isThrowException()) continue;
                    throw new BOSException((Throwable)e);
                }
                catch (EASBizException e) {
                    if (!sealUpInfo.isThrowException()) continue;
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                catch (InstantiationException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this._bizSealUp(ctx, unitID, orgTypeValue);
    }

    @Override
    protected void _batchBizSealUp(Context ctx, IObjectValue unitInfo, int orgTypeValue) throws BOSException, EASBizException {
        FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)unitInfo;
        String unitID = orgInfo.getId().toString();
        this.checkOrgType(orgInfo, orgTypeValue);
        INewOrgViewFacade iNewOView = NewOrgViewFacadeFactory.getLocalInstance(ctx);
        OrgUnitCollection orgColSub = iNewOView.getChildren(orgInfo.getId().toString(), OrgViewType.getEnum(orgTypeValue), false);
        orgColSub.add(orgInfo);
        OrgType type = OrgType.getEnum(orgTypeValue);
        IOrgBizChecker aChecker = null;
        try {
            List checkers = OrgConfigHelper.getXMLBizClasses("beforeOrgSealUp", null);
            for (int j = 0; j < orgColSub.size(); ++j) {
                FullOrgUnitInfo orgUnitInfo = orgColSub.get(j).castToFullOrgUnitInfo();
                int n = checkers.size();
                for (int i = 0; i < n; ++i) {
                    String className = ((OrgXMLElement)checkers.get(i)).getValue();
                    if (StringUtils.isEmpty((String)className)) continue;
                    aChecker = (IOrgBizChecker)Class.forName(className).newInstance();
                    aChecker.checkBizClear(ctx, orgUnitInfo, type);
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.info((Object)(aChecker + "error!"), (Throwable)e);
        }
        catch (JDOMException e) {
            logger.info((Object)(aChecker + "error!"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.info((Object)(aChecker + "error!"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            logger.info((Object)(aChecker + "error!"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.info((Object)(aChecker + "error!"), (Throwable)e);
        }
        if (1 == type.getValue()) {
            this.assistantSealUp(ctx, orgColSub);
        }
        this.delDelegate(ctx, orgColSub, orgTypeValue);
        this.batchUpdateBizSealUpTag(ctx, orgColSub, orgTypeValue, 1);
        for (int i = 0; i < orgColSub.size(); ++i) {
            OrgLogServerUtils.log(ctx, OrgLogServerUtils.convert(type), OrgLogTypeEnum.SEALUP, orgColSub.getObject(i));
        }
    }

    @Override
    protected void _batchOUSealUp(Context ctx, IObjectValue unitInfo) throws BOSException, EASBizException {
        int i;
        FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)unitInfo;
        if (this.checkIsAlreadySealedUp(ctx, orgInfo.getId().toString())) {
            return;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        String longNumberOfSubUnits = orgInfo.getLongNumber() + "!%";
        String oqlToFindUnSealedUpSubUnits = "where isOUSealUp = 0 and isUnion = 0 and longNumber like '" + longNumberOfSubUnits + "'";
        FullOrgUnitCollection orgColSub = iFull.getFullOrgUnitCollection(oqlToFindUnSealedUpSubUnits);
        orgColSub.add(orgInfo);
        for (i = 0; i < orgColSub.size(); ++i) {
            FullOrgUnitInfo orgUnitInfo = orgColSub.get(i);
            Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
            Iterator it = orgTypeCol.iterator();
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgUnitInfo);
            while (it.hasNext()) {
                OrgTypeInfo orgTypeInfo = (OrgTypeInfo)it.next();
                if (OrgType.NONE == orgTypeInfo.getOrgType() || OrgType.ControlUnit == orgTypeInfo.getOrgType() || !orgTypeHelper.isOrgType(orgTypeInfo.getOrgType())) continue;
                this._batchBizSealUp(ctx, (IObjectValue)orgUnitInfo, orgTypeInfo.getOrgType().getValue());
            }
        }
        this.batchUpdateSealUpTagAndDate(ctx, orgColSub, true, new java.sql.Date(System.currentTimeMillis()));
        for (i = 0; i < orgColSub.size(); ++i) {
            OrgLogServerUtils.log(ctx, OrgAlterPageEnum.PAGE_BASIC, OrgLogTypeEnum.SEALUP, orgColSub.getObject(i));
        }
    }

    private void delDelegate(Context ctx, OrgUnitCollection unitCol, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        iDelegate.batchDelDelegateForBizSealUp((IObjectCollection)unitCol, orgTypeValue);
    }

    private void assistantSealUp(Context ctx, OrgUnitCollection orgColSub) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select id where mainOrg.id in (");
        int size = orgColSub.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'").append(orgColSub.get(i).getId().toString()).append("'");
        }
        oql.append(") and isOUSealUp = 0");
        FullOrgUnitCollection assistantOrgCol = iFull.getFullOrgUnitCollection(oql.toString());
        for (int i = 0; i < assistantOrgCol.size(); ++i) {
            String unitId = assistantOrgCol.get(i).getId().toString();
            this._bizSealUp(ctx, unitId, 1);
            this._ouSealUp(ctx, unitId);
        }
    }

    private void batchUpdateBizSealUpTag(Context ctx, OrgUnitCollection orgColSub, int orgTypeValue, int value) throws BOSException {
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        OrgTypeSelfInfo orgTypeAppInfo = OrgTypeAppCenter.getInstance().getHelper(orgTypeValue).getOrgTypeSelfInfo();
        sql1.append("UPDATE ").append(orgTypeAppInfo.getTableName()).append(" SET FIsSealUp = ").append(value);
        sql2.append("UPDATE ").append(orgTypeAppInfo.getViewTableName()).append(" SET FIsSealUp = ").append(value);
        java.sql.Date currentDate = new java.sql.Date(System.currentTimeMillis());
        String timeStampFormat = this.dateTransforDateFormat(currentDate);
        if (value == 1) {
            sql1.append(",FPropertySealUpDate = {ts'").append(currentDate).append("'}");
            sql2.append(",FPropertySealUpDate = {ts'").append(currentDate).append("'}");
        } else {
            sql1.append(",FPropertySealUpDate = NULL");
            sql2.append(",FPropertySealUpDate = NULL");
        }
        sql2.append(",FLASTUPDATETIME = {ts'").append(timeStampFormat).append("'}");
        sql1.append(" WHERE FUnitID = ?");
        sql2.append(" WHERE FID = ?");
        Connection cn = this.getConnection(ctx);
        PreparedStatement pstmt1 = null;
        PreparedStatement pstmt2 = null;
        try {
            pstmt1 = cn.prepareStatement(sql1.toString());
            pstmt2 = cn.prepareStatement(sql2.toString());
            String[] pks = new String[orgColSub.size()];
            for (int i = 0; i < orgColSub.size(); ++i) {
                String unitID = orgColSub.get(i).getId().toString();
                pstmt1.setString(1, unitID);
                pks[i] = unitID;
                pstmt2.setString(1, unitID);
                pstmt1.addBatch();
                pstmt2.addBatch();
            }
            pstmt1.executeBatch();
            pstmt2.executeBatch();
            ORMValueCacheService.getInstance().removeBatch(ctx, orgTypeAppInfo.getOrgViewBosType(), pks);
            ORMValueCacheService.getInstance().removeBatch(ctx, orgTypeAppInfo.getOrgTableBosType(), pks);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)pstmt1, (Connection)cn);
            SQLUtils.cleanup(null, (Statement)pstmt2, (Connection)cn);
        }
    }

    private void batchUpdateSealUpTagAndDate(Context ctx, FullOrgUnitCollection unitCol, boolean isSealUp, java.sql.Date date) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        String timeStampFormat = this.dateTransforDateFormat(date);
        if (isSealUp) {
            String dateStr = date.toString();
            sql.append("update tableName set FIsOUSealUp = 1, FInvalidDate = {ts'").append(dateStr).append("'}, FLASTUPDATETIME = {ts'").append(timeStampFormat).append("'} where FID = ?");
        } else {
            sql.append("update tableName set FIsOUSealUp = 0, FInvalidDate = NULL, FLASTUPDATETIME = {ts'").append(timeStampFormat).append("'} where FID = ?");
        }
        List sqlList = this.getSqlList(sql.toString());
        Connection cn = this.getConnection(ctx);
        PreparedStatement pstmt = null;
        try {
            for (int i = 0; i < sqlList.size(); ++i) {
                pstmt = cn.prepareStatement(sqlList.get(i).toString());
                String[] pks = new String[unitCol.size()];
                for (int j = 0; j < unitCol.size(); ++j) {
                    String unitID;
                    pks[j] = unitID = unitCol.get(j).getId().toString();
                    pstmt.setString(1, unitID);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                ORMValueCacheService.getInstance().removeBatch(ctx, (BOSObjectType)this.orgBosTypeList.get(i), pks);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, pstmt, (Connection)cn);
        }
    }

    private String dateTransforDateFormat(java.sql.Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp timeStamp = new Timestamp(date.getTime());
        String timeStampFormat = format.format(timeStamp);
        return timeStampFormat;
    }

    @Override
    protected void _batchCUSealUp(Context ctx, IObjectValue unitInfo) throws BOSException, EASBizException {
        FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)unitInfo;
        String unitID = orgInfo.getId().toString();
        if (this.checkIsAlreadySealedUp(ctx, unitID)) {
            return;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        String longNumberOfSubUnits = orgInfo.getLongNumber() + "!%";
        String oqlToFindUnSealedUpSubUnits = "where isOUSealUp = 0 and isUnion = 0 and longNumber like '" + longNumberOfSubUnits + "'";
        FullOrgUnitCollection orgColSub = iFull.getFullOrgUnitCollection(oqlToFindUnSealedUpSubUnits);
        orgColSub.add(orgInfo);
        for (int i = 0; i < orgColSub.size(); ++i) {
            this._batchOUSealUp(ctx, (IObjectValue)orgColSub.get(i));
        }
    }

    @Override
    protected BizParentAndDelegateInfo _loadSuperiorAndDelegateUnits(Context ctx, IObjectPK unitPK, SelectorItemCollection selector) throws BOSException, EASBizException {
        BizParentAndDelegateInfo pdInfo = new BizParentAndDelegateInfo();
        if (!unitPK.toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            this.loadSuperiorUnits(ctx, unitPK, pdInfo, selector);
        }
        this.loadDelegate(ctx, unitPK, pdInfo, selector);
        return pdInfo;
    }

    @Override
    protected void _ouShift(Context ctx, OrgMoveParam orgMoveParam) throws BOSException, EASBizException {
        if (orgMoveParam == null) {
            return;
        }
        String movedOrgId = orgMoveParam.getMovedOrgId();
        Set<Integer> orgTypes = orgMoveParam.getOrgTypes();
        INewOrgViewFacade iNewOrgView = NewOrgViewFacadeFactory.getLocalInstance(ctx);
        for (Integer orgType : orgTypes) {
            iNewOrgView.updateBizParent(OrgType.getEnum(orgType), movedOrgId, orgMoveParam.getNewParentId(orgType));
        }
    }
}

