/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.basedata.org.app.AbstractNewOrgF7FacadeControllerBean;
import com.kingdee.eas.basedata.org.app.helper.BuildDirectChildrenFactory;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.IOrgDirectTreeNode;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.util.OrgF7FilterUtil;
import com.kingdee.eas.basedata.org.util.OrgTypeUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NewOrgF7FacadeControllerBean
extends AbstractNewOrgF7FacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)NewOrgF7FacadeControllerBean.class.getName());

    private String getQuerySQL(Context ctx, String querySQL) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isEmpty((String)querySQL)) {
            return null;
        }
        sql.append("select fid, fname_").append(ctx.getLocale().toString()).append(", fnumber, fcode, flongnumber, forgtypestr, fcontrolunitid ").append("from t_org_baseunit where fid in (").append(querySQL).append(")");
        return sql.toString();
    }

    @Override
    protected Map _getOrgInfosByQuerySQL(Context ctx, String querySQL) throws BOSException, EASBizException {
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        String sql = this.getQuerySQL(ctx, querySQL);
        if (StringUtils.isEmpty((String)sql)) {
            return result;
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                CoreBaseInfo info = this.createBizInfo(rs);
                result.put(info.getId().toString(), info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private CoreBaseInfo createBizInfo(IRowSet rs) throws SQLException {
        FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
        unitInfo.setId(BOSUuid.read((String)rs.getString(1)));
        unitInfo.setName(rs.getString(2));
        unitInfo.setNumber(rs.getString(3));
        unitInfo.setCode(rs.getString(4));
        unitInfo.setOrgTypeStr(rs.getString(6));
        CtrlUnitInfo cuInfo = new CtrlUnitInfo();
        cuInfo.setId(BOSUuid.read((String)rs.getString(7)));
        unitInfo.setCU(cuInfo);
        unitInfo.setLongNumber(rs.getString(5));
        return unitInfo;
    }

    @Override
    protected String _getTableNameByOrgTypeView(Context ctx, OrgViewType orgViewType) throws BOSException, EASBizException {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
        IOrgAppHelper iHelper = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType());
        String name = iHelper.getOrgTypeSelfInfo().getTableName();
        return name;
    }

    @Override
    protected List _getDirectChildren(Context ctx, OrgAssistInfo orgAssistInfo, CoreBaseInfo selectedNode) throws BOSException, EASBizException {
        ArrayList<CoreBaseInfo> result = new ArrayList<CoreBaseInfo>();
        if (selectedNode == null) {
            selectedNode = this.prepareSelectedNode(ctx, orgAssistInfo);
            if (selectedNode == null) {
                return null;
            }
            result.add(selectedNode);
        }
        IOrgDirectTreeNode handler = BuildDirectChildrenFactory.getInstance().createTreeNodeHandler(ctx, selectedNode, orgAssistInfo);
        result.addAll(handler.getDirectTreeNode(ctx, selectedNode, orgAssistInfo));
        return result;
    }

    private CoreBaseInfo prepareSelectedNode(Context ctx, OrgAssistInfo orgAssistInfo) throws BOSException, EASBizException {
        String rootUnitID = orgAssistInfo.getRootUnitID();
        if (StringUtils.isEmpty((String)rootUnitID)) {
            rootUnitID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo("where id = '" + rootUnitID + "'");
        if (orgAssistInfo.isStructure()) {
            OrgTypeInfo typeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgAssistInfo.getOrgViewType());
            OrgType orgType = typeInfo.getOrgType();
            if (!OrgTypeUtils.isOrgType((OrgUnitInfo)unitInfo, orgType)) {
                if (orgType == OrgType.UnionDebt) {
                    StringBuffer oql = new StringBuffer();
                    oql.append("select id, longnumber, level, isleaf, unit.name, unit.cu.id where tree.id = '").append(orgAssistInfo.getTreeID()).append("' and level = 1 and isvalid = 1");
                    OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureInfo(oql.toString());
                    return structInfo;
                }
                return null;
            }
            OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureInfo("where unit.id = '" + rootUnitID + "' and tree.id = '" + orgAssistInfo.getTreeID() + "'");
            structInfo.setUnit(unitInfo);
            return structInfo;
        }
        return unitInfo;
    }

    private String appendUnionAndMaintainQuery(Context ctx, OrgAssistInfo orgAssistInfo, String unitIDs) {
        StringBuffer sql = new StringBuffer();
        sql.append(" tree.type = 8 and ").append(" unit.isunion = 1 and ").append(" (tree.status = ").append(UnionVersionStatusEnum.START.getValue()).append(" or tree.status = ").append(UnionVersionStatusEnum.ARCHIVE.getValue()).append(")").append(" and (").append(" tree.CU.id in (").append(unitIDs).append(")").append(this.appendMaintainCU(orgAssistInfo.isDisplayMaintain(), unitIDs)).append(")").append(this.appendOrgRange(ctx, orgAssistInfo, 1, true));
        return sql.toString();
    }

    private String appendOrgRange(Context ctx, OrgAssistInfo orgAssistInfo, int orgRangeType, boolean isOQL) {
        StringBuffer oql = new StringBuffer();
        boolean isCUAdmin = Administrator.isAdminType((UserType)ContextUtil.getCurrentUserInfo((Context)ctx).getType());
        if (orgAssistInfo.isUnioNeedOrgRange() && !isCUAdmin) {
            if (isOQL) {
                oql.append(" and unit.cu.id in (");
            } else {
                oql.append(" and \"UNIT\".FCONTROLUNITID in (");
            }
            if (StringUtils.isEmpty((String)orgAssistInfo.getOrgRangeSQL())) {
                oql.append("select forgid from t_pm_orgrange where fuserid = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("' and ftype = ").append(orgRangeType == 4 ? 30 : 10);
            } else {
                oql.append(orgAssistInfo.getOrgRangeSQL());
            }
            oql.append(")");
        }
        return oql.toString();
    }

    private StringBuffer appendMaintainCU(boolean isDisplayMaintain, String cuIDs) {
        StringBuffer maintainOQL = new StringBuffer();
        if (isDisplayMaintain && !StringUtils.isEmpty((String)cuIDs)) {
            maintainOQL.append(" or (unit.maintainCU.id in (").append(cuIDs).append(")").append(" and tree.CU.id not in (").append(cuIDs).append(")").append(")");
        }
        return maintainOQL;
    }

    private List getDistinctOrgTreeInfo(OrgStructureCollection structCol) {
        ArrayList<OrgTreeInfo> result = new ArrayList<OrgTreeInfo>();
        if (structCol != null && structCol.size() > 0) {
            int n = structCol.size();
            for (int i = 0; i < n; ++i) {
                OrgTreeInfo treeInfo = structCol.get(i).getTree();
                if (result.contains(treeInfo)) continue;
                result.add(treeInfo);
            }
        }
        return result;
    }

    @Override
    protected List _getCUUnion(Context ctx, boolean isSuperAuAdmin, OrgAssistInfo orgAssistInfo) throws BOSException, EASBizException {
        boolean isCUAdmin;
        String sql = null;
        sql = isSuperAuAdmin ? "select fid from t_org_ctrlunit where fid <> '11111111-1111-1111-1111-111111111111CCE7AED4'" : ((isCUAdmin = Administrator.isCUAdmin((Context)ctx, (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()))) ? "select forgid from t_pm_orgrange where fuserid = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId() + "' and ftype = " + 10 : "select unit.fcontrolunitid from t_pm_orgrange range inner join t_org_baseunit unit on range.forgid = unit.fid where fuserid = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId() + "' and ftype = " + 30);
        StringBuffer oql = new StringBuffer();
        oql.append("select tree.id, tree.name, tree.startDate, tree.endDate, tree.isVersioned where ").append(this.appendUnionAndMaintainQuery(ctx, orgAssistInfo, sql)).append(" order by tree.number, tree.startDate");
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(oql.toString());
        List unionRange = this.getDistinctOrgTreeInfo(structCol);
        return unionRange;
    }

    @Override
    protected List _getCUUnion(Context ctx, String[] cuId, OrgAssistInfo orgAssistInfo) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select tree.id, tree.name, tree.startDate, tree.endDate, tree.isVersioned where ").append(this.appendUnionAndMaintainQuery(ctx, orgAssistInfo, ToolUtils.aryToStr((String[])cuId))).append(" order by tree.number, tree.startDate");
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(oql.toString());
        List unionRange = this.getDistinctOrgTreeInfo(structCol);
        return unionRange;
    }

    @Override
    protected List _getMutiRootNodes(Context ctx, String multiRootUnitsSQL) throws BOSException, EASBizException {
        ArrayList<FullOrgUnitInfo> result = new ArrayList<FullOrgUnitInfo>();
        if (StringUtils.isEmpty((String)multiRootUnitsSQL)) {
            IFullOrgUnit iunit = FullOrgUnitFactory.getLocalInstance(ctx);
            FullOrgUnitInfo unitInfo = iunit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
            result.add(unitInfo);
            return result;
        }
        ArrayList<String> longNumbers = new ArrayList<String>();
        int level = 0;
        int minLevel = 0;
        try {
            IRowSet rowset;
            while ((rowset = DbUtil.executeQuery((Context)ctx, (String)this.getMinLevel(ctx, level, longNumbers, multiRootUnitsSQL))).next() && (minLevel = rowset.getInt(1)) != 0) {
                if (minLevel == 1) {
                    FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
                    result.add(unitInfo);
                } else {
                    FullOrgUnitCollection unitColl;
                    StringBuffer querySQL = new StringBuffer();
                    querySQL.append("select id, name, longnumber, isleaf, iscu, isunion, cu.id, orgtypestr ").append("where level = ").append(minLevel).append(" and id in (").append(multiRootUnitsSQL).append(")");
                    if (longNumbers != null && longNumbers.size() > 0) {
                        int j = longNumbers.size();
                        for (int i = 0; i < j; ++i) {
                            querySQL.append(" and longnumber not like '").append(longNumbers.get(i)).append("!%' ");
                        }
                    }
                    if ((unitColl = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitCollection(querySQL.toString())) != null) {
                        int j = unitColl.size();
                        for (int i = 0; i < j; ++i) {
                            longNumbers.add(unitColl.get(i).getLongNumber());
                            result.add(unitColl.get(i));
                        }
                        level = minLevel;
                        continue;
                    }
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getMinLevel(Context ctx, int level, List longNumbers, String multiRootUnitsSQL) {
        StringBuffer querySQL = new StringBuffer();
        querySQL.append("select min(unit.flevel) from t_org_baseunit unit where unit.fid in (").append(multiRootUnitsSQL).append(")").append(" and unit.flevel >= ").append(level + 1).append(" and unit.fisunion = 0 ");
        if (longNumbers != null && longNumbers.size() > 0) {
            int j = longNumbers.size();
            for (int i = 0; i < j; ++i) {
                querySQL.append(" and unit.flongnumber not like '").append(longNumbers.get(i)).append("!%' ");
            }
        }
        return querySQL.toString();
    }

    @Override
    protected String _getPermSQLByUIPKAndActionPK(Context ctx, IObjectPK userPK, String cuID, IMetaDataPK uiPK, IMetaDataPK actionPK, OrgViewType viewType, boolean isCUFilter, boolean isIncludeSubCU) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return this.buildPermSQL(ctx, permItemName, userPK, cuID, viewType, isCUFilter, isIncludeSubCU);
            }
        }
        return OrgF7FilterUtil.buildParamSQL(ctx, userPK, cuID, viewType, isCUFilter, isIncludeSubCU);
    }

    private String buildPermSQL(Context ctx, String permItem, IObjectPK userPK, String cuID, OrgViewType viewType, boolean isCUFilter, boolean isIncludeSubCU) throws EASBizException, BOSException {
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permItem);
        if (permItemInfo.getOrgRelation() != null && permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            boolean hasFunPerm = iPermission.hasFunctionPermission(userPK, (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItem);
            if (hasFunPerm) {
                return OrgF7FilterUtil.buildParamSQL(ctx, userPK, cuID, viewType, isCUFilter, isIncludeSubCU);
            }
            return "'no_data'";
        }
        return OrgF7FilterUtil.buildAuthorizedOrgSQL(ctx, userPK, cuID, permItemInfo.getId().toString(), isCUFilter, isIncludeSubCU);
    }

    @Override
    protected String _getPermSQLByPermItem(Context ctx, String permItem, IObjectPK userPK, OrgViewType viewType) throws BOSException, EASBizException {
        return this.buildPermSQL(ctx, permItem, userPK, null, viewType, false, false);
    }

    @Override
    protected List _getUnion4AccreditPerm(Context ctx, UserInfo targetUser) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select tree.id, tree.name, tree.startDate, tree.endDate, tree.isVersioned where ").append(this.userOrgrangeFilter(targetUser)).append(" order by tree.number, tree.startDate");
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(oql.toString());
        List unionRange = this.getDistinctOrgTreeInfo(structCol);
        return unionRange;
    }

    private String userOrgrangeFilter(UserInfo targetUser) {
        StringBuilder sb = new StringBuilder();
        sb.append(" tree.type = 8 and ").append(" unit.isunion = 1 and ").append(" (tree.status = ").append(UnionVersionStatusEnum.START.getValue()).append(" or tree.status = ").append(UnionVersionStatusEnum.ARCHIVE.getValue()).append(")").append(" and (").append(" unit.id in (").append(" SELECT FORGID  FROM T_PM_ORGRANGE where FUSERID ='" + targetUser.getId().toString() + "' and ").append(" ftype =10").append("))");
        return sb.toString();
    }

    @Override
    protected Set _getUserOrgRange4Union(Context ctx, IObjectPK userPK) throws BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append("select forgid from t_org_baseunit baseunit inner join t_pm_orgrange range on baseunit.fid= range.forgid ").append(" where range.fuserid=  '").append(userPK.toString()).append("'  and range.ftype=").append(10).append(" and baseunit.fisunion=1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashSet<String> setIds = new HashSet<String>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("forgid");
                if (StringUtils.isEmpty((String)id)) continue;
                setIds.add(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return setIds;
    }
}

