/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.BizOrgAssistInfoBuilder;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.IOtherDealUpdateParent;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgLogTypeEnum;
import com.kingdee.eas.basedata.org.OrgSpecialTablesRebuildFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.app.AbstractNewOrgViewFacadeControllerBean;
import com.kingdee.eas.basedata.org.app.helper.BuildDirectChildrenFactory;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.IOrgDirectTreeNode;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.app.helper.QueryOrgStructSqlHelper;
import com.kingdee.eas.basedata.org.app.log.OrgLogServerUtils;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NewOrgViewFacadeControllerBean
extends AbstractNewOrgViewFacadeControllerBean {
    private static Logger logger = Logger.getLogger(NewOrgViewFacadeControllerBean.class);

    @Override
    protected IRowSet _buildRowSetByCU(Context ctx, String cuID, String orgViewID) throws BOSException, EASBizException {
        return this.getRowSetByCU(ctx, cuID, orgViewID, null, true);
    }

    @Override
    protected IRowSet _buildRowSetByCU(Context ctx, String cuID, String orgViewID, String unitID) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo structInfo = iStruct.getOrgStructureInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
        return this.getRowSetByCU(ctx, cuID, orgViewID, structInfo, true);
    }

    @Override
    protected IRowSet _buildRowSetByCU(Context ctx, String cuID, String orgViewID, boolean isShowSub) throws BOSException, EASBizException {
        return this.getRowSetByCU(ctx, cuID, orgViewID, null, isShowSub);
    }

    private IRowSet getRowSetByCU(Context ctx, String cuID, String orgViewID, OrgStructureInfo structInfo, boolean isShowSub) throws BOSException, EASBizException {
        QueryOrgStructSqlHelper querySqlHelper = new QueryOrgStructSqlHelper();
        return querySqlHelper.getRowSetByCU(ctx, cuID, orgViewID, structInfo, isShowSub);
    }

    @Override
    protected IRowSet _buildUnionRows(Context ctx, String unitID, String treeID) throws BOSException, EASBizException {
        QueryOrgStructSqlHelper querySqlHelper = new QueryOrgStructSqlHelper();
        return querySqlHelper.getUnionRows(ctx, unitID, treeID);
    }

    @Override
    protected void _rebuildCUView(Context ctx) throws BOSException, EASBizException {
        this._rebuildView(ctx, "00000000-0000-0000-0000-000000000000CCE7AED4", "00000000-0000-0000-0000-0000000000014F2827FD");
    }

    @Override
    protected void _rebuildView(Context ctx, String cuID) throws BOSException, EASBizException {
        Collection orgTypeCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeCol) {
            OrgType curOrgType = orgTypeInfo.getOrgType();
            if (OrgType.NONE == curOrgType || OrgType.ControlUnit == curOrgType || !orgTypeInfo.isBasicOrgType()) continue;
            this._rebuildView(ctx, cuID, orgTypeInfo.getOrgTreeID());
        }
    }

    @Override
    protected void _rebuildView(Context ctx, String cuID, String treeId) throws EASBizException, BOSException {
        IOrgTree iOrgTree = OrgTreeFactory.getLocalInstance(ctx);
        OrgTreeInfo orgTreeInfo = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK(treeId));
        OrgViewType orgViewType = orgTreeInfo.getType();
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        IOrgStructure iOrgStructure = OrgStructureFactory.getLocalInstance(ctx);
        FullOrgUnitInfo cuOrgInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuID));
        String longNumber = cuOrgInfo.getLongNumber();
        Vector orgIdVec = this.getCUSubOrgs(ctx, cuID, orgViewType, longNumber);
        if (orgIdVec.size() == 0) {
            orgIdVec.add(cuID);
        }
        this.deleteOrgStru(ctx, treeId, cuID, longNumber);
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        orgMap.put(cuID, cuOrgInfo);
        HashMap<String, Integer> orgLevelMap = new HashMap<String, Integer>();
        orgLevelMap.put(cuID, new Integer(cuOrgInfo.getLevel()));
        HashMap orgPlayedMap = new HashMap();
        for (int i = 0; i < orgIdVec.size(); ++i) {
            String orgId = (String)orgIdVec.get(i);
            FullOrgUnitInfo orgInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
            if (orgMap.containsKey(orgId)) continue;
            orgMap.put(orgId, orgInfo);
            orgLevelMap.put(orgId, new Integer(orgInfo.getLevel()));
            if (orgInfo.getParent().getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) continue;
            this.searchLevelOrgs(ctx, iFull, orgMap, orgLevelMap, orgInfo.getParent().getId().toString(), "00000000-0000-0000-0000-000000000000CCE7AED4");
        }
        OrgStructureInfo fatherOrgStru = null;
        int targetLevel = 1;
        int maxLevel = this.getMaxLevel(orgLevelMap);
        this.buildSubOrgStru(ctx, iOrgStructure, orgTreeInfo, orgMap, orgLevelMap, orgPlayedMap, fatherOrgStru, targetLevel, maxLevel);
    }

    private Vector getCUSubOrgs(Context ctx, String cuID, OrgViewType orgType, String longNumber) throws BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" select FID from T_ORG_BaseUnit where FID!='");
        strBuffer.append("");
        strBuffer.append("' ");
        strBuffer.append(" and charindex('");
        strBuffer.append(longNumber);
        strBuffer.append("',FLongNumber)>=1");
        OrgType curOrgType = OrgType.getEnum(orgType.getValue());
        strBuffer.append(" and FOrgTypeStr like '%").append(OrgTypeHelper.createLikeStr(curOrgType)).append("%'");
        if (orgType.getValue() == 10) {
            strBuffer.append(" and FIsCU=1");
        } else {
            strBuffer.append(" and fcontrolunitid='");
            strBuffer.append(cuID);
            strBuffer.append("' ");
        }
        Vector<String> orgIdVec = new Vector<String>();
        ISQLExecutor iExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet irs = iExecutor.executeSQL();
        try {
            while (irs.next()) {
                orgIdVec.add(irs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orgIdVec;
    }

    private void deleteOrgStru(Context ctx, String treeID, String cuID, String longNumber) throws BOSException {
    }

    private boolean isOnTree(Context ctx, String treeID, String orgID) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean result = false;
        try {
            con = this.getConnection(ctx);
            String sql = "SELECT fid FROM T_Org_Structure WHERE FTreeID=?AND FUnitID=?";
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, treeID);
            pstmt.setString(2, orgID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    private int getMaxLevel(HashMap orgLevelMap) {
        int result = -1;
        for (String orgId : orgLevelMap.keySet()) {
            int element = (Integer)orgLevelMap.get(orgId);
            if (element <= result) continue;
            result = element;
        }
        return result;
    }

    private void buildSubOrgStru(Context ctx, IOrgStructure iOrgStructure, OrgTreeInfo orgTreeInfo, HashMap orgMap, HashMap orgLevelMap, HashMap orgPlayedMap, OrgStructureInfo fatherOrgStru, int targetLevel, int maxLevel) throws BOSException, EASBizException {
        if (targetLevel == 10) {
            return;
        }
        for (String orgId : orgLevelMap.keySet()) {
            int level = (Integer)orgLevelMap.get(orgId);
            if (level == targetLevel && !orgPlayedMap.containsKey(orgId)) {
                FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)orgMap.get(orgId);
                if (!this.isOnTree(ctx, orgTreeInfo.getId().toString(), orgId)) {
                    if (level == 1) {
                        fatherOrgStru = null;
                    } else {
                        fatherOrgStru = this.getParentOrgStru(iOrgStructure, orgTreeInfo.getId().toString(), orgInfo.getParent().getId().toString());
                        if (fatherOrgStru == null) {
                            HashMap<String, FullOrgUnitInfo> tempOrgMap = new HashMap<String, FullOrgUnitInfo>();
                            HashMap<String, Integer> tempOrgLvMap = new HashMap<String, Integer>();
                            HashMap tempOrgPlayedMap = new HashMap();
                            IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
                            FullOrgUnitInfo tempOrgInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getParent().getId()));
                            tempOrgMap.put(orgInfo.getParent().getId().toString(), tempOrgInfo);
                            tempOrgLvMap.put(orgInfo.getParent().getId().toString(), new Integer(tempOrgInfo.getLevel()));
                            if (tempOrgInfo.getParent() != null) {
                                this.searchLevelOrgs1(ctx, iFull, tempOrgMap, tempOrgLvMap, tempOrgInfo.getParent().getId().toString());
                            }
                            int tempMaxLevel = this.getMaxLevel(tempOrgLvMap);
                            this.buildSubOrgStru(ctx, iOrgStructure, orgTreeInfo, tempOrgMap, tempOrgLvMap, tempOrgPlayedMap, fatherOrgStru, 1, tempMaxLevel);
                            fatherOrgStru = this.getParentOrgStru(iOrgStructure, orgTreeInfo.getId().toString(), orgInfo.getParent().getId().toString());
                        }
                    }
                    OrgStructureInfo orgStruInfo = new OrgStructureInfo();
                    orgStruInfo.setLevel(orgInfo.getLevel());
                    if (level != 1 && (fatherOrgStru == null || !orgInfo.getLongNumber().startsWith(fatherOrgStru.getLongNumber()))) continue;
                    orgStruInfo.setLongNumber(orgInfo.getLongNumber());
                    orgStruInfo.setIsLeaf(orgInfo.isIsLeaf());
                    orgStruInfo.setTree(orgTreeInfo);
                    orgStruInfo.setUnit(orgInfo);
                    Collection orgTypeInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
                    Iterator it = orgTypeInfoCol.iterator();
                    OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgInfo);
                    orgStruInfo.setIsValid(false);
                    while (it.hasNext()) {
                        OrgTypeInfo orgTypeInfo = (OrgTypeInfo)it.next();
                        OrgType curOrgType = orgTypeInfo.getOrgType();
                        if (!orgTypeInfo.isBasicOrgType() || OrgType.NONE == curOrgType || !orgTypeHelper.isOrgType(curOrgType) || orgTreeInfo.getType().getValue() != curOrgType.getValue()) continue;
                        orgStruInfo.setIsValid(true);
                    }
                    orgStruInfo.setParent(fatherOrgStru);
                    iOrgStructure.addnew(orgStruInfo);
                    orgPlayedMap.put(orgId, orgId);
                    fatherOrgStru = orgStruInfo;
                }
            }
            this.buildSubOrgStru(ctx, iOrgStructure, orgTreeInfo, orgMap, orgLevelMap, orgPlayedMap, fatherOrgStru, targetLevel + 1, maxLevel);
        }
    }

    private void searchLevelOrgs(Context ctx, IFullOrgUnit iFull, HashMap orgMap, HashMap orgLevelMap, String orgId, String cuID) throws EASBizException, BOSException {
        if (!orgMap.containsKey(orgId)) {
            FullOrgUnitInfo orgInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
            orgMap.put(orgId, orgInfo);
            orgLevelMap.put(orgId, new Integer(orgInfo.getLevel()));
            if (!orgInfo.getParent().getId().toString().equals(cuID)) {
                orgId = orgInfo.getParent().getId().toString();
                this.searchLevelOrgs(ctx, iFull, orgMap, orgLevelMap, orgId, cuID);
            }
        }
    }

    private void searchLevelOrgs1(Context ctx, IFullOrgUnit iFull, HashMap orgMap, HashMap orgLevelMap, String orgId) throws EASBizException, BOSException {
        if (!orgMap.containsKey(orgId)) {
            FullOrgUnitInfo orgInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
            orgMap.put(orgId, orgInfo);
            orgLevelMap.put(orgId, new Integer(orgInfo.getLevel()));
            if (orgInfo.getParent() != null) {
                orgId = orgInfo.getParent().getId().toString();
                this.searchLevelOrgs1(ctx, iFull, orgMap, orgLevelMap, orgId);
            }
        }
    }

    private OrgStructureInfo getParentOrgStru(IOrgStructure iOrgStru, String treeId, String ouID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId));
        fi.getFilterItems().add(new FilterItemInfo("unit.id", (Object)ouID));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        SelectorItemCollection itemColl = this.getParenOrgStruSelector();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)itemColl);
        OrgStructureCollection orgStruColl = iOrgStru.getOrgStructureCollection(viewInfo);
        if (orgStruColl == null || orgStruColl.size() == 0) {
            return null;
        }
        OrgStructureInfo parent = orgStruColl.get(0);
        return parent;
    }

    @Override
    protected IObjectValue _getParent(Context ctx, String ouID, String treeId) throws BOSException, EASBizException {
        IOrgStructure iOrgStru = OrgStructureFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId));
        fi.getFilterItems().add(new FilterItemInfo("unit.id", (Object)ouID));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        SelectorItemCollection itemColl = this.getParentUnitSelector();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)itemColl);
        OrgStructureCollection orgStruColl = iOrgStru.getOrgStructureCollection(viewInfo);
        if (orgStruColl == null || orgStruColl.size() == 0) {
            return null;
        }
        OrgStructureInfo parent = orgStruColl.get(0).getParent();
        if (parent == null) {
            return null;
        }
        FullOrgUnitInfo orgInfo = parent.getUnit();
        return orgInfo;
    }

    @Override
    protected IObjectValue _getParent(Context ctx, String ouID, OrgViewType orgViewType) throws BOSException, EASBizException {
        IOrgStructure iOrgStru = OrgStructureFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(orgViewType.getValue())));
        fi.getFilterItems().add(new FilterItemInfo("unit.id", (Object)ouID));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        SelectorItemCollection itemColl = this.getParentUnitSelector();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)itemColl);
        OrgStructureCollection orgStruColl = iOrgStru.getOrgStructureCollection(viewInfo);
        if (orgStruColl == null || orgStruColl.size() == 0) {
            return null;
        }
        OrgStructureInfo parent = orgStruColl.get(0).getParent();
        if (parent == null) {
            return null;
        }
        FullOrgUnitInfo orgInfo = parent.getUnit();
        return orgInfo;
    }

    private SelectorItemCollection getParentUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.unit.isGrouping"));
        sic.add(new SelectorItemInfo("parent.unit.effectDate"));
        sic.add(new SelectorItemInfo("parent.unit.invalidDate"));
        sic.add(new SelectorItemInfo("parent.unit.isFreeze"));
        sic.add(new SelectorItemInfo("parent.unit.isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("parent.unit.isAdminOrgUnit"));
        sic.add(new SelectorItemInfo("parent.unit.isSaleOrgUnit"));
        sic.add(new SelectorItemInfo("parent.unit.isPurchaseOrgUnit"));
        sic.add(new SelectorItemInfo("parent.unit.isStorageOrgUnit"));
        sic.add(new SelectorItemInfo("parent.unit.isProfitOrgUnit"));
        sic.add(new SelectorItemInfo("parent.unit.isCostOrgUnit"));
        sic.add(new SelectorItemInfo("parent.unit.orgTypeStr"));
        sic.add(new SelectorItemInfo("parent.unit.isCU"));
        sic.add(new SelectorItemInfo("parent.unit.isLeaf"));
        sic.add(new SelectorItemInfo("parent.unit.level"));
        sic.add(new SelectorItemInfo("parent.unit.longNumber"));
        sic.add(new SelectorItemInfo("parent.unit.name"));
        sic.add(new SelectorItemInfo("parent.unit.number"));
        sic.add(new SelectorItemInfo("parent.unit.description"));
        sic.add(new SelectorItemInfo("parent.unit.simpleName"));
        sic.add(new SelectorItemInfo("parent.unit.createTime"));
        sic.add(new SelectorItemInfo("parent.unit.lastUpdateTime"));
        sic.add(new SelectorItemInfo("parent.unit.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    private SelectorItemCollection getParenOrgStruSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isValid"));
        sic.add(new SelectorItemInfo("tree"));
        sic.add(new SelectorItemInfo("unit"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, String ouID, String treeId) throws BOSException, EASBizException {
        return this._getChildren(ctx, ouID, treeId, false);
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, String cuID, String treeID, boolean isContainSealUp) throws BOSException, EASBizException {
        boolean isUnion = !treeID.startsWith("00000000-0000-0000-0000-00000000000");
        IOrgStructure iOrgStru = OrgStructureFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID));
        fi.getFilterItems().add(new FilterItemInfo("parent.unit.id", (Object)cuID));
        if (!(isContainSealUp || treeID.equals("00000000-0000-0000-0000-0000000000014F2827FD") || isUnion)) {
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID);
            String fieldLike = OrgTypeHelper.createLikeStr(orgTypeInfo.getOrgType());
            fi.getFilterItems().add(new FilterItemInfo("orgTypeStr", (Object)fieldLike, CompareType.NOTLIKE));
        }
        viewInfo.setFilter(fi);
        SelectorItemCollection itemColl = this.getUnitSelector();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)itemColl);
        OrgStructureCollection orgStruColl = iOrgStru.getOrgStructureCollection(viewInfo);
        if (orgStruColl == null || orgStruColl.size() == 0) {
            return null;
        }
        FullOrgUnitCollection orgColl = new FullOrgUnitCollection();
        for (int i = 0; i < orgStruColl.size(); ++i) {
            FullOrgUnitInfo orgInfo = orgStruColl.get(i).getUnit();
            orgColl.add(orgInfo);
        }
        return orgColl;
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, String ouID, OrgViewType orgViewType) throws BOSException, EASBizException {
        return this._getChildren(ctx, ouID, orgViewType, false);
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, String cuID, OrgViewType orgViewType) throws BOSException, EASBizException {
        BizOrgQueryParam subBizParam = new BizOrgQueryParam();
        subBizParam.setBizObjType("BIZOBJ_VIEW");
        subBizParam.setOrgOUSealType("FALSE");
        return this.getAllChildren(ctx, cuID, orgViewType, subBizParam);
    }

    private IObjectCollection getAllChildren(Context ctx, String cuID, OrgViewType orgViewType, BizOrgQueryParam subBizParam) throws BOSException, EASBizException {
        BizOrgQueryParam bizParam = new BizOrgQueryParam();
        bizParam.setBizObjType("BIZOBJ_VIEW");
        bizParam.setOrgId(cuID);
        IOrgAppHelper iOrgHelper = OrgTypeAppCenter.getInstance().getHelper(OrgType.getEnum(orgViewType.getValue()));
        OrgUnitCollection orgCol = OrgAppHelper.getOrgUnitCollection(ctx, iOrgHelper, bizParam);
        if (orgCol == null || orgCol.isEmpty()) {
            return null;
        }
        OrgUnitInfo orgInfo = orgCol.get(0);
        subBizParam.setSubLongNumber(orgInfo.getLongNumber());
        return OrgAppHelper.getOrgUnitCollection(ctx, iOrgHelper, subBizParam);
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, String cuID, OrgViewType orgViewType, boolean isContainSealUp) throws BOSException, EASBizException {
        BizOrgQueryParam subBizParam = new BizOrgQueryParam();
        subBizParam.setBizObjType("BIZOBJ_VIEW");
        if (!isContainSealUp) {
            subBizParam.setOrgOUSealType(BizOrgQueryParam.getBooleanParam(isContainSealUp));
        }
        return this.getAllChildren(ctx, cuID, orgViewType, subBizParam);
    }

    private SelectorItemCollection getUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("unit.isGrouping"));
        sic.add(new SelectorItemInfo("unit.effectDate"));
        sic.add(new SelectorItemInfo("unit.invalidDate"));
        sic.add(new SelectorItemInfo("unit.isFreeze"));
        sic.add(new SelectorItemInfo("unit.isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isAdminOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isSaleOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isPurchaseOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isStorageOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isProfitOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isCostOrgUnit"));
        sic.add(new SelectorItemInfo("unit.orgTypeStr"));
        sic.add(new SelectorItemInfo("unit.isCU"));
        sic.add(new SelectorItemInfo("unit.isLeaf"));
        sic.add(new SelectorItemInfo("unit.level"));
        sic.add(new SelectorItemInfo("unit.longNumber"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.description"));
        sic.add(new SelectorItemInfo("unit.simpleName"));
        sic.add(new SelectorItemInfo("unit.createTime"));
        sic.add(new SelectorItemInfo("unit.lastUpdateTime"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    @Override
    protected IObjectCollection _getBrothers(Context ctx, String ouID, String treeId) throws BOSException, EASBizException {
        FullOrgUnitInfo parent = (FullOrgUnitInfo)this._getParent(ctx, ouID, treeId);
        if (parent == null) {
            return null;
        }
        FullOrgUnitCollection sonColl = (FullOrgUnitCollection)this._getChildren(ctx, parent.getId().toString(), treeId);
        for (int i = 0; sonColl != null && i < sonColl.size(); ++i) {
            if (!sonColl.get(i).getId().toString().equals(ouID)) continue;
            sonColl.removeObject(i);
        }
        return sonColl;
    }

    @Override
    protected IObjectCollection _getBrothers(Context ctx, String ouID, OrgViewType orgViewType) throws BOSException, EASBizException {
        FullOrgUnitInfo parent = (FullOrgUnitInfo)this._getParent(ctx, ouID, orgViewType);
        if (parent == null) {
            return null;
        }
        FullOrgUnitCollection sonColl = (FullOrgUnitCollection)this._getChildren(ctx, parent.getId().toString(), orgViewType);
        for (int i = 0; sonColl != null && i < sonColl.size(); ++i) {
            if (!sonColl.get(i).getId().toString().equals(ouID)) continue;
            sonColl.removeObject(i);
        }
        return sonColl;
    }

    @Override
    protected void _rebuildAllView(Context ctx) throws BOSException, EASBizException {
        Collection orgTypeInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            OrgType curOrgType = orgTypeInfo.getOrgType();
            if (!orgTypeInfo.isBasicOrgType() || OrgType.NONE == curOrgType) continue;
            this._innerRebuildOUView(ctx, orgTypeInfo.getOrgViewType(), orgTypeInfo.getOrgTreeID());
        }
    }

    private void _insertSYSCU(PreparedStatement pstmt, Statement stmt) throws BOSException, EASBizException {
        ResultSet rs = null;
        try {
            String sql = "SELECT flongnumber,flevel,fisleaf FROM T_ORG_BaseUnit WHERE FID='11111111-1111-1111-1111-111111111111CCE7AED4'";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                String ln = rs.getString("FLongNumber");
                int level = rs.getInt("FLevel");
                int isLeaf = rs.getInt("FIsLeaf");
                String structID = NewOrgViewHelper.getNewStructID();
                pstmt.setString(1, structID);
                pstmt.setString(2, "00000000-0000-0000-0000-0000000000014F2827FD");
                pstmt.setString(3, "11111111-1111-1111-1111-111111111111CCE7AED4");
                pstmt.setString(4, null);
                pstmt.setString(5, ln);
                pstmt.setInt(6, isLeaf);
                pstmt.setInt(7, level);
                pstmt.setInt(8, 0);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQLError:" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private boolean isValid(OrgViewType type, ResultSet rs) throws SQLException {
        String orgTypeStr = rs.getString("orgTypeStr");
        return OrgTypeHelper.isOrgType(orgTypeStr, OrgType.getEnum(type.getValue()));
    }

    private String viewType2ColumnName(OrgViewType type) {
        String partSql = "(FIsCU=1 OR FOrgTypeStr like '%orgTypeCondition%')";
        String orgCon = OrgTypeHelper.createLikeStr(OrgType.getEnum(type.getValue()));
        return StringUtils.replace((String)partSql, (String)"orgTypeCondition", (String)orgCon);
    }

    private void _innerRebuildOUView(Context ctx, OrgViewType viewType, String treeID) throws BOSException, EASBizException {
        Connection con = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap<String, String> ou2struct = new HashMap<String, String>();
        HashMap<String, String> ln2ID = new HashMap<String, String>();
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            stmt.executeUpdate("DELETE FROM T_ORG_Structure WHERE FTreeID='" + treeID + "'");
            rs = stmt.executeQuery("SELECT FLongNumber FROM T_ORG_BaseUnit WHERE FID='00000000-0000-0000-0000-000000000000CCE7AED4'");
            String rootLn = null;
            if (rs.next()) {
                rootLn = rs.getString("FLongNumber");
            }
            rs.close();
            if (rootLn == null) {
                throw new RuntimeException("not specify root");
            }
            String sql = "SELECT fid,flongnumber,flevel,fisleaf FROM T_ORG_BaseUnit WHERE (FLongNumber='" + rootLn + "' OR FLongNumber Like '" + rootLn + "!%') AND " + this.viewType2ColumnName(viewType) + " ORDER BY FLongNumber";
            String insertSql = "INSERT INTO T_ORG_Structure (FID,FTreeID,FUnitID,FParentID,FLongNumber,FIsLeaf,FLevel,FIsValid) VALUES(?,?,?,?,?,?,?,?)";
            rs = stmt.executeQuery(sql);
            pstmt = con.prepareStatement(insertSql);
            while (rs.next()) {
                String unitID = rs.getString("FID");
                String ln = rs.getString("FLongNumber");
                int level = rs.getInt("FLevel");
                int isLeaf = rs.getInt("FIsLeaf");
                String structID = NewOrgViewHelper.getNewStructID();
                ou2struct.put(unitID, structID);
                String parentStructID = (String)ou2struct.get(NewOrgViewHelper.getParentIDByLn(ln, ln2ID));
                ln2ID.put(ln, unitID);
                boolean valid = this.isValid(viewType, rs);
                pstmt.setString(1, structID);
                pstmt.setString(2, treeID);
                pstmt.setString(3, unitID);
                pstmt.setString(4, parentStructID);
                pstmt.setString(5, ln);
                pstmt.setInt(6, isLeaf);
                pstmt.setInt(7, level);
                pstmt.setInt(8, valid ? 1 : 0);
                pstmt.executeUpdate();
            }
            if (viewType.equals((Object)OrgViewType.CTRLUNIT)) {
                this._insertSYSCU(pstmt, stmt);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQLError:" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)con);
    }

    @Override
    protected void _updateBizView(Context ctx, IObjectValue unitInfo, boolean isUpdate) throws BOSException, EASBizException {
        FullOrgUnitInfo unit = (FullOrgUnitInfo)unitInfo;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        if (unit.isIsCU()) {
            OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select id,longNumber,level,sortCode,displayName, parent.unit.id, parent.longNumber, parent.level, parent.displayName, parent.sortCode,unit.number, unit.name Where unit.id = '" + unit.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000014F2827FD" + "'");
            ObjectUuidPK pk = new ObjectUuidPK(structInfo.getId());
            iStruct.update((IObjectPK)pk, structInfo);
        }
        OrgTypeAppCenter.getInstance().updateStructure(ctx, unit, isUpdate);
    }

    @Override
    protected void _updateBizParent(Context ctx, OrgType orgType, String id, String parentId) throws BOSException, EASBizException {
        OrgTypeAppCenter.getInstance().getHelper(orgType).updateBizParent(ctx, id, parentId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longNumber"));
        OrgUnitInfo newParent = NewOrgUnitHelper.getTypedOrgUnit(ctx, parentId, sic, orgType);
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        OrgUnitInfo unitInfo = NewOrgUnitHelper.getTypedOrgUnit(ctx, id, sic, orgType);
        OrgUnitInfo oldParent = (OrgUnitInfo)unitInfo.get("parent");
        OrgLogServerUtils.log(ctx, (IObjectValue)unitInfo, oldParent, newParent);
        FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
        orgUnitInfo.setId(unitInfo.getId());
        orgUnitInfo.setOrgTypeStr(orgType.getName());
        orgUnitInfo.setLongNumber(unitInfo.getLongNumber());
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(orgUnitInfo, 4);
        this.otherDealUpdateParent(ctx, orgType, id, parentId);
    }

    private void otherDealUpdateParent(Context ctx, OrgType orgType, String id, String parentId) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"97A1E2E8", IOtherDealUpdateParent.class);
            if (checks != null && checks.length > 0) {
                IOtherDealUpdateParent otherDealUpdateParentCheck = null;
                for (int i = 0; i < checks.length; ++i) {
                    otherDealUpdateParentCheck = (IOtherDealUpdateParent)Class.forName(checks[i]).newInstance();
                    otherDealUpdateParentCheck.afterDeal(ctx, orgType, id, parentId);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void innerUpdateBizParent(Context ctx, OrgStructureInfo structInfo, OrgStructureInfo parentStructInfo) throws BOSException, EASBizException {
        structInfo.setParent(parentStructInfo);
        structInfo.setIsValid(true);
        ObjectUuidPK pk = new ObjectUuidPK(structInfo.getId());
        OrgStructureFactory.getLocalInstance(ctx).update((IObjectPK)pk, structInfo);
    }

    @Override
    protected void _bizOrgUnite(Context ctx, OrgType orgType, String id, String targetId) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null) {
            return;
        }
        String treeId = orgTypeInfo.getOrgTreeID();
        OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select unit.number, unit.name Where unit.id = '" + id + "' and tree.id = '" + treeId + "'");
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(orgType);
        this.bizOrgUnite(ctx, orgAppHelper, treeId, targetId);
        NewOUInnerFacadeFactory.getLocalInstance(ctx).bizSealUp(id, orgType.getValue());
        OrgLogServerUtils.log(ctx, OrgLogServerUtils.convert(orgType), OrgLogTypeEnum.UNITE, (IObjectValue)structInfo.getUnit());
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables();
    }

    private void bizOrgUnite(Context ctx, IOrgAppHelper orgAppHelper, String id, String targetId) throws BOSException, EASBizException {
        OrgStructureInfo targetStructInfo;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgType curOrgType = orgAppHelper.getOrgTypeSelfInfo().getOrgType();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(curOrgType);
        if (orgTypeInfo == null) {
            return;
        }
        String treeId = orgTypeInfo.getOrgTreeID();
        OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select id,longNumber,level,sortCode,displayName, parent.unit.id, parent.longNumber, parent.level, parent.displayName,parent.sortCode, unit.number, unit.name Where unit.id = '" + id + "' and tree.id = '" + treeId + "'");
        if (OrgAppHelper.existBizSuperiorLoop(ctx, structInfo, targetStructInfo = iStruct.getOrgStructureInfo("Select id,longNumber,level,sortCode,displayName, parent.unit.id, parent.longNumber, parent.level, parent.displayName, parent.sortCode,unit.number, unit.name Where unit.id = '" + targetId + "' and tree.id = '" + treeId + "'"))) {
            Object[] params = new String[]{curOrgType.getAlias()};
            throw new OUException(OUException.ORG_UNITE_LOOP, params);
        }
        OrgStructureCollection subStructCol = iStruct.getOrgStructureCollection("SELECT id,longNumber,level,sortCode,displayName, parent.unit.id, parent.longNumber, parent.level, parent.displayName, parent.sortCode,unit.number, unit.name WHERE parent.id = '" + structInfo.getId().toString() + "' AND tree.id = '" + "00000000-0000-0000-0000-0000000000034F2827FD" + "'");
        int n = subStructCol.size();
        for (int i = 0; i < n; ++i) {
            OrgStructureInfo subStructInfo = subStructCol.get(i);
            this.innerUpdateBizParent(ctx, subStructInfo, targetStructInfo);
        }
    }

    @Override
    protected void _updateBizViewOnCU(Context ctx, IObjectValue unitInfo) throws BOSException, EASBizException {
        FullOrgUnitInfo unit = (FullOrgUnitInfo)unitInfo;
        OrgTypeAppCenter.getInstance().updateBizViewOnCU(ctx, unit);
    }

    @Override
    protected void _addBizViewOnCU(Context ctx, IObjectValue unitInfo) throws BOSException, EASBizException {
        FullOrgUnitInfo unit = (FullOrgUnitInfo)unitInfo;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        String parentId = unit.getParent().getId().toString();
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000014F2827FD"));
        OrgStructureInfo self = new OrgStructureInfo();
        this.setParentStureInfo(ctx, iStruct, parentId, self);
        self.setTree(treeInfo);
        self.setUnit(unit);
        self.setIsValid(true);
        iStruct.addnew(self);
    }

    private void setParentStureInfo(Context ctx, IOrgStructure iStruct, String parentId, OrgStructureInfo self) throws BOSException, EASBizException {
        String existOql = "select 1 where tree.id='00000000-0000-0000-0000-0000000000014F2827FD' and unit.id = '" + parentId + "'";
        if (iStruct.exists(existOql)) {
            String oql = "Select id,longNumber,level,sortCode,displayName, parent.unit.id, parent.longNumber, parent.level, parent.displayName,parent.sortCode,unit.name,unit.number Where tree.id = '00000000-0000-0000-0000-0000000000014F2827FD' and unit.id = '" + parentId + "'";
            OrgStructureInfo structureInfo = iStruct.getOrgStructureInfo(oql);
            self.setParent(structureInfo);
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("parent"));
            FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(parentId), sic);
            this.setParentStureInfo(ctx, iStruct, unitInfo.getParent().getId().toString(), self);
        }
    }

    private void checkBizSuperior(Context ctx, FullOrgUnitInfo unitInfo, boolean isUpdate) throws BOSException, EASBizException {
        if (!isUpdate) {
            return;
        }
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection col = iStruct.getOrgStructureCollection("Select tree.id Where unit.id = '" + unitInfo.getId().toString() + "' and isValid = 1");
        if (col != null && col.size() > 0) {
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper(unitInfo);
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                OrgStructureInfo info = col.get(i);
                String treeID = info.getTree().getId().toString();
                boolean change = false;
                Collection orgCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
                for (OrgTypeInfo curOrgTypeInfo : orgCol) {
                    OrgType curOrgType = curOrgTypeInfo.getOrgType();
                    if (!curOrgTypeInfo.isBasicOrgType() || ToolUtils.equalObject((Object)((Object)curOrgType), (Object)((Object)OrgType.ControlUnit)) || ToolUtils.equalObject((Object)((Object)curOrgType), (Object)((Object)OrgType.NONE)) || !treeID.equals(curOrgTypeInfo.getOrgTreeID()) || !orgTypeHelper.isOrgType(curOrgType)) continue;
                    change = true;
                    break;
                }
                if (!change) continue;
                throw new OUException(OUException.CANT_DELETE_BIZPROPERTY);
            }
        }
    }

    @Override
    protected boolean _isBizChildrenExist(Context ctx, IObjectValue unitInfo, String treeID) throws BOSException, EASBizException {
        FullOrgUnitInfo unit = (FullOrgUnitInfo)unitInfo;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo structInfo = null;
        try {
            structInfo = iStruct.getOrgStructureInfo("Select longNumber Where unit.id = '" + unit.getId().toString() + "' and tree.id = '" + treeID + "'");
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        String longNumber = structInfo.getLongNumber();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)longNumber, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        return iStruct.exists(filter);
    }

    @Override
    protected IRowSet _buildViewRowSet2(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual) throws BOSException, EASBizException {
        return this.buildViewRowSetCommon(ctx, treeID, rootUnitID, isContainSealUp, BizOrgQueryParam.getBooleanParam(isShowVirtual));
    }

    private IRowSet buildViewRowSetCommon(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, String isVirtualType) throws BOSException, EASBizException {
        QueryOrgStructSqlHelper querySqlHelper = new QueryOrgStructSqlHelper();
        return querySqlHelper.getViewRowSetCommon(ctx, treeID, rootUnitID, isContainSealUp, isVirtualType);
    }

    @Override
    protected IRowSet _buildViewRowSet(Context ctx, String orgViewID, String rootUnitID, boolean isContainSealUp) throws BOSException, EASBizException {
        return this.buildViewRowSetCommon(ctx, orgViewID, rootUnitID, isContainSealUp, "ALL");
    }

    @Override
    protected IRowSet _buildViewRowSet3(Context ctx, String orgViewID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, boolean isUseDataPerm) throws BOSException, EASBizException {
        return this.buildViewRowSetCommon(ctx, orgViewID, rootUnitID, isContainSealUp, "ALL");
    }

    @Override
    protected IRowSet _buildViewRowSet4(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, int level, boolean isShowAssistantOrg) throws BOSException, EASBizException {
        throw new IllegalArgumentException("_buildViewRowSet4 is deprecated ,please use buildViewRowSet4New!");
    }

    @Override
    protected OrgStructureCollection _buildViewRowSet4New(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, int level, boolean isShowAssistantOrg, boolean isRevised, StepAddParamInfo stepAddParamInfo) throws BOSException, EASBizException {
        QueryOrgStructSqlHelper sqlHelper = new QueryOrgStructSqlHelper();
        return sqlHelper.getOrgStructureDetailCol(ctx, treeID, rootUnitID, isContainSealUp, isShowVirtual, level, isShowAssistantOrg, stepAddParamInfo, isRevised);
    }

    private String getOrgFilterStr(Context ctx, String orgId, boolean queryInCu) throws BOSException, EASBizException {
        StringBuffer sqlStr = new StringBuffer();
        if (queryInCu) {
            return sqlStr.append("and baseunit.FControlUnitID = '").append(orgId).append("'").toString();
        }
        if (orgId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            return "";
        }
        String rootLongNumber = "";
        String oql = "select longNumber where id = '" + orgId + "'";
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        rootLongNumber = iFull.exists(oql) ? iFull.getFullOrgUnitCollection(oql).get(0).getLongNumber() : "###@$@###";
        sqlStr.append(" and ( flongnumber = '").append(rootLongNumber).append("' or flongnumber like '").append(rootLongNumber).append("!%')");
        return sqlStr.toString();
    }

    private FullOrgUnitCollection buildOURowSetCommon(Context ctx, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, boolean queryInCu) throws BOSException, EASBizException {
        try {
            String[] allFieldName = "id,number,name,code,englishName,simpleName,description,isCU,level,longNumber,isLeaf,isOUSealUp,parent,isAssistantOrg,orgTypeStr".split(",");
            EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(new FullOrgUnitInfo().getBOSType());
            String allFieldNameStr = OrgAppHelper.getSelectFieldFactName2Str(ctx, "baseunit", allFieldName, entityObjInfo);
            StringBuffer sqlStr = new StringBuffer("");
            sqlStr.append(" select ").append(allFieldNameStr).append(" from T_ORG_BaseUnit baseunit left join T_ORG_OUPartAdmin oupartadmin on baseunit.FID = oupartadmin.FUnitID ");
            sqlStr.append(" where FIsUnion = 0 and baseunit.fid<>'").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ");
            sqlStr.append(this.getOrgFilterStr(ctx, rootUnitID, queryInCu));
            if (!isContainSealUp) {
                sqlStr.append(" and FISOUSealUp = 0 ");
            }
            if (!isShowVirtual) {
                sqlStr.append(" and (FIsAdminOrgUnit = 0 or oupartadmin.FIsVirtual = 0 or oupartadmin.FIsVirtual is null ) ");
            }
            sqlStr.append(" order by flongnumber asc ");
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
            FullOrgUnitCollection fullCol = new FullOrgUnitCollection();
            while (row.next()) {
                FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
                fullInfo.setId(BOSUuid.read((String)row.getString("baseunit.fid")));
                fullInfo.setNumber(row.getString("baseunit.fnumber"));
                fullInfo.setName(row.getString("baseunit.fname"));
                fullInfo.setCode(row.getString("baseunit.fcode"));
                fullInfo.setEnglishName(row.getString("baseunit.fenglishName"));
                fullInfo.setSimpleName(row.getString("baseunit.fsimpleName"));
                fullInfo.setDescription(row.getString("baseunit.FDescription"));
                fullInfo.setLevel(row.getInt("baseunit.flevel"));
                fullInfo.setLongNumber(row.getString("baseunit.flongNumber"));
                fullInfo.setIsLeaf(row.getBoolean("baseunit.fisLeaf"));
                fullInfo.setIsOUSealUp(row.getBoolean("baseunit.fisOUSealUp"));
                fullInfo.setOrgTypeStr(row.getString("baseunit.forgTypeStr"));
                OrgTypeHelper.createOrgType4FullOrg(fullInfo);
                String parentId = row.getString("baseunit.FParentID");
                if (parentId != null) {
                    FullOrgUnitInfo parentInfo = new FullOrgUnitInfo();
                    parentInfo.setId(BOSUuid.read((String)parentId));
                    fullInfo.setParent(parentInfo);
                }
                fullCol.add(fullInfo);
            }
            return fullCol;
        }
        catch (UuidException e) {
            logger.error((Object)"UuidException error!", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"sql error!", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IRowSet _buildOURowSet(Context ctx, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("isUnion", (Object)new Integer(0), CompareType.EQUALS));
        if (!rootUnitID.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            String rootLongNumber = "";
            String oql = "select longNumber where id = '" + rootUnitID + "'";
            rootLongNumber = iFull.exists(oql) ? iFull.getFullOrgUnitCollection(oql).get(0).getLongNumber() : "###@$@###";
            filter1.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootLongNumber, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootLongNumber + "!%"), CompareType.LIKE));
            filter1.setMaskString("#0 and (#1 or #2)");
        }
        if (!isContainSealUp) {
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)new Integer(0), CompareType.EQUALS));
            filter1.mergeFilter(filter2, "and");
        }
        if (!isShowVirtual) {
            FilterInfo filter3 = new FilterInfo();
            filter3.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(0), CompareType.EQUALS));
            filter3.getFilterItems().add(new FilterItemInfo("partAdmin.isVirtual", (Object)new Integer(0), CompareType.EQUALS));
            filter3.setMaskString("#0 or #1");
            filter1.mergeFilter(filter3, "and");
        }
        viewInfo.setFilter(filter1);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.OUQuery");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcutor.setObjectView(viewInfo);
        return queryExcutor.executeQuery();
    }

    @Override
    protected FullOrgUnitCollection _buildOURowSetNew(Context ctx, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual) throws BOSException, EASBizException {
        return this.buildOURowSetCommon(ctx, rootUnitID, isContainSealUp, isShowVirtual, false);
    }

    @Override
    protected FullOrgUnitCollection _buildOURowSetByCUFilter(Context ctx, String cuID, boolean isContainSealUp, boolean isShowVirtual) throws BOSException, EASBizException {
        return this.buildOURowSetCommon(ctx, cuID, isContainSealUp, isShowVirtual, true);
    }

    private boolean isCUBizPropertyExistInOU(Context ctx, FullOrgUnitInfo unit, int orgType) throws BOSException, EASBizException {
        if (!unit.isIsCU()) {
            return false;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)unit.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)unit.getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgTypeStr", (Object)OrgTypeHelper.createLikeStr(OrgType.getEnum(orgType)), CompareType.LIKE));
        filter.setMaskString("#0 and #1 and #2");
        return iFull.exists(filter);
    }

    private boolean isDelegatedByOthers(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegateFacade = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        return iDelegateFacade.isDelegatedByOthers(unit.getId().toString(), orgTypeValue);
    }

    private void deleteSelfDelegate(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegateFacade = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        iDelegateFacade.deleteSelfDelegateOnType(unit.getId().toString(), orgTypeValue);
    }

    @Override
    protected void _rebuildReponseView(Context ctx) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement insertStmt = null;
        Statement stmt = null;
        HashMap<String, Integer> mapCost = new HashMap<String, Integer>();
        ArrayList<OrgStructureInfo> alCost = new ArrayList<OrgStructureInfo>();
        HashMap<String, OrgStructureInfo> mapRes = new HashMap<String, OrgStructureInfo>();
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureCollection costCol = iStruct.getOrgStructureCollection("Select *,parent.unit.id Where tree.id = '00000000-0000-0000-0000-0000000000054F2827FD' order by longNumber asc");
        int n = costCol.size();
        for (int i = 0; i < n; ++i) {
            OrgStructureInfo record = costCol.get(i);
            mapCost.put(record.getUnit().getId().toString(), new Integer(i));
            alCost.add(record);
        }
        OrgStructureCollection profitCol = iStruct.getOrgStructureCollection("Select id,longNumber,level,sortCode,displayName,isLeaf,parent.id,parent.unit.id Where tree.id = '00000000-0000-0000-0000-0000000000044F2827FD' order by longNumber asc");
        try {
            String parentID;
            int i;
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            stmt.executeUpdate("delete from T_ORG_Structure where FTreeID = '00000000-0000-0000-0000-0000000000094F2827FD'");
            String insertSql = "INSERT INTO T_ORG_Structure (FID,FTreeID,FUnitID,FParentID,FLongNumber,FIsLeaf,FLevel,FIsValid) VALUES(?,?,?,?,?,?,?,?)";
            insertStmt = con.prepareStatement(insertSql);
            HashMap<String, String> mapLink = new HashMap<String, String>();
            int n2 = profitCol.size();
            for (i = 0; i < n2; ++i) {
                OrgStructureInfo recordProfit = profitCol.get(i);
                OrgStructureInfo recordRes = new OrgStructureInfo();
                String id = NewOrgViewHelper.getNewStructID();
                insertStmt.setString(1, id);
                recordRes.setId(BOSUuid.read((String)id));
                mapLink.put(recordProfit.getId().toString(), id);
                insertStmt.setString(2, "00000000-0000-0000-0000-0000000000094F2827FD");
                OrgTreeInfo treeInfo = new OrgTreeInfo();
                treeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000094F2827FD"));
                recordRes.setTree(treeInfo);
                insertStmt.setString(3, recordProfit.getUnit().getId().toString());
                recordRes.setUnit(recordProfit.getUnit());
                OrgStructureInfo oldParent = recordProfit.getParent();
                if (oldParent == null) {
                    insertStmt.setString(4, null);
                    recordRes.setParent(null);
                } else {
                    parentID = (String)mapLink.get(oldParent.getId().toString());
                    insertStmt.setString(4, parentID);
                    OrgStructureInfo parentInfo = new OrgStructureInfo();
                    parentInfo.setId(BOSUuid.read((String)parentID));
                    recordRes.setParent(parentInfo);
                }
                insertStmt.setString(5, recordProfit.getLongNumber());
                recordRes.setLongNumber(recordProfit.getLongNumber());
                insertStmt.setInt(6, recordProfit.isIsLeaf() ? 1 : 0);
                recordRes.setIsLeaf(recordProfit.isIsLeaf());
                insertStmt.setInt(7, recordProfit.getLevel());
                recordRes.setLevel(recordProfit.getLevel());
                insertStmt.setInt(8, 1);
                recordRes.setIsValid(true);
                insertStmt.executeUpdate();
                mapRes.put(recordRes.getUnit().getId().toString(), recordRes);
            }
            for (i = profitCol.size() - 1; i >= 0; --i) {
                OrgStructureInfo recordProfit = profitCol.get(i);
                ArrayList costNodes = this.searchNodeInMap(recordProfit.getUnit().getId().toString(), mapCost, alCost);
                int m = costNodes.size();
                for (int j = 0; j < m; ++j) {
                    OrgStructureInfo recordCost = (OrgStructureInfo)costNodes.get(j);
                    if (mapRes.containsKey(recordCost.getUnit().getId().toString())) continue;
                    OrgStructureInfo parentInfo = (OrgStructureInfo)mapRes.get(recordCost.getParent().getUnit().getId().toString());
                    parentID = parentInfo.getId().toString();
                    String ln = parentInfo.getLongNumber() + "!" + this.getNumberFromLongNumber(recordCost.getLongNumber());
                    int level = parentInfo.getLevel() + 1;
                    String id = NewOrgViewHelper.getNewStructID();
                    OrgStructureInfo recordRes = new OrgStructureInfo();
                    insertStmt.setString(1, id);
                    recordRes.setId(BOSUuid.read((String)id));
                    insertStmt.setString(2, "00000000-0000-0000-0000-0000000000094F2827FD");
                    OrgTreeInfo treeInfo = new OrgTreeInfo();
                    treeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000094F2827FD"));
                    recordRes.setTree(treeInfo);
                    insertStmt.setString(3, recordCost.getUnit().getId().toString());
                    recordRes.setUnit(recordCost.getUnit());
                    insertStmt.setString(4, parentID);
                    recordRes.setParent(parentInfo);
                    insertStmt.setString(5, ln);
                    recordRes.setLongNumber(ln);
                    insertStmt.setInt(6, 1);
                    recordRes.setIsLeaf(true);
                    insertStmt.setInt(7, level);
                    recordRes.setLevel(level);
                    insertStmt.setInt(8, 1);
                    recordRes.setIsValid(true);
                    insertStmt.executeUpdate();
                    mapRes.put(recordRes.getUnit().getId().toString(), recordRes);
                    stmt.executeUpdate("update T_ORG_Structure set FIsLeaf = 0 where FID = '" + parentID + "'");
                }
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException("Rebuild ResponseCenter SQL Error!", (Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(insertStmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Statement)insertStmt);
        SQLUtils.cleanup((Connection)con);
    }

    private ArrayList searchNodeInMap(String unitID, HashMap mapCost, ArrayList alCost) {
        ArrayList<OrgStructureInfo> ret = new ArrayList<OrgStructureInfo>();
        if (mapCost.containsKey(unitID)) {
            int i = (Integer)mapCost.get(unitID);
            OrgStructureInfo recordCost = (OrgStructureInfo)alCost.get(i);
            String rootLnStr = recordCost.getLongNumber() + "!";
            int n = alCost.size();
            for (int j = i + 1; j < n; ++j) {
                recordCost = (OrgStructureInfo)alCost.get(j);
                if (!recordCost.getLongNumber().startsWith(rootLnStr)) continue;
                ret.add(recordCost);
            }
        }
        return ret;
    }

    private String getNumberFromLongNumber(String longNumber) {
        String[] segments = longNumber.split("!");
        if (segments != null) {
            return segments[segments.length - 1];
        }
        return null;
    }

    @Override
    protected IObjectCollection _buildViewSubordinateCollection(Context ctx, String parentID, String orgViewID, boolean isOnlyDirectSubordinate, boolean isContainSealUp) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        String oql = "Select longNumber,level Where unit.id = '" + parentID + "' and tree.id = '" + orgViewID + "'";
        OrgStructureInfo parentStructInfo = null;
        if (!iStruct.exists(oql)) {
            return new OrgStructureCollection();
        }
        parentStructInfo = iStruct.getOrgStructureInfo(oql);
        String parentLongNumber = parentStructInfo.getLongNumber();
        int parentLevel = parentStructInfo.getLevel();
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("unit.id"));
        QueryOrgStructSqlHelper sqlHelper = new QueryOrgStructSqlHelper();
        StepAddParamInfo stepInfo = new StepAddParamInfo();
        stepInfo.setCurLevel(parentLevel);
        stepInfo.setCurLongNumber(parentLongNumber);
        stepInfo.setFetchTwoLayerData(false);
        if (isOnlyDirectSubordinate) {
            stepInfo.setCurLevel(parentLevel);
        } else {
            stepInfo.setCurLevel(-1);
        }
        return sqlHelper.getOrgStructureDetailCol(ctx, "00000000-0000-0000-0000-0000000000014F2827FD", parentID, isContainSealUp, true, parentLevel, true, stepInfo, false);
    }

    @Override
    protected IObjectCollection _buildViewSuperiorCollection(Context ctx, String currentOUID, String orgViewID) throws BOSException, EASBizException {
        String oql;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        if (!iStruct.exists(oql = "Select parent.id Where tree.id = '" + orgViewID + "' and unit.id = '" + currentOUID + "'")) {
            return new OrgStructureCollection();
        }
        Stack<OrgStructureInfo> stack = new Stack<OrgStructureInfo>();
        OrgStructureInfo currentStruct = iStruct.getOrgStructureInfo(oql);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        for (OrgStructureInfo parentStruct = currentStruct.getParent(); parentStruct != null; parentStruct = parentStruct.getParent()) {
            BOSUuid parentUuid = parentStruct.getId();
            parentStruct = iStruct.getOrgStructureInfo((IObjectPK)new ObjectUuidPK(parentUuid), sic);
            stack.push(parentStruct);
        }
        OrgStructureCollection ret = new OrgStructureCollection();
        while (stack.size() > 0) {
            ret.add((OrgStructureInfo)stack.pop());
        }
        return ret;
    }

    @Override
    protected IObjectValue _findBizSuperiorInCU(Context ctx, IObjectValue model, int orgType) throws BOSException, EASBizException {
        if (model == null || !(model instanceof FullOrgUnitInfo)) {
            throw new IllegalArgumentException(" model is null!");
        }
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(orgType);
        FullOrgUnitInfo fullOrgUnit = (FullOrgUnitInfo)model;
        BOSObjectType bosType = orgAppHelper.getOrgTypeSelfInfo().getOrgViewBosType();
        BizOrgQueryParam queryParam = new BizOrgQueryParam();
        queryParam.setBizUnitType("FALSE");
        return OrgAppHelper.findBizSuperiorOrg(ctx, fullOrgUnit, bosType, queryParam, OrgType.getEnum(orgType));
    }

    @Override
    protected boolean _isBizPropertyExistInCU(Context ctx, IObjectValue model, int orgType) throws BOSException, EASBizException {
        FullOrgUnitInfo unit = (FullOrgUnitInfo)model;
        if (unit.isIsCU()) {
            return true;
        }
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (ctrlInfo == null) {
            throw new OUException(OUException.CU_CAN_NOT_NULL);
        }
        ObjectUuidPK ctrlPK = unit.getCU() != null && unit.getCU().getId() != null ? new ObjectUuidPK(unit.getCU().getId()) : new ObjectUuidPK(ctrlInfo.getId());
        ICtrlUnit iCtrl = CtrlUnitFactory.getLocalInstance(ctx);
        CacheService.getInstance().discardType(ctrlInfo.getBOSType());
        ctrlInfo = iCtrl.getCtrlUnitInfo((IObjectPK)ctrlPK);
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(ctrlInfo);
        return orgTypeHelper.isOrgType(OrgType.getEnum(orgType));
    }

    @Override
    protected IRowSet _executeAdminQueryForAsstAcct(Context ctx) throws BOSException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery4AsstAcct");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        return queryExcutor.executeQuery();
    }

    @Override
    protected IRowSet _executeCompanyQueryForAsstAcct(Context ctx) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery4AsstAcct");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        return queryExcutor.executeQuery();
    }

    @Override
    protected IRowSet _executeSaleQueryForAsstAcct(Context ctx) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery4AsstAcct");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        return queryExcutor.executeQuery();
    }

    @Override
    protected IRowSet _executePurchaseQueryForAsstAcct(Context ctx) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery4AsstAcct");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        return queryExcutor.executeQuery();
    }

    @Override
    protected IRowSet _executeStorageQueryForAsstAcct(Context ctx) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery4AsstAcct");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        return queryExcutor.executeQuery();
    }

    @Override
    protected IRowSet _executeCostCenterQueryForAsstAcct(Context ctx) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery4AsstAcct");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        return queryExcutor.executeQuery();
    }

    @Override
    protected IRowSet _executeProfitCenterQueryForAsstAcct(Context ctx) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery4AsstAcct");
        IQueryExecutor queryExcutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        return queryExcutor.executeQuery();
    }

    @Override
    protected String _queryBizSealUpOrgSql(Context ctx, String treeId, BizOrgQueryParam queryParam) throws BOSException, EASBizException {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeId);
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType());
        return OrgAppHelper.getSqlQueryOrgInfo(orgAppHelper.getOrgTypeSelfInfo().getTableName(), queryParam);
    }

    @Override
    protected FullOrgUnitCollection _createFullOrgUnitCol(Context ctx, IRowSet rowSet) throws BOSException, EASBizException {
        QueryOrgStructSqlHelper querySqlHelper = new QueryOrgStructSqlHelper();
        return querySqlHelper.createFullOrgUnitCol(ctx, rowSet);
    }

    @Override
    protected OrgStructureCollection _createStructureCol(Context ctx, IRowSet rowSet, boolean isRevised) throws BOSException, EASBizException {
        QueryOrgStructSqlHelper querySqlHelper = new QueryOrgStructSqlHelper();
        return querySqlHelper.createOrgStructureCol(ctx, rowSet, isRevised);
    }

    @Override
    protected OrgStructureCollection _buildViewRowSetCommon2StructCol(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, String isVirtualType_BizOrgQueryParam, boolean isRevised) throws BOSException, EASBizException {
        return this._buildViewRowSetCommon2StructCol(ctx, treeID, rootUnitID, isContainSealUp, isVirtualType_BizOrgQueryParam, isRevised, false);
    }

    @Override
    protected FullOrgUnitInfo _getOrgUnitInfo(Context ctx, String orgNumber) throws BOSException, EASBizException {
        LowTimeHelper timeHelper = new LowTimeHelper();
        QueryOrgStructSqlHelper querySqlHelper = new QueryOrgStructSqlHelper();
        IRowSet rowSet = querySqlHelper.getRowSetByOrgNumber(ctx, orgNumber);
        OrgStructureCollection retCol = querySqlHelper.createOrgStructureCol(ctx, rowSet, false);
        timeHelper.printTime2Last("get all data over ,return:");
        if (retCol == null || retCol.size() == 0) {
            return null;
        }
        return retCol.get(0).getUnit();
    }

    @Override
    protected OrgStructureCollection _buildViewRowSet4New(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, boolean isShowVirtual, int level, boolean isShowAssistantOrg, boolean isRevised, boolean isSimpleField, StepAddParamInfo stepAddParamInfo) throws BOSException, EASBizException {
        QueryOrgStructSqlHelper sqlHelper = new QueryOrgStructSqlHelper();
        return sqlHelper.getOrgStructureDetailCol(ctx, treeID, rootUnitID, isContainSealUp, isShowVirtual, level, isShowAssistantOrg, stepAddParamInfo, isRevised, isSimpleField);
    }

    @Override
    protected OrgStructureCollection _buildViewRowSetCommon2StructCol(Context ctx, String treeID, String rootUnitID, boolean isContainSealUp, String isVirtualType_BizOrgQueryParam, boolean isRevised, boolean isSimpleField) throws BOSException, EASBizException {
        LowTimeHelper timeHelper = new LowTimeHelper();
        QueryOrgStructSqlHelper querySqlHelper = new QueryOrgStructSqlHelper();
        IRowSet rowSet = querySqlHelper.getViewRowSetCommon(ctx, treeID, rootUnitID, isContainSealUp, isVirtualType_BizOrgQueryParam, isSimpleField);
        OrgStructureCollection retCol = querySqlHelper.createOrgStructureCol(ctx, rowSet, isRevised, isSimpleField);
        timeHelper.printTime2Last("get all data over ,return:");
        return retCol;
    }

    @Override
    protected List _getViewDirectChildNodes(Context ctx, String treeID, OrgStructureInfo selectNode, boolean isShowSealUp, boolean isShowVirtual, boolean isShowAssistant) throws BOSException, EASBizException {
        return this._getViewDirectChildNodes(ctx, treeID, selectNode, isShowSealUp, isShowVirtual, isShowAssistant, false);
    }

    @Override
    protected List _getViewDirectChildNodes(Context ctx, String treeID, OrgStructureInfo selectNode, boolean isShowSealUp, boolean isShowVirtual, boolean isShowAssistant, boolean isNeedConsiderFaultTree) throws BOSException, EASBizException {
        ArrayList<OrgStructureInfo> result = new ArrayList<OrgStructureInfo>();
        if (StringUtils.isEmpty((String)treeID)) {
            throw new BOSException("treeID cannot be null or empty string.");
        }
        if (selectNode == null) {
            selectNode = this.prepareSelectedNode(ctx, treeID);
            result.add(selectNode);
        }
        OrgAssistInfo assistInfo = this.buildOrgAssistInfo(treeID, isShowSealUp, isShowVirtual, isShowAssistant, isNeedConsiderFaultTree);
        IOrgDirectTreeNode handler = BuildDirectChildrenFactory.getInstance().createTreeNodeHandler(ctx, selectNode, assistInfo);
        result.addAll(handler.getDirectTreeNode(ctx, selectNode, assistInfo));
        return result;
    }

    private OrgStructureInfo prepareSelectedNode(Context ctx, String treeID) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id, longNumber, isLeaf, level, parent.id, unit.id, unit.number, unit.name, unit.isunion ").append("where tree.id = '").append(treeID).append("' and unit.id = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        OrgStructureInfo info = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureInfo(oql.toString());
        return info;
    }

    private OrgAssistInfo buildOrgAssistInfo(String treeID, boolean isShowSealUp, boolean isShowVirtual, boolean isShowAssistant, boolean isNeedConsiderFaultTree) {
        OrgAssistInfo info = new OrgAssistInfo();
        info.setStructure(true);
        info.setTreeID(treeID);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID);
        if (orgTypeInfo != null && orgTypeInfo.isBasicOrgType()) {
            info.setOrgViewType(orgTypeInfo.getOrgViewType());
        } else {
            info.setOrgViewType(OrgViewType.UNIONDEBT);
        }
        info.setNeedAddSealUpFilter(!isShowSealUp);
        info.setNeedAddVirtualFilter(!isShowVirtual);
        info.setNeedAddAssistantFilter(!isShowAssistant);
        info.setNeedConsiderFaultTree(isNeedConsiderFaultTree);
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FID <> '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' AND ").append("\"STRUCTURE\"").append(".FIsValid = 1 ");
        info.setExtraFilters(extraFilters.toString());
        return info;
    }

    @Override
    protected List _getViewDirectChildNodesByUIPKAndActionPK(Context ctx, String treeID, OrgStructureInfo selectNode, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)treeID) || uiPK == null || actionPK == null) {
            throw new BOSException("illegal param. params(treeID,uiPK,actionPK) cannot be null.");
        }
        ArrayList<OrgStructureInfo> result = new ArrayList<OrgStructureInfo>();
        if (selectNode == null) {
            selectNode = this.prepareSelectedNode(ctx, treeID);
            result.add(selectNode);
        }
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        OrgAssistInfo assistInfo = this.buildOrgAssistInfoByUIPKAndActionPK((IObjectPK)userPK, treeID, uiPK, actionPK);
        IOrgDirectTreeNode handler = BuildDirectChildrenFactory.getInstance().createTreeNodeHandler(ctx, selectNode, assistInfo);
        result.addAll(handler.getDirectTreeNode(ctx, selectNode, assistInfo));
        return result;
    }

    private OrgAssistInfo buildOrgAssistInfoByUIPKAndActionPK(IObjectPK userPK, String treeID, IMetaDataPK uiPK, IMetaDataPK actionPK) {
        OrgAssistInfo info = new OrgAssistInfo();
        info.setStructure(true);
        info.setTreeID(treeID);
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(treeID);
        if (orgTypeInfo != null && orgTypeInfo.isBasicOrgType()) {
            info.setOrgViewType(orgTypeInfo.getOrgViewType());
        } else {
            info.setOrgViewType(OrgViewType.UNIONDEBT);
        }
        info.setUserPK(userPK);
        info.setUiPK(uiPK);
        info.setActionPK(actionPK);
        info.setNeedAddOrgRange(true);
        info.setNeedConsiderFaultTree(true);
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FID <> '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' AND ").append("\"STRUCTURE\"").append(".FIsValid = 1 ");
        info.setExtraFilters(extraFilters.toString());
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.PermissionFilter4F7Decorator");
        info.setConstructParam(decorators);
        return info;
    }

    @Override
    protected DefaultKingdeeTreeNode _getViewDirectChildNodesByMultiCondition(Context ctx, OrgViewType orgViewType, String treeID, boolean isCUFilter, boolean isCUFilterIncludeSub, DefaultKingdeeTreeNode selectNode, boolean isNeedAddSealUpFilter, boolean isNeedAddOrgRange, IMetaDataPK uiPK, IMetaDataPK actionPK, String extraTreeFilter) throws BOSException, EASBizException {
        if (orgViewType == OrgViewType.UNIONDEBT && StringUtils.isEmpty((String)treeID)) {
            throw new BOSException("treeID is needed when orgviewtype is union");
        }
        if (StringUtils.isEmpty((String)treeID)) {
            treeID = NewOrgViewHelper.convert2TreeId(orgViewType);
        }
        if ((selectNode == null || selectNode.getUserObject() == null) && (selectNode = this.getDefaultSelectedNod(ctx, treeID)) == null) {
            return new DefaultKingdeeTreeNode();
        }
        OrgStructureInfo info = (OrgStructureInfo)selectNode.getUserObject();
        OrgAssistInfo assistInfo = this.buildOrgAssistInfoByMultiCondition(ctx, orgViewType, treeID, isCUFilter, isCUFilterIncludeSub, info.getUnit().getId().toString(), isNeedAddSealUpFilter, isNeedAddOrgRange, uiPK, actionPK, extraTreeFilter);
        IOrgDirectTreeNode handler = BuildDirectChildrenFactory.getInstance().createTreeNodeHandler(ctx, info, assistInfo);
        List directChildren = handler.getDirectTreeNode(ctx, info, assistInfo);
        selectNode = NewOrgViewHelper.buildTreeByList(selectNode, directChildren);
        return selectNode;
    }

    private DefaultKingdeeTreeNode getDefaultSelectedNod(Context ctx, String treeID) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id, longNumber, isLeaf, level, parent.id, unit.id, unit.number, unit.name, unit.isunion ").append("where tree.id = '").append(treeID).append("' and unit.id = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        OrgStructureInfo info = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureInfo(oql.toString());
        if (info == null) {
            return null;
        }
        return new DefaultKingdeeTreeNode((Object)info);
    }

    private OrgAssistInfo buildOrgAssistInfoByMultiCondition(Context ctx, OrgViewType orgViewType, String treeID, boolean isCUFilter, boolean isCUFilterIncludeSub, String rootUnitID, boolean isNeedAddSealUpFilter, boolean isNeedAddOrgRange, IMetaDataPK uiPK, IMetaDataPK actionPK, String extraTreeFilter) {
        OrgAssistInfo assistInfo = new OrgAssistInfo();
        assistInfo.setStructure(true);
        assistInfo.setRootUnitID(rootUnitID);
        assistInfo.setOrgViewType(orgViewType);
        assistInfo.setCUFilter(isCUFilter);
        assistInfo.setCUFilterIncludeSub(isCUFilterIncludeSub);
        assistInfo.setTreeID(treeID);
        assistInfo.setUserPK((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()));
        assistInfo.setCuID(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        assistInfo.setExtraFilters(extraTreeFilter);
        assistInfo.setNeedConsiderFaultTree(true);
        assistInfo.setUiPK(uiPK);
        assistInfo.setActionPK(actionPK);
        assistInfo.setNeedAddOrgRange(isNeedAddOrgRange);
        assistInfo.setNeedAddSealUpFilter(isNeedAddSealUpFilter);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        if (isCUFilter && !isNeedAddOrgRange) {
            decorators.add("com.kingdee.eas.basedata.org.app.helper.CUFilter4F7Decorator");
        } else {
            decorators.add("com.kingdee.eas.basedata.org.app.helper.PermissionFilter4F7Decorator");
        }
        assistInfo.setConstructParam(decorators);
        return assistInfo;
    }

    @Override
    protected String _getAllSubNodeSQL(Context ctx, OrgStructureInfo selectedNode, BizOrgAssistInfoBuilder builder) throws BOSException, EASBizException {
        if (selectedNode == null && (selectedNode = this.getDefaultSelectedNode(ctx, builder.getTreeID())) == null) {
            return "'no_data'";
        }
        OrgAssistInfo assistInfo = this.convertBuilder2AssistInfo(ctx, selectedNode, builder);
        IOrgDirectTreeNode handler = BuildDirectChildrenFactory.getInstance().createTreeNodeHandler(ctx, selectedNode, assistInfo);
        return handler.getAllSubNodeSQL(ctx, selectedNode, assistInfo, null);
    }

    private OrgStructureInfo getDefaultSelectedNode(Context ctx, String treeID) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id, longNumber, isLeaf, level, parent.id, unit.id, unit.number, unit.name, unit.isunion ").append("where tree.id = '").append(treeID).append("' and unit.id = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        OrgStructureInfo info = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureInfo(oql.toString());
        if (info == null) {
            return null;
        }
        return info;
    }

    @Override
    protected List _getViewDirectChildNodesByMultiCondition(Context ctx, OrgStructureInfo selectedNode, BizOrgAssistInfoBuilder builder) throws BOSException, EASBizException {
        ArrayList<OrgStructureInfo> result = new ArrayList<OrgStructureInfo>();
        if (selectedNode == null) {
            selectedNode = this.getDefaultSelectedNode(ctx, builder.getTreeID());
            if (selectedNode == null) {
                return new ArrayList();
            }
            result.add(selectedNode);
        }
        OrgAssistInfo assistInfo = this.convertBuilder2AssistInfo(ctx, selectedNode, builder);
        IOrgDirectTreeNode handler = BuildDirectChildrenFactory.getInstance().createTreeNodeHandler(ctx, selectedNode, assistInfo);
        List directChildNode = handler.getDirectTreeNode(ctx, selectedNode, assistInfo);
        if (directChildNode != null) {
            result.addAll(directChildNode);
        }
        return result;
    }

    private OrgAssistInfo convertBuilder2AssistInfo(Context ctx, OrgStructureInfo selectedNode, BizOrgAssistInfoBuilder builder) throws BOSException {
        this.checkBuilder(builder);
        OrgAssistInfo info = new OrgAssistInfo();
        info.setStructure(true);
        info.setNeedConsiderOuterFilter(true);
        if (StringUtils.isEmpty((String)builder.getCuID())) {
            String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            info.setCuID(cuID);
        }
        if (builder.getUserPK() == null) {
            ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            info.setUserPK((IObjectPK)userPK);
        }
        info.setRootUnitID(selectedNode.getUnit().getId().toString());
        info.setOrgViewType(builder.getOrgViewType());
        if (StringUtils.isEmpty((String)builder.getTreeID())) {
            info.setTreeID(NewOrgViewHelper.convert2TreeId(builder.getOrgViewType()));
        } else {
            info.setTreeID(builder.getTreeID());
        }
        info.setCUFilter(builder.isCUFilter());
        info.setCUFilterIncludeSub(builder.isCUFilterIncludeSub());
        info.setNeedConsiderFaultTree(builder.isNeedConsiderFaultTree());
        info.setUiPK(builder.getUiPK());
        info.setActionPK(builder.getActionPK());
        info.setNeedAddOrgRange(builder.isNeedAddOrgRange());
        info.setNeedAddSealUpFilter(builder.isNeedAddSealUpFilter());
        info.setNeedAddVirtualFilter(builder.isNeedAddVirtualFilter());
        info.setNeedAddAssistantFilter(builder.isNeedAddAssistantFilter());
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        if (info.isCUFilter() && !info.isNeedAddOrgRange()) {
            decorators.add("com.kingdee.eas.basedata.org.app.helper.CUFilter4F7Decorator");
        } else {
            decorators.add("com.kingdee.eas.basedata.org.app.helper.PermissionFilter4F7Decorator");
        }
        info.setConstructParam(decorators);
        this.setExtraFilterIntoAssistInfo(builder, info);
        return info;
    }

    private void checkBuilder(BizOrgAssistInfoBuilder builder) throws BOSException {
        if (builder.getOrgViewType() == null) {
            throw new BOSException("orgViewType cannot be null");
        }
        if (builder.getOrgViewType() == OrgViewType.UNIONDEBT && StringUtils.isEmpty((String)builder.getTreeID())) {
            throw new BOSException("treeID cannot be null when orgViewType is union");
        }
    }

    private void setExtraFilterIntoAssistInfo(BizOrgAssistInfoBuilder builder, OrgAssistInfo assistInfo) {
        HashMap<String, String> extraFilters = new HashMap<String, String>();
        extraFilters.put("extraFilter", builder.getExtraFilters());
        extraFilters.put("bizUnitFilter", builder.getBizUnitQuerySQL());
        extraFilters.put("accountTableAndPeriodFilter", builder.getAccountTableAndPeriodSQL());
        extraFilters.put("accountSchemeFilter", builder.getAccountSchemaSQL());
        StringBuilder extraFilter = new StringBuilder();
        for (String filter : extraFilters.values()) {
            if (StringUtils.isEmpty((String)filter)) continue;
            extraFilter.append(" AND (").append(filter).append(")");
        }
        assistInfo.setExtraFilters(extraFilter.toString());
    }

    @Override
    protected Map _getParents(Context ctx, String ouId) throws BOSException, EASBizException {
        FilterItemInfo orgUnitItem = new FilterItemInfo("unit.id", (Object)ouId, CompareType.EQUALS);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(orgUnitItem);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.unit.longNumber"));
        sic.add(new SelectorItemInfo("parent.unit.name"));
        sic.add(new SelectorItemInfo("parent.unit.number"));
        sic.add(new SelectorItemInfo("parent.unit.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("tree.id"));
        sic.add(new SelectorItemInfo("tree.type"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        OrgStructureCollection parentOrgStructCol = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureCollection(view);
        OrgStructureInfo structInfo = null;
        HashMap<Integer, FullOrgUnitInfo> ret = new HashMap<Integer, FullOrgUnitInfo>();
        int size = parentOrgStructCol.size();
        for (int i = 0; i < size; ++i) {
            structInfo = parentOrgStructCol.get(i);
            ret.put(structInfo.getTree().getType().getValue(), structInfo.getParent().getUnit());
        }
        return ret;
    }
}

