/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitLayerType;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.app.AbstractOUListUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import org.apache.log4j.Logger;

public class OUListUIHandler
extends AbstractOUListUIHandler {
    private static final Logger logger = Logger.getLogger(OUListUIHandler.class);

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.handleActionAddNew(request, response, context);
    }

    public void handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        BOSUuid userId = (BOSUuid)request.get("userId");
        BOSUuid orgId = (BOSUuid)request.get("orgId");
        if (userId != null && orgId != null) {
            boolean flag_OU_Update = this.checkFunctionPermission("OU_AddNew", userId, orgId, context);
            this.checkPrermission(userId, orgId, context);
        }
        String cuID = (String)request.get("CURRENTCUID");
        Boolean isShowVirtual = (Boolean)request.get("isShowVirtual");
        if (cuID == null || isShowVirtual == null) {
            return;
        }
    }

    public void handleActionImportOU(RequestContext request, ResponseContext response, Context context) throws Exception {
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance(context).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
    }

    public void handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleActionEdit(request, response, context);
        BOSUuid userId = (BOSUuid)request.get("userId");
        BOSUuid orgId = (BOSUuid)request.get("orgId");
        if (userId != null && orgId != null) {
            boolean flag_OU_Update = this.checkFunctionPermission("OU_Update", userId, orgId, context);
            this.checkPrermission(userId, orgId, context);
        }
        this.isShowOrgNumber(context);
        AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(context);
        IOrgUnitLayerType iLayerType = OrgUnitLayerTypeFactory.getLocalInstance(context);
        OrgUnitLayerTypeCollection col = iLayerType.getOrgUnitLayerTypeCollection();
    }

    private boolean isShowOrgNumber(Context ctx) {
        boolean showOrgNumber = false;
        String paramkey = "ShowOrgNumber";
        try {
            String paravalue = ParamManager.getParamValue((Context)ctx, null, (String)paramkey);
            if (paravalue != null && paravalue.equals("true")) {
                showOrgNumber = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return showOrgNumber;
    }

    private void checkPrermission(BOSUuid userId, BOSUuid orgId, Context context) {
        boolean flag_Com = this.checkFunctionPermission("OU_Com_Update", userId, orgId, context);
        boolean flag_Admin = this.checkFunctionPermission("OU_Admin_Update", userId, orgId, context);
        boolean flag_Purchase = this.checkFunctionPermission("OU_Purchase_Update", userId, orgId, context);
        boolean flag_Sale = this.checkFunctionPermission("OU_Sale_Update", userId, orgId, context);
        boolean flag_Storage = this.checkFunctionPermission("OU_Storage_Update", userId, orgId, context);
        boolean flag_Profit = this.checkFunctionPermission("OU_Profit_Update", userId, orgId, context);
        boolean flag_Cost = this.checkFunctionPermission("OU_Cost_Update", userId, orgId, context);
        boolean flag_HRO = this.checkFunctionPermission("OU_HRO_Update", userId, orgId, context);
        boolean flag_Transport = this.checkFunctionPermission("OU_Transport_Update", userId, orgId, context);
        boolean flag_Quality = this.checkFunctionPermission("OU_Quality_Update", userId, orgId, context);
    }

    private boolean checkFunctionPermission(String permItemName, BOSUuid userId, BOSUuid orgId, Context context) {
        IPermission permission = null;
        boolean flag = false;
        try {
            ObjectUuidPK userPk = new ObjectUuidPK("id", userId);
            ObjectUuidPK orgPk = new ObjectUuidPK("id", orgId);
            permission = PermissionFactory.getLocalInstance((Context)context);
            flag = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
        }
        catch (Throwable ex) {
            if (ex instanceof Exception) {
                // empty if block
            }
        }
        return flag;
    }

    @Override
    protected void _handleActionRefreshView(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionOUSealUp(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionOUShift(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionOUUnSealUp(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportOU(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportAdmin(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportCompany(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionExportOU(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionExportAdmin(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionExportCompany(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportSale(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportPurchase(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportStorage(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportCostCenter(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportProfitCenter(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportHR(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionUpdateOrgRelation(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionDeleteOrgRelation(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionShowVirtual(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportTransport(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionImportQuality(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionImportOrg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

