/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.BizReference;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OUPartReference {
    private static Logger logger = Logger.getLogger((String)OUPartReference.class.getName());

    protected static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static void isReferenced(Context ctx, String bosType, String id) throws BOSException, BizReferenceException {
        BizReference ref = null;
        try {
            ref = OUPartReference.getReference(ctx, bosType, id);
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        if (ref != null) {
            Object[] param = new Object[]{ref.getRefEntityAlias_L2() + "\uff1b" + ref.getRefTableName() + "\uff1b" + ref.getRefFieldName()};
            throw new BizReferenceException(BizReferenceException.BIZ_REFERENCED2, param);
        }
    }

    private static BizReference getReference(Context ctx, String bosType, String id) {
        boolean found = false;
        BizReference reference = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSet rsTemp = null;
        String matched = new StringBuffer().append("SELECT ").append("FRefTableName, ").append("FRefFieldName, ").append("FRefEntityName, ").append("FRefEntityAlias_L1, ").append("FRefEntityAlias_L2, ").append("FRefEntityAlias_L3 ").append("FROM T_SYS_EntityRef ").append("WHERE FIsBosFK = 1 and FBosType = ? ").append("ORDER BY FOrder DESC").toString();
        boolean step1 = false;
        try {
            conn = OUPartReference.getConnection(ctx);
            stmt = conn.createStatement();
            pstmt = conn.prepareStatement(matched);
            pstmt.setString(1, bosType);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                step1 = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e));
        }
        if (step1) {
            boolean rsNext = true;
            while (rsNext) {
                StringBuffer sql = new StringBuffer();
                try {
                    String fRefTableName = rs.getString(1);
                    if (!"T_ORG_BaseUnit".equalsIgnoreCase(fRefTableName)) {
                        sql.append("SELECT 1 FROM ");
                        sql.append(fRefTableName);
                        sql.append(" WHERE ");
                        sql.append(rs.getString(2));
                        sql.append(" = '");
                        sql.append(id);
                        sql.append("'");
                        rsTemp = stmt.executeQuery(sql.toString());
                        if (rsTemp.next()) {
                            found = true;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("\u8868\u6216\u89c6\u56fe\u4e0d\u5b58\u5728\uff01\u67e5\u8be2SQL\u662f\uff1a\n" + sql.toString()));
                }
                try {
                    rsNext = rs.next();
                }
                catch (SQLException e) {
                    logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e));
                    rsNext = false;
                }
            }
            try {
                if (found) {
                    reference = new BizReference();
                    reference.setRefTableName(rs.getString(1));
                    reference.setRefFieldName(rs.getString(2));
                    reference.setRefEntityName(rs.getString(3));
                    reference.setRefEntityAlias_L1(rs.getString(4));
                    reference.setRefEntityAlias_L2(rs.getString(5));
                    reference.setRefEntityAlias_L3(rs.getString(6));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e));
                reference = null;
            }
        }
        SQLUtils.cleanup(rs);
        SQLUtils.cleanup(rsTemp);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return reference;
    }

    public static void isAdminOrgUnitReferencedByAsstActTypeDefault(Context ctx, String id) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT fid FROM T_BD_AsstActTypeDefault ").append("WHERE FAsstActTypeid = 'YW3xsAEJEADgAAYwwKgTB0c4VZA=' ").append("AND FDefaultID = ?").toString();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = OUPartReference.getConnection(ctx);
            pstmt = conn.prepareStatement(selectSql);
            pstmt.setString(1, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                throw new OUException(OUException.IS_REFERENCED_BY_ASSTACTTYPEDEFAULT);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e));
        }
        SQLUtils.cleanup(rs);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpecialSupplierEntityId(Context ctx, BOSUuid uuid) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        String id;
        block26: {
            StringBuffer selectSql = new StringBuffer().append("SELECT FUnitID FROM ");
            id = uuid.toString();
            String type = uuid.getType().toString();
            if ("BCA8D47D".equals(type)) {
                selectSql.append("T_ORG_OUPartAdmin WHERE FID = ?");
            } else if ("35233503".equals(type)) {
                selectSql.append("T_ORG_OUPartCtrl WHERE FID = ?");
            } else if ("5C40E07B".equals(type)) {
                selectSql.append("T_ORG_OUPartFI WHERE FID = ?");
            } else if ("BB7FE4DF".equals(type)) {
                selectSql.append("T_ORG_OUPartSale WHERE FID = ?");
            } else if ("5750B219".equals(type)) {
                selectSql.append("T_ORG_OUPartPurchase WHERE FID = ?");
            } else if ("399BE2E9".equals(type)) {
                selectSql.append("T_ORG_OUPartStorage WHERE FID = ?");
            } else if ("2EC9A165".equals(type)) {
                selectSql.append("T_ORG_OUPartCostCenter WHERE FID = ?");
            } else if ("6EF82F1C".equals(type)) {
                selectSql.append("T_ORG_OUPartProfitCenter WHERE FID = ?");
            } else if ("714011A8".equals(type)) {
                selectSql.append("T_ORG_OUPartHR WHERE FID = ?");
            } else if ("8355C0AB".equals(type)) {
                selectSql.append("T_ORG_OUPartTransport WHERE FID = ?");
            } else if ("952C0301".equals(type)) {
                selectSql.append("T_ORG_OUPartQuality WHERE FID = ?");
            } else {
                return id;
            }
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = OUPartReference.getConnection(ctx);
                pstmt = conn.prepareStatement(selectSql.toString());
                pstmt.setString(1, id);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block26;
                id = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"OUPartReference", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    SQLUtils.cleanup(pstmt);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delReferenced(Context ctx, String bosType, List pkList, String ignorTableNam) throws BOSException, BizReferenceException {
        if (pkList == null || pkList.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        String matched = new StringBuffer().append("SELECT ").append("FRefTableName, ").append("FRefFieldName, ").append("FRefEntityName, ").append("FRefEntityAlias_L1, ").append("FRefEntityAlias_L2, ").append("FRefEntityAlias_L3 ").append("FROM T_SYS_EntityRef ").append("WHERE FIsBosFK = 1 and FBosType = ? ").append("ORDER BY FOrder DESC").toString();
        try {
            conn = OUPartReference.getConnection(ctx);
            stmt = conn.createStatement();
            pstmt = conn.prepareStatement(matched);
            pstmt.setString(1, bosType);
            rs = pstmt.executeQuery();
        }
        catch (SQLException e) {
            logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e));
        }
        try {
            while (rs.next()) {
                String fRefTableName = rs.getString(1);
                if (("T_ORG_BaseUnit".equalsIgnoreCase(fRefTableName) || "T_ORG_Structure".equalsIgnoreCase(fRefTableName) || ignorTableNam.equalsIgnoreCase(fRefTableName)) && ("T_ORG_BaseUnit".equalsIgnoreCase(fRefTableName) || !"32B85C74".equals(bosType))) continue;
                for (int i = 0; i < pkList.size(); ++i) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("DELETE FROM ");
                    sql.append(fRefTableName);
                    sql.append(" WHERE ");
                    sql.append(rs.getString(2));
                    sql.append(" ='");
                    sql.append(pkList.get(i));
                    sql.append("'");
                    stmt.addBatch(sql.toString());
                }
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e));
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Statement)pstmt);
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void delReferenced(Context ctx, String bosType, String id, String ignorTableNam) throws BOSException, BizReferenceException {
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add(id);
        OUPartReference.delReferenced(ctx, bosType, pkList, ignorTableNam);
    }

    public static void delAdminOrgUnitReferencedByAsstActTypeDefault(Context ctx, String id) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("DELETE FROM T_BD_AsstActTypeDefault ").append("WHERE FAsstActTypeid = 'YW3xsAEJEADgAAYwwKgTB0c4VZA=' ").append("AND FDefaultID = ?").toString();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = OUPartReference.getConnection(ctx);
            pstmt = conn.prepareStatement(selectSql);
            pstmt.setString(1, id);
            pstmt.execute();
        }
        catch (SQLException e) {
            logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e));
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
    }
}

