/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgBudgetViewInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.app.AbstractOrgBudgetViewControllerBean;
import com.kingdee.eas.basedata.org.app.OrgAppUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class OrgBudgetViewControllerBean
extends AbstractOrgBudgetViewControllerBean {
    @Override
    protected void _refreshView(Context ctx) throws BOSException, EASBizException {
        this.deleteOrgView(ctx);
        this.insertOrgView(ctx);
    }

    private void deleteOrgView(Context ctx) throws BOSException {
        String sql = "delete from T_Org_View";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void insertOrgView(Context ctx) throws BOSException, EASBizException {
        this.insertOrgView(ctx, OrgViewType.ADMIN);
        this.insertOrgView(ctx, OrgViewType.COMPANY);
        this.insertOrgView(ctx, OrgViewType.SALE);
        this.insertOrgView(ctx, OrgViewType.STORAGE);
        this.insertOrgView(ctx, OrgViewType.PURCHASE);
        this.insertOrgView(ctx, OrgViewType.RESPONSECENTER);
    }

    private void insertOrgView(Context ctx, OrgViewType orgViewType) throws BOSException, EASBizException {
        String sql = "insert into T_Org_View (fid, funitId, fOrgViewType, flevel, fisLeaf, flongNumber, fparentUnit) values(?, ?, ?, ?, ?, ?, ?)";
        Object[] param = new Object[7];
        BOSObjectType bosType = new OrgBudgetViewInfo().getBOSType();
        OrgUnitCollection c = null;
        c = new OrgUnitCollection();
        for (int i = 0; i < c.size(); ++i) {
            param[0] = BOSUuid.create((BOSObjectType)bosType);
            param[1] = c.get(i).getId().toString();
            param[2] = new Integer(((OrgViewType)((Object)c.get(i).get("orgViewType"))).getValue());
            param[3] = new Integer(c.get(i).get("level").toString());
            param[4] = new Boolean((Boolean)c.get(i).get("isLeaf"));
            param[5] = c.get(i).get("longNumber").toString();
            param[6] = c.get(i).get("superOrgUnit") == null ? null : ((OrgUnitInfo)c.get(i).get("superOrgUnit")).getId().toString();
            OrgAppUtils.executeOrgViewSql(ctx, sql, param);
        }
    }

    @Override
    protected void _refreshOrgBudgetView(Context ctx) throws EASBizException, BOSException {
        if (this.checkUpdateFalg(ctx)) {
            this._refreshView(ctx);
            DbUtil.executeQuery((Context)ctx, (String)"UPDATE T_ORG_VIEWFLAG SET FUPDATEFLAG=0");
        }
    }

    boolean checkUpdateFalg(Context ctx) throws BOSException {
        boolean isChanged = false;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT FUPDATEFLAG FROM T_ORG_VIEWFLAG");
        if (rowSet.size() > 0) {
            try {
                rowSet.next();
                isChanged = rowSet.getInt("FUPDATEFLAG") == 1;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isChanged;
    }
}

