/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import java.sql.ResultSet;

public class OrgCollectionServerUtils {
    public static LanguageCollection langCol = null;

    public static LanguageCollection getLanguageCollection(Context ctx) {
        if (langCol == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            SolutionInfo solutionInfo = loader.getSolution();
            langCol = solutionInfo.getLanguages();
        }
        return langCol;
    }

    public static OrgUnitInfo createOrgUnitInfo(Context ctx, OrgType orgType, ResultSet rs) throws Exception {
        OrgUnitInfo orgInfo = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getOrgUnitViewInfo();
        orgInfo.setIsGrouping(rs.getBoolean("FIsGrouping"));
        orgInfo.setEffectDate(rs.getDate("FEffectDate"));
        orgInfo.setInvalidDate(rs.getDate("FInvalidDate"));
        orgInfo.setIsFreeze(rs.getBoolean("FIsFreeze"));
        orgInfo.setIsCompanyOrgUnit(rs.getBoolean("FIsCompanyOrgUnit"));
        orgInfo.setIsAdminOrgUnit(rs.getBoolean("FIsAdminOrgUnit"));
        orgInfo.setIsSaleOrgUnit(rs.getBoolean("FIsSaleOrgUnit"));
        orgInfo.setIsPurchaseOrgUnit(rs.getBoolean("FIsPurchaseOrgUnit"));
        orgInfo.setIsStorageOrgUnit(rs.getBoolean("FIsStorageOrgUnit"));
        orgInfo.setIsProfitOrgUnit(rs.getBoolean("FIsProfitOrgUnit"));
        orgInfo.setIsCostOrgUnit(rs.getBoolean("FIsCostOrgUnit"));
        orgInfo.setIsCU(rs.getBoolean("FIsCU"));
        orgInfo.setIsUnion(rs.getBoolean("FIsUnion"));
        orgInfo.setIsHROrgUnit(rs.getBoolean("FIsHROrgUnit"));
        orgInfo.setIsStart(rs.getBoolean("FIsStart"));
        orgInfo.setIsOUSealUp(rs.getBoolean("FIsOUSealUp"));
        LanguageCollection lc = OrgCollectionServerUtils.getLanguageCollection(ctx);
        orgInfo.setIsLeaf(rs.getBoolean("FIsLeaf"));
        orgInfo.setLevel(rs.getInt("FLevel"));
        orgInfo.setLongNumber(rs.getString("FLongNumber"));
        String strDisplayName = "FDisplayName_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String displayName = strDisplayName + langInfo.getPostfix();
            orgInfo.setDisplayName(rs.getString(displayName), langInfo.getLocale());
        }
        String strName = "FName_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String name = strName + langInfo.getPostfix();
            orgInfo.setName(rs.getString(name), langInfo.getLocale());
        }
        orgInfo.setNumber(rs.getString("FNumber"));
        String strDescription = "FDescription_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String description = strDescription + langInfo.getPostfix();
            orgInfo.setDescription(rs.getString(description), langInfo.getLocale());
        }
        orgInfo.setSimpleName(rs.getString("FSimpleName"));
        String creatorId = rs.getString("FCreatorID");
        if (creatorId != null && creatorId.trim().length() != 0) {
            UserInfo creatorInfo = new UserInfo();
            creatorInfo.setId(BOSUuid.read((String)creatorId));
            orgInfo.setCreator(creatorInfo);
        }
        orgInfo.setCreateTime(rs.getTimestamp("FCreateTime"));
        String lastUpdateUserId = rs.getString("FLastUpdateUserID");
        if (lastUpdateUserId != null && lastUpdateUserId.trim().length() != 0) {
            UserInfo lastUpdateUserInfo = new UserInfo();
            lastUpdateUserInfo.setId(BOSUuid.read((String)lastUpdateUserId));
            orgInfo.setLastUpdateUser(lastUpdateUserInfo);
        }
        orgInfo.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
        String cuId = rs.getString("FControlUnitID");
        if (cuId != null && cuId.trim().length() != 0) {
            CtrlUnitInfo cuInfo = new CtrlUnitInfo();
            cuInfo.setId(BOSUuid.read((String)cuId));
            orgInfo.setCU(cuInfo);
        }
        orgInfo.setCode(rs.getString("FCode"));
        String id = rs.getString("FID");
        orgInfo.setId(BOSUuid.read((String)id));
        return orgInfo;
    }
}

