/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgSpecialTalbesEnum;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitDefaultRelationFactory;
import com.kingdee.eas.basedata.org.app.AbstractOrgSpecialTablesRebuildFacadeControllerBean;
import com.kingdee.eas.basedata.org.app.OrgSpecialTablesSqlManager;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class OrgSpecialTablesRebuildFacadeControllerBean
extends AbstractOrgSpecialTablesRebuildFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)OrgSpecialTablesRebuildFacadeControllerBean.class.getName());

    @Override
    protected void _rebuildSpecialTables(Context ctx) throws BOSException, EASBizException {
        this._rebuildSpecialTables(ctx, (IObjectValue)null);
    }

    @Override
    protected void _rebuildSpecialTables(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        String[] sqlsToRun = null;
        List enumList = OrgSpecialTalbesEnum.getEnumList();
        int enumValue = 0;
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)info;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            int n = enumList.size();
            for (int i = 0; i < n; ++i) {
                OrgSpecialTalbesEnum curEnum = (OrgSpecialTalbesEnum)((Object)enumList.get(i));
                enumValue = curEnum.getValue();
                if (!this.isNeedRebuildOrgViews(unitInfo, enumValue) || (sqlsToRun = OrgSpecialTablesSqlManager.getInstance().getSqlByEnumValue(enumValue)) == null) continue;
                stmt.execute(sqlsToRun[0]);
                stmt.execute(sqlsToRun[1]);
            }
        }
        catch (Exception e) {
            try {
                SQLException sqle;
                logger.error((Object)"Rebuild organization view tables error! \n", (Throwable)e);
                if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                    logger.error((Object)"**************************** Next exception is: ***************************");
                    sqle.printStackTrace();
                }
                if (e.getCause() instanceof SQLException) {
                    throw new BOSException((Throwable)JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause())));
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        OrgCacheFactory.getOrgCache(ctx).clearOrgCache();
    }

    @Override
    protected void _rebuildSpecialTables(Context ctx, IObjectValue info, int operateType) throws BOSException, EASBizException {
        String[] sqlsToRun = new String[4];
        String[] sql = null;
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)info;
        try {
            OrgTypeAppCenter orgCenter = OrgTypeAppCenter.getInstance();
            Set set = this.getNeedOrgSpecialTalbesEnum(ctx, unitInfo, orgCenter);
            for (OrgType orgType : set) {
                if (unitInfo.get("hrOrgNotChanged") != null && 16 == orgType.getValue()) continue;
                OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgType);
                OrgSpecialTalbesEnum curEnum = orgTypeInfo.getSpecialTalbesEnum();
                int enumValue = curEnum.getValue();
                sql = OrgSpecialTablesSqlManager.getInstance().getSqlByEnumValue(enumValue);
                sqlsToRun[0] = sql[0];
                sqlsToRun[1] = sql[1];
                if (sqlsToRun == null) continue;
                OrgStructureInfo oldStructureInfo = new OrgStructureInfo();
                if (operateType == 3 || operateType == 4 || operateType == 5) {
                    oldStructureInfo = orgCenter.getOldStructureInfo(ctx, unitInfo, orgType);
                }
                OrgStructureInfo newStructureInfo = new OrgStructureInfo();
                newStructureInfo = orgCenter.getOrgStructureInfo(ctx, unitInfo, orgType);
                if (operateType == 4) {
                    String updateSql;
                    sqlsToRun[2] = updateSql = orgCenter.getUpateViewSql(ctx, orgType);
                    sqlsToRun[3] = orgCenter.getUpdateViewCUSql(ctx, orgType);
                }
                this.specialTableOperate(ctx, operateType, orgType, unitInfo, newStructureInfo, oldStructureInfo, sqlsToRun);
                if (newStructureInfo.getTree() == null || !"00000000-0000-0000-0000-0000000000024F2827FD".equals(StringUtils.cnulls((Object)newStructureInfo.getTree().getId()))) continue;
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mainOrg.id", (Object)newStructureInfo.getUnit().getId().toString()));
                entityView.setFilter(filter);
                entityView.getSelector().add(new SelectorItemInfo("id"));
                IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance(ctx);
                FullOrgUnitCollection orgUnitCol = iOrgUnit.getFullOrgUnitCollection(entityView);
                for (int i = 0; i < orgUnitCol.size(); ++i) {
                    FullOrgUnitInfo orgUnitInfo = orgUnitCol.get(i);
                    this.specialTableOperate(ctx, operateType, orgType, orgUnitInfo, newStructureInfo, oldStructureInfo, sqlsToRun);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Rebuild organization view tables error! \n", (Throwable)e);
            if (e.getCause() instanceof SQLException) {
                throw new BOSException((Throwable)JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause())));
            }
            throw new BOSException((Throwable)e);
        }
        OrgCacheFactory.getOrgCache(ctx).clearOrgCache();
    }

    private void specialTableOperate(Context ctx, int operateType, OrgType orgType, FullOrgUnitInfo unitInfo, OrgStructureInfo newStructureInfo, OrgStructureInfo oldStructureInfo, String[] sqlsToRun) throws SQLException, BOSException, EASBizException {
        String addSql = "";
        String deleteSql = "";
        String updateSql = "";
        String unitId = unitInfo.getId().toString();
        switch (operateType) {
            case 1: {
                addSql = sqlsToRun[1] + " and ou.fid=?";
                DbUtil.execute((Context)ctx, (String)addSql, (Object[])new String[]{unitId});
                break;
            }
            case 2: {
                deleteSql = sqlsToRun[0] + " where (fid=? OR flongnumber like ?)";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{unitId, newStructureInfo.getLongNumber() + "!%"});
                break;
            }
            case 3: {
                if (ToolUtils.equalObject((Object)newStructureInfo.getLongNumber(), (Object)oldStructureInfo.getLongNumber()) && ToolUtils.equalObject((Object)newStructureInfo.getDisplayName(LocaleUtils.getLocale((String)"L1")), (Object)oldStructureInfo.getDisplayName(LocaleUtils.getLocale((String)"L1"))) && ToolUtils.equalObject((Object)newStructureInfo.getDisplayName(LocaleUtils.getLocale((String)"L2")), (Object)oldStructureInfo.getDisplayName(LocaleUtils.getLocale((String)"L2"))) && ToolUtils.equalObject((Object)newStructureInfo.getDisplayName(LocaleUtils.getLocale((String)"L3")), (Object)oldStructureInfo.getDisplayName(LocaleUtils.getLocale((String)"L3")))) {
                    deleteSql = sqlsToRun[0] + " where (fid=?)";
                    DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{unitId});
                    addSql = sqlsToRun[1] + " and (ou.fid=?)";
                    DbUtil.execute((Context)ctx, (String)addSql, (Object[])new String[]{unitId});
                    break;
                }
                deleteSql = sqlsToRun[0] + " where (fid=? OR flongnumber like ?)";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{unitId, oldStructureInfo.getLongNumber() + "!%"});
                addSql = sqlsToRun[1] + " and (ou.fid=? OR stru.flongnumber like ?)";
                DbUtil.execute((Context)ctx, (String)addSql, (Object[])new String[]{unitId, newStructureInfo.getLongNumber() + "!%"});
                OrgTypeAppCenter.getInstance().updateParentStructure(ctx, orgType, oldStructureInfo, false);
                break;
            }
            case 4: {
                updateSql = sqlsToRun[3] + " WHERE (fid=? OR flongnumber like ?)";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new String[]{unitId, unitInfo.getLongNumber() + "!%"});
                updateSql = sqlsToRun[2] + " WHERE (fid=? OR flongnumber like ?)";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new String[]{unitId, unitInfo.getLongNumber() + "!%"});
                OrgTypeAppCenter.getInstance().updateParentStructure(ctx, orgType, oldStructureInfo, false);
                break;
            }
            case 5: {
                deleteSql = sqlsToRun[0] + " where (fid=? OR flongnumber like ?)";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{unitId, oldStructureInfo.getLongNumber() + "!%"});
                addSql = sqlsToRun[1] + " and (ou.fid=? OR stru.flongnumber like ?)";
                DbUtil.execute((Context)ctx, (String)addSql, (Object[])new String[]{unitId, newStructureInfo.getLongNumber() + "!%"});
                OrgTypeAppCenter.getInstance().updateParentStructure(ctx, orgType, oldStructureInfo, false);
                break;
            }
        }
        OrgTypeAppCenter.getInstance().updateParentStructure(ctx, orgType, newStructureInfo, true);
        OrgTypeSelfInfo orgTypeInfo = OrgTypeAppCenter.getInstance().getOrgTypeSelfInfo(ctx, orgType);
        ORMValueCacheService.getInstance().discardType(ctx, orgTypeInfo.getOrgViewBosType());
    }

    private boolean isNewDifferentToOld(Context ctx, IObjectValue newInfo, IObjectValue oldInfo) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo orgUnitEntity = loader.getEntity(newInfo.getBOSType());
        PropertyCollection propertyCol = orgUnitEntity.getPropertiesRuntime();
        for (int index = 0; index < propertyCol.size(); ++index) {
            PropertyInfo propertyInfo = propertyCol.get(index);
            String propertyName = propertyInfo.getName();
            if ("orgTypeStr".equals(propertyName) || "lastUpdateUser".equals(propertyName) || "lastUpdateTime".equals(propertyName) || "parent".equals(propertyName) || "versionNumber".equals(propertyName)) continue;
            Object newObj = newInfo.get(propertyName);
            Object oldObj = oldInfo.get(propertyName);
            if (newObj instanceof CoreBaseInfo && oldObj instanceof CoreBaseInfo) {
                CoreBaseInfo newBaseInfo = (CoreBaseInfo)newObj;
                CoreBaseInfo oldBaseInfo = (CoreBaseInfo)oldObj;
                if (ToolUtils.equalObject((Object)newBaseInfo.getId(), (Object)oldBaseInfo.getId())) continue;
                return true;
            }
            if (ToolUtils.equalObject((Object)newObj, (Object)oldObj)) continue;
            return true;
        }
        return false;
    }

    private Set getNeedOrgSpecialTalbesEnum(Context ctx, FullOrgUnitInfo unitInfo, OrgTypeAppCenter orgCenter) throws EASBizException, BOSException {
        String orgTypeStr = unitInfo.getOrgTypeStr();
        Set newOrgTypeSet = new OrgTypeHelper(orgTypeStr).getAllSelectOrgTypeSet();
        TreeSet orgTypeSet = new TreeSet();
        if (unitInfo.get("OldData") != null) {
            FullOrgUnitInfo oldUnitInfo = (FullOrgUnitInfo)unitInfo.get("OldData");
            String oldOrgTypeStr = oldUnitInfo.getOrgTypeStr();
            Set oldOrgTypeSet = new OrgTypeHelper(oldOrgTypeStr).getAllSelectOrgTypeSet();
            oldOrgTypeSet.addAll(newOrgTypeSet);
            return oldOrgTypeSet;
        }
        return newOrgTypeSet;
    }

    private boolean isCUEdit(FullOrgUnitInfo unitInfo, Set orgTypeSet) {
        if (unitInfo == null || orgTypeSet == null || orgTypeSet.size() == 0) {
            return false;
        }
        for (OrgType orgType : orgTypeSet) {
            OUPartCoreBaseInfo ouPartInfo = unitInfo.getOUPart(orgType);
            if (!unitInfo.isIsCU() || 10 == orgType.getValue() || ouPartInfo != null) continue;
            return true;
        }
        return false;
    }

    private boolean isNeedRebuildOrgViews(FullOrgUnitInfo unitInfo, int enumValue) {
        if (unitInfo == null) {
            return true;
        }
        String orgTypeStr = unitInfo.getOrgTypeStr();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(OrgSpecialTalbesEnum.getEnum(enumValue));
        if (orgTypeInfo == null) {
            return false;
        }
        String oldOrgTypeStr = null;
        Set oldOrgTypeSet = new HashSet();
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgTypeStr);
        if (unitInfo.get("olddata") != null) {
            oldOrgTypeStr = ((FullOrgUnitInfo)unitInfo.get("olddata")).getOrgTypeStr();
            oldOrgTypeSet = new OrgTypeHelper(oldOrgTypeStr).getAllSelectOrgTypeSet();
            Set newOrgTypeSet = orgTypeHelper.getAllSelectOrgTypeSet();
            oldOrgTypeSet.addAll(newOrgTypeSet);
            Iterator it = oldOrgTypeSet.iterator();
            while (it.hasNext()) {
                orgTypeHelper.addOrgType((OrgType)((Object)it.next()));
            }
        }
        OrgType curOrgType = orgTypeInfo.getOrgType();
        return orgTypeHelper.isOrgType(curOrgType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _rebuildSpecialTables(Context ctx, int enumValue) throws BOSException, EASBizException {
        Statement st;
        Connection cn;
        block9: {
            if (enumValue == 10) {
                OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToHRDefaultRelation();
                return;
            }
            if (enumValue == 11) {
                OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToFIDefaultRelation();
                return;
            }
            String[] sqlsToRun = OrgSpecialTablesSqlManager.getInstance().getSqlByEnumValue(enumValue);
            cn = null;
            st = null;
            try {
                cn = this.getConnection(ctx);
                st = cn.createStatement();
                st.addBatch(sqlsToRun[0]);
                st.addBatch(sqlsToRun[1]);
                st.executeBatch();
                if (enumValue == 2) {
                    OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildOrgDefaultRelation();
                    break block9;
                }
                if (enumValue == 9) {
                    OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToHRDefaultRelation();
                    break block9;
                }
                if (enumValue != 1) break block9;
                OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToFIDefaultRelation();
            }
            catch (Exception e) {
                try {
                    SQLException sqle;
                    CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    StringBuffer detail = new StringBuffer();
                    detail.append("Rebuild organization view tables error!\n").append("Current user is: ").append(ctx.getUserName()).append("\n").append("Current control unit is: ").append(cuInfo.getName()).append("\n").append("Detail exception is: \n");
                    if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                        logger.error((Object)"***************************** Next exception is: ****************************");
                        sqle.printStackTrace();
                    }
                    logger.error((Object)(detail + e.getMessage()), (Throwable)e);
                    if (!(e.getCause() instanceof SQLException)) throw new BOSException((Throwable)e);
                    throw new BOSException((Throwable)JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause())));
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(st, (Connection)cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return;
    }

    @Override
    protected void _rebuildSpecialTables(Context ctx, int[] enumValues) throws BOSException, EASBizException {
        Connection cn = null;
        Statement st = null;
        String[] sqlsToRun = null;
        boolean hasRebuildAdminToHR = false;
        boolean hasRebuildAdminToFI = false;
        boolean hasStatement = false;
        try {
            cn = this.getConnection(ctx);
            st = cn.createStatement();
            int n = enumValues.length;
            for (int i = 0; i < n; ++i) {
                if (enumValues[i] == 10) {
                    if (hasRebuildAdminToHR) continue;
                    OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToHRDefaultRelation();
                    hasRebuildAdminToHR = true;
                    continue;
                }
                if (enumValues[i] == 11) {
                    if (hasRebuildAdminToFI) continue;
                    OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToFIDefaultRelation();
                    hasRebuildAdminToFI = true;
                    continue;
                }
                hasStatement = true;
                sqlsToRun = OrgSpecialTablesSqlManager.getInstance().getSqlByEnumValue(enumValues[i]);
                st.addBatch(sqlsToRun[0]);
                st.addBatch(sqlsToRun[1]);
                if (enumValues[i] == 2) {
                    if (!hasRebuildAdminToHR) {
                        OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToHRDefaultRelation();
                        hasRebuildAdminToHR = true;
                    }
                    if (hasRebuildAdminToFI) continue;
                    OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToFIDefaultRelation();
                    hasRebuildAdminToFI = true;
                    continue;
                }
                if (enumValues[i] == 9) {
                    if (hasRebuildAdminToHR) continue;
                    OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToHRDefaultRelation();
                    hasRebuildAdminToHR = true;
                    continue;
                }
                if (enumValues[i] != 1 || hasRebuildAdminToFI) continue;
                OrgUnitDefaultRelationFactory.getLocalInstance(ctx).rebuildAdminToFIDefaultRelation();
                hasRebuildAdminToFI = true;
            }
            if (hasStatement) {
                st.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                SQLException sqle;
                CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                StringBuffer detail = new StringBuffer();
                detail.append("Rebuild organization view tables error!\n").append("Current user is: ").append(ctx.getUserName()).append("\n").append("Current control unit is: ").append(cuInfo.getName()).append("\n").append("Detail exception is: \n");
                if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                    logger.error((Object)"***************************** Next exception is: ****************************");
                    sqle.printStackTrace();
                }
                logger.error((Object)(detail + e.getMessage()), (Throwable)e);
                if (e.getCause() instanceof SQLException) {
                    throw new BOSException((Throwable)JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause())));
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    @Override
    protected void _rebuildOrgStructureDisplayName(Context ctx) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ListElement> elemList = new ArrayList<ListElement>();
        HashMap<String, DisplayName> map = new HashMap<String, DisplayName>();
        String selectSql = new StringBuffer().append("SELECT struc.FID, struc.FParentID, unit.FNumber, unit.FName_L1, unit.FName_L2, unit.FName_L3 ").append("FROM T_ORG_Structure struc INNER JOIN T_ORG_BaseUnit unit ON struc.FUnitID = unit.FID ").append("ORDER BY struc.FLongNumber, struc.FID").toString();
        String updateSql = "UPDATE T_ORG_Structure SET FLongNumber = ?, FDisplayName_L1 = ?, FDisplayName_L2 = ?, FDisplayName_L3 = ? WHERE FID = ?";
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectSql);
            while (rs.next()) {
                String id = rs.getString(1);
                String parentId = rs.getString(2);
                String number = rs.getString(3);
                String name_l1 = rs.getString(4);
                String name_l2 = rs.getString(5);
                String name_l3 = rs.getString(6);
                ListElement elem = new ListElement(id, parentId, number, name_l1, name_l2, name_l3);
                elemList.add(elem);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(updateSql);
            for (int i = 0; i < elemList.size(); ++i) {
                ListElement elem = (ListElement)elemList.get(i);
                String id = elem.id;
                String parentId = elem.parentId;
                String number = elem.number;
                String name_l1 = elem.name_l1;
                String name_l2 = elem.name_l2;
                String name_l3 = elem.name_l3;
                if (parentId != null) {
                    DisplayName dis = (DisplayName)map.get(parentId);
                    if (dis == null) {
                        StringBuffer errerInfor = new StringBuffer();
                        errerInfor.append("---***_rebuildOrgStructureDisplayName***---\n").append("id = ").append(id).append("\n").append("parentId = ").append(parentId).append("\n").append("number = ").append(number).append("\n");
                        continue;
                    }
                    number = dis.longNumber == null || number == null ? null : dis.longNumber + "!" + number;
                    name_l1 = dis.displayName_l1 == null || name_l1 == null ? null : dis.displayName_l1 + "_" + name_l1;
                    name_l2 = dis.displayName_l2 == null || name_l2 == null ? null : dis.displayName_l2 + "_" + name_l2;
                    name_l3 = dis.displayName_l3 == null || name_l3 == null ? null : dis.displayName_l3 + "_" + name_l3;
                }
                map.put(id, new DisplayName(number, name_l1, name_l2, name_l3));
                pstmt.setString(1, number);
                pstmt.setString(2, name_l1);
                pstmt.setString(3, name_l2);
                pstmt.setString(4, name_l3);
                pstmt.setString(5, id);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                if (e.getCause() instanceof SQLException) {
                    throw new BOSException((Throwable)JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause())));
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _deleteDuplicateOrgRelation(Context ctx) throws BOSException {
        String selectDupSql = "SELECT FFromUnitID, FToUnitID, FTypeRelationID FROM T_ORG_UnitRelation GROUP BY FFromUnitID, FToUnitID, FTypeRelationID HAVING COUNT(FFromUnitID) > 1";
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<OrgElement> duplicateList = new ArrayList<OrgElement>();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectDupSql);
            String fromUnitID = null;
            String toUnitID = null;
            String typeRelationID = null;
            OrgElement orgElement = null;
            while (rs.next()) {
                fromUnitID = rs.getString(1);
                toUnitID = rs.getString(2);
                typeRelationID = rs.getString(3);
                orgElement = new OrgElement(fromUnitID, toUnitID, typeRelationID);
                duplicateList.add(orgElement);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        if (duplicateList.size() > 0) {
            block14: {
                String selectSql = "SELECT FID FROM T_ORG_UnitRelation WHERE FFromUnitID = ? AND FToUnitID = ? AND FTypeRelationID = ?";
                ArrayList<String> idList = new ArrayList<String>();
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(selectSql);
                    ResultSet tmp = null;
                    for (int i = 0; i < duplicateList.size(); ++i) {
                        OrgElement elem = (OrgElement)duplicateList.get(i);
                        pstmt.setString(1, elem.fromUnitID);
                        pstmt.setString(2, elem.toUnitID);
                        pstmt.setString(3, elem.typeRelationID);
                        tmp = pstmt.executeQuery();
                        if (tmp.next()) {
                            String id = null;
                            while (tmp.next()) {
                                id = tmp.getString(1);
                                idList.add(id);
                            }
                        }
                        tmp.close();
                        tmp = null;
                    }
                    pstmt.close();
                    pstmt = null;
                    if (idList.size() <= 0) break block14;
                    String deleteSql = "DELETE FROM T_ORG_UnitRelation WHERE FID = ?";
                    pstmt = conn.prepareStatement(deleteSql);
                    for (int i = 0; i < idList.size(); ++i) {
                        pstmt.setString(1, (String)idList.get(i));
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
                catch (Exception e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected void _rebuildOrgStructureLongNumbers(Context ctx) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Object pstmt = null;
        HashMap<String, ListElement> map = new HashMap<String, ListElement>();
        HashMap mapSon = new HashMap();
        String structureSql = new StringBuffer().append("select struc.FID,struc.FLongNumber,struc.FParentID,unit.FNumber ").append("from T_ORG_Structure struc INNER JOIN T_org_baseUnit unit ").append("on struc.FUnitID = unit.FID ").append(" order by struc.FLEVEL").toString();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(structureSql);
            while (rs.next()) {
                String id = rs.getString("FID");
                String longNumber = rs.getString("FLongNumber");
                String number = rs.getString("FNumber");
                String parentId = rs.getString("FParentID");
                ListElement listElement = new ListElement(id, longNumber, number, parentId);
                map.put(id, listElement);
                Set sonSet = null;
                sonSet = mapSon.get(parentId) == null ? new HashSet() : (Set)mapSon.get(parentId);
                sonSet.add(listElement);
                mapSon.put(parentId, sonSet);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        this.updateLongNumber(ctx, (Set)mapSon.get(null), mapSon, map);
    }

    protected void updateLongNumber(Context ctx, Set set, Map mapSon, Map map) throws BOSException {
        Connection conn = null;
        Object stmt = null;
        PreparedStatement pstmt = null;
        String updateSql = "UPDATE T_ORG_Structure SET FLongNumber = ? WHERE FID = ?";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(updateSql);
            for (ListElement elem : set) {
                String id = elem.id;
                String number = elem.number;
                String longNumber = elem.longNumber;
                Set sonSet = (Set)mapSon.get(id);
                String parentId = elem.parentId;
                if (!StringUtils.isEmpty((String)parentId)) {
                    ListElement elemParent = (ListElement)map.get(parentId);
                    longNumber = elemParent.longNumber == null || number == null ? null : elemParent.longNumber + "!" + number;
                    pstmt.setString(1, longNumber);
                    pstmt.setString(2, id);
                    pstmt.executeUpdate();
                    map.put(id, new ListElement(id, longNumber, number, parentId));
                }
                if (sonSet == null || sonSet.size() == 0) continue;
                this.updateLongNumber(ctx, sonSet, mapSon, map);
            }
        }
        catch (Exception e) {
            try {
                if (e.getCause() instanceof SQLException) {
                    throw new BOSException((Throwable)JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause())));
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _rebuildAdminCU(Context ctx) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ListElement> elemList = new ArrayList<ListElement>();
        HashMap<String, ListElement> elemListmap = new HashMap<String, ListElement>();
        String selectSql = new StringBuffer().append("select struc.FID,struc.FParentID,struc.FUnitID,unit.FIsCU ").append("from T_ORG_Structure struc INNER JOIN T_org_baseUnit unit ").append("on struc.FUnitID = unit.FID ").append("where struc.FTreeId = '").append("00000000-0000-0000-0000-0000000000034F2827FD").append("' order by struc.FLongNumber,struc.FLEVEL").toString();
        String updateSql = "UPDATE T_ORG_OUPartAdmin SET FControlUnitID = ? WHERE FUnitID = ?";
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectSql);
            while (rs.next()) {
                String id = rs.getString("FID");
                String parentId = rs.getString("FParentID");
                String unitId = rs.getString("FUnitID");
                boolean isCu = rs.getBoolean("FIsCU");
                ListElement elem = new ListElement(id, parentId, unitId, isCu);
                elemList.add(elem);
                elemListmap.put(id, elem);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(updateSql);
            for (int i = 0; i < elemList.size(); ++i) {
                ListElement elem = (ListElement)elemList.get(i);
                String id = elem.id;
                String parentId = elem.parentId;
                String unitId = elem.unitId;
                boolean isCu = elem.isCu;
                if (isCu) {
                    pstmt.setString(1, unitId);
                } else {
                    pstmt.setString(1, this.getControlUnitID(id, elemListmap));
                }
                pstmt.setString(2, unitId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private String getControlUnitID(String id, HashMap elemListmap) {
        ListElement elem = (ListElement)elemListmap.get(id);
        if (elem.isCu) {
            return elem.unitId;
        }
        return this.getControlUnitID(elem.parentId, elemListmap);
    }

    private class OrgElement {
        String fromUnitID = null;
        String toUnitID = null;
        String typeRelationID = null;

        public OrgElement(String fromUnitID, String toUnitID, String typeRelationID) {
            this.fromUnitID = fromUnitID;
            this.toUnitID = toUnitID;
            this.typeRelationID = typeRelationID;
        }
    }

    private class DisplayName {
        String longNumber = null;
        String displayName_l1 = null;
        String displayName_l2 = null;
        String displayName_l3 = null;

        DisplayName(String longNumber, String displayName_l1, String displayName_l2, String displayName_l3) {
            this.longNumber = longNumber;
            this.displayName_l1 = displayName_l1;
            this.displayName_l2 = displayName_l2;
            this.displayName_l3 = displayName_l3;
        }
    }

    private class ListElement {
        String id = null;
        String parentId = null;
        String number = null;
        String name_l1 = null;
        String name_l2 = null;
        String name_l3 = null;
        String unitId = null;
        boolean isCu = false;
        String longNumber = null;

        public ListElement(String id, String parentId, String number, String name_l1, String name_l2, String name_l3) {
            this.id = id;
            this.parentId = parentId;
            this.number = number;
            this.name_l1 = name_l1;
            this.name_l2 = name_l2;
            this.name_l3 = name_l3;
        }

        public ListElement(String id, String parentId, String unitId, boolean isCu) {
            this.id = id;
            this.parentId = parentId;
            this.unitId = unitId;
            this.isCu = isCu;
        }

        public ListElement(String id, String longNumber, String number, String parentId) {
            this.id = id;
            this.longNumber = longNumber;
            this.number = number;
            this.parentId = parentId;
        }
    }
}

