/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.app.AbstractOrgSwitchFacadeControllerBean;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeInitHelper;
import com.kingdee.eas.basedata.org.app.helper.QueryOrgInfoHelper;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgSwitchFacadeControllerBean
extends AbstractOrgSwitchFacadeControllerBean {
    private static Logger logger = Logger.getLogger(OrgSwitchFacadeControllerBean.class);

    @Override
    protected void _orgSwitch(Context ctx, String ouId) throws BOSException, EASBizException {
        HashMap map = this._getSwitchOrgs(ctx, ouId);
        IContextManager contextManager = ContextManagerFactory.getLocalInstance((Context)ctx);
        contextManager.setContext((Map)map);
    }

    @Override
    protected HashMap _getOrgs(Context ctx, String ouId) throws BOSException, EASBizException {
        HashMap map = this._getSwitchOrgs(ctx, ouId);
        IContextManager contextManager = ContextManagerFactory.getLocalInstance((Context)ctx);
        contextManager.setContext((Map)map);
        return map;
    }

    @Override
    protected HashMap _getSwitchOrgs(Context ctx, String ouId) throws BOSException, EASBizException {
        OrgUnitCollection toHrUnitCol;
        OrgTypeInitHelper helper = new OrgTypeInitHelper();
        helper.checkOrgInit(ctx);
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        FullOrgUnitInfo ouInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(ouId));
        CtrlUnitInfo cuInfo = ouInfo.getCU();
        if (cuInfo == null || cuInfo.getId() == null) {
            throw new OrgException(OrgException.CURRENT_CU_IS_NULL);
        }
        INewOrgUnitFacade iNOU = NewOrgUnitFacadeFactory.getLocalInstance(ctx);
        HashMap<Object, OrgUnitInfo> map = new HashMap<Object, OrgUnitInfo>();
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)((Object)orgTypeList.get(i));
            try {
                OrgUnitInfo orgUnitInfo = iNOU.getDelegateUnit(ouInfo, curOrgType);
                if (OrgType.UnionDebt.equals((Object)curOrgType)) continue;
                map.put((Object)curOrgType, orgUnitInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("---OrgSwitchFacadeC*B---load orgtype :" + (Object)((Object)curOrgType) + " fail!"));
                logger.error((Object)e);
            }
        }
        try {
            OrgUnitInfo fiInfo = iNOU.getDelegateUnit(ouId, OrgType.Company);
            map.put((Object)OrgType.Company, fiInfo);
            map.put("CompanyInfo", fiInfo);
        }
        catch (Exception e) {
            // empty catch block
        }
        map.put("CurOU", ouInfo);
        if (ouInfo.isIsAdminOrgUnit() && !ouInfo.isIsHROrgUnit() && (toHrUnitCol = OrgUnitRelationFactory.getLocalInstance(ctx).getToUnit(ouInfo.getId().toString(), 0, 16)) != null && toHrUnitCol.size() == 1) {
            map.put((Object)OrgType.HRO, toHrUnitCol.get(0));
        }
        return map;
    }

    private IObjectCollection getOrgRangesCommon(Context ctx, IObjectPK userPK, boolean isSimple) throws BOSException, EASBizException {
        FullOrgUnitCollection fullCol = new FullOrgUnitCollection();
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("SELECT DISTINCT BaseUnit.FID").append(" FROM T_PM_OrgRange OrgRange ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON OrgRange.FOrgID = BaseUnit.FID  ").append(" WHERE OrgRange.FUserID = ? ").append(" AND OrgRange.FType = ").append(10).append(" AND BaseUnit.FIsAssistantOrg = 0");
        Object[] params = new Object[]{userPK.toString()};
        try {
            QueryOrgInfoHelper queryHelper = new QueryOrgInfoHelper();
            fullCol = isSimple ? queryHelper.querySimpleOrgUnitCol(ctx, buffer.toString(), params) : queryHelper.queryOrgUnitCol(ctx, buffer.toString(), params);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_ORGRANGE_FAIL, (Throwable)e);
        }
        if (Administrator.isSuperCUAdmin((IObjectPK)userPK) && fullCol.isEmpty()) {
            return this.initAdministratorOrgRange(ctx);
        }
        return fullCol;
    }

    @Override
    protected IObjectCollection _getOrgRanges(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        return this.getOrgRangesCommon(ctx, userPK, false);
    }

    @Override
    protected IObjectCollection _getSimpleOrgRanges(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        return this.getOrgRangesCommon(ctx, userPK, true);
    }

    private FullOrgUnitCollection initAdministratorOrgRange(Context ctx) throws EASBizException, BOSException {
        FullOrgUnitCollection fullCol = new FullOrgUnitCollection();
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance(ctx);
        EntityViewInfo entityInfo = new EntityViewInfo();
        entityInfo.getSelector().add("id");
        CtrlUnitCollection ctrlUnitCol = iCtrlUnit.getCtrlUnitCollection(entityInfo);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F"));
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        if (ctrlUnitCol != null && !ctrlUnitCol.isEmpty()) {
            OrgRangeCollection orgRangeCol = new OrgRangeCollection();
            int size = ctrlUnitCol.size();
            for (int i = 0; i < size; ++i) {
                CtrlUnitInfo ctrlInfo = ctrlUnitCol.get(i);
                OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
                FullOrgUnitInfo fullOrgInfo = ctrlInfo.castToFullOrgUnitInfo();
                orgRangeInfo.setOrg(fullOrgInfo);
                orgRangeInfo.setUser(userInfo);
                orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
                if (fullOrgInfo == null || fullOrgInfo.getId() == null || fullOrgInfo.getId().toString().equals("11111111-1111-1111-1111-111111111111CCE7AED4")) continue;
                orgRangeCol.add(orgRangeInfo);
                fullCol.add(fullOrgInfo);
            }
            iOrgRange.addNewCol(orgRangeCol);
        }
        return fullCol;
    }

    @Override
    protected void _initOrgData(Context ctx) throws BOSException, EASBizException {
        OrgTypeInitHelper helper = new OrgTypeInitHelper();
        helper.initFieldData(ctx);
    }
}

