/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.UnsupportFunctionException;
import com.kingdee.eas.basedata.org.app.AbstractOrgUnitCommonControlBean;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;

public class OrgUnitCommonControlBean
extends AbstractOrgUnitCommonControlBean {
    @Override
    protected IObjectCollection _getOrgTrees(Context ctx, OrgType orgType) throws BOSException, EASBizException {
        IOrgTree tree = OrgTreeFactory.getLocalInstance(ctx);
        OrgViewType viewType = NewOrgViewHelper.convert(orgType);
        String oql = "select * where type=" + viewType.getValue() + " order by basic";
        return tree.getOrgTreeCollection(oql);
    }

    @Override
    protected IObjectValue _getBasicTree(Context ctx, OrgType orgType) throws BOSException, EASBizException {
        IOrgTree tree = OrgTreeFactory.getLocalInstance(ctx);
        OrgViewType viewType = NewOrgViewHelper.convert(orgType);
        String oql = "select * where type=" + viewType.getValue() + " and basic=1";
        OrgTreeCollection col = tree.getOrgTreeCollection(oql);
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.getObject(0);
    }

    @Override
    protected IObjectValue _getOrgUnit(Context ctx, BOSUuid unitId) throws BOSException, EASBizException {
        return NewOrgUnitHelper.getTypedOrgUnit(ctx, unitId.toString(), OrgType.NONE);
    }

    @Override
    protected IObjectValue _getOrgUnit(Context ctx, BOSUuid unitID, SelectorItemCollection selectorItems) throws BOSException, EASBizException {
        return NewOrgUnitHelper.getTypedOrgUnit(ctx, unitID.toString(), OrgType.NONE);
    }

    @Override
    protected IObjectCollection _getOrgUnits(Context ctx, BOSUuid[] orgUnitIds) throws BOSException, EASBizException {
        return this._getOrgUnits(ctx, orgUnitIds, null);
    }

    @Override
    protected IObjectCollection _getOrgUnits(Context ctx, BOSUuid[] orgUnitIds, SelectorItemCollection selectorItems) throws BOSException, EASBizException {
        OrgUnitCollection col = new OrgUnitCollection();
        if (selectorItems == null) {
            for (int i = 0; i < orgUnitIds.length; ++i) {
                col.add((OrgUnitInfo)this._getOrgUnit(ctx, orgUnitIds[i]));
            }
        } else {
            for (int i = 0; i < orgUnitIds.length; ++i) {
                col.add((OrgUnitInfo)this._getOrgUnit(ctx, orgUnitIds[i], selectorItems));
            }
        }
        return col;
    }

    @Override
    protected IObjectCollection _getChildrenUnits(Context ctx, BOSUuid treeID, BOSUuid unitID) throws BOSException, EASBizException {
        return this._getChildrenUnits(ctx, treeID, unitID, null);
    }

    @Override
    protected IObjectCollection _getChildrenUnits(Context ctx, BOSUuid treeID, BOSUuid unitID, SelectorItemCollection selectorItems) throws BOSException, EASBizException {
        IOrgStructure struct = OrgStructureFactory.getLocalInstance(ctx);
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(treeID);
        OrgUnitInfo unitInfo = new OrgUnitInfo();
        unitInfo.setId(unitID);
        OrgStructureInfo structInfo = struct.getValue(treeInfo, unitInfo);
        if (structInfo == null) {
            return null;
        }
        String longNumber = structInfo.getLongNumber();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID));
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!" + "%"), CompareType.LIKE));
        evi.getSorter().add(new SorterItemInfo("level"));
        evi.setFilter(fi);
        OrgStructureCollection col = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureCollection(evi);
        OrgUnitCollection result = new OrgUnitCollection();
        for (int i = 0; i < col.size(); ++i) {
            result.add(col.get(i).getUnit());
        }
        return result;
    }

    @Override
    protected IObjectCollection _getBrotherUnits(Context ctx, BOSUuid treeID, BOSUuid unitID) throws BOSException, EASBizException {
        return this._getBrotherUnits(ctx, treeID, unitID, null);
    }

    @Override
    protected IObjectCollection _getBrotherUnits(Context ctx, BOSUuid treeID, BOSUuid unitID, SelectorItemCollection selectorItems) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(treeID);
        OrgUnitInfo unitInfo = new OrgUnitInfo();
        unitInfo.setId(unitID);
        IOrgStructure structure = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo structInfo = structure.getValue(treeInfo, unitInfo);
        if (structInfo == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID));
        fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)structInfo.getParent().getId()));
        fi.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitID, CompareType.NOTEQUALS));
        evi.setFilter(fi);
        OrgStructureCollection col = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureCollection(evi);
        OrgUnitCollection result = new OrgUnitCollection();
        for (int i = 0; i < col.size(); ++i) {
            result.add(col.get(i).getUnit());
        }
        return result;
    }

    @Override
    protected IObjectValue _getParentUnit(Context ctx, BOSUuid treeID, BOSUuid unitID) throws BOSException, EASBizException {
        return this._getParentUnit(ctx, treeID, unitID, null);
    }

    @Override
    protected IObjectValue _getParentUnit(Context ctx, BOSUuid treeID, BOSUuid unitID, SelectorItemCollection selectorItems) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(treeID);
        OrgUnitInfo unitInfo = new OrgUnitInfo();
        unitInfo.setId(unitID);
        IOrgStructure structure = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo structInfo = structure.getValue(treeInfo, unitInfo);
        if (structInfo == null) {
            return null;
        }
        if (structInfo.getParent() == null) {
            return null;
        }
        ObjectUuidPK parentPK = new ObjectUuidPK(structInfo.getParent().getId());
        OrgStructureInfo parentStructInfo = (OrgStructureInfo)structure.getValue((IObjectPK)parentPK);
        if (selectorItems == null) {
            return this._getOrgUnit(ctx, parentStructInfo.getUnit().getId());
        }
        return this._getOrgUnit(ctx, parentStructInfo.getUnit().getId(), selectorItems);
    }

    @Override
    protected IObjectValue _getRelationUnit(Context ctx, BOSUuid _fromUnitID, OrgType _toOrgType) throws BOSException, EASBizException {
        return NewOrgUnitFacadeFactory.getLocalInstance(ctx).getDelegateUnit(_fromUnitID.toString(), _toOrgType);
    }

    @Override
    protected IObjectValue _getRelationUnit(Context ctx, BOSUuid fromUnitID, OrgType toOrgType, SelectorItemCollection selectorItems) throws BOSException, EASBizException {
        return NewOrgUnitFacadeFactory.getLocalInstance(ctx).getDelegateUnit(fromUnitID.toString(), toOrgType);
    }

    @Override
    protected IObjectValue _getRootUnit(Context ctx, BOSUuid treeID) throws BOSException, EASBizException {
        return this._getRootUnit(ctx, treeID, null);
    }

    @Override
    protected IObjectValue _getRootUnit(Context ctx, BOSUuid treeID, SelectorItemCollection selectorItems) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID));
        fi.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1)));
        evi.setFilter(fi);
        OrgStructureCollection col = OrgStructureFactory.getLocalInstance(ctx).getOrgStructureCollection(evi);
        if (col.size() == 0) {
            return null;
        }
        return this._getOrgUnit(ctx, col.get(0).getUnit().getId(), selectorItems);
    }

    @Override
    protected IObjectValue _getCompany(Context ctx, BOSUuid unitID) throws BOSException, EASBizException {
        INewOrgUnitFacade facade = NewOrgUnitFacadeFactory.getLocalInstance(ctx);
        return facade.getDelegateUnit(unitID.toString(), OrgType.NONE, OrgType.Company);
    }

    @Override
    protected IObjectValue _getCompany(Context ctx, BOSUuid unitID, SelectorItemCollection selectors) throws BOSException, EASBizException {
        INewOrgUnitFacade facade = NewOrgUnitFacadeFactory.getLocalInstance(ctx);
        return facade.getDelegateUnit(unitID.toString(), OrgType.NONE, OrgType.Company);
    }

    @Override
    protected IObjectCollection _getPrincipals(Context ctx, BOSUuid adminOrgId) throws BOSException, EASBizException {
        IAdminOrgUnit iadmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo info = iadmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId));
        if (info == null) {
            throw new OrgException(OrgException.NOT_EXIST_SUCH_ADMINORG);
        }
        if (info.getResponPosition() == null) {
            throw new OrgException(OrgException.NOT_EXIST_RES_ORG);
        }
        IPositionMember iPH = PositionMemberFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)info.getResponPosition().getId()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("person.name"));
        PositionMemberCollection phCol = iPH.getPositionMemberCollection(evi);
        if (phCol == null) {
            return new PersonCollection();
        }
        PersonCollection pCol = new PersonCollection();
        for (int i = 0; i < phCol.size(); ++i) {
            pCol.add(phCol.get(i).getPerson());
        }
        return pCol;
    }

    private void addPersonCollectionByIRowSet(PersonCollection persons, IRowSet rows) throws SQLException {
        if (persons == null) {
            persons = new PersonCollection();
        }
        PersonInfo info = null;
        while (rows.next()) {
            info = new PersonInfo();
            info.setId(BOSUuid.read((String)rows.getString("id")));
            info.setName(rows.getString("name"));
            info.setBirthday((Date)rows.getDate("birthday"));
            info.setGender(Genders.getEnum((int)rows.getInt("gender")));
            info.setNumber(rows.getString("number"));
            persons.add(info);
        }
    }

    @Override
    protected IObjectCollection _getAdminPersons(Context ctx, BOSUuid adminOrgId) throws BOSException, EASBizException {
        return this.getAdminPersons(ctx, adminOrgId, false);
    }

    private PersonCollection getAdminPersons(Context ctx, BOSUuid adminOrgId, boolean isAll) throws EASBizException, BOSException {
        IOrgUnitCommon iOrgUnitComm = null;
        iOrgUnitComm = OrgUnitCommonFactory.getLocalInstance(ctx);
        BOSUuid treeId = iOrgUnitComm.getBasicTree(OrgType.Admin).getId();
        IOrgStructure iOrgStructure = null;
        iOrgStructure = OrgStructureFactory.getLocalInstance(ctx);
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(treeId);
        AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
        orgInfo.setId(adminOrgId);
        OrgStructureInfo info = iOrgStructure.getValue(treeInfo, (OrgUnitInfo)orgInfo);
        String longNumber = info.getLongNumber();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PersonsByAdminOrg");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("OrgTree.id", (Object)treeId.toString()));
        if (isAll) {
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgStructure.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgStructure.longNumber", (Object)longNumber, CompareType.EQUALS));
        }
        filterInfo.setMaskString("#0 and #1");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        queryExcu.setObjectView(viewInfo);
        PersonCollection personInfos = new PersonCollection();
        try {
            this.addPersonCollectionByIRowSet(personInfos, queryExcu.executeQuery());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return personInfos;
    }

    @Override
    protected IObjectCollection _getAdminAllPersons(Context ctx, BOSUuid adminOrgId) throws EASBizException, BOSException {
        return this.getAdminPersons(ctx, adminOrgId, true);
    }

    @Override
    protected IObjectValue _getRootCompany(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getAdminByCompany(Context ctx, BOSUuid comUuid, OrgType fromOrgType, OrgType toOrgType) throws BOSException {
        throw new UnsupportFunctionException();
    }

    OrgStructureInfo getOrgStructureByUnit(Context ctx, OrgUnitInfo unitInfo, OrgTreeInfo tInfo) throws BOSException {
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfo.getId()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        OrgStructureCollection structInfos = iStruc.getOrgStructureCollection(view);
        if (structInfos.size() != 0) {
            return structInfos.get(0);
        }
        return null;
    }

    @Override
    protected IObjectCollection _getUnionDebtChildren(Context ctx, IObjectValue parentOrg, IObjectValue treeInfo) throws BOSException, EASBizException {
        OrgUnitCollection unitInfos = new OrgUnitCollection();
        OrgUnitInfo unitInfo = (OrgUnitInfo)parentOrg;
        OrgTreeInfo tInfo = (OrgTreeInfo)treeInfo;
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo structInfo = this.getOrgStructureByUnit(ctx, unitInfo, tInfo);
        if (structInfo != null) {
            EntityViewInfo view1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
            filter1.getFilterItems().add(new FilterItemInfo("parent.id", (Object)structInfo.getId()));
            view1.setFilter(filter1);
            view1.getSelector().add(new SelectorItemInfo("*"));
            view1.getSelector().add(new SelectorItemInfo("unit.id"));
            view1.getSelector().add(new SelectorItemInfo("unit.isGrouping"));
            view1.getSelector().add(new SelectorItemInfo("unit.name"));
            view1.getSelector().add(new SelectorItemInfo("unit.number"));
            view1.getSorter().add(new SorterItemInfo("unit.number"));
            OrgStructureCollection infos = iStruc.getOrgStructureCollection(view1);
            for (int i = 0; i < infos.size(); ++i) {
                unitInfos.add(infos.get(i).getUnit());
            }
            return unitInfos;
        }
        return null;
    }

    @Override
    protected IObjectCollection _getUnionDebtAllOrgUnit(Context ctx, IObjectValue parentOrg, IObjectValue treeInfo) throws BOSException, EASBizException {
        OrgUnitInfo unitInfo = (OrgUnitInfo)parentOrg;
        OrgTreeInfo tInfo = (OrgTreeInfo)treeInfo;
        OrgUnitCollection unitInfos = new OrgUnitCollection();
        OrgStructureInfo strucInfo = this.getOrgStructureByUnit(ctx, unitInfo, tInfo);
        if (strucInfo != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
            filter.getFilterItems().add(new FilterItemInfo("unit.isGrouping", (Object)new Integer(1), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(strucInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("unit.id"));
            view.getSelector().add(new SelectorItemInfo("unit.name"));
            view.getSelector().add(new SelectorItemInfo("unit.number"));
            view.getSorter().add(new SorterItemInfo("unit.number"));
            IOrgStructure iStruc = OrgStructureFactory.getLocalInstance(ctx);
            OrgStructureCollection strucInfos = iStruc.getOrgStructureCollection(view);
            if (strucInfos.size() != 0) {
                for (int i = 0; i < strucInfos.size(); ++i) {
                    unitInfos.add(strucInfos.get(i).getUnit());
                }
                return unitInfos;
            }
        }
        return null;
    }

    @Override
    protected String _getCompIdByNumber(Context ctx, String comNumber) throws BOSException, EASBizException {
        String oql = "select id where number='" + comNumber + "'";
        OrgUnitCollection col = NewOrgViewHelper.getOrgUnitCollection(ctx, OrgType.Company, oql);
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.get(0).getId().toString();
    }
}

