/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OUPartCoreBaseCollection;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.app.AbstractOrgViewControllerBean;
import com.kingdee.eas.basedata.org.app.ext.ExtHelper;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.app.helper.TreeDataHelper;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.org.stepadd.QueryTreeParamInfo;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgViewControllerBean
extends AbstractOrgViewControllerBean {
    private static Logger logger = Logger.getLogger((String)OrgViewControllerBean.class.getName());

    private OrgUnitCollection getOrgViewTree2(Context ctx, OrgViewType orgViewType) throws BOSException {
        OrgUnitCollection units = new OrgUnitCollection();
        OrgUnitInfo info = null;
        OrgUnitInfo parent = null;
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.org.app.OrgBudgetViewQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("OrgViewType", (Object)new Integer(orgViewType.getValue())));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("longNumber"));
        IQueryExecutor queryExecu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        queryExecu.setObjectView(evi);
        IRowSet rows = queryExecu.executeQuery();
        try {
            while (rows.next()) {
                info = new OrgUnitInfo();
                info.setId(BOSUuid.read((String)rows.getString("unitId")));
                info.setName(rows.getString("OrgUnit.name"));
                info.setNumber(rows.getString("OrgUnit.number"));
                info.setEffectDate(rows.getDate("OrgUnit.effectDate"));
                info.setInvalidDate(rows.getDate("OrgUnit.invalidDate"));
                info.setIsFreeze(rows.getBoolean("OrgUnit.isFreeze"));
                info.put("longNumber", rows.getString("longNumber"));
                info.put("level", new Integer(rows.getInt("level")));
                info.put("isLeaf", new Boolean(rows.getBoolean("isLeaf")));
                info.put("orgViewType", (Object)orgViewType);
                if (rows.getString("SuperOrgUnit.id") != null) {
                    parent = new OrgUnitInfo();
                    parent.setId(BOSUuid.read((String)rows.getString("SuperOrgUnit.id")));
                    parent.setName(rows.getString("SuperOrgUnit.name"));
                    parent.setNumber(rows.getString("SuperOrgUnit.number"));
                    parent.setEffectDate(rows.getDate("SuperOrgUnit.effectDate"));
                    parent.setInvalidDate(rows.getDate("SuperOrgUnit.invalidDate"));
                    parent.setIsFreeze(rows.getBoolean("SuperOrgUnit.isFreeze"));
                    info.put("superOrgUnit", parent);
                }
                units.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                rows.close();
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        return units;
    }

    @Override
    protected IObjectCollection _getOrgViewTree(Context ctx, OrgViewType orgViewType) throws BOSException {
        return this.getOrgViewTree2(ctx, orgViewType);
    }

    private IRowSet getIRowSetByQuery(Context ctx, String queryName, FilterInfo filter) throws BOSException {
        MetaDataPK querypk = new MetaDataPK(queryName);
        IQueryExecutor queryExecu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)querypk);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExecu.setObjectView(evi);
        return queryExecu.executeQuery();
    }

    private String getParentKey(String curKey) {
        if (curKey.lastIndexOf("!") == -1) {
            return null;
        }
        return curKey.substring(0, curKey.lastIndexOf("!"));
    }

    private OrgUnitCollection getUnitsByIRowSet(IRowSet rows, OrgType fromType, OrgViewType viewType) throws BOSException {
        return this.getUnitsByIRowSet(rows, fromType, null, viewType);
    }

    private OrgUnitCollection getResponseUnitsByIRowSet(IRowSet rows, OrgViewType viewType) throws BOSException {
        OrgUnitCollection units = new OrgUnitCollection();
        OrgUnitInfo info = null;
        OrgUnitInfo child = null;
        OrgUnitInfo grandChild = null;
        OrgUnitInfo parent = null;
        String parentLongNumber = null;
        OrgType fromType = OrgType.Company;
        OrgType toType = OrgType.ProfitCenter;
        OrgType toToType = OrgType.CostCenter;
        HashMap<String, OrgUnitInfo> map = new HashMap<String, OrgUnitInfo>();
        try {
            while (rows.next()) {
                if (!units.contains(BOSUuid.read((String)rows.getString("OrgUnit.id")))) {
                    info = new OrgUnitInfo();
                    info.setId(BOSUuid.read((String)rows.getString("OrgUnit.id")));
                    info.setName(rows.getString("OrgUnit.name"));
                    info.setNumber(rows.getString("OrgUnit.number"));
                    info.setEffectDate(rows.getDate("OrgUnit.effectDate"));
                    info.setInvalidDate(rows.getDate("OrgUnit.invalidDate"));
                    info.setIsFreeze(rows.getBoolean("OrgUnit.isFreeze"));
                    info.put("longNumber", rows.getString("OrgStructure.longNumber"));
                    info.put("level", new Integer(rows.getInt("OrgStructure.level")));
                    info.put("isLeaf", new Boolean(true));
                    info.put("orgViewType", (Object)viewType);
                    map.put((String)info.get("longNumber"), info);
                    parent = (OrgUnitInfo)map.get(this.getParentKey((String)info.get("longNumber")));
                    if (parent != null) {
                        parent.put("isLeaf", new Boolean("false"));
                        info.put("superOrgUnit", parent);
                    }
                    units.add(info);
                }
                if (!(rows.getString("ToUnit.id") == null || units.contains(BOSUuid.read((String)rows.getString("ToUnit.id"))) || rows.getString("ToUnit.id").trim().length() <= 0 || rows.getInt("OrgTypeRelation.fromType") != toType.getValue() && rows.getInt("OrgTypeRelation.fromType") != toToType.getValue() || rows.getInt("OrgTypeRelation.toType") != fromType.getValue())) {
                    child = new OrgUnitInfo();
                    child.setId(BOSUuid.read((String)rows.getString("ToUnit.id")));
                    child.setName(rows.getString("ToUnit.name"));
                    child.setNumber(rows.getString("ToUnit.number"));
                    child.setEffectDate(rows.getDate("ToUnit.effectDate"));
                    child.setInvalidDate(rows.getDate("ToUnit.invalidDate"));
                    child.setIsFreeze(rows.getBoolean("ToUnit.isFreeze"));
                    child.put("isLeaf", new Boolean(true));
                    child.put("orgViewType", (Object)viewType);
                    parent = units.get(info.getId());
                    if (parent != null) {
                        parentLongNumber = (String)parent.get("longNumber");
                        if (parentLongNumber != null) {
                            child.put("longNumber", parentLongNumber + "!" + child.getNumber());
                        } else {
                            child.put("longNumber", child.getNumber());
                        }
                        parent.put("isLeaf", new Boolean(false));
                        child.put("superOrgUnit", parent);
                        child.put("level", new Integer((Integer)parent.get("level") + 1));
                    }
                    units.add(child);
                }
                if (rows.getString("Unit.id") == null || rows.getString("Unit.id").trim().length() <= 0 || rows.getInt("TypeRelation.fromType") != toToType.getValue() || rows.getInt("TypeRelation.toType") != toType.getValue()) continue;
                grandChild = new OrgUnitInfo();
                grandChild.setId(BOSUuid.read((String)rows.getString("Unit.id")));
                grandChild.setName(rows.getString("Unit.name"));
                grandChild.setNumber(rows.getString("Unit.number"));
                grandChild.setEffectDate(rows.getDate("Unit.effectDate"));
                grandChild.setInvalidDate(rows.getDate("Unit.invalidDate"));
                grandChild.setIsFreeze(rows.getBoolean("Unit.isFreeze"));
                grandChild.put("isLeaf", new Boolean(true));
                grandChild.put("orgViewType", (Object)viewType);
                parent = units.get(child.getId());
                if (parent != null) {
                    parentLongNumber = (String)parent.get("longNumber");
                    if (parentLongNumber != null) {
                        grandChild.put("longNumber", parentLongNumber + "!" + grandChild.getNumber());
                    } else {
                        grandChild.put("longNumber", grandChild.getNumber());
                    }
                    parent.put("isLeaf", new Boolean(false));
                    grandChild.put("superOrgUnit", parent);
                    grandChild.put("level", new Integer((Integer)parent.get("level") + 1));
                }
                units.add(grandChild);
            }
            rows.close();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return units;
    }

    private OrgUnitCollection getUnitsByIRowSet(IRowSet rows, OrgType fromType, OrgType toType, OrgViewType viewType) throws BOSException {
        OrgUnitCollection units = new OrgUnitCollection();
        OrgUnitInfo info = null;
        OrgUnitInfo child = null;
        OrgUnitInfo parent = null;
        String parentLongNumber = null;
        HashMap<String, OrgUnitInfo> map = new HashMap<String, OrgUnitInfo>();
        try {
            while (rows.next()) {
                if (!units.contains(BOSUuid.read((String)rows.getString("OrgUnit.id")))) {
                    info = new OrgUnitInfo();
                    info.setId(BOSUuid.read((String)rows.getString("OrgUnit.id")));
                    info.setName(rows.getString("OrgUnit.name"));
                    info.setNumber(rows.getString("OrgUnit.number"));
                    info.setEffectDate(rows.getDate("OrgUnit.effectDate"));
                    info.setInvalidDate(rows.getDate("OrgUnit.invalidDate"));
                    info.setIsFreeze(rows.getBoolean("OrgUnit.isFreeze"));
                    info.put("longNumber", rows.getString("OrgStructure.longNumber"));
                    info.put("isLeaf", new Boolean(true));
                    info.put("level", new Integer(rows.getInt("OrgStructure.level")));
                    info.put("orgViewType", (Object)viewType);
                    map.put((String)info.get("longNumber"), info);
                    parent = (OrgUnitInfo)map.get(this.getParentKey((String)info.get("longNumber")));
                    if (parent != null) {
                        parent.put("isLeaf", new Boolean("false"));
                        info.put("superOrgUnit", parent);
                    }
                    units.add(info);
                }
                if (fromType == null || rows.getString("ToUnit.id") == null || rows.getString("ToUnit.id").trim().length() <= 0 || rows.getInt("OrgTypeRelation.fromType") != fromType.getValue() || rows.getInt("OrgTypeRelation.toType") != toType.getValue()) continue;
                child = new OrgUnitInfo();
                child.setId(BOSUuid.read((String)rows.getString("ToUnit.id")));
                child.setName(rows.getString("ToUnit.name"));
                child.setNumber(rows.getString("ToUnit.number"));
                child.setEffectDate(rows.getDate("ToUnit.effectDate"));
                child.setInvalidDate(rows.getDate("ToUnit.invalidDate"));
                child.setIsFreeze(rows.getBoolean("OrgUnit.isFreeze"));
                child.put("orgViewType", (Object)viewType);
                child.put("isLeaf", new Boolean(true));
                parent = units.get(info.getId());
                if (parent != null) {
                    parentLongNumber = (String)parent.get("longNumber");
                    if (parentLongNumber != null) {
                        child.put("longNumber", parentLongNumber + "!" + child.getNumber());
                    } else {
                        child.put("longNumber", child.getNumber());
                    }
                    parent.put("isLeaf", new Boolean(false));
                    child.put("superOrgUnit", parent);
                    child.put("level", new Integer((Integer)parent.get("level") + 1));
                }
                units.add(child);
            }
            rows.close();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return units;
    }

    @Override
    protected IObjectValue _getParent(Context ctx, OrgViewType orgViewType, String unitID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getDirectChildren(Context ctx, OrgViewType orgViewType, String unitID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected AbstractObjectCollection _getChildren(Context ctx, QueryTreeParamInfo queryTreeParamInfo) throws BOSException, EASBizException {
        TreeDataHelper treeDataHelper = new TreeDataHelper();
        return treeDataHelper.getChildren(ctx, queryTreeParamInfo.getParentInfo(), queryTreeParamInfo.getPInfo(), queryTreeParamInfo.isStruct(), queryTreeParamInfo.getOrgTreeInfo(), queryTreeParamInfo.isViewAll(), queryTreeParamInfo.isCu(), queryTreeParamInfo.isUseORMapping(), queryTreeParamInfo.isContainOUSealUp(), queryTreeParamInfo.isShowAssistantOrg());
    }

    @Override
    protected AbstractObjectCollection _getChildren(Context ctx, QueryTreeParamInfo queryTreeParamInfo, StepAddParamInfo stepAddParamInfo) throws BOSException, EASBizException {
        TreeDataHelper treeDataHelper = new TreeDataHelper();
        AbstractObjectCollection retCollection = treeDataHelper.getChildren(ctx, queryTreeParamInfo.getParentInfo(), queryTreeParamInfo.getPInfo(), queryTreeParamInfo.isStruct(), queryTreeParamInfo.getOrgTreeInfo(), queryTreeParamInfo.isViewAll(), queryTreeParamInfo.isCu(), queryTreeParamInfo.isUseORMapping(), queryTreeParamInfo.isContainOUSealUp(), queryTreeParamInfo.isShowAssistantOrg(), stepAddParamInfo);
        return retCollection;
    }

    @Override
    protected OrgUnitCollection _getOrgUnitCollection(Context ctx, OrgType orgType, BizOrgQueryParam bizOrgQueryParam) throws BOSException, EASBizException {
        IOrgAppHelper iOrgHelper = OrgTypeAppCenter.getInstance().getHelper(orgType);
        return OrgAppHelper.getOrgUnitCollection(ctx, iOrgHelper, bizOrgQueryParam);
    }

    @Override
    protected OUPartCoreBaseCollection _getOUPartByOrgInfo(Context ctx, List orgIdList, OrgType orgType, SelectorItemCollection selectInfo) throws BOSException, EASBizException {
        OrgTypeSelfInfo orgTypeInfo = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)ToolUtils.aryToStr((List)orgIdList, (boolean)false), CompareType.INCLUDE));
        view.setFilter(filter);
        OUPartCoreBaseCollection oupartCol = new OUPartCoreBaseCollection();
        if (selectInfo != null) {
            view.setSelector(selectInfo);
        }
        IObjectCollection iOC = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(orgTypeInfo.getOrgTableBosType(), view);
        for (int i = 0; i < iOC.size(); ++i) {
            oupartCol.add((OUPartCoreBaseInfo)iOC.getObject(i));
        }
        return oupartCol;
    }

    @Override
    protected String _getOrgClientExtImp(Context ctx) throws BOSException, EASBizException {
        return ExtHelper.getOrgClientExtImpl();
    }

    @Override
    protected Map _getOrgsIsEntityMap(Context ctx, Set idSet, OrgTypeForEntityEnum orgTypeForEntity) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        EntityViewInfo view = new EntityViewInfo();
        HashSet<String> appointOrgTypeIds = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("orgTypeStr"));
        view.setSelector(selectorCol);
        CoreBaseCollection col = FullOrgUnitFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            boolean containsOrgType;
            FullOrgUnitInfo info = (FullOrgUnitInfo)col.get(i);
            String orgTypeStr = info.getOrgTypeStr();
            boolean bl = containsOrgType = StringUtils.cnulls((String)orgTypeStr).toUpperCase().indexOf(orgTypeForEntity.getName().toUpperCase()) >= 0;
            if (containsOrgType) {
                appointOrgTypeIds.add(info.getId().toString());
                continue;
            }
            map.put(info.getId().toString(), new Boolean(false));
        }
        if (appointOrgTypeIds.size() == 0) {
            return map;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", appointOrgTypeIds, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        OrgType type = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgTypeForEntity).getOrgType();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        viewInfo.setSelector(selector);
        OrgUnitCollection appointOrgTypeCol = null;
        try {
            appointOrgTypeCol = NewOrgViewHelper.getOrgUnitCollection(ctx, type, viewInfo);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int j = 0; j < appointOrgTypeCol.size(); ++j) {
            OrgUnitInfo info = appointOrgTypeCol.get(j);
            Boolean isEntityOrg = (Boolean)info.get("isBizUnit");
            map.put(info.getId().toString(), isEntityOrg);
        }
        return map;
    }
}

