/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgDataCheckerHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class OrgHideFunctionCheckDataHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.org.app.helper.OrgHideFunctionCheckDataHelper");
    private final String tnSturcutre = "t_org_structure";
    private final String tnBaseunit = "t_org_baseunit";
    private final String tnPartCtrl = "t_org_oupartctrl";
    private final String tnCtrlUnit = "t_org_ctrlunit";
    private static Set<String> ignoreSet = OrgHideFunctionCheckDataHelper.getStructureIgnoreSet();
    private static Map<OrgType, String> orgTypeMappingOrghelperImpl = OrgHideFunctionCheckDataHelper.getOrgTypeMappingOrghelperImpl();
    private final String TJ = "@tj@";

    private OrgHideFunctionCheckDataHelper() {
    }

    public static OrgHideFunctionCheckDataHelper getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static Set<String> getStructureIgnoreSet() {
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("11111111-1111-1111-1111-11111111111132B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000032B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000132B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000232B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000332B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000432B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000532B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000632B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000732B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000832B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000000932B85C74");
        ignoreSet.add("00000000-0000-0000-0000-00000000001032B85C74");
        return ignoreSet;
    }

    private static Map<OrgType, String> getOrgTypeMappingOrghelperImpl() {
        HashMap<OrgType, String> orgTypeMappingOrghelperImpl = new HashMap<OrgType, String>();
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(1), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppCompanyImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(0), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppAdminImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(2), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppSaleImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(3), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppPurchaseImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(4), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppStorgeImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(5), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppCostImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(6), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppProfitImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(8), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppUnionGroupImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(10), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppCtrlImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(16), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppHrImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(24), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppTransportImpl");
        orgTypeMappingOrghelperImpl.put(OrgType.getEnum(32), "com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgAppQualityImpl");
        return orgTypeMappingOrghelperImpl;
    }

    public List getStructureErrData(Context ctx, Set orgTypeSet) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        String sqlStructure = "select  fid,fisleaf,flevel,flongnumber,funitid,fparentid from t_org_structure";
        String sqlBaseUnit = "select fid,fnumber from t_org_baseunit";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStructure);
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sqlBaseUnit);
        HashMap<String, String> mpBaseUnit = new HashMap<String, String>();
        int arraySize = 0;
        arraySize = rowSet.size();
        if (arraySize < 1) {
            return null;
        }
        HashMap<String, Integer> mIdPos = new HashMap<String, Integer>();
        String[] idArray = new String[arraySize];
        boolean[] isLeafArray = new boolean[arraySize];
        int[] levelArray = new int[arraySize];
        String[] longNumberArray = new String[arraySize];
        String[] unitIDArray = new String[arraySize];
        String[] parentIDArray = new String[arraySize];
        try {
            int pos = 0;
            while (rowSet.next()) {
                String fid = rowSet.getString(1);
                boolean fisleaf = rowSet.getBoolean(2);
                int flevel = rowSet.getInt(3);
                String flongnumber = rowSet.getString(4);
                String funitid = rowSet.getString(5);
                String fparentid = rowSet.getString(6);
                mIdPos.put(fid, pos);
                idArray[pos] = fid;
                isLeafArray[pos] = fisleaf;
                levelArray[pos] = flevel;
                longNumberArray[pos] = flongnumber;
                unitIDArray[pos] = funitid;
                parentIDArray[pos] = fparentid;
                ++pos;
            }
            while (rowSet1.next()) {
                mpBaseUnit.put(rowSet1.getString(1), rowSet1.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"OrgHideFunctionCheckDataFacadeControllerBean._getStructureErrData");
            logger.error((Object)e);
            e.printStackTrace();
        }
        ArrayList errDataList = new ArrayList();
        for (int i = 0; i < arraySize; ++i) {
            if (parentIDArray[i] == null || "".equals(parentIDArray[i])) {
                if (levelArray[i] == 1 && longNumberArray[i].indexOf("!") <= 0) continue;
                this.addErrData(errDataList, "t_org_structure", idArray[i], "fparentid=null ; flevel=" + levelArray[i] + " ; flongnumber=" + longNumberArray[i], "\u8fd9\u6761\u6570\u636e\u6709\u95ee\u9898\uff0c\u5efa\u8bae\u624b\u5de5\u7ef4\u62a4");
                continue;
            }
            if (mIdPos.get(parentIDArray[i]) == null) {
                this.addErrData(errDataList, "t_org_structure", idArray[i], "fparentid=" + parentIDArray[i], "\u7236ID\u4e0d\u5b58\u5728\uff0c\u5efa\u8bae\u624b\u5de5\u7ef4\u62a4");
                continue;
            }
            int parPos = (Integer)mIdPos.get(parentIDArray[i]);
            if (isLeafArray[parPos]) {
                this.addErrData(errDataList, "t_org_structure", idArray[parPos], "fisleaf=true", "\u8be5\u7ec4\u7ec7\u5b58\u5728\u4e0b\u7ea7\u8282\u70b9");
                continue;
            }
            if (levelArray[parPos] != levelArray[i] - 1) {
                this.addErrData(errDataList, "t_org_structure", idArray[i], "flevel=" + levelArray[i], "\u8be5\u8282\u70b9\u7ea7\u6b21\u4e0d\u5bf9");
                continue;
            }
            if (mpBaseUnit.get(unitIDArray[i]) == null) {
                this.addErrData(errDataList, "t_org_structure", idArray[i], "funitid" + unitIDArray[i], "\u7ec4\u7ec7ID\u5728t_org_baseunit\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u5efa\u8bae\u624b\u5de5\u7ef4\u62a4");
                continue;
            }
            if (longNumberArray[i].equals(longNumberArray[parPos] + "!" + (String)mpBaseUnit.get(unitIDArray[i]))) continue;
            this.addErrData(errDataList, "t_org_structure", idArray[i], "flongnumber" + longNumberArray[i], "\u7ec4\u7ec7\u7ec4\u7ec7\u957f\u7f16\u7801\u4e0d\u5bf9");
        }
        logger.error((Object)("getStructureErrData costTime:" + (System.currentTimeMillis() - startTime)));
        if (errDataList.size() > 500) {
            errDataList.clear();
            this.addErrData(errDataList, "t_org_structure", "\u672a\u77e5", "\u672a\u77e5", "\u9519\u8bef\u6570\u636e\u8d85\u8fc7500\u4e2a\u5217\u4e0d\u5b8c\uff0c\u5efa\u8bae\u67e5\u627e\u810f\u6570\u636e\u6765\u6e90\uff01");
        }
        return errDataList;
    }

    private void addErrData(List errDataList, String tableName, String fid, String col, String detail) {
        errDataList.add(tableName + "@tj@" + fid + "@tj@" + col + "@tj@" + detail);
    }

    private void checkCtrlUnitErrData(Context ctx, List errDataList, Map<String, Integer> mIdPos, List<BaseUnitNode> lsBaseUnit) throws BOSException {
        BaseUnitNode baseUnit;
        int i;
        String sqlPartctrl = "select  fid,funitId,fVersionNumber from t_org_oupartctrl";
        HashMap<String, Integer> mPartctrlIdPos = new HashMap<String, Integer>();
        String[][] partCtrlArray = this.getFieldArray(ctx, sqlPartctrl, mPartctrlIdPos);
        int IFidPC = 0;
        int IFunitidPC = 1;
        int IFversionnumberPC = 2;
        String sqlCtrlunit = "select  fId,fParentId,fVersionNumber,fnumber,fcontrolunitid,fisleaf,flevel,flongnumber from t_org_ctrlunit";
        HashMap<String, Integer> mCtrlunitIdPos = new HashMap<String, Integer>();
        String[][] ctrlunitArray = this.getFieldArray(ctx, sqlCtrlunit, mCtrlunitIdPos);
        int IFidCT = 0;
        int IFparentidCT = 1;
        int IFversionnumberCT = 2;
        int IFnumberCT = 3;
        int IFcontrolunitidCT = 4;
        int IFisleafCT = 5;
        int IFlevelCT = 6;
        int IFlongnumberCT = 7;
        String sqlStructure = "select fid,fparentid,flongnumber,funitid from t_org_structure where ftreeid = '00000000-0000-0000-0000-0000000000014F2827FD'";
        HashMap<String, Integer> mStructureIdPos = new HashMap<String, Integer>();
        String[][] structureArray = this.getFieldArray(ctx, sqlStructure, mStructureIdPos);
        int IFidST = 0;
        int IFparentidST = 1;
        int IFlongnumberST = 2;
        int IFunitidST = 3;
        int size = partCtrlArray[0].length;
        for (i = 0; i < size; ++i) {
            if (mIdPos.get(partCtrlArray[IFunitidPC][i]) == null) {
                this.addErrData(errDataList, "t_org_oupartctrl", partCtrlArray[IFidPC][i], "funitid=" + partCtrlArray[IFunitidPC][i], "funitid\u5e76\u6ca1\u6709\u5bf9\u5e94\u7684t_org_baseunit\u6570\u636e");
                continue;
            }
            baseUnit = lsBaseUnit.get(mIdPos.get(partCtrlArray[IFunitidPC][i]));
            if (partCtrlArray[IFversionnumberPC][i].equals(baseUnit.getfVersionNumber())) continue;
            this.addErrData(errDataList, "t_org_oupartctrl", partCtrlArray[IFidPC][i], "fversionNumber=" + partCtrlArray[IFversionnumberPC][i], "\u4e0et_org_baseunit\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
        }
        size = structureArray[0].length;
        for (i = 0; i < size; ++i) {
            if (mIdPos.get(structureArray[IFunitidST][i]) == null) {
                this.addErrData(errDataList, "t_org_structure", structureArray[IFidST][i], "funitid=" + structureArray[IFunitidST][i], "funitid\u5e76\u6ca1\u6709\u5bf9\u5e94\u7684t_org_baseunit\u6570\u636e");
                continue;
            }
            baseUnit = lsBaseUnit.get(mIdPos.get(structureArray[IFunitidST][i]));
            if (!(structureArray[IFparentidST][i] != null && baseUnit.getfParentId() != null || structureArray[IFparentidST][i] == null && baseUnit.getfParentId() == null)) {
                this.addErrData(errDataList, "t_org_structure", structureArray[IFidST][i], "fparentid=" + structureArray[IFparentidST][i], "\u7236ID\u4e0et_org_baseunit\u5bf9\u5e94\u7684\u7236ID\u4e0d\u4e00\u81f4\uff0c\u5efa\u8bae\u624b\u5de5\u7ef4\u62a4");
                continue;
            }
            if (structureArray[IFlongnumberST][i].equals(baseUnit.getfLongnumber())) continue;
            this.addErrData(errDataList, "t_org_structure", structureArray[IFidST][i], "flongnumber=" + structureArray[IFlongnumberST][i], "\u957f\u7f16\u7801\u4e0et_org_baseunit\u5bf9\u5e94\u7684\u957f\u7f16\u7801\u4e0d\u4e00\u81f4");
        }
        size = ctrlunitArray[0].length;
        for (i = 0; i < size; ++i) {
            if (mIdPos.get(ctrlunitArray[IFidCT][i]) == null) {
                this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "fid=" + ctrlunitArray[IFidCT][i], "fid\u5e76\u6ca1\u6709\u5bf9\u5e94\u7684t_org_baseunit\u6570\u636e");
                continue;
            }
            baseUnit = lsBaseUnit.get(mIdPos.get(ctrlunitArray[IFidCT][i]));
            if (!ctrlunitArray[IFversionnumberCT][i].equals(baseUnit.getfVersionNumber())) {
                this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "fversionNumber=" + ctrlunitArray[IFversionnumberCT][i], "\u4e0et_org_baseunit\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
                continue;
            }
            if (ctrlunitArray[IFparentidCT][i] != null && baseUnit.getfParentId() != null) {
                if (!ctrlunitArray[IFparentidCT][i].equals(baseUnit.getfParentId())) {
                    this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "fparentid=" + ctrlunitArray[IFparentidCT][i], "fparentid\u4e0et_org_baseunit\u5bf9\u5e94\u7684fparentid\u4e0d\u4e00\u81f4");
                    continue;
                }
                int parPos = (Integer)mCtrlunitIdPos.get(ctrlunitArray[IFparentidCT][i]);
                if ("true".equals(ctrlunitArray[IFisleafCT][parPos])) {
                    this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "fIsleaf=" + ctrlunitArray[IFisleafCT][i], "fIsleaf\u4e0et_org_baseunit\u5bf9\u5e94\u7684fIsleaf\u4e0d\u4e00\u81f4");
                    continue;
                }
            } else if (ctrlunitArray[IFparentidCT][i] != null || baseUnit.getfParentId() != null) {
                this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "fparentid=" + ctrlunitArray[IFparentidCT][i], "fparentid\u4e0et_org_baseunit\u5bf9\u5e94\u7684fparentid\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!ctrlunitArray[IFnumberCT][i].equals(baseUnit.getfNumber())) {
                this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "fnumber=" + ctrlunitArray[IFnumberCT][i], "fnumber\u4e0et_org_baseunit\u5bf9\u5e94\u7684fnumber\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!ctrlunitArray[IFlevelCT][i].equals(String.valueOf(baseUnit.getfLevel()))) {
                this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "flevel=" + ctrlunitArray[IFlevelCT][i], "flevel\u4e0et_org_baseunit\u5bf9\u5e94\u7684flevel\u4e0d\u4e00\u81f4");
                continue;
            }
            if (ctrlunitArray[IFlongnumberCT][i].equals(baseUnit.getfLongnumber())) continue;
            this.addErrData(errDataList, "t_org_ctrlunit", ctrlunitArray[IFidCT][i], "flongnumber=" + ctrlunitArray[IFlongnumberCT][i], "flongnumber\u4e0et_org_baseunit\u5bf9\u5e94\u7684flongnumber\u4e0d\u4e00\u81f4");
        }
    }

    private String[][] getFieldArray(Context ctx, String sql, Map<String, Integer> mIdPos) throws BOSException {
        int arrSize = sql.substring(0, sql.indexOf("from")).split(",").length;
        IRowSet rowSet3 = DbUtil.executeQuery((Context)ctx, (String)sql);
        int rowcount = rowSet3.size();
        String[][] fieldArray = new String[arrSize][rowcount];
        try {
            int pos = 0;
            while (rowSet3.next()) {
                String fid;
                fieldArray[0][pos] = fid = rowSet3.getString(1);
                for (int i = 1; i < arrSize; ++i) {
                    fieldArray[i][pos] = rowSet3.getString(i + 1);
                }
                mIdPos.put(fid, pos);
                ++pos;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return fieldArray;
    }

    public List getBaseunitErrData(Context ctx, Set orgtypeSet) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        HashMap<String, Integer> mIdPos = new HashMap<String, Integer>();
        List<BaseUnitNode> lsBaseUnit = this.getBaseUnitList(ctx, mIdPos);
        int baseunitSize = lsBaseUnit.size();
        if (baseunitSize < 1) {
            return null;
        }
        ArrayList errDataList = new ArrayList();
        String fversionNumber = null;
        for (int i = 0; i < baseunitSize; ++i) {
            BaseUnitNode baseOrg = lsBaseUnit.get(i);
            if (fversionNumber == null) {
                fversionNumber = baseOrg.getfVersionNumber();
            } else if (!fversionNumber.equals(baseOrg.getfVersionNumber())) {
                this.addErrData(errDataList, "t_org_baseunit", baseOrg.getfId().toString(), "fversionNumber=" + baseOrg.getfVersionNumber(), "\u4e0et_org_baseunit\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
                continue;
            }
            if (baseOrg.getfParentId() == null) {
                if (baseOrg.getfLevel() != 1) {
                    this.addErrData(errDataList, "t_org_baseunit", baseOrg.getfId().toString(), "flevel=" + baseOrg.getfLevel(), "\u9876\u7ea7\u8282\u70b9\u7ea7\u6b21\u5e94\u8be5\u4e3a1");
                    continue;
                }
                if (baseOrg.getfLongnumber().equals(baseOrg.getfNumber())) continue;
                this.addErrData(errDataList, "t_org_baseunit", baseOrg.getfId().toString(), "fnumber=" + baseOrg.getfNumber() + " ; flongnumber=" + baseOrg.getfLongnumber(), "\u957f\u7f16\u7801\u4e0d\u5bf9\u3002");
                continue;
            }
            BaseUnitNode parOrg = lsBaseUnit.get((Integer)mIdPos.get(baseOrg.getfParentId()));
            if (parOrg.isfIsleaf()) {
                this.addErrData(errDataList, "t_org_baseunit", parOrg.getfId(), "fisleaf=true", "\u8be5\u7ec4\u7ec7\u5b58\u5728\u4e0b\u7ea7\u8282\u70b9");
                continue;
            }
            if (parOrg.getfLevel() != baseOrg.getfLevel() - 1) {
                this.addErrData(errDataList, "t_org_baseunit", baseOrg.getfId(), "flevel=" + baseOrg.getfLevel(), "\u8be5\u8282\u70b9\u7ea7\u6b21\u4e0d\u5bf9");
                continue;
            }
            if (baseOrg.getfLongnumber().equals(parOrg.getfLongnumber() + "!" + baseOrg.getfNumber())) continue;
            this.addErrData(errDataList, "t_org_baseunit", baseOrg.getfId(), "flongnumber" + baseOrg.getfLongnumber(), "\u7ec4\u7ec7\u7ec4\u7ec7\u957f\u7f16\u7801\u4e0d\u5bf9");
        }
        this.checkCtrlUnitErrData(ctx, errDataList, mIdPos, lsBaseUnit);
        long costTime = System.currentTimeMillis() - startTime;
        logger.error((Object)("getBaseunitErrData costTime:" + costTime));
        if (errDataList.size() > 500) {
            errDataList.clear();
            this.addErrData(errDataList, "t_org_structure", "\u672a\u77e5", "\u672a\u77e5", "\u9519\u8bef\u6570\u636e\u8d85\u8fc7500\u4e2a\u5217\u4e0d\u5b8c\uff0c\u5efa\u8bae\u67e5\u627e\u810f\u6570\u636e\u6765\u6e90\uff01");
        }
        return errDataList;
    }

    private List<BaseUnitNode> getBaseUnitList(Context ctx, Map<String, Integer> mIdPos) throws BOSException {
        String sqlBaseUnit = "select  fid,fParentId,fIsleaf,fLevel,fVersionNumber,fNumber,fLongnumber from t_org_baseunit";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBaseUnit);
        int arraySize = 0;
        arraySize = rowSet.size();
        if (arraySize < 1) {
            return null;
        }
        ArrayList<BaseUnitNode> lsBaseunit = new ArrayList<BaseUnitNode>();
        try {
            int pos = 0;
            while (rowSet.next()) {
                String fid = rowSet.getString(1);
                String fparentid = rowSet.getString(2);
                boolean fisleaf = rowSet.getBoolean(3);
                int flevel = rowSet.getInt(4);
                String fVersionNumber = rowSet.getString(5);
                String fNumber = rowSet.getString(6);
                String fLongnumber = rowSet.getString(7);
                mIdPos.put(fid, pos);
                BaseUnitNode buN = new BaseUnitNode(fid, fparentid, fisleaf, flevel, fVersionNumber, fNumber, fLongnumber);
                lsBaseunit.add(buN);
                ++pos;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return lsBaseunit;
    }

    public List getBizOrgErrData(Context ctx, Set orgtypeSet) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        if (orgtypeSet == null) {
            return null;
        }
        final ConcurrentHashMap threadsErrList = new ConcurrentHashMap();
        HashSet<1> ths = new HashSet<1>();
        ArrayList errDataList = new ArrayList();
        for (OrgType otype : orgtypeSet) {
            final String string = orgTypeMappingOrghelperImpl.get((Object)otype);
            final Context ctx1 = ctx;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    List errList = OrgHideFunctionCheckDataHelper.this.getOrghelperErrData(ctx1, string);
                    if (errList != null) {
                        threadsErrList.put(this, errList);
                    }
                }
            };
            thread.start();
            ths.add(thread);
        }
        for (Thread thread : ths) {
            try {
                thread.join();
                List ls = (List)threadsErrList.get(thread);
                if (ls == null) continue;
                errDataList.addAll(ls);
            }
            catch (InterruptedException e) {
                logger.error((Object)"getBizOrgErrData tr.join() error");
            }
        }
        OrgDataCheckerHelper.clearBaseUnit();
        if (errDataList.size() > 500) {
            errDataList.clear();
            this.addErrData(errDataList, "t_org_structure", "\u672a\u77e5", "\u672a\u77e5", "\u9519\u8bef\u6570\u636e\u8d85\u8fc7500\u4e2a\u5217\u4e0d\u5b8c\uff0c\u5efa\u8bae\u67e5\u627e\u810f\u6570\u636e\u6765\u6e90\uff01");
        }
        long l = System.currentTimeMillis() - startTime;
        logger.error((Object)("getBizOrgErrData costTime:" + l));
        return errDataList;
    }

    public boolean repairData(Context ctx, List dataList) throws BOSException {
        int size = dataList.size();
        if (size < 1) {
            return true;
        }
        boolean isSuccess = true;
        HashMap<String, List<String>> mpTnIdlist = new HashMap<String, List<String>>();
        for (int i = 0; i < size; ++i) {
            String data = (String)dataList.get(i);
            String tableName = data.substring(0, data.indexOf("@tj@"));
            String fid = data.substring(data.indexOf("@tj@") + 4);
            ArrayList<String> tnIdsList = (ArrayList<String>)mpTnIdlist.get(tableName);
            if (tnIdsList != null) {
                tnIdsList.add(fid);
                continue;
            }
            tnIdsList = new ArrayList<String>();
            tnIdsList.add(fid);
            mpTnIdlist.put(tableName, tnIdsList);
        }
        List tnSturcutreIdsList = (List)mpTnIdlist.get("t_org_structure");
        List tnBaseunitIdsList = (List)mpTnIdlist.get("t_org_baseunit");
        List tnCtrlUnitIdsList = (List)mpTnIdlist.get("t_org_ctrlunit");
        try {
            this.repairStructureRowdata(ctx, tnSturcutreIdsList);
            this.repairBaseunitRowdata(ctx, tnBaseunitIdsList);
            this.repairCtrlUnitRowdata(ctx, tnCtrlUnitIdsList);
            this.repairBizOrgTbRowdata(ctx, mpTnIdlist);
        }
        catch (SQLException e) {
            e.printStackTrace();
            isSuccess = false;
        }
        return isSuccess;
    }

    private void repairBizOrgTbRowdata(Context ctx, Map<String, List<String>> mpTnIdlist) throws BOSException, SQLException {
        for (OrgType orgType : orgTypeMappingOrghelperImpl.keySet()) {
            String clsName = orgTypeMappingOrghelperImpl.get((Object)orgType);
            String tn = this.getOrghelperTableName(clsName);
            List<String> idsList = null;
            idsList = mpTnIdlist.get(tn);
            if (idsList == null || idsList.size() < 1) continue;
            this.repairBizOrgViewTbRowdata(ctx, idsList, orgType);
        }
    }

    private String getOrghelperTableName(String className) {
        Class<?> clz = null;
        OrgTypeSelfInfo orgTypeInfo = null;
        try {
            clz = Class.forName(className);
            Object o = clz.newInstance();
            Method method = clz.getMethod("getOrgTypeSelfInfo", null);
            orgTypeInfo = (OrgTypeSelfInfo)method.invoke(o, null);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)(className + " not found"));
        }
        catch (InstantiationException e) {
            logger.error((Object)(className + ".newInstance() error"));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)(className + ".newInstance() error"));
        }
        catch (SecurityException e) {
            logger.error((Object)(className + " Method:getRebuildSql not found"));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)(className + " Method:getRebuildSql not found"));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)(className + "invoke error"));
        }
        catch (InvocationTargetException e) {
            logger.error((Object)(className + "invoke error"));
        }
        if (orgTypeInfo == null) {
            return null;
        }
        return orgTypeInfo.getViewTableName();
    }

    private void repairCtrlUnitRowdata(Context ctx, List<String> idsList) throws BOSException, SQLException {
        this.repairBizOrgViewTbRowdata(ctx, idsList, OrgType.ControlUnit);
    }

    private void repairBizOrgViewTbRowdata(Context ctx, List<String> idsList, OrgType orgType) throws BOSException, SQLException {
        if (idsList == null || idsList.size() < 1) {
            return;
        }
        int size = idsList.size();
        if (size < 1) {
            return;
        }
        String className = orgTypeMappingOrghelperImpl.get((Object)orgType);
        String[] sqls = this.getOrghelperRebuildTableSql(className);
        String delSql = sqls[0] + " where fid = ?";
        String insSql = sqls[1] + " and ou.fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < size; ++i) {
            Object[] param = new Object[]{idsList.get(i)};
            paramList.add(param);
        }
        this.executeBatchRepairSql(ctx, delSql, paramList);
        this.executeBatchRepairSql(ctx, insSql, paramList);
    }

    private List<String> getOrghelperErrData(Context ctx, String className) {
        Class<?> clz = null;
        List errDataList = null;
        try {
            clz = Class.forName(className);
            Object o = clz.newInstance();
            Method method = clz.getMethod("getErrDataList", Context.class);
            errDataList = (List)method.invoke(o, ctx);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)(className + " not found"));
        }
        catch (InstantiationException e) {
            logger.error((Object)(className + ".newInstance() error"));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)(className + ".newInstance() error"));
        }
        catch (SecurityException e) {
            logger.error((Object)(className + " Method:getErrDataList not found"));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)(className + " Method:getErrDataList not found"));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)(className + "invoke error"));
        }
        catch (InvocationTargetException e) {
            logger.error((Object)(className + "invoke error"));
        }
        return errDataList;
    }

    private String[] getOrghelperRebuildTableSql(String className) {
        Class<?> clz = null;
        String[] sqls = null;
        try {
            clz = Class.forName(className);
            Object o = clz.newInstance();
            Method method = clz.getMethod("getRebuildSql", null);
            sqls = (String[])method.invoke(o, null);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)(className + " not found"));
        }
        catch (InstantiationException e) {
            logger.error((Object)(className + ".newInstance() error"));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)(className + ".newInstance() error"));
        }
        catch (SecurityException e) {
            logger.error((Object)(className + " Method:getRebuildSql not found"));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)(className + " Method:getRebuildSql not found"));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)(className + "invoke error"));
        }
        catch (InvocationTargetException e) {
            logger.error((Object)(className + "invoke error"));
        }
        return sqls;
    }

    private void repairBaseunitRowdata(Context ctx, List<String> idsList) throws BOSException, SQLException {
        if (idsList == null || idsList.size() < 1) {
            return;
        }
        HashMap<String, Integer> mIdPos = new HashMap<String, Integer>();
        List<BaseUnitNode> lsBaseUnit = this.getBaseUnitList(ctx, mIdPos);
        HashSet<String> parentIdSet = new HashSet<String>();
        int size = idsList.size();
        int count = lsBaseUnit.size();
        for (int i = 0; i < count; ++i) {
            BaseUnitNode bs = lsBaseUnit.get(i);
            parentIdSet.add(bs.getfParentId());
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < size; ++i) {
            String realLongnumber;
            int realLevel;
            String fid = idsList.get(i);
            int pos = (Integer)mIdPos.get(fid);
            BaseUnitNode bs = lsBaseUnit.get(pos);
            boolean realIsleaf = parentIdSet.contains(bs.getfId());
            if (mIdPos.get(bs.getfParentId()) == null) {
                realLevel = 1;
                realLongnumber = bs.getfNumber();
            } else {
                int parpos = (Integer)mIdPos.get(bs.getfParentId());
                BaseUnitNode parBs = lsBaseUnit.get(parpos);
                realLevel = parBs.getfLevel() + 1;
                realLongnumber = parBs.getfLongnumber() + "!" + bs.getfNumber();
            }
            Object[] param = new Object[]{realIsleaf, realLevel, realLongnumber, fid};
            paramList.add(param);
        }
        String updteSql = "update t_org_baseunit set fisleaf=?,flevel=?,flongnumber=? where fid=?";
        this.executeBatchRepairSql(ctx, updteSql, paramList);
    }

    private void repairStructureRowdata(Context ctx, List<String> idsList) throws BOSException, SQLException {
        if (idsList == null || idsList.size() < 1) {
            return;
        }
        String sqlStructure = "select  fid,fisleaf,flevel,flongnumber,funitid,fparentid from t_org_structure";
        String sqlBaseUnit = "select fid,fnumber from t_org_baseunit";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStructure);
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sqlBaseUnit);
        HashMap<String, String> mpBaseUnit = new HashMap<String, String>();
        int arraySize = 0;
        arraySize = rowSet.size();
        if (arraySize < 1) {
            return;
        }
        HashMap<String, Integer> mIdPos = new HashMap<String, Integer>();
        String[] idArray = new String[arraySize];
        boolean[] isLeafArray = new boolean[arraySize];
        int[] levelArray = new int[arraySize];
        String[] longNumberArray = new String[arraySize];
        String[] unitIDArray = new String[arraySize];
        String[] parentIDArray = new String[arraySize];
        int tmpPos = 0;
        while (rowSet.next()) {
            String fid = rowSet.getString(1);
            boolean fisleaf = rowSet.getBoolean(2);
            int flevel = rowSet.getInt(3);
            String flongnumber = rowSet.getString(4);
            String funitid = rowSet.getString(5);
            String fparentid = rowSet.getString(6);
            mIdPos.put(fid, tmpPos);
            idArray[tmpPos] = fid;
            isLeafArray[tmpPos] = fisleaf;
            levelArray[tmpPos] = flevel;
            longNumberArray[tmpPos] = flongnumber;
            unitIDArray[tmpPos] = funitid;
            parentIDArray[tmpPos] = fparentid;
            ++tmpPos;
        }
        while (rowSet1.next()) {
            mpBaseUnit.put(rowSet1.getString(1), rowSet1.getString(2));
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        int size = idsList.size();
        for (int i = 0; i < size; ++i) {
            int parPos;
            String fid = idsList.get(i);
            int pos = (Integer)mIdPos.get(fid);
            if (parentIDArray[pos] == null || "".equals(parentIDArray[pos]) || mIdPos.get(parentIDArray[pos]) == null) continue;
            int n = parPos = ((Integer)mIdPos.get(parentIDArray[pos])).intValue();
            int n2 = levelArray[n] + 1;
            levelArray[n] = n2;
            int realLevel = n2;
            boolean realIsleaf = true;
            int sum = parentIDArray.length;
            for (int j = 0; j < sum; ++j) {
                if (!fid.equalsIgnoreCase(parentIDArray[j])) continue;
                realIsleaf = false;
                break;
            }
            String realLongnumber = longNumberArray[parPos] + "!" + (String)mpBaseUnit.get(unitIDArray[pos]);
            Object[] param = new Object[]{realIsleaf, realLevel, realLongnumber, fid};
            paramList.add(param);
        }
        String updteSql = "update t_org_structure set fisleaf=?,flevel=?,flongnumber=? where fid=?";
        this.executeBatchRepairSql(ctx, updteSql, paramList);
    }

    private void executeBatchRepairSql(Context ctx, String sql, List paramsList) throws BOSException {
        DbUtil.executeBatch((Context)ctx, (String)sql, (List)paramsList);
        this.repairDataLog(ctx, sql, paramsList);
    }

    private void repairDataLog(Context ctx, String sql, List paramsList) {
    }

    class BaseUnitNode {
        String fVersionNumber;
        String fId;
        String fParentId;
        boolean fIsleaf;
        int fLevel;
        String fNumber;
        String fLongnumber;

        public String getfVersionNumber() {
            return this.fVersionNumber;
        }

        public String getfId() {
            return this.fId;
        }

        public String getfParentId() {
            return this.fParentId;
        }

        public boolean isfIsleaf() {
            return this.fIsleaf;
        }

        public int getfLevel() {
            return this.fLevel;
        }

        public String getfNumber() {
            return this.fNumber;
        }

        public String getfLongnumber() {
            return this.fLongnumber;
        }

        public BaseUnitNode(String fId, String fParentId, boolean fIsleaf, int fLevel, String fVersionNumber, String fNumber, String fLongnumber) {
            this.fId = fId;
            this.fParentId = fParentId;
            this.fIsleaf = fIsleaf;
            this.fLevel = fLevel;
            this.fVersionNumber = fVersionNumber;
            this.fNumber = fNumber;
            this.fLongnumber = fLongnumber;
        }
    }

    private static class LazyHolder {
        private static final OrgHideFunctionCheckDataHelper INSTANCE = new OrgHideFunctionCheckDataHelper();

        private LazyHolder() {
        }
    }
}

