/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.util.CUParentChangedHandlerUtil;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgTypeAppCenter {
    private static Logger logger = Logger.getLogger((String)OrgTypeAppCenter.class.getName());
    private static List appDealList = new ArrayList();
    private static Map helperMap = new HashMap();
    private static OrgTypeAppCenter instance = null;
    public static Map entityObjCacheMap = new HashMap();

    private OrgTypeAppCenter() {
        if (appDealList.isEmpty()) {
            Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
            for (OrgTypeInfo orgTypeInfo : col) {
                IOrgAppHelper oneHelper = this.createInstance(orgTypeInfo.getAppClassName());
                if (oneHelper == null) continue;
                helperMap.put(orgTypeInfo.getOrgType(), oneHelper);
            }
            appDealList.addAll(helperMap.values());
        }
    }

    public void clear() {
        instance = null;
        appDealList.clear();
        helperMap.clear();
        OrgTypeInfoMgr.getInstance().clear();
    }

    public static synchronized OrgTypeAppCenter getInstance() {
        if (instance == null) {
            instance = new OrgTypeAppCenter();
        }
        return instance;
    }

    public IOrgAppHelper getHelper(OrgType orgType) {
        if (helperMap.containsKey((Object)orgType)) {
            return (IOrgAppHelper)helperMap.get((Object)orgType);
        }
        logger.error((Object)("orgType is not right,not support this org type :" + (Object)((Object)orgType)));
        return null;
    }

    public IOrgAppHelper getHelper(int orgTypeInt) {
        OrgType orgType = OrgType.getEnum(orgTypeInt);
        return this.getHelper(orgType);
    }

    public IOrgAppHelper createInstance(String className) {
        try {
            this.getClass();
            return (IOrgAppHelper)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)("IOrgAppHelper createInstance error!" + className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("IOrgAppHelper createInstance error!" + className), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("IOrgAppHelper createInstance error!" + className), (Throwable)e);
        }
        return null;
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            oneHelper.updateOrgInfo(ctx, pk, unitInfo, currentCUInfo, versionNumber, isOrgStart);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws EASBizException, BOSException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            oneHelper.addNewInfo(ctx, unitInfo, currentCUInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo delOrgInfo) throws EASBizException, BOSException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            oneHelper.delOrgInfo(ctx, delOrgInfo);
        }
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection delOrgCol) throws EASBizException, BOSException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            oneHelper.batchDelOrgInfo(ctx, delOrgCol);
        }
    }

    public void delPermission(Context ctx, FullOrgUnitCollection delOrgCol) throws EASBizException, BOSException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            oneHelper.delPermission(ctx, delOrgCol);
        }
    }

    public EntityObjectInfo getEntityObjectInfoByBosType(Context ctx, BOSObjectType bizObjType) {
        if (entityObjCacheMap == null) {
            entityObjCacheMap = new HashMap();
        }
        if (entityObjCacheMap.containsKey(bizObjType)) {
            return (EntityObjectInfo)entityObjCacheMap.get(bizObjType);
        }
        EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bizObjType);
        entityObjCacheMap.put(bizObjType, entityObjInfo);
        return entityObjInfo;
    }

    public String getLeftJoinSimpleFiled(Context ctx, String bizObjType) throws EASBizException, BOSException {
        StringBuffer retSql = new StringBuffer();
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            IOrgAppHelper oneHelper;
            if (OrgType.NONE == orgTypeInfo.getOrgType() || (oneHelper = this.getHelper(orgTypeInfo.getOrgType())) == null) continue;
            Set fieldSet = oneHelper.getOrgTypeSelfInfo().getIOrgQueryInfo().getLeftJoinSimpleFiled(bizObjType);
            BOSObjectType bosObjectType = oneHelper.getOrgTypeSelfInfo().getOrgTableBosType();
            if ("BIZOBJ_VIEW".equals(bizObjType)) {
                bosObjectType = oneHelper.getOrgTypeSelfInfo().getOrgViewBosType();
            }
            EntityObjectInfo entityObjInfo = this.getEntityObjectInfoByBosType(ctx, bosObjectType);
            String sqlFieldStr = OrgAppHelper.getSelectFieldFactName2Str(ctx, oneHelper.getOrgTypeSelfInfo().getTableNameAlias(), fieldSet, entityObjInfo);
            if (StringUtils.isEmpty((String)sqlFieldStr)) continue;
            if (retSql.length() == 0) {
                retSql.append(sqlFieldStr);
                continue;
            }
            retSql.append(",").append(sqlFieldStr);
        }
        return retSql.toString();
    }

    public String getLeftJoinSimpleFiledByOrgType(Context ctx, String bizObjType, OrgTypeInfo orgTypeInfo) throws EASBizException, BOSException {
        StringBuffer retSql = new StringBuffer();
        if (OrgType.NONE == orgTypeInfo.getOrgType()) {
            return retSql.toString();
        }
        IOrgAppHelper oneHelper = this.getHelper(orgTypeInfo.getOrgType());
        if (oneHelper == null) {
            return retSql.toString();
        }
        Set fieldSet = oneHelper.getOrgTypeSelfInfo().getIOrgQueryInfo().getLeftJoinSimpleFiled(bizObjType);
        BOSObjectType bosObjectType = oneHelper.getOrgTypeSelfInfo().getOrgTableBosType();
        if ("BIZOBJ_VIEW".equals(bizObjType)) {
            bosObjectType = oneHelper.getOrgTypeSelfInfo().getOrgViewBosType();
        }
        EntityObjectInfo entityObjInfo = this.getEntityObjectInfoByBosType(ctx, bosObjectType);
        String sqlFieldStr = OrgAppHelper.getSelectFieldFactName2Str(ctx, oneHelper.getOrgTypeSelfInfo().getTableNameAlias(), fieldSet, entityObjInfo);
        if (!StringUtils.isEmpty((String)sqlFieldStr)) {
            if (retSql.length() == 0) {
                retSql.append(sqlFieldStr);
            } else {
                retSql.append(",").append(sqlFieldStr);
            }
        }
        return retSql.toString();
    }

    public String getLeftJoinTableSql(String sourceFiledName) throws EASBizException, BOSException {
        StringBuffer retSql = new StringBuffer();
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            String sqlFieldStr;
            IOrgAppHelper oneHelper;
            if (OrgType.NONE == orgTypeInfo.getOrgType() || (oneHelper = this.getHelper(orgTypeInfo.getOrgType())) == null || StringUtils.isEmpty((String)(sqlFieldStr = oneHelper.getOrgTypeSelfInfo().getIOrgQueryInfo().getLeftJoinTableSql(oneHelper, sourceFiledName)))) continue;
            if (retSql.length() == 0) {
                retSql.append(sqlFieldStr);
                continue;
            }
            retSql.append(" ").append(sqlFieldStr);
        }
        return retSql.toString();
    }

    public List getInsertHisDataSql() {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            if (oneHelper.getInsertHisDataSql() == null) continue;
            retList.addAll(oneHelper.getInsertHisDataSql());
        }
        return retList;
    }

    public List getOrgUpdateStmts(String versionNumber) {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            retList.addAll(this.getOrgUpdateStmts(oneHelper, versionNumber));
        }
        return retList;
    }

    private List getOrgUpdateStmts(IOrgAppHelper oneHelper, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)oneHelper.getOrgTypeSelfInfo().getViewTableName())) {
            retList.add(new StringBuffer().append("UPDATE ").append(oneHelper.getOrgTypeSelfInfo().getViewTableName()).append(" SET FVersionNumber = '").append(versionNumber).append("'").toString());
        }
        if (!StringUtils.isEmpty((String)oneHelper.getOrgTypeSelfInfo().getTableName())) {
            retList.add(new StringBuffer().append("UPDATE ").append(oneHelper.getOrgTypeSelfInfo().getTableName()).append(" SET FVersionNumber = '").append(versionNumber).append("'").toString());
        }
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String versionNumber) {
        String inValidateStr = OrgAppHelper.getInvalidDate();
        ArrayList retList = new ArrayList();
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            retList.addAll(this.getOrgVersioningUpdateStmts(oneHelper, inValidateStr, versionNumber));
        }
        return retList;
    }

    private List getOrgVersioningUpdateStmts(IOrgAppHelper oneHelper, String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        String viewTableName = oneHelper.getOrgTypeSelfInfo().getViewTableNameHis();
        if (!StringUtils.isEmpty((String)viewTableName)) {
            retList.add(new StringBuffer().append("UPDATE ").append(oneHelper.getOrgTypeSelfInfo().getViewTableNameHis()).append(" SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        }
        return retList;
    }

    public void loadSuperiorUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo, boolean curVersion) throws BOSException, EASBizException {
        this.loadSuperiorUnits(ctx, fullVersionInfo, pdInfo, curVersion, null);
    }

    public void loadSuperiorUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo, boolean curVersion, SelectorItemCollection selector) throws BOSException, EASBizException {
        Set orgTypeSet = this.getOrgTypeByUnitInfo(ctx, fullVersionInfo);
        Iterator it = orgTypeSet.iterator();
        while (it.hasNext()) {
            IOrgAppHelper oneHelper = this.getHelper((OrgType)((Object)it.next()));
            if (oneHelper == null) continue;
            this.loadSuperiorUnits(ctx, oneHelper, fullVersionInfo, pdInfo, curVersion, selector);
        }
    }

    private void loadSuperiorUnits(Context ctx, IOrgAppHelper oneHelper, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo, boolean curVersion, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (curVersion) {
            this.loadCurVersionSuperiorUnits(ctx, oneHelper, fullVersionInfo, pdInfo, selector);
        } else {
            this.loadSuperiorHisOrgUnits(ctx, oneHelper, fullVersionInfo, pdInfo);
        }
    }

    private void loadCurVersionSuperiorUnits(Context ctx, IOrgAppHelper oneHelper, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo, SelectorItemCollection selector) throws BOSException, EASBizException {
        String queryPerentSql = "select fparentid  from " + oneHelper.getOrgTypeSelfInfo().getViewTableName() + " where fid = '" + fullVersionInfo.getId().toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryPerentSql);
        String parentId = "";
        try {
            if (!rowSet.next()) {
                return;
            }
            parentId = rowSet.getString(1);
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (selector != null && !selector.isEmpty()) {
            viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)parentId, CompareType.EQUALS));
        if (oneHelper.getOrgTypeSelfInfo().getOrgUnitViewInfo() != null && OrgUnitExtInfo.class.isAssignableFrom(oneHelper.getOrgTypeSelfInfo().getOrgUnitViewInfo().getClass()) && !OrgType.HRO.equals((Object)oneHelper.getOrgTypeSelfInfo().getOrgType())) {
            filter.getFilterItems().add(new FilterItemInfo("IsBizUnit", (Object)0, CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        IObjectCollection iCol = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(oneHelper.getOrgTypeSelfInfo().getOrgViewBosType(), viewInfo);
        if (iCol == null || iCol.isEmpty()) {
            return;
        }
        pdInfo.setParentOrg(oneHelper.getOrgTypeSelfInfo().getOrgType(), (OrgUnitInfo)iCol.getObject(0));
    }

    private void loadSuperiorHisOrgUnits(Context ctx, IOrgAppHelper oneHelper, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        oneHelper.loadSuperiorHisOrgUnits(ctx, fullVersionInfo, pdInfo);
    }

    public void updateStructure(Context ctx, FullOrgUnitInfo unitInfo, boolean isUpdate) throws BOSException, EASBizException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            oneHelper.updateStructure(ctx, unitInfo, isUpdate);
        }
    }

    public void fillFullOrgUnit(Context ctx, FullOrgUnitInfo unitInfo, IRowSet row, String bizObjType, boolean isSimpleField, OrgTypeInfo orgTypeInfo) throws SQLException, BOSException, EASBizException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            if (isSimpleField && orgTypeInfo != null && !orgTypeInfo.getOrgType().equals((Object)oneHelper.getOrgTypeSelfInfo().getOrgType())) continue;
            if (oneHelper.getOrgTypeSelfInfo() == null) {
                this.printOrgTypeManagerAndAppCenter();
            } else if (oneHelper.getOrgTypeSelfInfo().getIOrgQueryInfo() == null) {
                // empty if block
            }
            oneHelper.getOrgTypeSelfInfo().getIOrgQueryInfo().fillOrgUnitInfo(ctx, oneHelper, unitInfo, row, bizObjType);
        }
    }

    private void printOrgTypeManagerAndAppCenter() {
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
        }
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
        }
    }

    public void fillFullOrgUnit(Context ctx, FullOrgUnitInfo unitInfo, IRowSet row, String bizObjType) throws SQLException, BOSException, EASBizException {
        this.fillFullOrgUnit(ctx, unitInfo, row, bizObjType, false, null);
    }

    public void updateBizViewOnCU(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        for (int i = 0; i < appDealList.size(); ++i) {
            IOrgAppHelper oneHelper = (IOrgAppHelper)appDealList.get(i);
            this.updateBizViewOnCU(ctx, oneHelper, unitInfo);
        }
    }

    private void updateBizViewOnCU(Context ctx, IOrgAppHelper oneHelper, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgType curOrgType = oneHelper.getOrgTypeSelfInfo().getOrgType();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(curOrgType);
        if (orgTypeInfo == null) {
            return;
        }
        String orgTreeId = orgTypeInfo.getOrgTreeID();
        if (StringUtils.isEmpty((String)orgTreeId)) {
            return;
        }
        String oql = "Select *, parent.unit.id, parent.longNumber, parent.displayname, parent.level, unit.name, unit.number Where unit.id = '" + unitInfo.getId().toString() + "' and tree.id = '" + orgTreeId + "'";
        OrgStructureCollection struCol = iStruct.getOrgStructureCollection(oql);
        if (struCol == null || struCol.isEmpty()) {
            return;
        }
        OrgStructureInfo strucInfo = struCol.get(0);
        ObjectUuidPK pk = new ObjectUuidPK(strucInfo.getId());
        if (OrgType.ControlUnit == curOrgType) {
            OrgStructureInfo parentStructInfo = null;
            if (!unitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                parentStructInfo = iStruct.getOrgStructureInfo("Select *, unit.number Where unit.id = '" + unitInfo.getParent().getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000014F2827FD" + "'");
            }
            if (!unitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4") && OrgAppHelper.existBizSuperiorLoop(ctx, strucInfo, parentStructInfo)) {
                Object[] params = new String[]{OrgType.ControlUnit.getAlias()};
                throw new OUException(OUException.ORG_SUPERIOR_LOOP, params);
            }
            CUParentChangedHandlerUtil.adjustData((Context)ctx, (OrgStructureInfo)strucInfo, (OrgStructureInfo)strucInfo.getParent(), parentStructInfo);
            strucInfo.setParent(parentStructInfo);
            strucInfo.setIsValid(true);
        }
        iStruct.update((IObjectPK)pk, strucInfo);
    }

    public OUPartCoreBaseInfo getOUPartByFullOrgUnit(Context ctx, FullOrgUnitInfo unitInfo, OrgType orgType) throws BOSException, EASBizException {
        IOrgAppHelper oneHelper = this.getHelper(orgType);
        if (oneHelper == null) {
            return null;
        }
        return oneHelper.getOUPartByFullOrgUnit(ctx, unitInfo);
    }

    public OrgStructureInfo getOrgStructureInfo(Context ctx, FullOrgUnitInfo unitInfo, OrgType orgType) throws BOSException, EASBizException {
        IOrgAppHelper oneHelper = this.getHelper(orgType);
        if (oneHelper == null) {
            return null;
        }
        return oneHelper.getOrgStructureInfo(ctx, unitInfo);
    }

    public OrgStructureInfo getOldStructureInfo(Context ctx, FullOrgUnitInfo unitInfo, OrgType orgType) throws BOSException, EASBizException {
        IOrgAppHelper oneHelper = this.getHelper(orgType);
        if (oneHelper == null) {
            return null;
        }
        return oneHelper.getOldStructureInfo(ctx, unitInfo);
    }

    public String getUpateViewSql(Context ctx, OrgType orgType) {
        IOrgAppHelper oneHelper = this.getHelper(orgType);
        if (oneHelper == null) {
            return null;
        }
        return oneHelper.getUpateViewSql();
    }

    public String getUpdateViewCUSql(Context ctx, OrgType orgType) {
        IOrgAppHelper oneHelper = this.getHelper(orgType);
        if (oneHelper == null) {
            return null;
        }
        return oneHelper.getUpdateViewCUSql();
    }

    public void updateParentStructure(Context ctx, OrgType orgType, OrgStructureInfo structureInfo, boolean isNew) throws BOSException, EASBizException {
        IOrgAppHelper oneHelper = this.getHelper(orgType);
        if (oneHelper == null) {
            return;
        }
        oneHelper.updateParentStructure(ctx, structureInfo, isNew);
    }

    private Set getOrgTypeByUnitInfo(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        String orgTypeStr = unitInfo.getOrgTypeStr();
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgTypeStr);
        Set orgTypeSet = orgTypeHelper.getAllSelectOrgTypeSet();
        return orgTypeSet;
    }

    public void updateOUPartCU(Context ctx, FullOrgUnitInfo unitInfo, FullOrgUnitInfo oldUnitInfo) throws BOSException, EASBizException {
        Set orgTypeSet = this.getOrgTypeByUnitInfo(ctx, oldUnitInfo);
        Iterator it = orgTypeSet.iterator();
        while (it.hasNext()) {
            IOrgAppHelper oneHelper = this.getHelper((OrgType)((Object)it.next()));
            if (oneHelper == null) continue;
            oneHelper.updateOUPartCU(ctx, unitInfo, oldUnitInfo);
        }
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo(Context ctx, OrgType orgType) {
        IOrgAppHelper oneHelper = this.getHelper(orgType);
        if (oneHelper == null) {
            return null;
        }
        return oneHelper.getOrgTypeSelfInfo();
    }
}

