/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.TableAssistInfo;
import com.kingdee.eas.basedata.org.app.helper.FilterAssembleDecorator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PermItemFilter4F7Decorator
extends FilterAssembleDecorator {
    private static Logger logger = Logger.getLogger((String)PermItemFilter4F7Decorator.class.getName());
    protected List<TableAssistInfo> tables = new ArrayList<TableAssistInfo>();
    protected List<Object> objParams = new ArrayList<Object>();

    @Override
    protected List<String> handleFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)assistInfo.getPermItem())) {
            List<String> filters = null;
            try {
                filters = this.isAdminType(ctx, assistInfo.getUserPK()) ? this.buildAdminFilter(ctx, assistInfo) : this.buildPermItemFilter(ctx, assistInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            return filters;
        }
        return null;
    }

    @Override
    protected List<TableAssistInfo> handleTables(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)assistInfo.getPermItem())) {
            return this.tables;
        }
        return null;
    }

    @Override
    protected List<Object> getObjParams(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)assistInfo.getPermItem())) {
            return this.objParams;
        }
        return null;
    }

    private List<String> buildPermItemFilter(Context ctx, OrgAssistInfo assistInfo) throws EASBizException, BOSException {
        ArrayList<String> filter = new ArrayList<String>();
        String paramSQL = NewOrgF7FacadeFactory.getLocalInstance(ctx).getPermSQLByPermItem(assistInfo.getPermItem(), assistInfo.getUserPK(), assistInfo.getOrgViewType());
        filter.add("\"BASEUNIT\".FID in (" + paramSQL + ")");
        return filter;
    }

    private List<String> buildAdminFilter(Context ctx, OrgAssistInfo assistInfo) {
        ArrayList<String> filter = new ArrayList<String>();
        StringBuffer orgRangeSQL = new StringBuffer();
        orgRangeSQL.append("\"ORGRANGE\"").append(".FUserId = ? and ").append("\"ORGRANGE\"").append(".FType = ?");
        filter.add(orgRangeSQL.toString());
        this.tables.add(assistInfo.createTableAssistInfo("T_PM_ORGRANGE", "\"ORGRANGE\"", "FOrgId", "\"BASEUNIT\"", "FControlUnitID"));
        this.objParams.add(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        this.objParams.add(10);
        return filter;
    }

    private boolean isAdminType(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        boolean isCurrentUserPK;
        if (Administrator.isSuperAdmin((IObjectPK)userPK)) {
            return true;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK currentUserPK = new ObjectUuidPK(userInfo.getId());
        boolean bl = isCurrentUserPK = userPK == currentUserPK;
        if (isCurrentUserPK) {
            return Administrator.isAdminType((UserType)userInfo.getType());
        }
        return Administrator.isAdmin((Context)ctx, (IObjectPK)userPK);
    }
}

