/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.TableAssistInfo;
import com.kingdee.eas.basedata.org.app.helper.FilterAssembleDecorator;
import com.kingdee.eas.basedata.org.util.OrgF7FilterUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PermissionFilter4F7Decorator
extends FilterAssembleDecorator {
    private static Logger logger = Logger.getLogger((String)PermissionFilter4F7Decorator.class.getName());
    private AbstractOrgViewType orgViewType = null;

    @Override
    protected List<String> handleFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (assistInfo.isCUFilter() || assistInfo.isNeedAddOrgRange()) {
            this.initOrgViewType(ctx, assistInfo);
            try {
                return this.orgViewType.getOrgPermissionFilter();
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    private void initOrgViewType(Context ctx, OrgAssistInfo assistInfo) {
        if (this.orgViewType == null) {
            OrgViewType viewType = assistInfo.getOrgViewType();
            assert (viewType != null);
            this.orgViewType = viewType == OrgViewType.UNIONDEBT ? new UnionOrgViewType(ctx, assistInfo) : (viewType == OrgViewType.RESPONSECENTER ? new ResponsecenterOrgViewType(ctx, assistInfo) : new OtherOrgViewType(ctx, assistInfo));
        }
    }

    @Override
    protected List<TableAssistInfo> handleTables(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (assistInfo.isCUFilter() || assistInfo.isNeedAddOrgRange()) {
            this.initOrgViewType(ctx, assistInfo);
            return this.orgViewType.getTables();
        }
        return null;
    }

    @Override
    protected String getMaskString(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (assistInfo.isCUFilter() || assistInfo.isNeedAddOrgRange()) {
            this.initOrgViewType(ctx, assistInfo);
            return this.orgViewType.getMaskString();
        }
        return null;
    }

    @Override
    protected List<Object> getObjParams(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (assistInfo.isCUFilter() || assistInfo.isNeedAddOrgRange()) {
            this.initOrgViewType(ctx, assistInfo);
            return this.orgViewType.getObjParams();
        }
        return null;
    }

    private boolean isAdminType(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        boolean isCurrentUserPK;
        if (Administrator.isSuperAdmin((IObjectPK)userPK)) {
            return true;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK currentUserPK = new ObjectUuidPK(userInfo.getId());
        boolean bl = isCurrentUserPK = userPK == currentUserPK;
        if (isCurrentUserPK) {
            return Administrator.isAdminType((UserType)userInfo.getType());
        }
        return Administrator.isAdmin((Context)ctx, (IObjectPK)userPK);
    }

    private class OtherOrgViewType
    extends AbstractOrgViewType {
        private OtherOrgViewType(Context ctx, OrgAssistInfo assistInfo) {
            super(ctx, assistInfo);
        }

        @Override
        protected List<String> buildAdminFilter() throws BOSException, EASBizException {
            ArrayList<String> filter = new ArrayList<String>();
            if (this.isCUFilter) {
                filter.add("\"BASEUNIT\".FControlUnitID = '" + this.cuID + "'");
                if (this.isCUFilterIncludeSub) {
                    filter.add("UNIT_CU.FLongNumber like '" + OrgF7FilterUtil.getCULongNumber(this.ctx, this.cuID) + "!%'");
                    this.tables.add(this.assistInfo.createTableAssistInfo("T_ORG_CTRLUNIT", "UNIT_CU", "FID", "\"BASEUNIT\"", "FControlUnitID"));
                    this.maskString = "(#0 or #1)";
                }
            } else if (this.isNeedAddOrgRange) {
                StringBuffer orgRangeSQL = new StringBuffer();
                orgRangeSQL.append("\"ORGRANGE\"").append(".FUserId = ? and ").append("\"ORGRANGE\"").append(".FType = ?");
                filter.add(orgRangeSQL.toString());
                this.tables.add(this.assistInfo.createTableAssistInfo("T_PM_ORGRANGE", "\"ORGRANGE\"", "FOrgId", "\"BASEUNIT\"", "FControlUnitID"));
                this.objParams.add(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString());
                this.objParams.add(10);
            }
            return filter;
        }

        @Override
        protected List<String> buildOrgRangeFilter() throws BOSException, EASBizException {
            ArrayList<String> filter = new ArrayList<String>();
            if (this.isCUFilter) {
                String paramSQL = OrgF7FilterUtil.buildParamSQL(this.ctx, this.assistInfo.getUserPK(), this.assistInfo.getCuID(), this.assistInfo.getOrgViewType(), true, this.isCUFilterIncludeSub);
                filter.add("\"BASEUNIT\".FID in (" + paramSQL + ")");
            } else if (this.isNeedAddOrgRange) {
                StringBuffer orgRangeSQL = new StringBuffer();
                orgRangeSQL.append("\"ORGRANGE\"").append(".FUserId = ? and ").append("\"ORGRANGE\"").append(".FType = ?");
                filter.add(orgRangeSQL.toString());
                this.tables.add(this.assistInfo.createTableAssistInfo("T_PM_ORGRANGE", "\"ORGRANGE\"", "FOrgId", "\"BASEUNIT\"", "FID"));
                this.objParams.add(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString());
                this.objParams.add(this.getOrgRangeType(this.assistInfo));
            }
            return filter;
        }

        private int getOrgRangeType(OrgAssistInfo assistInfo) {
            return assistInfo.getOrgViewType() == OrgViewType.ADMIN ? 20 : 10;
        }

        @Override
        protected List<String> buildPermItemFilter() throws BOSException, EASBizException {
            ArrayList<String> filter = new ArrayList<String>();
            if (this.isCUFilter || this.isNeedAddOrgRange) {
                String paramSQL = NewOrgF7FacadeFactory.getLocalInstance(this.ctx).getPermSQLByUIPKAndActionPK(this.userPK, this.cuID, this.uiPK, this.actionPK, this.viewType, this.isCUFilter, this.isCUFilterIncludeSub);
                filter.add("\"BASEUNIT\".FID in (" + paramSQL + ")");
            }
            return filter;
        }
    }

    private class ResponsecenterOrgViewType
    extends AbstractOrgViewType {
        private ResponsecenterOrgViewType(Context ctx, OrgAssistInfo assistInfo) {
            super(ctx, assistInfo);
        }

        @Override
        protected List<String> buildAdminFilter() throws BOSException, EASBizException {
            return null;
        }

        @Override
        protected List<String> buildOrgRangeFilter() throws BOSException, EASBizException {
            return null;
        }

        @Override
        protected List<String> buildPermItemFilter() throws BOSException, EASBizException {
            return null;
        }
    }

    private class UnionOrgViewType
    extends AbstractOrgViewType {
        private UnionOrgViewType(Context ctx, OrgAssistInfo assistInfo) {
            super(ctx, assistInfo);
        }

        @Override
        protected List<String> getOrgPermissionFilter() throws BOSException, EASBizException {
            List<String> filter = super.getOrgPermissionFilter();
            if (filter == null) {
                filter = new ArrayList<String>();
            }
            filter.add("\"STRUCTURE\".FTreeID = '" + this.treeID + "'");
            filter.add("\"BASEUNIT\".FIsUnion = 0 ");
            filter.add("OUPART_FI.FIsSealUp = 0 ");
            this.tables.add(this.assistInfo.createTableAssistInfo("T_ORG_OUPARTFI", "OUPART_FI", "FUnitId", "\"BASEUNIT\"", "FID"));
            this.maskString = "(#0 or (#1 and #2 and #3))";
            return filter;
        }

        @Override
        protected List<String> buildAdminFilter() throws BOSException, EASBizException {
            ArrayList<String> filter = new ArrayList<String>();
            if (this.isCUFilter) {
                filter.add("\"BASEUNIT\".FControlUnitID = '" + this.cuID + "'");
            } else if (this.isNeedAddOrgRange) {
                StringBuffer orgRangeSQL = new StringBuffer();
                orgRangeSQL.append("\"ORGRANGE\"").append(".FUserId = ? and ").append("\"ORGRANGE\"").append(".FType = ?");
                filter.add(orgRangeSQL.toString());
                this.tables.add(this.assistInfo.createTableAssistInfo("T_PM_ORGRANGE", "\"ORGRANGE\"", "FOrgId", "\"BASEUNIT\"", "FControlUnitID"));
                this.objParams.add(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString());
                this.objParams.add(10);
            }
            return filter;
        }

        @Override
        protected List<String> buildOrgRangeFilter() throws BOSException, EASBizException {
            ArrayList<String> filter = new ArrayList<String>();
            if (this.isCUFilter) {
                String paramSQL = OrgF7FilterUtil.buildParamSQL(this.ctx, this.assistInfo.getUserPK(), this.assistInfo.getCuID(), this.assistInfo.getOrgViewType(), true, false);
                filter.add("\"BASEUNIT\".FID in (" + paramSQL + ")");
            } else if (this.isNeedAddOrgRange) {
                StringBuffer orgRangeSQL = new StringBuffer();
                orgRangeSQL.append("\"ORGRANGE\"").append(".FUserId = ? and ").append("\"ORGRANGE\"").append(".FType = ?");
                filter.add(orgRangeSQL.toString());
                this.tables.add(this.assistInfo.createTableAssistInfo("T_PM_ORGRANGE", "\"ORGRANGE\"", "FOrgId", "\"BASEUNIT\"", "FID"));
                this.objParams.add(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString());
                this.objParams.add(this.getOrgRangeType(this.assistInfo));
            }
            return filter;
        }

        private int getOrgRangeType(OrgAssistInfo assistInfo) {
            return assistInfo.getOrgViewType() == OrgViewType.ADMIN ? 20 : 10;
        }

        @Override
        protected List<String> buildPermItemFilter() throws BOSException, EASBizException {
            ArrayList<String> filter = new ArrayList<String>();
            if (this.isCUFilter || this.isNeedAddOrgRange) {
                String paramSQL = NewOrgF7FacadeFactory.getLocalInstance(this.ctx).getPermSQLByUIPKAndActionPK(this.userPK, this.cuID, this.uiPK, this.actionPK, this.viewType, this.isCUFilter, false);
                filter.add("\"BASEUNIT\".FID in (" + paramSQL + ")");
            }
            return filter;
        }
    }

    private abstract class AbstractOrgViewType {
        protected List<TableAssistInfo> tables = new ArrayList<TableAssistInfo>();
        protected List<Object> objParams = new ArrayList<Object>();
        protected String maskString = null;
        protected Context ctx;
        protected OrgAssistInfo assistInfo;
        protected String cuID;
        protected OrgViewType viewType;
        protected String treeID;
        protected IObjectPK userPK;
        protected IMetaDataPK uiPK;
        protected IMetaDataPK actionPK;
        protected boolean isCUFilterIncludeSub;
        protected boolean isCUFilter;
        protected boolean isNeedAddOrgRange;

        private AbstractOrgViewType(Context ctx, OrgAssistInfo assistInfo) {
            this.ctx = ctx;
            this.assistInfo = assistInfo;
            this.initParam();
        }

        public List<Object> getObjParams() {
            return this.objParams;
        }

        private void initParam() {
            this.cuID = this.assistInfo.getCuID();
            this.viewType = this.assistInfo.getOrgViewType();
            this.treeID = this.assistInfo.getTreeID();
            this.userPK = this.assistInfo.getUserPK();
            this.uiPK = this.assistInfo.getUiPK();
            this.actionPK = this.assistInfo.getActionPK();
            this.isCUFilterIncludeSub = this.assistInfo.isCUFilterIncludeSub();
            this.isCUFilter = this.assistInfo.isCUFilter();
            this.isNeedAddOrgRange = this.assistInfo.isNeedAddOrgRange();
        }

        protected List<String> getOrgPermissionFilter() throws BOSException, EASBizException {
            List<String> filters = null;
            filters = PermissionFilter4F7Decorator.this.isAdminType(this.ctx, this.userPK) ? this.buildAdminFilter() : (this.uiPK == null || this.actionPK == null ? this.buildOrgRangeFilter() : this.buildPermItemFilter());
            return filters;
        }

        protected abstract List<String> buildPermItemFilter() throws BOSException, EASBizException;

        protected abstract List<String> buildOrgRangeFilter() throws BOSException, EASBizException;

        protected abstract List<String> buildAdminFilter() throws BOSException, EASBizException;

        protected List<TableAssistInfo> getTables() {
            return this.tables;
        }

        protected String getMaskString() {
            return this.maskString;
        }
    }
}

