/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.TableAssistInfo;
import com.kingdee.eas.basedata.org.app.helper.TreeNodeTypeAssemblage;
import com.kingdee.eas.basedata.org.app.helper.UnitAssemblage;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StructAssemblage
extends TreeNodeTypeAssemblage {
    private static Logger logger = Logger.getLogger((String)UnitAssemblage.class.getName());

    @Override
    protected List buildInfoByResultSet(Context ctx, IRowSet rs) throws BOSException {
        ArrayList<OrgStructureInfo> result = new ArrayList<OrgStructureInfo>();
        try {
            String fidTemp = null;
            while (rs.next()) {
                try {
                    if (rs.getString("fisunion") != null && rs.getString("fisunion").equals("1")) {
                        if (fidTemp != null && rs.getString(1).equals(fidTemp)) continue;
                        fidTemp = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                OrgStructureInfo structInfo = new OrgStructureInfo();
                structInfo.setId(BOSUuid.read((String)rs.getString(1)));
                structInfo.setLongNumber(rs.getString(2));
                structInfo.setLevel(rs.getInt(3));
                structInfo.setIsLeaf(rs.getBoolean(4));
                if (rs.getString(5) != null) {
                    OrgStructureInfo parent = new OrgStructureInfo();
                    parent.setId(BOSUuid.read((String)rs.getString(5)));
                    structInfo.setParent(parent);
                }
                FullOrgUnitInfo fullUnitInfo = new FullOrgUnitInfo();
                fullUnitInfo.setId(BOSUuid.read((String)rs.getString(6)));
                fullUnitInfo.setName(rs.getString(7));
                fullUnitInfo.setNumber(rs.getString(8));
                fullUnitInfo.setIsUnion(rs.getBoolean(9));
                structInfo.setUnit(fullUnitInfo);
                result.add(structInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map<String, List<String>> handleSelectors(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (null == ctx) {
            throw new BOSException("context can't be null.");
        }
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        ArrayList<String> structColumns = new ArrayList<String>();
        structColumns.add("FID");
        structColumns.add("FLongnumber");
        structColumns.add("FLevel");
        structColumns.add("FIsleaf");
        structColumns.add("FParentID");
        result.put("\"STRUCTURE\"", structColumns);
        ArrayList<String> unitColumns = new ArrayList<String>();
        unitColumns.add("FID");
        unitColumns.add("FName_" + ctx.getLocale().toString());
        unitColumns.add("FNumber");
        unitColumns.add("FIsUnion");
        result.put("\"BASEUNIT\"", unitColumns);
        return result;
    }

    @Override
    protected List<String> handleSortItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<String> sortItems = new ArrayList<String>();
        if (assistInfo.getNeedBySortCode()) {
            sortItems.add("\"STRUCTURE\".FSortCode");
        }
        sortItems.add("\"STRUCTURE\".FLongNumber");
        return sortItems;
    }

    @Override
    protected List<TableAssistInfo> handleTables(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<TableAssistInfo> result = new ArrayList<TableAssistInfo>();
        TableAssistInfo structTable = new TableAssistInfo();
        structTable.setTableName("T_ORG_Structure");
        structTable.setTableAlias("\"STRUCTURE\"");
        result.add(structTable);
        TableAssistInfo unitTable = new TableAssistInfo();
        unitTable.setTableName("T_ORG_BASEUNIT");
        unitTable.setTableAlias("\"BASEUNIT\"");
        unitTable.setRefTableAlias("\"STRUCTURE\"");
        unitTable.setRefTableColumn("FUnitId");
        result.add(unitTable);
        return result;
    }

    @Override
    protected String buildQuerySQL(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            String sortItems;
            StringBuffer querySQL = new StringBuffer();
            String filterItems = this.buildFilterItems(ctx, selectedNode, assistInfo);
            String selectors = this.buildSelectors(ctx, selectedNode, assistInfo);
            if (StringUtils.isEmpty((String)selectors)) {
                throw new BOSException("selectors can't be null.");
            }
            querySQL.append("select ").append(selectors).append(" from ").append(" T_ORG_STRUCTURE ").append("\"STRUCTURE\"").append(" INNER JOIN T_ORG_BASEUNIT ").append("\"BASEUNIT\"").append(" on ").append("\"STRUCTURE\"").append(".FUnitID = ").append("\"BASEUNIT\"").append(".FID ");
            if (!StringUtils.isEmpty((String)filterItems)) {
                querySQL.append(" where ").append(filterItems).append(" and ").append("\"STRUCTURE\"").append(".FTreeID = '").append(assistInfo.getTreeID()).append("'");
            }
            if (!StringUtils.isEmpty((String)(sortItems = this.buildOrderItems(ctx, selectedNode, assistInfo)))) {
                querySQL.append(" order by ").append(sortItems);
            }
            return querySQL.toString();
        }
        return super.buildQuerySQL(ctx, selectedNode, assistInfo);
    }

    @Override
    protected String buildFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            String tables;
            String selectedNodeLNum = (String)selectedNode.get("longNumber");
            if (StringUtils.isEmpty((String)selectedNodeLNum)) {
                logger.error((Object)"selectedNode's longNumber is null.");
                throw new BOSException("selectedNode's longNumber is null.");
            }
            StringBuffer tmp = new StringBuffer();
            String filterItems = super.buildFilterItems(ctx, selectedNode, assistInfo);
            if (!StringUtils.isEmpty((String)filterItems)) {
                tmp.append(" where ").append(filterItems);
                if (!StringUtils.isEmpty((String)assistInfo.getExtraFilters())) {
                    tmp.append(" ").append(assistInfo.getExtraFilters());
                }
            } else if (!StringUtils.isEmpty((String)assistInfo.getExtraFilters())) {
                tmp.append(" where ").append(assistInfo.getExtraFilters());
            }
            if (StringUtils.isEmpty((String)(tables = this.buildTables(ctx, selectedNode, assistInfo)))) {
                throw new BOSException("tables can't be null.");
            }
            StringBuffer result = new StringBuffer();
            StringBuffer longNumber = new StringBuffer().append("\"STRUCTURE\"").append(".FLongNumber");
            result.append(longNumber).append(" in (").append("select distinct substring(").append(longNumber).append(", 0, CHARINDEX('!', ").append(longNumber).append("||'!', ").append(selectedNodeLNum.length() + 2).append(")-1) ").append("AS FVALIDLN").append(" from ").append(tables).append(tmp).append(")");
            return result.toString();
        }
        return super.buildFilterItems(ctx, selectedNode, assistInfo);
    }

    @Override
    protected List<String> handleFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<String> filterItems = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            filterItems.add(new StringBuffer().append("\"STRUCTURE\"").append(".FLongNumber like ?").toString());
            filterItems.add(new StringBuffer().append("\"STRUCTURE\"").append(".FTreeId = ?").toString());
        } else {
            filterItems.add(new StringBuffer().append("\"STRUCTURE\"").append(".FParentID = ?").toString());
        }
        if (assistInfo.getOrgViewType() == OrgViewType.UNIONDEBT && assistInfo.getInt("selectMode") == 0) {
            filterItems.add(new StringBuffer().append("\"BASEUNIT\"").append(".FIsUnion = 1").toString());
        }
        return filterItems;
    }

    @Override
    protected List<Object> getObjParams(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<Object> objParams = new ArrayList<Object>();
        if (!StringUtils.isEmpty((String)assistInfo.getQuickQueryValue()) || assistInfo.isNeedConsiderFaultTree()) {
            String selectedNodeLNum = selectedNode.getString("longNumber");
            if (StringUtils.isEmpty((String)selectedNodeLNum)) {
                objParams.add("nodata");
            } else {
                objParams.add(selectedNodeLNum + "!%");
            }
            String treeId = assistInfo.getTreeID();
            if (StringUtils.isEmpty((String)treeId)) {
                objParams.add("nodata");
            } else {
                objParams.add(treeId);
            }
        } else {
            objParams.add(selectedNode.getId().toString());
        }
        return objParams;
    }
}

