/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.TableAssistInfo;
import com.kingdee.eas.basedata.org.app.helper.AssembleHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class TreeNodeTypeAssemblage
extends AssembleHelper {
    private static Logger logger = Logger.getLogger((String)TreeNodeTypeAssemblage.class.getName());
    protected List<AssembleHelper> decorators = new ArrayList<AssembleHelper>();

    public void registerFilterDecorator(AssembleHelper helper) {
        assert (helper != null);
        this.decorators.add(helper);
    }

    public TreeNodeTypeAssemblage() {
        this.registerFilterDecorator(this);
    }

    protected String buildSelectors(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        StringBuffer selectorsString = new StringBuffer();
        for (int i = 0; i < this.decorators.size(); ++i) {
            AssembleHelper helper = this.decorators.get(i);
            Map<String, List<String>> selectors = helper.handleSelectors(ctx, selectedNode, assistInfo);
            if (null == selectors || selectors.size() == 0) continue;
            Set<Map.Entry<String, List<String>>> entrySet = selectors.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                selectorsString.append(this.appendSelectorsByEntry(entry));
            }
        }
        if (StringUtils.isEmpty((String)selectorsString.toString())) {
            throw new BOSException("selectors can't be null or size can't be zero.");
        }
        return selectorsString.substring(0, selectorsString.length() - 1);
    }

    private String appendSelectorsByEntry(Map.Entry<String, List<String>> entry) {
        StringBuffer oneTableColumns = new StringBuffer();
        if (entry != null) {
            String tableAlias = entry.getKey();
            List<String> columns = entry.getValue();
            if (columns != null && columns.size() > 0) {
                for (int i = 0; i < columns.size(); ++i) {
                    oneTableColumns.append(tableAlias).append(".").append((Object)columns.get(i)).append(",");
                }
            }
        }
        return oneTableColumns.toString();
    }

    protected String buildTables(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        StringBuffer tablesString = new StringBuffer();
        for (int i = 0; i < this.decorators.size(); ++i) {
            AssembleHelper helper = this.decorators.get(i);
            List<TableAssistInfo> tables = helper.handleTables(ctx, selectedNode, assistInfo);
            if (tables == null || tables.size() == 0) continue;
            for (int j = 0; j < tables.size(); ++j) {
                TableAssistInfo info = tables.get(j);
                if (tablesString.length() == 0) {
                    tablesString.append(info.getTableName()).append(" ").append(info.getTableAlias());
                    continue;
                }
                tablesString.append(assistInfo.isInnerJoinStyle() ? info.INNER_JOIN : info.LEFT_JOIN).append(info.getTableName()).append(" ").append(info.getTableAlias()).append(" ON ").append(info.getTableAlias()).append(".").append(StringUtils.isEmpty((String)info.getTableColumn()) ? "FID" : info.getTableColumn()).append(" = ").append(info.getRefTableAlias()).append(".").append(info.getRefTableColumn());
            }
        }
        if (StringUtils.isEmpty((String)tablesString.toString())) {
            throw new BOSException("tables can't be null or size can't be zero.");
        }
        return tablesString.toString();
    }

    protected String buildFilterItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        StringBuffer filtersString = new StringBuffer();
        String maskString = this.reDefinitionMaskString();
        if (StringUtils.isEmpty((String)maskString)) {
            for (int i = 0; i < this.decorators.size(); ++i) {
                String mask;
                String tmp;
                AssembleHelper helper = this.decorators.get(i);
                List<String> filterItems = helper.handleFilterItems(ctx, selectedNode, assistInfo);
                if (filterItems == null || filterItems.size() == 0 || StringUtils.isEmpty((String)(tmp = this.appendFilterItems(filterItems, mask = helper.getMaskString(ctx, selectedNode, assistInfo))))) continue;
                if (filtersString.length() != 0) {
                    filtersString.append(" AND ");
                }
                filtersString.append("(").append(tmp).append(")");
            }
        } else {
            filtersString.append(this.appendFilterItemsUsingMaskString(maskString, ctx, selectedNode, assistInfo));
        }
        return filtersString.toString();
    }

    protected String appendFilterItems(List<String> filterItems, String maskString) {
        if (filterItems == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (StringUtils.isEmpty((String)maskString)) {
            for (int i = 0; i < filterItems.size(); ++i) {
                String filter = filterItems.get(i);
                if (StringUtils.isEmpty((String)filter)) continue;
                if (result.length() == 0) {
                    result.append(filter);
                    continue;
                }
                result.append(" AND ").append(filter);
            }
        } else {
            result.append(maskString.trim());
            int fromIndex = 0;
            for (int i = 0; i < filterItems.size(); ++i) {
                String filter = filterItems.get(i);
                if (StringUtils.isEmpty((String)filter)) continue;
                int index = result.indexOf("#", fromIndex);
                result = result.replace(index, index + String.valueOf(i).length() + 1, filter);
                fromIndex += filter.length();
            }
        }
        return result.toString();
    }

    protected StringBuffer appendFilterItemsUsingMaskString(String maskString, Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        StringBuffer result = new StringBuffer(maskString.trim());
        int fromIndex = 0;
        for (int i = 0; i < this.decorators.size(); ++i) {
            AssembleHelper helper = this.decorators.get(i);
            List<String> filterItems = helper.handleFilterItems(ctx, selectedNode, assistInfo);
            if (filterItems == null || filterItems.size() == 0) continue;
            for (int j = 0; j < filterItems.size(); ++j) {
                String filterItem = filterItems.get(j);
                if (StringUtils.isEmpty((String)filterItem)) continue;
                int index = result.indexOf("#", fromIndex);
                result = result.replace(index, index + 1, filterItem);
                fromIndex += filterItem.length();
            }
        }
        if (result.indexOf("#", fromIndex) != -1) {
            logger.warn((Object)"size of maskString is not equal with the size of filterItems");
        }
        return result;
    }

    protected String buildOrderItems(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        StringBuffer sortItemsString = new StringBuffer();
        for (int i = 0; i < this.decorators.size(); ++i) {
            AssembleHelper helper = this.decorators.get(i);
            List<String> sortItems = helper.handleSortItems(ctx, selectedNode, assistInfo);
            if (sortItems == null || sortItems.size() == 0) continue;
            for (int j = 0; j < sortItems.size(); ++j) {
                sortItemsString.append(sortItems.get(j)).append(",");
            }
        }
        if (StringUtils.isEmpty((String)sortItemsString.toString())) {
            return "";
        }
        return sortItemsString.substring(0, sortItemsString.length() - 1);
    }

    protected String buildQuerySQL(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        String sortItems;
        StringBuffer querySQL = new StringBuffer();
        String filterItems = this.buildFilterItems(ctx, selectedNode, assistInfo);
        String selectors = this.buildSelectors(ctx, selectedNode, assistInfo);
        String tables = this.buildTables(ctx, selectedNode, assistInfo);
        if (StringUtils.isEmpty((String)selectors) || StringUtils.isEmpty((String)tables)) {
            throw new BOSException("selectors or tables can't be null.");
        }
        querySQL.append("select ").append(selectors).append(" from ").append(tables);
        if (!StringUtils.isEmpty((String)filterItems)) {
            querySQL.append(" where ").append(filterItems);
            if (!StringUtils.isEmpty((String)assistInfo.getExtraFilters())) {
                querySQL.append(" ").append(assistInfo.getExtraFilters());
            }
        } else if (!StringUtils.isEmpty((String)assistInfo.getExtraFilters())) {
            querySQL.append(" where ").append(assistInfo.getExtraFilters());
        }
        if (!StringUtils.isEmpty((String)(sortItems = this.buildOrderItems(ctx, selectedNode, assistInfo)))) {
            querySQL.append(" order by ").append(sortItems);
        }
        return querySQL.toString();
    }

    protected List executeQuery(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        long t1 = System.currentTimeMillis();
        String queryString = this.buildQuerySQL(ctx, selectedNode, assistInfo);
        logger.info((Object)("buildQuerySQL cost: " + (System.currentTimeMillis() - t1)));
        logger.info((Object)("querySQL is: " + queryString));
        if (StringUtils.isEmpty((String)queryString)) {
            throw new BOSException("queryString can't be null.");
        }
        List<Object> params = this.getTotalObjParams(ctx, selectedNode, assistInfo);
        if (null == params) {
            params = new ArrayList<Object>();
        }
        Object[] objs = params.toArray();
        List result = null;
        long t2 = System.currentTimeMillis();
        IRowSet rs = DbUtil.executeQueryNoTx((Context)ctx, (String)queryString, (Object[])objs);
        logger.info((Object)("executeQuery cost: " + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        result = this.buildInfoByResultSet(ctx, rs);
        logger.info((Object)("buildInfoByResultSet cost: " + (System.currentTimeMillis() - t3)));
        return result;
    }

    protected String reDefinitionMaskString() {
        return null;
    }

    protected int getFilterItemCount(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        int count = 0;
        String filterItem = null;
        for (int i = 0; i < this.decorators.size(); ++i) {
            AssembleHelper helper = this.decorators.get(i);
            List<String> filterItems = helper.handleFilterItems(ctx, selectedNode, assistInfo);
            if (filterItems == null || filterItems.size() <= 0) continue;
            for (int j = 0; j < filterItems.size(); ++j) {
                filterItem = filterItems.get(j);
                if (StringUtils.isEmpty((String)filterItem)) continue;
                ++count;
            }
        }
        return count;
    }

    protected List<Object> getTotalObjParams(Context ctx, CoreBaseInfo selectedNode, OrgAssistInfo assistInfo) throws BOSException {
        ArrayList<Object> objParams = new ArrayList<Object>();
        for (int i = 0; i < this.decorators.size(); ++i) {
            AssembleHelper helper = this.decorators.get(i);
            List<Object> params = helper.getObjParams(ctx, selectedNode, assistInfo);
            if (params == null || params.size() <= 0) continue;
            objParams.addAll(params);
        }
        return objParams;
    }
}

