/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppDataHelper;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgDataCheckerHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgQueryHelper;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.orgext.OUPartMarketInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class AbstractDefaultOrgTypeImpl
implements IOrgAppHelper,
IOrgAppDataHelper {
    private static Logger logger = Logger.getLogger((String)AbstractDefaultOrgTypeImpl.class.getName());
    protected final OrgDataCheckerHelper orgDataCheckerHelper = new OrgDataCheckerHelper();
    protected ReentrantLock lock = new ReentrantLock();
    protected final Map<String, Map<String, Integer>> mpTbFieldIndex = new HashMap<String, Map<String, Integer>>();
    protected final Map<String, Object> mpTbArray = new HashMap<String, Object>();

    public IObjectValue getOrgInfo(Context ctx, String orgId, BizOrgQueryParam queryParam) throws BOSException, EASBizException {
        return null;
    }

    private Object getRowSetValue(IRowSet rowSet, String fieldAliasName, String clazzName) throws BOSException {
        return OrgAppHelper.getRowSetValue(rowSet, fieldAliasName, clazzName);
    }

    @Override
    public void updateStructure(Context ctx, FullOrgUnitInfo unit, boolean isUpdate) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgType curOrgType = this.getOrgTypeSelfInfo().getOrgType();
        if (curOrgType.getValue() == 10) {
            return;
        }
        if (unit.get("hrOrgNotChanged") != null && 16 == curOrgType.getValue()) {
            return;
        }
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(curOrgType);
        if (orgTypeInfo == null) {
            return;
        }
        if (OrgTypeHelper.isOrgType(unit.getOrgTypeStr(), curOrgType)) {
            BizParentAndDelegateInfo pdInfo = (BizParentAndDelegateInfo)unit.get("PDValueInfo");
            if (pdInfo == null) {
                logger.error((Object)" client occur error! pdInfo is null");
                throw new BOSException(" client occur error! pdInfo is null");
            }
            OrgUnitInfo parentUnit = pdInfo.getParentOrg(this.getOrgTypeSelfInfo().getOrgType());
            if (parentUnit == null && !unit.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                Object[] params = new String[]{curOrgType.getAlias()};
                throw new OUException(OUException.MUST_INPUT_SUPERIOR, params);
            }
            OrgStructureInfo parentStructInfo = null;
            if (!unit.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                parentStructInfo = iStruct.getOrgStructureInfo("Select id,level,longnumber,isleaf,tree.id,sortcode,displayname,isvalid, unit.number, unit.name Where unit.id = '" + parentUnit.getId().toString() + "' and tree.id = '" + orgTypeInfo.getOrgTreeID() + "'");
            }
            OrgTreeInfo treeInfo = new OrgTreeInfo();
            treeInfo.setId(BOSUuid.read((String)orgTypeInfo.getOrgTreeID()));
            if (!isUpdate) {
                if (OrgType.Admin == curOrgType && !unit.getPartAdmin().isIsVirtual() && parentUnit != null && Boolean.valueOf((String)parentUnit.get("isVirtual")).booleanValue()) {
                    throw new OUException(OUException.CANT_ADD_NOT_VIRTUAL);
                }
                OrgStructureInfo structInfo = new OrgStructureInfo();
                structInfo.setUnit(unit);
                structInfo.setParent(parentStructInfo);
                structInfo.setTree(treeInfo);
                structInfo.setIsValid(true);
                iStruct.addnew(structInfo);
            } else if (!iStruct.exists("Select 1 Where unit.id = '" + unit.getId().toString() + "' and tree.id = '" + orgTypeInfo.getOrgTreeID() + "'")) {
                OrgStructureInfo structInfo = new OrgStructureInfo();
                structInfo.setUnit(unit);
                structInfo.setParent(parentStructInfo);
                structInfo.setTree(treeInfo);
                structInfo.setIsValid(true);
                iStruct.addnew(structInfo);
            } else {
                OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("Select id,level,longnumber,isleaf,tree.id,sortcode,displayname,isvalid, unit.number, unit.name Where unit.id = '" + unit.getId().toString() + "' and tree.id = '" + orgTypeInfo.getOrgTreeID() + "'");
                if (!"00000000-0000-0000-0000-000000000000CCE7AED4".equals(unit.getId().toString()) && OrgAppHelper.existBizSuperiorLoop(ctx, structInfo, parentStructInfo)) {
                    Object[] params = new String[]{curOrgType.getAlias()};
                    throw new OUException(OUException.ORG_SUPERIOR_LOOP, params);
                }
                structInfo.setParent(parentStructInfo);
                structInfo.setIsValid(true);
                ObjectUuidPK pk = new ObjectUuidPK(structInfo.getId());
                iStruct.update((IObjectPK)pk, structInfo);
            }
        } else if (isUpdate) {
            Object[] params = new String[]{curOrgType.getAlias(), curOrgType.getAlias()};
            if (!StringUtils.isEmpty((String)orgTypeInfo.getOrgTreeID()) && OrgAppHelper.isBizChildrenExist(ctx, unit, orgTypeInfo.getOrgTreeID())) {
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (curOrgType.getValue() == 8) {
                return;
            }
            if (OrgAppHelper.isCUBizPropertyExistInOU(ctx, unit, curOrgType.getValue())) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            if (this.isDelegatedByOthers(ctx, unit, curOrgType.getValue())) {
                throw new OUException(OUException.DELEGATEDBYOTHERS_NOTDELETE, params);
            }
            if (!unit.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unit.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTypeInfo.getOrgTreeID(), CompareType.EQUALS));
                filter.setMaskString("#0 and #1");
                iStruct.delete(filter);
            } else {
                DbUtil.execute((Context)ctx, (String)("Update T_ORG_Structure set FIsValid = 0 where FUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4' and FTreeID = '" + orgTypeInfo.getOrgTreeID() + "'"));
            }
            this.deleteSelfDelegate(ctx, unit, curOrgType.getValue());
        }
    }

    private boolean isDelegatedByOthers(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegateFacade = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        return iDelegateFacade.isDelegatedByOthers(unit.getId().toString(), orgTypeValue);
    }

    private void deleteSelfDelegate(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        IOrgDelegateFacade iDelegateFacade = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        iDelegateFacade.deleteSelfDelegateOnType(unit.getId().toString(), orgTypeValue);
    }

    @Override
    public void updateBizParent(Context ctx, String id, String parentId) throws BOSException, EASBizException {
        OrgStructureInfo parentStructInfo;
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgType curOrgType = this.getOrgTypeSelfInfo().getOrgType();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(curOrgType);
        if (orgTypeInfo == null) {
            return;
        }
        String treeId = orgTypeInfo.getOrgTreeID();
        OrgStructureInfo structInfo = iStruct.getOrgStructureInfo("select *,unit.* Where unit.id = '" + id + "' and tree.id = '" + treeId + "'");
        if (OrgAppHelper.existBizSuperiorLoop(ctx, structInfo, parentStructInfo = iStruct.getOrgStructureInfo("Select id,longNumber,displayName Where unit.id = '" + parentId + "' and tree.id = '" + treeId + "'"))) {
            Object[] params = new String[]{curOrgType.getAlias()};
            throw new OUException(OUException.ORG_SUPERIOR_LOOP, params);
        }
        structInfo.setParent(parentStructInfo);
        structInfo.setIsValid(true);
        ObjectUuidPK pk = new ObjectUuidPK(structInfo.getId());
        iStruct.update((IObjectPK)pk, structInfo);
    }

    private void innerUpdateBizParent(Context ctx, OrgStructureInfo structInfo, OrgStructureInfo parentStructInfo) throws BOSException, EASBizException {
        structInfo.setParent(parentStructInfo);
        structInfo.setIsValid(true);
        ObjectUuidPK pk = new ObjectUuidPK(structInfo.getId());
        OrgStructureFactory.getLocalInstance(ctx).update((IObjectPK)pk, structInfo);
    }

    protected String getOrgTreeID() {
        OrgType curOrgType = this.getOrgTypeSelfInfo().getOrgType();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(curOrgType);
        return orgTypeInfo.getOrgTreeID();
    }

    @Override
    public OrgStructureInfo getOrgStructureInfo(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        if (unitInfo == null) {
            throw new BOSException("unit can't be null");
        }
        OrgStructureInfo stureInfo = new OrgStructureInfo();
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfo.getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.getOrgTreeID()));
        viewInfo.setFilter(filterInfo);
        OrgStructureCollection structureCol = iStruct.getOrgStructureCollection(viewInfo);
        if (structureCol != null && structureCol.size() > 0) {
            stureInfo = structureCol.get(0);
        }
        return stureInfo;
    }

    @Override
    public OrgStructureInfo getOldStructureInfo(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        OrgStructureInfo stureInfo = new OrgStructureInfo();
        String tableName = this.getOrgTypeSelfInfo().getViewTableName();
        String treeId = this.getOrgTreeID();
        Locale locale = ctx.getLocale();
        String fdisplayName = "fdisplayName_" + locale;
        String sql = " SELECT fLongNumber,FParentID," + fdisplayName + " FROM " + tableName + " WHERE fid=?";
        String longNumber = "";
        String parentLongNumber = "";
        String parentId = "";
        String displayName = "";
        try {
            int index;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{unitInfo.getId().toString()});
            if (rowSet.next()) {
                longNumber = rowSet.getString("fLongNumber");
                parentId = rowSet.getString("FParentID");
                displayName = rowSet.getString(fdisplayName);
            }
            if ((index = longNumber.lastIndexOf("!")) >= 1) {
                parentLongNumber = longNumber.substring(0, index);
                if (!StringUtils.isEmpty((String)parentLongNumber)) {
                    IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
                    stureInfo = iStruct.getOrgStructureInfo(" where longNumber='" + parentLongNumber + "' and tree.id='" + treeId + "'");
                    stureInfo.setLongNumber(longNumber);
                    stureInfo.setDisplayName(displayName);
                }
            } else {
                if (!StringUtils.isEmpty((String)parentId)) {
                    OrgStructureInfo parentSturctInfo = new OrgStructureInfo();
                    parentSturctInfo.setId(BOSUuid.read((String)parentId));
                    stureInfo.setParent(parentSturctInfo);
                }
                stureInfo.setLongNumber(longNumber);
                stureInfo.setDisplayName(displayName);
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        return stureInfo;
    }

    @Override
    public OUPartCoreBaseInfo getOUPartByFullOrgUnit(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        if (unitInfo == null) {
            throw new BOSException("unit can't be null");
        }
        OUPartCoreBaseInfo coreBaseInfo = unitInfo.getOUPart(this.getOrgTypeSelfInfo().getOrgType());
        if (coreBaseInfo == null) {
            String tableName = this.getOrgTypeSelfInfo().getTableName();
            OUPartMarketInfo retInfo = new OUPartMarketInfo();
            String selectSql = "SELECT * FROM " + tableName + " WHERE FUnitID= ?";
            Object[] params = new Object[]{unitInfo.getId().toString()};
            coreBaseInfo = OrgQueryHelper.getOUPartVersionInfo(ctx, selectSql, (OUPartBaseInfo)retInfo, params);
        }
        return coreBaseInfo;
    }

    @Override
    public String getUpateViewSql() {
        StringBuffer update = new StringBuffer(200);
        String viewTableName = this.getOrgTypeSelfInfo().getViewTableName();
        String ouPartTableName = this.getOrgTypeSelfInfo().getTableName();
        String treeId = this.getOrgTreeID();
        Locale[] locales = MultiLangHelper.getDefinedLocales((Context)ContextUtils.getContextFromSessionNoException());
        OrgTypeSelfInfo orgTypeSelfInfo = this.getOrgTypeSelfInfo();
        OrgType orgType = orgTypeSelfInfo.getOrgType();
        update.append("UPDATE ").append(viewTableName).append(" a SET flongnumber=(SELECT flongnumber FROM t_org_structure st ").append("WHERE st.funitId=a.fid AND st.ftreeId='").append(treeId).append("'),").append("fparentid =(SELECT funitId FROM t_org_structure os WHERE os.fid =(SELECT t.fparentid ").append("FROM t_org_structure t WHERE t.funitId = a.fid").append(" and t.ftreeId='").append(treeId).append("')),").append("flevel = (SELECT flevel FROM t_org_structure st WHERE st.funitId=a.fid").append(" AND st.ftreeId='").append(treeId).append("'),");
        if (orgType.getValue() == 0) {
            update.append("fsortcode = (SELECT fsortcode FROM t_org_structure st WHERE st.funitId=a.fid").append(" AND st.ftreeId='").append(treeId).append("'),");
        }
        int size = locales.length;
        for (int i = 0; i < size; ++i) {
            update.append("FDisplayName_").append(locales[i]).append("=(select FDisplayName_").append(locales[i]).append(" from t_org_structure where funitid=a.fid and ftreeid='").append(treeId).append("')");
            if (i >= locales.length - 1) continue;
            update.append(",");
        }
        return update.toString();
    }

    @Override
    public String getUpdateViewCUSql() {
        StringBuffer update = new StringBuffer(200);
        String viewTableName = this.getOrgTypeSelfInfo().getViewTableName();
        update.append("UPDATE ").append(viewTableName).append(" a SET FControlunitid=(select fcontrolunitid from t_org_baseunit ").append(" where fid=a.fid)");
        return update.toString();
    }

    @Override
    public void updateParentStructure(Context ctx, OrgStructureInfo structureInfo, boolean isNew) throws BOSException, EASBizException {
        if (structureInfo == null || isNew && (structureInfo.getParent() == null || structureInfo.getParent().getId() == null) || !isNew && (structureInfo.getUnit() == null || structureInfo.getUnit().getId() == null)) {
            return;
        }
        boolean isLeaf = false;
        String fid = "";
        if (isNew) {
            String parentId = structureInfo.getParent().getId().toString();
            IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
            OrgStructureInfo info = iStruct.getOrgStructureInfo((IObjectPK)new ObjectStringPK(parentId));
            if (info == null || info.getUnit() == null && info.getUnit().getId() == null) {
                return;
            }
            fid = info.getUnit().getId().toString();
            isLeaf = info.isIsLeaf();
        } else {
            fid = structureInfo.getUnit().getId().toString();
            isLeaf = structureInfo.isIsLeaf();
        }
        StringBuffer updateSql = new StringBuffer(50);
        updateSql.append("update ").append(this.getOrgTypeSelfInfo().getViewTableName()).append(" set fisLeaf=? where fid=?");
        Object[] params = new Object[]{isLeaf ? 1 : 0, fid};
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
    }

    @Override
    public void updateOUPartCU(Context ctx, FullOrgUnitInfo unitInfo, FullOrgUnitInfo oldUnitInfo) throws BOSException, EASBizException {
        if (unitInfo == null || unitInfo.getCU() == null || oldUnitInfo == null || oldUnitInfo.getCU() == null) {
            throw new BOSException("unitInfo can't be null");
        }
        StringBuffer updateSql = new StringBuffer(100);
        String tableName = this.getOrgTypeSelfInfo().getTableName();
        updateSql.append("UPDATE ").append(tableName).append(" set fcontrolunitid=?").append(" where funitid in (select fid from t_org_baseunit where fcontrolunitid =?").append(" and (flongnumber=?").append(" or flongnumber like ?))");
        String longNumber = oldUnitInfo.getLongNumber();
        Object[] params = new String[]{unitInfo.getCU().getId().toString(), oldUnitInfo.getCU().getId().toString(), longNumber, longNumber + "!%"};
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
    }

    @Override
    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        OrgTypeSelfInfo orgTypeSelfInfo = this.getOrgTypeSelfInfo();
        OrgType orgType = orgTypeSelfInfo.getOrgType();
        ArrayList<String[]> pkList = new ArrayList<String[]>();
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!OrgTypeHelper.isOrgType(unitInfo.getOrgTypeStr(), orgType)) {
                return;
            }
            pkList.add(new String[]{unitInfo.getId().toString()});
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper(unitInfo);
            orgTypeHelper.removeOrgType(orgType);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
        if (pkList.size() > 0) {
            String delOUPartSql = "delete from " + orgTypeSelfInfo.getTableName() + " where fUnitId= ?";
            DbUtil.executeBatch((Context)ctx, (String)delOUPartSql, pkList);
            OUPartReference.delReferenced(ctx, orgTypeSelfInfo.getOrgViewBosType().toString(), pkList, orgTypeSelfInfo.getViewTableName());
            OUPartReference.delReferenced(ctx, orgTypeSelfInfo.getOrgTableBosType().toString(), pkList, orgTypeSelfInfo.getTableName());
        }
    }

    @Override
    public void delStructure(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        OrgTypeSelfInfo orgTypeSelfInfo = this.getOrgTypeSelfInfo();
        OrgType orgType = orgTypeSelfInfo.getOrgType();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            OrgStructureInfo orgStruInfo = null;
            try {
                orgStruInfo = iStruct.getOrgStructureInfo("Select id Where unit.id = '" + unitInfo.getId().toString() + "' and tree.id = '" + orgTypeInfo.getOrgTreeID() + "'");
            }
            catch (ObjectNotFoundException e) {
                this.deleteSelfDelegate(ctx, unitInfo, orgType.getValue());
                continue;
            }
            String[] params = new String[]{orgType.getAlias()};
            if (!unitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                OUPartReference.delReferenced(ctx, "32B85C74", orgStruInfo.getId().toString(), "");
                iStruct.delete((IObjectPK)new ObjectUuidPK(orgStruInfo.getId()));
            } else {
                DbUtil.execute((Context)ctx, (String)("Update T_ORG_Structure set FIsValid = 0 where FUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4' and FTreeID = '" + orgTypeInfo.getOrgTreeID() + "'"));
            }
            this.deleteSelfDelegate(ctx, unitInfo, orgType.getValue());
        }
    }

    @Override
    public void delPermission(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        OrgTypeSelfInfo orgTypeSelfInfo = this.getOrgTypeSelfInfo();
        OrgType orgType = orgTypeSelfInfo.getOrgType();
        HashSet<OrgType> delOrgTypeSet = new HashSet<OrgType>();
        delOrgTypeSet.add(orgType);
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            String ouID = unitInfo.getId().toString();
            UserCollection userCol = null;
            IPermission iPer = PermissionFactory.getLocalInstance((Context)ctx);
            if (delOrgTypeSet != null && delOrgTypeSet.size() != 0) {
                userCol = iPer.getRefUersByPermisson(delOrgTypeSet, ouID);
            }
            if (userCol == null || userCol.size() == 0) continue;
            iPer.delPermissoinAfterDelOrg(delOrgTypeSet, unitInfo);
        }
    }

    protected String[] getExpTbOupartFields() {
        return this.orgDataCheckerHelper.getExpTbOupartFields();
    }

    protected String[] getExpTbViewFields() {
        return this.orgDataCheckerHelper.getExpTbViewFields();
    }

    protected void checkTbViewField(List<String> errDataList, OrgDataCheckerHelper orgDataCheckerHelper) {
    }

    protected void checkTbOupartField(List<String> errDataList, OrgDataCheckerHelper orgDataCheckerHelper) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getErrDataList(Context ctx) throws BOSException, EASBizException {
        int bsPos;
        int i;
        ArrayList<String> errDataList = new ArrayList<String>();
        String treeId = this.getOrgTreeID();
        String viewTableName = this.getOrgTypeSelfInfo().getViewTableName();
        String ouPartTableName = this.getOrgTypeSelfInfo().getTableName();
        Object[] expTbOupartField = this.getExpTbOupartFields();
        String sqlOupart = null;
        sqlOupart = expTbOupartField != null ? "select fid,funitid,fversionnumber," + StringUtil.arrayToString((Object[])expTbOupartField, (String)",") + " from " + ouPartTableName : "select fid,funitid,fversionnumber from " + ouPartTableName;
        Object[] expTbViewFields = this.getExpTbViewFields();
        String sqlView = null;
        sqlView = expTbViewFields == null ? "select fid,fparentid,fisleaf,flevel,fnumber,flongnumber,fversionnumber from " + viewTableName : "select fid,fparentid,fisleaf,flevel,fnumber,flongnumber,fversionnumber," + StringUtil.arrayToString((Object[])expTbViewFields, (String)",") + " from " + viewTableName;
        String sqlStructure = "select  fid,fparentid,fisleaf,flevel,flongnumber,funitid from t_org_structure where ftreeid ='" + treeId + "'";
        String sqlBaseUnit = "select  fid,fParentId,fIsleaf,fLevel,fNumber,fLongnumber,fVersionNumber from t_org_baseunit";
        if (!this.lock.isLocked()) {
            this.lock.lock();
            try {
                if (this.orgDataCheckerHelper.getmBaseUnitIdPos() == null) {
                    HashMap<String, Integer> mBaseUnitIdPos = new HashMap<String, Integer>();
                    String[][] baseUnitArray = this.getFieldArray(ctx, sqlBaseUnit, mBaseUnitIdPos);
                    this.orgDataCheckerHelper.setmBaseUnitIdPos(mBaseUnitIdPos);
                    this.orgDataCheckerHelper.setBaseUnitArray(baseUnitArray);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        HashMap<String, Integer> mOuPartIdPos = new HashMap<String, Integer>();
        String[][] oupartArray = this.getFieldArray(ctx, sqlOupart, mOuPartIdPos);
        int IFid_OUP = 0;
        int IFunitId_OUP = 1;
        int IFversionNumber_OUP = 2;
        this.orgDataCheckerHelper.setmOuPartIdPos(mOuPartIdPos);
        this.orgDataCheckerHelper.setOupartArray(oupartArray);
        HashMap<String, Integer> mViewIdPos = new HashMap<String, Integer>();
        String[][] viewArray = this.getFieldArray(ctx, sqlView, mViewIdPos);
        int IFid_VI = 0;
        int IFparentId_VI = 1;
        int IFisleaf_VI = 2;
        int IFlevel_VI = 3;
        int IFnumber_VI = 4;
        int IFlongnumber_VI = 5;
        int IFversionNumber_VI = 6;
        this.orgDataCheckerHelper.setmViewIdPos(mViewIdPos);
        this.orgDataCheckerHelper.setViewArray(viewArray);
        HashMap<String, Integer> mStructureIdPos = new HashMap<String, Integer>();
        String[][] structureArray = this.getFieldArray(ctx, sqlStructure, mStructureIdPos);
        boolean IFid_ST = false;
        int IFparentId_ST = 1;
        int IFisleaf_ST = 2;
        int IFlevel_ST = 3;
        int IFlongnumber_ST = 4;
        int IFunitid_ST = 5;
        HashMap<String, Integer> mStructureUnitIdPos = new HashMap<String, Integer>();
        int size = structureArray[0].length;
        for (int i2 = 0; i2 < size; ++i2) {
            mStructureUnitIdPos.put(structureArray[IFunitid_ST][i2], i2);
        }
        this.orgDataCheckerHelper.setmStructureIdPos(mStructureIdPos);
        this.orgDataCheckerHelper.setStructureArray(structureArray);
        this.orgDataCheckerHelper.setmStructureUnitIdPos(mStructureUnitIdPos);
        Map<String, Integer> mBaseUnitIdPos = null;
        String[][] baseUnitArray = null;
        boolean IFid_BU = false;
        boolean IFparentId_BU = true;
        int IFisleaf_BU = 2;
        int IFlevel_BU = 3;
        int IFnumber_BU = 4;
        int IFlongnumber_BU = 5;
        int IFversionNumber_BU = 6;
        mBaseUnitIdPos = this.orgDataCheckerHelper.getmBaseUnitIdPos();
        baseUnitArray = this.orgDataCheckerHelper.getBaseUnitArray();
        int size2 = viewArray.length;
        for (i = 0; i < size2; ++i) {
            if (mBaseUnitIdPos.get(viewArray[IFid_VI][i]) == null) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fid=" + viewArray[IFid_VI][i], "t_org_baseunit\u6ca1\u6709\u8be5ID\u7684\u7ec4\u7ec7\u6570\u636e");
                continue;
            }
            if (mStructureUnitIdPos.get(viewArray[IFid_VI][i]) == null) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fid=" + viewArray[IFid_VI][i], "t_org_structure\u6ca1\u6709\u8be5\u7ec4\u7ec7\u4e1a\u52a1\u89c6\u56fe\u6570\u636e");
                continue;
            }
            bsPos = mBaseUnitIdPos.get(viewArray[IFid_VI][i]);
            if (!viewArray[IFversionNumber_VI][i].equals(baseUnitArray[IFversionNumber_BU][bsPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fversionNumber=" + viewArray[IFversionNumber_VI][i], "\u4e0et_org_baseunit\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
                continue;
            }
            int stPos = (Integer)mStructureUnitIdPos.get(viewArray[IFid_VI][i]);
            if (viewArray[IFparentId_VI][i] != null && structureArray[IFparentId_ST][stPos] != null) {
                if (mStructureUnitIdPos.get(structureArray[IFparentId_ST][stPos]) == null) {
                    this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fparentid=" + viewArray[IFparentId_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684parentID\u4e0d\u4e00\u81f4");
                    continue;
                }
                int stParPos = (Integer)mStructureUnitIdPos.get(structureArray[IFparentId_ST][stPos]);
                if (!structureArray[IFunitid_ST][stParPos].equals(viewArray[IFparentId_VI][i])) {
                    this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fparentid=" + viewArray[IFparentId_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684parentID\u4e0d\u4e00\u81f4");
                    continue;
                }
            } else if (viewArray[IFparentId_VI][i] != null || structureArray[IFparentId_ST][stPos] != null) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fparentid=" + viewArray[IFparentId_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684parentID\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFisleaf_VI][i].equals(structureArray[IFisleaf_ST][stPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fisleaf=" + viewArray[IFisleaf_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684isleaf\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFlevel_VI][i].equals(structureArray[IFlevel_ST][stPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "flevel=" + viewArray[IFlevel_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684level\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFnumber_VI][i].equals(baseUnitArray[IFnumber_BU][bsPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "fnumber=" + viewArray[IFnumber_VI][i], "\u4e0et_org_baseunit\u5bf9\u5e94\u8bb0\u5f55\u7684number\u4e0d\u4e00\u81f4");
                continue;
            }
            if (!viewArray[IFlongnumber_VI][i].equals(structureArray[IFlongnumber_ST][stPos])) {
                this.addErrData(errDataList, viewTableName, viewArray[IFid_VI][i], "flongnumber=" + viewArray[IFlongnumber_VI][i], "\u4e0et_org_structure\u5bf9\u5e94\u8bb0\u5f55\u7684longnumber\u4e0d\u4e00\u81f4");
                continue;
            }
            this.checkTbViewField(errDataList, this.orgDataCheckerHelper);
        }
        size2 = oupartArray.length;
        for (i = 0; i < size2; ++i) {
            if (mBaseUnitIdPos.get(oupartArray[IFunitId_OUP][i]) == null) {
                this.addErrData(errDataList, ouPartTableName, oupartArray[IFid_OUP][i], "funitid=" + oupartArray[IFunitId_OUP][i], "funitid\u5e76\u6ca1\u6709\u5bf9\u5e94\u7684t_org_baseunit\u6570\u636e");
                continue;
            }
            bsPos = mBaseUnitIdPos.get(oupartArray[IFunitId_OUP][i]);
            if (!oupartArray[IFversionNumber_OUP][i].equals(baseUnitArray[IFversionNumber_BU][bsPos])) {
                this.addErrData(errDataList, ouPartTableName, oupartArray[IFid_OUP][i], "fversionNumber=" + oupartArray[IFversionNumber_OUP][i], "\u4e0et_org_baseunit\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
                continue;
            }
            this.checkTbOupartField(errDataList, this.orgDataCheckerHelper);
        }
        this.checkDataFields(errDataList, this.orgDataCheckerHelper);
        return errDataList;
    }

    protected void checkDataFields(List<String> errDataList, OrgDataCheckerHelper orgDataCheckerHelper) {
    }

    protected void addErrData(List errDataList, String tableName, String fid, String col, String detail) {
        errDataList.add(tableName + "@tj@" + fid + "@tj@" + col + "@tj@" + detail);
    }

    protected final String[][] getFieldArray(Context ctx, String sql, Map<String, Integer> mIdPos) throws BOSException {
        String[] fields = sql.substring(0, sql.indexOf("from")).split(",");
        String strTemp = sql.substring(sql.indexOf("from") + 5) + " ";
        String tableName = strTemp.substring(0, strTemp.indexOf(" ")).trim().toLowerCase();
        int arrSize = fields.length;
        Map<String, Integer> mpFieldIndex = this.mpTbFieldIndex.get(tableName);
        if (mpFieldIndex == null) {
            mpFieldIndex = new HashMap<String, Integer>();
            this.mpTbFieldIndex.put(tableName, mpFieldIndex);
        }
        mpFieldIndex.put("fid", 0);
        for (int i = 1; i < arrSize; ++i) {
            mpFieldIndex.put(fields[i].trim().toLowerCase(), i);
        }
        IRowSet rowSet3 = DbUtil.executeQuery((Context)ctx, (String)sql);
        int rowcount = rowSet3.size();
        String[][] fieldArray = new String[arrSize][rowcount];
        this.mpTbArray.put(tableName, fieldArray);
        try {
            int pos = 0;
            while (rowSet3.next()) {
                String fid;
                fieldArray[0][pos] = fid = rowSet3.getString(1);
                for (int i = 1; i < arrSize; ++i) {
                    fieldArray[i][pos] = rowSet3.getString(i + 1);
                }
                mIdPos.put(fid, pos);
                ++pos;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return fieldArray;
    }

    protected final String getTbFieldbyIndex(String tableName, String fieldName, int index) {
        return this.getTbFields(tableName, fieldName)[index];
    }

    protected final String[] getTbFields(String tableName, String fieldName) {
        String[][] fieldArray = (String[][])this.mpTbArray.get(tableName.toLowerCase());
        Map<String, Integer> mpFieldIndex = this.mpTbFieldIndex.get(tableName.toLowerCase());
        int pos = mpFieldIndex.get(fieldName.toLowerCase());
        return fieldArray[pos];
    }
}

