/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.CUParentChangedHandlerUtil;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCtrlCollection;
import com.kingdee.eas.basedata.org.OUPartCtrlInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.QueryCtrlInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppCtrlImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppCtrlImpl.class.getName());

    public static OrgUnitCollection createCtrlUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection ctrlVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            CtrlUnitInfo ctrlVersionInfo = OrgAppCtrlImpl.createCtrlUnitVersionInfo(ctx, rs);
            ctrlVersionCol.add(ctrlVersionInfo);
        }
        return ctrlVersionCol;
    }

    public static CtrlUnitInfo createCtrlUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        CtrlUnitInfo ctrlVersionInfo = (CtrlUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo(ctx, new CtrlUnitInfo(), rs);
        String versionNumber = ctrlVersionInfo.getVersionNumber();
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            CtrlUnitInfo parentVersionInfo = new CtrlUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            ctrlVersionInfo.setParent(parentVersionInfo);
        }
        return ctrlVersionInfo;
    }

    public static OUPartCtrlInfo createOUPartCtrlVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartCtrlInfo partCtrlVersionInfo = new OUPartCtrlInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partCtrlVersionInfo.setUnit(fullVersionInfo);
        }
        return partCtrlVersionInfo;
    }

    public static OUPartCtrlCollection createOUPartCtrlVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartCtrlCollection partCtrlVersionCol = new OUPartCtrlCollection();
        while (rs.next()) {
            OUPartCtrlInfo partCtrlVersionInfo = OrgAppCtrlImpl.createOUPartCtrlVersionInfo(ctx, rs);
            partCtrlVersionCol.add(partCtrlVersionInfo);
        }
        return partCtrlVersionCol;
    }

    @Override
    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartCtrl_His(FID,FUnitID,FVersionNumber) SELECT FID,FUnitID,FVersionNumber FROM T_ORG_OUPartCtrl");
        retList.add("INSERT INTO T_ORG_CtrlUnit_His(FID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit,FIsCU,FIsUnion,FIsHROrgUnit,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FIsLeaf,FLevel,FLongNumber,FParentID,FIsStart,FIsOUSealUp,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit,FIsCU,FIsUnion,FIsHROrgUnit,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FIsLeaf,FLevel,FLongNumber,FParentID,FIsStart,FIsOUSealUp,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_CtrlUnit");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_CtrlUnit_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new CtrlUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    protected OrgUnitCollection _getCtrlUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_CtrlUnit_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND FID <> '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartCtrlCollection _getOUPartCtrlVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartCtrl_His").toString();
        try {
            OUPartCtrlCollection partCtrlVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartCtrlCollection oUPartCtrlCollection = partCtrlVersionCol = OrgAppCtrlImpl.createOUPartCtrlVersionCollection(ctx, (ResultSet)rs);
            return oUPartCtrlCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    @Override
    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartCtrlInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partCtrlId = rs.getString("FPartCtrlID");
        if (partCtrlId != null && partCtrlId.trim().length() != 0) {
            OUPartCtrlInfo partCtrlVersionInfo = new OUPartCtrlInfo(versionNumber, BOSUuid.read((String)partCtrlId));
            fullVersionInfo.setPartCtrl(partCtrlVersionInfo);
        }
    }

    @Override
    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartCtrl");
        orgInfo.setTableNameAlias("PtCtrl");
        orgInfo.setViewTableName("T_ORG_Ctrlunit");
        orgInfo.setTableNameAlias("ctrl");
        orgInfo.setTableNameHis("T_ORG_OUPartCtrl_his");
        orgInfo.setViewTableNameHis("T_ORG_Ctrlunit_his");
        orgInfo.setOrgViewBosType(new CtrlUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartCtrlInfo().getBOSType());
        orgInfo.setOuPartInfo(new OUPartCtrlInfo());
        orgInfo.setOrgUnitViewInfo(new CtrlUnitInfo());
        orgInfo.setOrgType(OrgType.ControlUnit);
        orgInfo.setIOrgQueryInfo(new QueryCtrlInfo());
        return orgInfo;
    }

    @Override
    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
    }

    @Override
    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
    }

    @Override
    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_CtrlUnit (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FVersionNumber,\n").append("FCode,\n").append("FOrgTypeStr,\n").append("FIsTransportOrgUnit,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FOrgTypeStr,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000014F2827FD')\n");
        return new String[]{"delete from T_ORG_CtrlUnit", sb.toString()};
    }

    @Override
    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
    }

    @Override
    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_CtrlUnit_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            CtrlUnitInfo ctrlVersionInfo = OrgAppCtrlImpl.createCtrlUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            CtrlUnitInfo ctrlUnitInfo = ctrlVersionInfo;
            return ctrlUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    @Override
    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_CtrlUnit_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" AND FID <> '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection ctrlVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = ctrlVersionCol = OrgAppCtrlImpl.createCtrlUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public void updateBizViewOnCU(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        OrgStructureInfo parentStructInfo = null;
        if (!unitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            parentStructInfo = iStruct.getOrgStructureInfo("Select *, unit.number Where unit.id = '" + unitInfo.getParent().getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000014F2827FD" + "'");
        }
        OrgStructureInfo strucInfo = iStruct.getOrgStructureInfo("Select *, parent.unit.id, parent.longNumber, parent.level, unit.number Where unit.id = '" + unitInfo.getId().toString() + "' and tree.id = '" + "00000000-0000-0000-0000-0000000000014F2827FD" + "'");
        if (!unitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4") && OrgAppHelper.existBizSuperiorLoop(ctx, strucInfo, parentStructInfo)) {
            Object[] params = new String[]{OrgType.ControlUnit.getAlias()};
            throw new OUException(OUException.ORG_SUPERIOR_LOOP, params);
        }
        CUParentChangedHandlerUtil.adjustData((Context)ctx, (OrgStructureInfo)strucInfo, (OrgStructureInfo)strucInfo.getParent(), (OrgStructureInfo)parentStructInfo);
        ObjectUuidPK pk = new ObjectUuidPK(strucInfo.getId());
        strucInfo.setParent(parentStructInfo);
        strucInfo.setIsValid(true);
        iStruct.update((IObjectPK)pk, strucInfo);
    }

    @Override
    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE " + "FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    private OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartCtrlInfo partCtrlVersionInfo = OrgAppCtrlImpl.createOUPartCtrlVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartCtrlInfo oUPartCtrlInfo = partCtrlVersionInfo;
            return oUPartCtrlInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    @Override
    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartCtrl_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    @Override
    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartCtrl_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }
}

