/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.helper;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class OrgTypeHelper {
    private static Logger logger = Logger.getLogger(OrgTypeHelper.class);
    Set orgTypeSet = new TreeSet();

    public OrgTypeHelper() {
    }

    public Set getAllSelectOrgTypeSet() {
        return this.orgTypeSet;
    }

    public OrgTypeHelper(String orgTypeStr) {
        if (StringUtils.isEmpty((String)orgTypeStr)) {
            return;
        }
        String[] orgTypeStrAry = orgTypeStr.split(";");
        for (int i = 0; i < orgTypeStrAry.length; ++i) {
            OrgType orgType;
            String orgTypeValue = orgTypeStrAry[i];
            if (StringUtils.isEmpty((String)orgTypeValue) || (orgType = OrgType.getEnum(orgTypeValue)) == null) continue;
            this.orgTypeSet.add(orgType);
        }
    }

    public OrgTypeHelper(OrgUnitInfo orgInfo) {
        this(orgInfo.getOrgTypeStr());
        if (StringUtils.isEmpty((String)orgInfo.getOrgTypeStr())) {
            // empty if block
        }
    }

    public void addOrgType(OrgType orgType) {
        this.orgTypeSet.add(orgType);
    }

    public void removeOrgType(OrgType orgType) {
        this.orgTypeSet.remove((Object)orgType);
    }

    public boolean isOrgType(OrgType orgType) {
        return this.orgTypeSet.contains((Object)orgType);
    }

    public String createOrgTypeStrBySet() {
        StringBuffer retStr = new StringBuffer("");
        for (OrgType orgType : this.orgTypeSet) {
            if (orgType == null) continue;
            retStr.append(";").append(orgType.getName()).append(";");
        }
        return retStr.toString();
    }

    public static String createOrgTypeStr(FullOrgUnitInfo orgInfo) {
        String orgTypeStr = orgInfo.getOrgTypeStr();
        StringBuffer retStr = new StringBuffer("");
        if (!StringUtils.isEmpty((String)orgTypeStr)) {
            retStr.append(OrgTypeHelper.getExtOrgTypeStr(orgTypeStr));
        }
        retStr.append(";").append(orgInfo.isIsAdminOrgUnit() ? ";" + OrgType.Admin.getName() + ";" : "").append(orgInfo.isIsCompanyOrgUnit() ? ";" + OrgType.Company.getName() + ";" : "").append(orgInfo.isIsCostOrgUnit() ? ";" + OrgType.CostCenter.getName() + ";" : "").append(orgInfo.isIsHROrgUnit() ? ";" + OrgType.HRO.getName() + ";" : "").append(orgInfo.isIsProfitOrgUnit() ? ";" + OrgType.ProfitCenter.getName() + ";" : "").append(orgInfo.isIsPurchaseOrgUnit() ? ";" + OrgType.Purchase.getName() + ";" : "").append(orgInfo.isIsQualityOrgUnit() ? ";" + OrgType.Quality.getName() + ";" : "").append(orgInfo.isIsSaleOrgUnit() ? ";" + OrgType.Sale.getName() + ";" : "").append(orgInfo.isIsStorageOrgUnit() ? ";" + OrgType.Storage.getName() + ";" : "").append(orgInfo.isIsTransportOrgUnit() ? ";" + OrgType.Transport.getName() + ";" : "").append(orgInfo.isIsCU() ? ";" + OrgType.ControlUnit.getName() + ";" : "").append(orgInfo.isIsUnion() ? ";" + OrgType.UnionDebt.getName() + ";" : "");
        return retStr.toString();
    }

    public static void createOrgType4FullOrg(OrgUnitInfo orgInfo, String orgTypStr) {
        if (orgInfo == null || StringUtils.isEmpty((String)orgTypStr)) {
            return;
        }
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgTypStr);
        orgInfo.setIsAdminOrgUnit(orgTypeHelper.isOrgType(OrgType.Admin));
        orgInfo.setIsCompanyOrgUnit(orgTypeHelper.isOrgType(OrgType.Company));
        orgInfo.setIsCU(orgTypeHelper.isOrgType(OrgType.ControlUnit));
        orgInfo.setIsCostOrgUnit(orgTypeHelper.isOrgType(OrgType.CostCenter));
        orgInfo.setIsHROrgUnit(orgTypeHelper.isOrgType(OrgType.HRO));
        orgInfo.setIsProfitOrgUnit(orgTypeHelper.isOrgType(OrgType.ProfitCenter));
        orgInfo.setIsPurchaseOrgUnit(orgTypeHelper.isOrgType(OrgType.Purchase));
        orgInfo.setIsQualityOrgUnit(orgTypeHelper.isOrgType(OrgType.Quality));
        orgInfo.setIsSaleOrgUnit(orgTypeHelper.isOrgType(OrgType.Sale));
        orgInfo.setIsStorageOrgUnit(orgTypeHelper.isOrgType(OrgType.Storage));
        orgInfo.setIsTransportOrgUnit(orgTypeHelper.isOrgType(OrgType.Transport));
        orgInfo.setIsUnion(orgTypeHelper.isOrgType(OrgType.UnionDebt));
    }

    public static void createOrgType4FullOrg(FullOrgUnitInfo orgInfo) {
        if (orgInfo == null) {
            return;
        }
        OrgTypeHelper.createOrgType4FullOrg(orgInfo, orgInfo.getOrgTypeStr());
    }

    public static boolean isOrgType(String orgTypeStr, OrgType orgType) {
        if (StringUtils.isEmpty((String)orgTypeStr)) {
            return false;
        }
        OrgTypeHelper orgHeper = new OrgTypeHelper(orgTypeStr);
        return orgHeper.isOrgType(orgType);
    }

    public static String createLikeStr(OrgType orgType) {
        return ";" + orgType.getName() + ";";
    }

    public static String createTreeId(int value) {
        String valueStr = value + "4F2827FD";
        String standStr = "00000000-0000-0000-0000-0000000000004F2827FD";
        String retId = standStr.substring(0, standStr.length() - valueStr.length()) + valueStr;
        return retId;
    }

    public static String getAlias(Locale locale, String resClassName, String resourceName) {
        if (StringUtils.isEmpty((String)resClassName) || StringUtils.isEmpty((String)resourceName)) {
            return null;
        }
        if (locale == null) {
            return EASResource.getString((String)resClassName, (String)resourceName);
        }
        return EASCommonResource.getString((String)resClassName, (String)resourceName, (Locale)locale);
    }

    public boolean isOnlyThisOrgType(OrgType curOrgType) {
        if (this.orgTypeSet == null || this.orgTypeSet.size() != 1) {
            return false;
        }
        return curOrgType == (OrgType)((Object)this.orgTypeSet.iterator().next());
    }

    public static Collection getAllComplexOrgType() {
        HashSet<OrgType> retSet = new HashSet<OrgType>();
        Collection orgTypeInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            if (orgTypeInfo.isBasicOrgType()) continue;
            retSet.add(orgTypeInfo.getOrgType());
        }
        return retSet;
    }

    public static Collection myOrgTypeSet() {
        Set allOrgTypeSet = OrgTypeInfoMgr.getInstance().getAllOrgType();
        return CollectionUtils.subtract((Collection)allOrgTypeSet, (Collection)OrgTypeHelper.getAllComplexOrgType());
    }

    public boolean containComplexOrgType() {
        Set myOrgTypeSet = this.getAllSelectOrgTypeSet();
        Collection retCol = CollectionUtils.intersection((Collection)OrgTypeHelper.getAllComplexOrgType(), (Collection)myOrgTypeSet);
        return !retCol.isEmpty();
    }

    public OrgType getComplexOrgType() {
        Set myOrgTypeSet = this.getAllSelectOrgTypeSet();
        Collection retCol = CollectionUtils.intersection((Collection)OrgTypeHelper.getAllComplexOrgType(), (Collection)myOrgTypeSet);
        if (retCol.isEmpty()) {
            return null;
        }
        return (OrgType)((Object)retCol.iterator().next());
    }

    private static String getExtOrgTypeStr(String orgTypeStr) {
        StringBuffer extOrgTypeStr = new StringBuffer("");
        String[] orgTypeStrAry = orgTypeStr.split(";");
        Map map = OrgTypeInfoMgr.getAllStandardOrgMap();
        for (int i = 0; i < orgTypeStrAry.length; ++i) {
            Object obj;
            String orgTypeValue = orgTypeStrAry[i];
            if (StringUtils.isEmpty((String)orgTypeValue) || (obj = map.get(orgTypeValue)) != null) continue;
            extOrgTypeStr.append(";").append(orgTypeValue).append(";");
        }
        return extOrgTypeStr.toString();
    }
}

