/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.metadata.cache;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.metadata.ColMetaInfo;
import com.kingdee.eas.basedata.org.metadata.OrgTypeCollection;
import com.kingdee.eas.basedata.org.metadata.OrgTypeInfo;
import com.kingdee.eas.basedata.org.metadata.cache.IOrgMetaDataCache;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractOrgMetaDataCache
implements IOrgMetaDataCache {
    protected Context ctx;
    protected OrgTypeCollection cachedOrgTypeCol = null;
    protected Map tableColMetaMap = new HashMap();

    protected AbstractOrgMetaDataCache(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public OrgTypeInfo getOrgTypeInfo(int value) {
        OrgTypeInfo orgTypeInfo = null;
        if (this.cachedOrgTypeCol != null) {
            orgTypeInfo = this.cachedOrgTypeCol.get(new Integer(value));
        }
        if (orgTypeInfo == null) {
            orgTypeInfo = this.getOrgTypeInfoFromMDSource(value);
        }
        if (orgTypeInfo == null) {
            throw new IllegalArgumentException("OrgType value is not defined!");
        }
        return orgTypeInfo;
    }

    protected abstract OrgTypeInfo getOrgTypeInfoFromMDSource(int var1);

    @Override
    public OrgTypeInfo getOrgTypeInfo(String name) {
        OrgTypeInfo orgTypeInfo = null;
        if (this.cachedOrgTypeCol != null) {
            orgTypeInfo = this.getOrgTypeInfoByName(this.cachedOrgTypeCol, name);
        }
        if (orgTypeInfo == null) {
            orgTypeInfo = this.getOrgTypeInfoFromMDSource(name);
        }
        if (orgTypeInfo == null) {
            throw new IllegalArgumentException("OrgType name is not defined!");
        }
        return orgTypeInfo;
    }

    protected abstract OrgTypeInfo getOrgTypeInfoFromMDSource(String var1);

    protected OrgTypeInfo getOrgTypeInfoByName(OrgTypeCollection orgTypeCol, String name) {
        OrgTypeInfo orgTypeInfo = null;
        for (int i = 0; i < orgTypeCol.size(); ++i) {
            orgTypeInfo = orgTypeCol.get(i);
            if (!orgTypeInfo.getName().equals(name)) continue;
            return orgTypeInfo;
        }
        return null;
    }

    @Override
    public OrgTypeInfo getOrgTypeInfoByTreeID(String treeID) {
        OrgTypeInfo orgTypeInfo = null;
        if (this.cachedOrgTypeCol != null) {
            orgTypeInfo = this.getOrgTypeInfoByTreeID(this.cachedOrgTypeCol, treeID);
        }
        if (orgTypeInfo == null) {
            orgTypeInfo = this.getOrgTypeInfoByTreeIDFromMDSource(treeID);
        }
        return orgTypeInfo;
    }

    protected abstract OrgTypeInfo getOrgTypeInfoByTreeIDFromMDSource(String var1);

    protected OrgTypeInfo getOrgTypeInfoByTreeID(OrgTypeCollection orgTypeCol, String treeID) {
        OrgTypeInfo orgTypeInfo = null;
        for (int i = 0; i < orgTypeCol.size(); ++i) {
            orgTypeInfo = orgTypeCol.get(i);
            if (!treeID.equals(orgTypeInfo.getOrgViewTreeID())) continue;
            return orgTypeInfo;
        }
        return null;
    }

    @Override
    public OrgTypeCollection getOrgTypeCollection() {
        OrgTypeCollection orgTypeCol = this.getOrgTypeCollectionFromMDSource();
        if (orgTypeCol == null || orgTypeCol.size() == 0) {
            throw new IllegalArgumentException("OrgTypes are not defined!");
        }
        return orgTypeCol;
    }

    protected abstract OrgTypeCollection getOrgTypeCollectionFromMDSource();

    @Override
    public Map getColMetaInfos(String tableName) {
        String tabName = tableName.toUpperCase();
        Map colMetaMap = (Map)this.tableColMetaMap.get(tabName);
        if (colMetaMap == null || colMetaMap.size() == 0) {
            colMetaMap = this.getColMetaInfosFromMDSource(tabName);
        }
        if (colMetaMap == null || colMetaMap.size() == 0) {
            throw new IllegalArgumentException("Table " + tableName + " metadatas are not found!");
        }
        return colMetaMap;
    }

    protected abstract Map getColMetaInfosFromMDSource(String var1);

    @Override
    public ColMetaInfo getColMetaInfo(String tableName, String columnName) {
        String tabName = tableName.toUpperCase();
        String colName = columnName.toUpperCase();
        ColMetaInfo colMetaInfo = null;
        Map colMetaMap = (Map)this.tableColMetaMap.get(tabName);
        if (colMetaMap != null) {
            colMetaInfo = (ColMetaInfo)colMetaMap.get(colName);
        }
        if (colMetaInfo == null) {
            colMetaInfo = this.getColMetaInfoFromMDSource(tabName, colName);
        }
        if (colMetaInfo == null) {
            throw new IllegalArgumentException("Table " + tableName + " column " + columnName + " metadata is not found!");
        }
        return colMetaInfo;
    }

    protected abstract ColMetaInfo getColMetaInfoFromMDSource(String var1, String var2);

    @Override
    public void clear() {
        if (this.cachedOrgTypeCol != null) {
            this.cachedOrgTypeCol.clear();
            this.cachedOrgTypeCol = null;
        }
        this.tableColMetaMap.clear();
    }
}

